#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################

import os, sys
# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) ,
                             "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="example.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# send a <confirmed-commit>
s.confirmed_commit() # send first commit
s.commit()           # send follow-up commit

# Send a <confirmed-commit> with a persist ID
# send first commit
s.confirmed_commit(persistID="mycommit")

# Create another netconf session
# send the follow-up commit from another session using 
# the persist ID designated above

s2 = ssmanager.create_session(host="example.server.com", port=830, 
                user="testconf", password="testconf2")

s2.commit(persistID="mycommit")                

# Cancel confirmed-commit  example
s.confirmed_commit()  # send first commit
s.cancel_commit()     # abort it

# Send a <confirmed-commit> with a persist ID,
# but later have it canceled
s.confirmed_commit(persistID="mycommit")

# Create another netconf session
# send the follow-up commit from another session
s3 = ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")
s3.cancel_commit(persistID="mycommit")

# close sessions
s.close_session()
s2.close_session()
s3.close_session()
