#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################
import os, sys
# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) ,
                             "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# Example to send XML config directly                    
# You can send out any xml config data you already have

# The result is a tuple of five values:
# Operation succeeded (True or False), 
# reply in xml format, reply in lxml element format, 
# request in xml format, request in lxml element format  
#             
configData="""
    <config>
      <if:interfaces xmlns:if='http://netconfcentral.org/ns/yuma-interfaces'>
        <if:interface>
           <if:name>eth0</if:name>
          </if:interface>
      </if:interfaces>
    </config>
    """
    
s.edit_config(config=configData, target="candidate")
