#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #
# Redistribution of this software, in whole or in part, is prohibited #
# without the express written permission of Seguesoft.                #
#######################################################################

import os, sys

# Extend system path to import 'ssmanager' package under the installation 
# directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) ,
                                         "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

r = s.get_schema(identifier="ietf-netconf-monitoring", version="2010-10-04", schemaFormat="yang")
print("Send <get-schema> succeeded? ", 
        r[0], " \n=====Result=====:\n", 
        r[1], " \n=====Request=====:\n", r[3])

if r[0] ==True:
    module_text = s.extract_value_from_rpc_reply(r[1], "/ncm:data",
                 namespaces={"ncm":"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring"})
    print("module_text received\n", module_text)
        
