#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################   
# THIS EXAMPLE REPRENTS UNFINISHED WORK. CUSTOMERS SHOULD NOT USE IT 
# AT THIS TIME
   
import os, sys
from lxml import etree
import logging

# Extend system path to import 'ssmanager' package under 
# the installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# This is one of the higher level convenient commmands.
# These higher level commands include hget, hget_config,
# create, merge, delete, replace and remove.

# The result of these commands is a tuple of 
# (True/ False, reply_xml, reply_element, request_xml, request_element

# set up YANG module path.  If no path is given, use the default path which is 
# the same as in NETCONFc GUI
  
# Set paths to YANG models and load them
# The YANG path directories MUST be writable by the application
# since the application will need to generate XML based 
# definition files.
#
#s.load_yang_modules_in_paths("C:/MY-YANG-modules",  "C:/MY-YANG-modules2", recursive=True)
# Set YANG model path to the default path, which is the same as in the GUI NETCONFc
s.load_yang_modules_in_paths()

r= s.yang_lookup("/ietf-netconf-monitoring:netconf-state/schemas/schema/location", 
                "length")
print("got ", r)
 
print("look up type /segue-test-module:interface/listening-ip") 
t = s.yang_lookup("/segue-test-module:interface/listening-ip", "type")
print("look up base type  /segue-test-module:interface/listening-ip") 
bt = s.yang_lookup("/segue-test-module:interface/listening-ip", "base-type")
print("look up pattern  /segue-test-module:interface/listening-ip") 
pt = s.yang_lookup("/segue-test-module:interface/listening-ip", "pattern")
print("look up length  /segue-test-module:interface/listening-ip") 
l = s.yang_lookup("/segue-test-module:interface/listening-ip", "length") 
print("type ", t, " base-type ", bt, " pattern : ", pt , " len: ", l)


t = s.yang_lookup("/ietf-interfaces:interfaces/interface/type", "type")
bt = s.yang_lookup("/ietf-interfaces:interfaces/interface/type", "base")
print("type ", t, " base ", bt)

# Using a fake XML reply from the DUT
# comment out the following line if the DUT has implemented itef-interfaces model
ssmanager.USE_INTERNAL_TESTING_DATA_FILE = os.path.join(
    os.path.dirname(os.path.abspath(__file__)), "..", 
                        "sample-data", "ietf-interfaces-data.txt")
r, m = s.yang_validate_value("/ietf-interfaces:interfaces/interface/type", 
            "iana-if-type:ethernetCsmacd")
print("\n******** Validate  /ietf-interface:interfaces/interface/type:", r, "  ", m)

# comment out the following line if the DUT has implemented 
# itef-network-monitoring  model
ssmanager.USE_INTERNAL_TESTING_DATA_FILE = os.path.join(
        os.path.dirname(os.path.abspath(__file__)), "..", "sample-data", 
                        "ietf-netconf-monitoring-get-data.txt")
r, m = s.yang_validate_value(
    "/ietf-netconf-monitoring:netconf-state/datastores/datastore/locks/partial-lock/locked-node", 
    "/ietf-netconf-monitoring:netconf-state/sessions/session[session-id='142']/in-bad-rpcs")
print("\n******** Validate  /ietf-netconf-monitoring:netconf-state/datastores/datastore/locks/partial-lock/locked-node:", 
            r, "  ", m)

# type
type = s.yang_lookup("/nacm:nacm/nacm:enable-nacm", "type", 
        {"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})
print("\n/nacm:nacm/nacm:enable-nacm type ", type)

# type
type = s.yang_lookup("/nacm:nacm/nacm:groups/nacm:group/nacm:user-name", 
        "type", {"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})
print("\n/nacm:nacm/nacm:groups/nacm:group/nacm:user-name type ", type)

# type
type = s.yang_lookup("/nacm:nacm/groups/group/user-name", "type", 
        {"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})

type = s.yang_lookup("/nacm/groups/group/user-name", "type", 
    {None: "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})
print("\n/nacm/groups/group/user-name syntax type ", type)

exit(0)
type = s.yang_lookup("/if:interfaces/interface/name", "type", 
        {"if": "urn:ietf:params:xml:ns:yang:ietf-interfaces"})
print("\n/if:interfaces/interface/name syntax type ", type)

# sid form                      
type = s.yang_lookup("/if:interfaces/if:interface/ip:ipv4/ip:enabled", "type", 
                        {"if": "urn:ietf:params:xml:ns:yang:ietf-interfaces", 
                        "ip": "urn:ietf:params:xml:ns:yang:ietf-ip"})
print("\n/if:interfaces/interface/ip:ipv4/enabled ", type)

type = s.yang_lookup("/if:interfaces-state/interface/ip:ipv4/address/origin", "type",
                            {"if": "urn:ietf:params:xml:ns:yang:ietf-interfaces", 
                            "ip": "urn:ietf:params:xml:ns:yang:ietf-ip" })
print("\n/if:interfaces-state/interface/ip:ipv4/address/origin ", type)

type = s.yang_lookup("/ietf-system:system/clock/timezone-name",  "type")
basetype = s.yang_lookup("/ietf-system:system/clock/timezone-name",  "base-type")

print("\n/ietf-system:system/clock/timezone-name ", type, " base ", basetype)


type = s.yang_lookup("/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin",  "type")
print("\n/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin", type)
type = s.yang_lookup("/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin",  "base-type")
enums = s.yang_lookup("/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin",  "enum")
print("\n/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin basetype:", type,  "enums: ", enums)



type = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "type")
ubtype = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "base-type")
union_types = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "union-type")
print("--------base------------")
b1 = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "base-type", union_type="matchall-string-type")
print("----------pattern----------")
pattern1 = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "pattern", union_type="matchall-string-type")
print("----------pattern----------")
pattern2 = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "pattern", union_type="group-name-type")
print("type ", type, " ubtype" , ubtype, " uniontype: ", union_types, " b1 ", b1)
print("/ietf-netconf-acm:nacm/rule-list/group type:", type, " unions: ", union_types, "mathall-string-type pattern: ", pattern1, " group-name-pattern: ", pattern2)
 

type= s.yang_lookup("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host", "type",
     nsmap={'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring'})
btype= s.yang_lookup("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host", "base-type",
     nsmap={'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring'})
print("-- return all union types------------------")
utype= s.yang_lookup("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host", "union-type",
     nsmap={'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring'}, union_type="inet:ip-address")
print("###utype 1 " , utype , "\n")

utype= s.yang_lookup("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host", "union-type",
     nsmap={'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring'} )
print("###utype 2 " , utype)

print("--------base------------")
b1= s.yang_lookup("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host", "base-type",
     nsmap={'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring'},union_type="inet:ipv4-address")
print("----------pattern----------")
p1= s.yang_lookup("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host", "pattern",
     nsmap={'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring'}, union_type="inet:ipv6-address")

#print("Look up IID type ", type, "basetype ", btype, " union type: '%s'"%utype, "b1 ", b1 , " pattern1 " ,p1,  "len ", len(p1))
print("Look up IID type ", type, "basetype ", btype, " union type: '%s'"%utype, "b1 ", b1 , " pattern1 " ,p1[0])


type = s.yang_lookup("/ietf-snmp:snmp/target/udp/ip",  "type")
print("snmp target ip: ", type)
 
id = s.yangiid_to_segueiid("/snmp:snmp/snmp:target/snmp:udp/sd:prefix-length")
print("new id ", id)


type = s.yang_lookup("/ncm:netconf-state/schemas/schema[identifier='nc-notifications'][version='2008-07-14'][format='yang']/identifier", "type", {"ncm":"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring"})
print("Look up IID type: ", type)

utype = s.yang_lookup("/ncm:netconf-state/schemas/schema[identifier='nc-notifications'][version='2008-07-14'][format='yang']/identifier", "union-type", {"ncm":"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring"})
print("Look up IID type ", type, " union type: ", utype)

config = s.yang_lookup("/ietf-netconf-monitoring:netconf-state/schemas/schema[identifier='nc-notifications'][version='2008-07-14'][format='yang']/identifier", 
                     "config")
access = s.yang_lookup("/ietf-netconf-monitoring:netconf-state/schemas/schema[identifier='nc-notifications'][version = '2008-07-14'][format='yang']/identifier", 
                     "access")

print("Look up IID config (True-> RW or False->RO): ", config, " ", access)

keyVals = s.extract_key_from_iid("/ietf-netconf-monitoring:netconf-state/schemas/schema[identifier='nc-notifications'][version='2008-07-14'][format='yang']/identifier")
for key, val in keyVals:
    print("key ", key,  " val ", val)
    
    
keys = s.yang_lookup("/ietf-netconf-monitoring:netconf-state/schemas/schema",  "key")
print("Look up IID key form 1: ", keys)
keys = s.yang_lookup("/ncm:netconf-state/schemas/schema[identifier='nc-notifications'][version='2008-07-14'][format='yang']/identifier",  "key",
                     {"ncm":"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring"})
print("Look up IID key form 2: ", keys)


isMandatory = s.yang_lookup("/ietf-netconf-monitoring:netconf-state/sessions/session/username", "mandatory")
print("Look up IID isMandatory: ", isMandatory)

isMandatory = s.yang_lookup("/ietf-netconf-monitoring:netconf-state/sessions/session/source-host", "mandatory")
print("Look up IID isMandatory: ", isMandatory)

musts=  s.yang_lookup("/ietf-system:system/authentication/user-authentication-order", "must")
print("Look up IID must: ", musts)

orderedby=  s.yang_lookup("/ietf-system:system/authentication/user-authentication-order", "ordered-by")
print("Look up IID orderedby: ", orderedby)

mins =  s.yang_lookup("/ietf-netconf-monitoring:netconf-state/datastores/datastore/locks/partial-lock/select", "min-elements")
print("Look up IID min-elemnts: ", mins)

#   unique 
#   max-elements
#   #default
#   status

type = s.yang_lookup(   "/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin",  "base-type")
print("\n/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin type ", type)

r, m = s.yang_validate_value("/ietf-interfaces:interfaces-state/interface/ietf-ip:ipv4/address/origin",  "static")
print("\nenum valid? ", r, " ", m)

utype = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "union-type")
print("\nunion types ", utype)

ubtypepattern = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "pattern", union_type="matchall-string-type")
print("\nunion base type pattern ", ubtypepattern)

ubtype = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "base-type")
print("\nunion base types ", ubtype)

ubtype = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "base-type", union_type="group-name-type")
print("\nunion base types ", ubtype)


ulength = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/name",  "length")
print("\n******** /ietf-netconf-acm:nacm/rule-list/name length********:", ulength)

ulength = s.yang_lookup("/ietf-netconf-acm:nacm/rule-list/group",  "length", union_type="group-name-type")
print("\n******** /ietf-netconf-acm:nacm/rule-list/group union base type length********:", ulength)

r, m = s.yang_validate_value("/ietf-netconf-acm:nacm/rule-list/name",  "a")
print("\n******** Validate /ietf-netconf-acm:nacm/rule-list/name ********:", r, "  ", m)


r, m = s.yang_validate_value("/ietf-netconf-acm:nacm/rule-list/group",  "a"*1)
print("\n******** Validate /ietf-netconf-acm:nacm/rule-list/group ********:", r, "  ", m)


r, m = s.yang_validate_value("/ietf-netconf-monitoring:netconf-state/sessions/session/session-id", 4294967296)
print("\n******** Validate /ietf-netconf-monitoring:netconf-state/sessions/session/session-id ********:", r, "  ", m)
                     
r, m = s.yang_validate_value("/ietf-netconf-monitoring:netconf-state/sessions/session/session-id", -1)
print("\n******** Validate /ietf-netconf-monitoring:netconf-state/sessions/session/session-id ********:", r, "  ", m)


r, m = s.yang_validate_value("/ietf-netconf-acm:nacm/groups/group/name",  "a")
print("\n******** Validate /ietf-netconf-acm:nacm/groups/group/name ********:", r, "  ", m)

r, m = s.yang_validate_value("/ietf-netconf-acm:nacm/groups/group/name",  "++8=")
print("\n******** Validate /ietf-netconf-acm:nacm/groups/group/name ********:", r, "  ", m)

ssmanager.USE_INTERNAL_TESTING_DATA_FILE = os.path.join(os.path.dirname(os.path.abspath(__file__)), "..", "sample-data", "segue-test-module-get-data.txt")
r, m = s.yang_validate_value("/segue-test-module:mgmt-interface",  "eth0")
print("\n******** Validate  /segue-test-module:mgmt-interface ********:", r, "  ", m)

r, m = s.yang_validate_value("/segue-test-module:default-address/ifname",  "eth0")
print("\n******** Validate  /segue-test-module:default-address/ifname ********:", r, "  ", m)

r, m = s.yang_validate_value("/segue-test-module:default-address/address",  "192.0.2.2")
print("\n******** Validate  /segue-test-module:default-address/address ********:", r, "  ", m)



# min-elements?
# max-elements?
# mandatory
# when
# must
# unique
# mandetoary
# key (all index present)
# default value

