#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #
# Redistribution of this software, in whole or in part, is prohibited #
# without the express written permission of Seguesoft.                #
#######################################################################   
import os, sys

# Extend system path to import 'ssmanager' package under 
# the installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                        "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

nodeIDAndValues = [('/sfarm:server/sfarm:name', 'myserver'), 
     ('/sfarm:server/sfarm:reset/sfarm:input/sfarm:reset-at', '2011-10-1')]

r = s.send_any_action(*nodeIDAndValues,                    
                    namespaces={"sfarm":"urn:example:server-farm"})

 
r = s.send_any_action('/sfarm:server/sfarm:name', 'myserver',
        '/sfarm:server/sfarm:reset/sfarm:input/sfarm:reset-at', "2014-07-29T13:42:00Z",                    
        namespaces={"sfarm":"urn:example:server-farm"})

# input argument can be skipped 
r=s.send_any_action('/sfarm:server/sfarm:name', 'myserver',
        '/sfarm:server/sfarm:reset/sfarm:reset-at', "2014-07-29T13:42:00Z",                    
        namespaces={"sfarm":"urn:example:server-farm"})
