#**********************************************************************
# Copyright (c) 2018 Seguesoft, All Rights Reserved                   *
#                                                                     *
#              RESTRICTED RIGHTS LEGEND                               *
#                                                                     *
# This software is provided with RESTRICTED RIGHTS.                   *
#**********************************************************************
    
import os, robot
#import tempfile
import socket, threading, ssl, sys, traceback
import logging
import random, string

# Reporting keyword status is done simply using exceptions. 
# If an executed method raises an exception, the keyword status is FAIL,
# and if it returns normally, the status is PASS.

class TestFailedException(Exception):
    # normally a test contains a single keyword implemented as a
    # python method, either a class method or module method
    # If there are more than one keyword then will let test 
    # keep running enve if an earlier 
    ROBOT_CONTINUE_ON_FAILURE = True
    ROBOT_SUPPRESS_NAME = True

def test_remarks(msg="Progress Remarks: Test is in progress ..."):
    # Test remarks are printed to the console but not saved to test 
    # result file
    robot.api.logger.console("Progress Remarks: " + msg)        

def test_warn(msg=""):
    robot.api.logger.warn(msg)

def test_error(msg=""):
    robot.api.logger.error(msg)

def test_failed_stop(msg):
    raise  TestFailedException(msg) 

def test_passed(msg="No errors found"):
    robot.libraries.BuiltIn.BuiltIn().set_test_message(msg)

def test_info(msg=""):
    robot.api.logger.info(msg) 

def test_failed_continue(msg=""):
    # Test failed info  goes to test result files
    robot.api.logger.info("[FAILED] " + msg) 

def test_debug(msg=""):
    # Test info goes to test result files 
    robot.api.logger.debug(msg) 

def get_robot_log_level():
    level = robot.libraries.BuiltIn.BuiltIn().set_log_level("DEBUG")
    logging.getLogger('').setLevel(level=level)
    return level
     

def random_id(size=6, chars=string.ascii_uppercase + string.digits):
    return ''.join(random.choice(chars) for x in range(size))

# Enable packet printing in ssclient lib 
# Libraries can also log during the test library import and initialization. 
# These messages do not appear in the log file like the normal log messages,
# but are instead written to the syslog. This allows logging any kind of useful 
# debug information about the library initialization. Messages logged using 
# the WARN or ERROR levels are also visible in the test execution errors 
# section in the log file.

#tempfn = tempfile.NamedTemporaryFile(delete=False).name
#robot.api.logger.warn("tempfile " + tempfn)
#os.environ["ROBOT_SYSLOG_FILE"] = tempfn
#os.environ["ROBOT_SYSLOG_LEVEL"] = "INFO"

try:
    if get_robot_log_level().upper() == "DEBUG": 
        logging.getLogger('').setLevel(level=logging.DEBUG)
    else:
        robot.api.logger.info("No Resetting to debug logging ")
except:
    pass

