#---------------------------------------------------------------------
# Copyright (C) 2013  Seguesoft  Inc.
#                                                                             
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
# Modified based on ncclient
# ----------------------------------------------------------------------
# Copyright 2011 ChampNMS 

from ..xml_ import *

from .rpc import RPC
from .retrieve import GetReply
from . import util

import logging

logger = logging.getLogger("ncclient.operations.sendxml")

"Send RPC using arbitrary xml content text"

class SendXML(RPC):
    "Arbitrary RPC"
    REPLY_CLS = GetReply    
    def request(self, xmlstr, xmldeclaration=True, msgid=None):
        xmlstr = xmlstr.strip()
        #xmlstr = xmlstr.strip('<?xml version="1.0" encoding="UTF-8"?>')
        #print "xmlstr ", xmlstr
        #validated_element(xmlstr, ("rpc", qualify("rpc")))
        #xmlstr='<?xml version="1.0" encoding="UTF-8"?>\n'  + xmlstr
        if isinstance(xmlstr, (bytes, bytearray)): 
            xmlstr = xmlstr.decode("utf-8")
        if not xmlstr.startswith('<?xml') and xmldeclaration==True:
            xmlstr= '<?xml version="1.0" encoding="%s"?>\n%s' % ("UTF-8", xmlstr)
        return self._request(xmlstr,  msgid=msgid)
