######################################################################
# Copyright (C) 2011 - 2021 Seguesoft Inc. All rights reserved.
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
######################################################################
import codecs, traceback, time
import os, sys, subprocess, tempfile
from collections import deque
from itertools import tee 
import json
from lxml import etree
import re
import shutil
import platform
import logging
import collections
import  ssyangtree
import ast
from copy import deepcopy
import multiprocessing 
from common_global_variables import YIN10NS
from os import removedirs
from builtins import str
import bisect
import common_global_variables
import ssinstance
from common_global_variables import DEBUGPRINT, DEBUGPRINT_SYN
from common_global_variables import _dataNodes
from common_global_variables import YIN10NS
from common_global_variables import NEED_A_VALUE_FOR_KEY

from common_global_variables import builtin_types
from common_global_variables import numericTypeMin
from common_global_variables import numericTypeMax
from common_global_variables import numerical_builtin_types_extended

# This flag is used to determine if we raise when encountering errors
# E.g. in a GUI client vs a conftester
is_running_cftest = False

# YIN module dictionary is a dict that contains all YIN modules found in 
# the current YANG_MODULE_PATH         

# this is used to search modules based on module@revision
SS_YANG_Dict = {}

# mapping modulename to namespace, used by RESTCONF
moduleToNamespaceImplementedDict = {}
namespaceToModuleImplementedDict = {}
namespaceToModuleImplementedDict.update({None : None}) # <config> node in None namespace

Show_All_Model = False

revsion_pattern = re.compile("\s+revision\s+['\|\"]*([0-9]{4}-[0-9]{1,2}-[0-9]{1,2})['\|\"]*\s*[{|;]")
# non-greedy 
namepsace_pattern =  re.compile("\s+namespace\s+['\|\"](.+?)['\|\"]\s*;")  
prefix_pattern = re.compile("\s+prefix\s+['\|\"]*(.+?)['\|\"]*\s*;")
belongsTo_pattern = re.compile("\s+belongs-to\s+['\|\"]*(.+?)['\|\"]*\s+{")


IMG_FILE_LIST_MAPPING ={"action" : "console",
                        #"analysis" : "analysis",
                        #"anyxml" : "anyxml",
                        #"argument" : "argument",
                        "augment" : "augment",
                        #"base" : "base",                        
                        #"belongs-to" : "belongs-to", 
                        "bit" : "bit",
                        "case" : "case",
                        "choice" : "generic_elements",                        
                        #"config" : "config",  # this appears in xml instance
                        "contact" : "contact",
                        "container" : "container",
                        #"deviate" : "deviate", 
                        "deviation" : "deviation",
                        #"default" : "default", 
                        #"description" : "description",
                        "feature": "feature",
                        "extension" : "extension",
                        #"enum" : "enum",
                        "error" : "delete2",
                        "error-question" : "question_mark_red",
                        #"error-message" : "error-message", 
                        #"error-app-tag" : "error-app-tag",
                        "grouping" :"grouping",
                        "identity" : "identity", 
                        "if-feature" :"if-feature", 
                        "import" : "importmod", # mismatched name 
                        "include" : "include" , 
                        "input" : "input",
                        "key" : "unique",
                        "leaf" : "leaf", 
                        "leaf-list" : "leaf-list", 
                        "list" : "list",
                        #"length" : "length",
                        #"mandatory" : "mandatory" ,
                        #"max-elements" : "max-elements",
                        #"min-elements" :"min-elements", 
                        "module" : "module16",
                        #"must" : "must",
                        "namespace" : "namespace", 
                        "notification" : "notification",
                        "output" : "output",
                        "organization" : "organization", 
                        #"ordered-by" :"ordered-by", 
                        "prefix" : "prefix", 
                        #"pattern" :"pattern", 
                        #"range" : "range",
                        #"reference" : "reference",  
                        #"refine" : "refine",
                        "revision" : "month-16", # mismatched name
                        #"revision-date" : "month-16", # mismatched name
                        "rpc" : "command", 
                        #"status" : "status", 
                        #"text" :"text",
                        #"type" : "type",
                        "typedef" : "typedef",
                        "unique" :"unique", 
                        #"units" : "units",
                        #"yang-version" : "yang-version",
                        "uses" : "uses",
                        "warning-question" : "question_mark",
                        #"when" : "when"
                        }

# This is to find the mapped YIN nodes corresponding YANG value element
# The following mapping needs special processing b/c they are not
# xml node attributes in YIN file
# contact          | text          | true
# error-message    | value         | true 
# organization     | text          | true
# reference        | text          | true  
# input            | <no argument> | n/a 
# output           | <no argument> | n/a   
#Fix rad.com RE: Mismatch between tree window to edit window
YIN_YANG_MAPPING_EXTRA_NODE_EXCEPTION = ["text", "value"]
YIN_YANG_MAPPING_TEXT_EXCEPTION = ["contact", "description", "error-message", "organization", "reference"]
YIN_YANG_MAPPING_MULTILINE_EXCEPTION = ["when", "must"]
YIN_YANG_MAPPING_RPC_EXCEPTION = ["input", "output"]
   
YIN_YANG_Mapping_Dict = {"action": "name",
            "anydata": "name",                         
            "anyxml": "name",
            "argument": "name",
            "augment": "target-node"  ,
            "base": "name",
            "belongs-to": "module",
            "bit":   "name",
            "case": "name",
            "choice": "name",
            "config": "value",
            "contact": "text",
            "container": "name",
            "default": "value",
            "description": "text",
            "deviate": "value",
            "deviation": "target-node"  ,
            "enum":     "name",
            "error-app-tag": "value",
            "error-message" : "value",
            "extension": "name",
            "feature": "name",
            "fraction-digits": "value",
            "grouping": "name",
            "identity": "name",
            "if-feature": "name",
            "import": "module",
            "include": "module",
            "key":    "value",
            "leaf":   "name",
            "leaf-list": "name",
            "length": "value",
            "list":   "name",
            "mandatory": "value",
            "max-elements": "value",
            "min-elements": "value",
            "modifier": "value",
            "module": "name",
            "must":   "condition"     ,
            "namespace": "uri",
            "notification": "name",
            "ordered-by":"value",
            "organization": "text",
            "path": "value",  
            "pattern": "value",
            "position": "value",
            "prefix": "value",
            "presence": "value",
            "range":  "value",
            "reference": "text",
            "refine": "target-node",
            "require-instance": "value",
            "revision": "date",
            "revision-date": "date",
            "rpc": "name",
            "status": "value",
            "submodule": "name",
            "type":   "name",
            "typedef": "name",
            "unique": "tag",
            "units":  "name",
            "uses":  "name",
            "value": "value",
            "when":  "condition",
            "yang-version": "value",
            "yin-element": "value",           

}

##############################################################
def load_yang_modules_in_paths(*args, recursive=True,
                Target_YANG_Dict= SS_YANG_Dict,
                Target_NS_To_M_Dict = namespaceToModuleImplementedDict,
                Target_M_To_NS_Dict = moduleToNamespaceImplementedDict,
                alwaysConvert=False
                ):
    # set YANG path to given folders or the GUI default 
    if len(args):
        if isinstance(args, str):
            # path string is parsed in  
            os.environ["YANG_MODPATH"]  = args 
        else:
            os.environ["YANG_MODPATH"] = ""
            for path in args:        
                if os.environ["YANG_MODPATH"] == "":
                    os.environ["YANG_MODPATH"] = path
                else:    
                    os.environ["YANG_MODPATH"] = os.environ["YANG_MODPATH"] + os.pathsep + path  
                if recursive:
                    add_all_sub_folders_to_yangpath()
    else:
        mypreferences = common_global_variables.obtainPreferencesObj(
                common_global_variables.SEGUE_netconfc_preferences_file, 
                common_global_variables.MasterYANGdefaultPreferenceDict)
            
        os.environ["YANG_MODPATH"]  =mypreferences.get("Main", "YANG_MODPATH")

    if common_global_variables.DEMOORFULLGUI == "":
        # This is not used in NETCONFc GUI application
        # in ths case when calling load_yang_modules_in_paths()
        # all modules are loaded as well
        # In GUI NETCONFc, parse_module.compile_yang_models_in_paths()
        # snf parse_module.load_yin_models_in_paths() are invoked in
        # _resultProducer()
        
        compilingRes, loadingRes = load_all_modules_in_yang_path(
            Target_YANG_Dict=Target_YANG_Dict,
            Target_NS_To_M_Dict = Target_NS_To_M_Dict,
            Target_M_To_NS_Dict = Target_M_To_NS_Dict,
            alwaysConvert=alwaysConvert          
        )
        print("Compiling Models results ", compilingRes)
        print("Loading Models results ", loadingRes)



def add_all_sub_folders_to_yangpath():
    dirsLst = os.environ["YANG_MODPATH"].split(os.pathsep)
    newAllPathLst = []         
    for dirs in dirsLst:
        newAllPathLst.append(os.path.expanduser(dirs))
        for dirpath, dirnames, _ in os.walk(os.path.expanduser(dirs), followlinks=True):
            for dirname in dirnames:    
                dirFullPath = os.path.join(dirpath, dirname)
                if dirFullPath.find(".svn") == -1 and dirFullPath.find(".cvs") == -1 and dirFullPath.find(".git") == -1:                      
                    newAllPathLst.append(dirFullPath)    
  
    # remove duplicagtes
    newAllPathLst = list(set(newAllPathLst))
    newAllPathLst.sort()
    os.environ["YANG_MODPATH"] = os.pathsep.join(newAllPathLst) 
    return newAllPathLst  
    
def load_all_modules_in_yang_path(Target_YANG_Dict=SS_YANG_Dict,
                Target_NS_To_M_Dict = namespaceToModuleImplementedDict,
                Target_M_To_NS_Dict = moduleToNamespaceImplementedDict,
                alwaysConvert=False
                ):
    create_yang_filename_dict(Target_YANG_Dict=Target_YANG_Dict)

    compilingResultLst= compile_yang_models_in_paths(
            Target_YANG_Dict=Target_YANG_Dict,
            alwaysConvert=alwaysConvert)
    loadResultLst= load_yin_models_in_paths(
            Target_YANG_Dict=Target_YANG_Dict,
            Target_NS_To_M_Dict = Target_NS_To_M_Dict,
            Target_M_To_NS_Dict = Target_M_To_NS_Dict            
            )        
    return (compilingResultLst, loadResultLst)

def get_all_load_modules_in_session(ssesion):
    moduleNames = []
    for k, v in ssesion.SS_YANG_Dict.items():
        if v["lxmlTreeRoot"] is not None:
            moduleNames.append(k)
    return  moduleNames

########################################################################

def CheckIfmustDoConversionByTimeStamp(targetFile):
    fileNameFullPathResults = os.path.splitext(targetFile)[0] + ".res"    
    fileNameFullPathYin = os.path.splitext(targetFile)[0] + ".yin"    
    if not os.path.isfile(fileNameFullPathYin):  
        # no yin file so conversion needed or alwaysConvert
        if os.path.isfile(fileNameFullPathResults):
            os.remove(fileNameFullPathResults)   
        return True    

    # if x.res file is not empty then the last compiling contains
    # some errors. We need to recompile in case dependent files
    # updated. We also need to report the errors every time
    # when NETCONFc starts

    if  not os.path.isfile(fileNameFullPathResults) or \
        os.stat(fileNameFullPathResults).st_size != 0:
        return True    

    # http://stackoverflow.com/questions/237079/how-to-get-file-creation-modification-date-times-in-python
    targetFileModifiedTime = os.path.getmtime(targetFile)    
    outputFileLastModifiedTime = os.path.getmtime(fileNameFullPathYin)        
    if targetFileModifiedTime < outputFileLastModifiedTime:
        return False
    else:
        return True

def register_module_nsmap_all(ssession, treeRoot):    
    # because the root node always contain imported module prefix/namespacce in nsmap so we can do
    # the following directly            
    for prefix, namespace in list(treeRoot.nsmap.items()):
        ssession.register_namespace(prefix, namespace)
        

def _scanToFindAllBasesForAnIdentity (moduleNameColonIdentity, ssession):
    baseIdentitieSets = ssession.identityAndItsBaseDict[moduleNameColonIdentity]
    
    for bi in baseIdentitieSets:
        if bi in  ssession.identityAndItsBaseDict:
            # does this get a reference of bis set?
            # set extend?            
            biOfBis = ssession.identityAndItsBaseDict[bi]
            for biOfBi in biOfBis:
                if biOfBi in ssession.identityAndItsBaseDict[moduleNameColonIdentity] or biOfBi == moduleNameColonIdentity:                    
                    # circular identity
                    return
                ssession.identityAndItsBaseDict[moduleNameColonIdentity].append(biOfBi)
            
                # recursively solve it                
                _scanToFindAllBasesForAnIdentity (biOfBi, ssession)    
            
def searchForIdentitiesOfBase(ssession, basemodulename,  baseidentity, serverSupportedModules, identityDict):
    key = basemodulename  + ":" + baseidentity
    # this is the passed in dict
    identityDict[key] = []  
    DEBUGPRINT("serverSupportedModules ", serverSupportedModules)
    if ssession.identityAndItsBaseDict is None:
        # 1. We need to scan all modules to build Identity : Base dict (identityAndItsBaseDict, the original definition)
        # 2. Scan identityAndItsBaseDict, find all bases for an Identity, so we have Identity : { Base1, Base2, Base3} dict
        #     for example, A->B-C
        # 3. Scan identityAndItsBaseDict again, find all indetities that has the particular base,   identityDict[key] = indetitiesFoundHasBase
        ssession.identityAndItsBaseDict = {} 
        if serverSupportedModules is not None:
            moduleRevs = list(serverSupportedModules.keys())
            for moduleRev in moduleRevs:
                DEBUGPRINT("check moduleRevs ", moduleRev)
                if moduleRev in ssession.SS_YANG_Dict:
                    AtreeObj = ssession.SS_YANG_Dict[moduleRev]["lxmlTreeRoot"]
                    yangFile = ssession.SS_YANG_Dict[moduleRev]["file"]
                    modulename = ssession.SS_YANG_Dict[moduleRev]["module"]
                    if AtreeObj is not None:
                        identityNodes = AtreeObj.xpath("yin:identity", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
                        for idenNode in identityNodes:            
                            if idenNode.get("name").find(":") == -1:
                                res = idenNode.getroottree().getroot().get("name") + ":" + idenNode.get("name")                            
                                #print "res got ", res                 
                                # find its base                  
                                nb = idenNode.xpath('t:base',  namespaces={'t': YIN10NS})
                                baseres = []
                                for n in nb:                                   
                                    if n.get("name").find(":") == -1:
                                        bres = n.getroottree().getroot().get("name") + ":" + n.get("name")
                                    else:    
                                        bres = ssession.yangiid_to_segueiid(n.get("name"), n.nsmap)
                                    #DEBUGPRINT("bread searching for identity base", bres)     
                                    baseres.append(bres.strip("/"))
                                              
                                ssession.identityAndItsBaseDict[res] = baseres
                                
            # 2. Scan identityAndItsBaseDict, find all bases for an Identity, so we have Identity : { Base1, Base2, Base3} dict
            #     for example, A->B-C
            for k, _ in list(ssession.identityAndItsBaseDict.items()):            
                _scanToFindAllBasesForAnIdentity(k, ssession)
                
            # 3. Scan identityAndItsBaseDict again, find all indetities that has the particular base,   
            # identityDict[key] = indetitiesFoundHasBase
            for k in list(ssession.identityAndItsBaseDict.keys()):
                for k2, bi2 in list(ssession.identityAndItsBaseDict.items()):
                    if k in bi2:
                        if k in  ssession.identityDict:
                            ssession.identityDict[k].append(k2)
                        else:
                            ssession.identityDict[k] = []
                                  



def _isPossileAugmentingModule(augmentedModuleRoot, extendedModuleRoot): 
    # check if augmenting module imports the augmented module and if the
    # augmenting module contains "augment" statement       
    augmentedModuleName= augmentedModuleRoot.get("name")
    importNodes = extendedModuleRoot.xpath("yin:import", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    if len(importNodes):
        for impnode in importNodes:            
            impModuleName = impnode.get("module")       
            if impModuleName == augmentedModuleName:
                # check if contains augment
                augmentNodes = extendedModuleRoot.xpath("yin:augment", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
                if len(augmentNodes) :
                    return True
    # in a submodule it can augment the main module     
    foundCorrespondentBelongsToNode = extendedModuleRoot.xpath("yin:belongs-to[@module='%s']"%augmentedModuleName,  namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})    
    #print "found belongs-to node ", len(foundCorrespondentBelongsToNode), " ", foundCorrespondentBelongsToNode        
    if  len(foundCorrespondentBelongsToNode) == 1:                  
        augmentNodes = extendedModuleRoot.xpath("yin:augment", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        if len(augmentNodes) :
            return True
                        
    return False

def addTrimSpaceListPredicate(k, type="add"):
    kIDLst = k.split("/")
    nk = ""
    
    for kIDItem in kIDLst:
        if kIDItem == "":
            continue
                        
        start = kIDItem.find("[")
        if start !=-1:
            listEntry = kIDItem[0:start]                                        
            listPredicate = kIDItem[start:]                                                            
            
            listPredicateExtraSpaceOrChars = ""
            alreadyInserted=False

            for predicate in re.split(r"\[|\]", listPredicate):
                if predicate =="": 
                    continue
                
                #DEBUGPRINT("predicate ", predicate)
                (keyName, keyValue) = predicate.split("=", 1)                        
                keyValue = dequote(keyValue)  
                if type == "add":                      
                    listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='   %s   ']"%(keyName, keyValue)
                elif type == "insert" or type == "insertOne":
                    if type == "insertOne" and alreadyInserted:
                        # insertOne is to just change only one key value. So there is one key value has been changed
                        # use the same value for the rest of keys 
                        listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='%s']"%(keyName, keyValue)                             
                    elif len(keyValue) == 0:
                        listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='%s']"%(keyName, "segue test")                               
                    elif len(keyValue) == 1:
                        listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='%s']"%(keyName, keyValue+keyValue)
                    else:  
                        listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='%s']"%(keyName, keyValue[0:-1] +" test "+ keyValue[-1])
                    if type == "insertOne":
                        alreadyInserted = True    
                elif type == "insertIntLarge":
                    listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='%s']"%(keyName, 2**64)
                elif type == "insertStrLong":    
                    listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='%s']"%(keyName,  "x" * 500)
                else:                            
                    # just trip any leading or trailing space
                    listPredicateExtraSpaceOrChars = listPredicateExtraSpaceOrChars + "[%s='%s']"%(keyName, keyValue.strip())
                    
            nk = nk + "/" + listEntry + listPredicateExtraSpaceOrChars                        
        else:
            nk = nk + "/"+ kIDItem
            
    return nk         
    


def build_nodeIDAndValDictList(dataRoot, session, instanceDataOnly=False,
             includeKeyNode=False, requestIIDToExclude=[], unknownNodeIDs=[]):
    #nodeIDDict = collections.OrderedDict()
    nodeIDAndValDictList = []    
    nsmap = {}
    
    if isinstance(dataRoot, str):
        dataRoot = etree.fromstring(dataRoot)
    
    # Iterate instance tree, each time we only consider one node, so 
    # we don't need to check if multiple nodes belong to the same list entry  
    sameInstanceListEntryFlagDict = {"flag": False }
    
    foundYANGTreeRoot = None
    ssYangTreeInst = None
    
    for elemNode in dataRoot.iter():       
        if elemNode is dataRoot or len(elemNode):
            continue
        
        nodeIDAndValues = []        
        #DEBUGPRINT("\n---- process instance node %s : %s"%(elemNode.tag, elemNode.text) )
        try:               
            #DEBUGPRINT("foundYANGTreeRoot is ", foundYANGTreeRoot)
            #DEBUGPRINT(" ssYangTreeInst is ", ssYangTreeInst)
            
            ssinstance.getInstNodeYangInstanceID(elemNode, dataRoot,
                        nodeIDAndValues, nsmap, 
                        sameInstanceListEntryFlagDict=sameInstanceListEntryFlagDict,
                        separateLeafListIID=False, # Do not enumerate leaflist value using [.= value]  as key
                        )
        except ssinstance.KeyOrderError:
            raise                 
        except Exception:
            unknownNodeID = ssinstance.getInstanceIDPath(elemNode,  None)               
            #DEBUGPRINT("Detected an unknownNodeID ", unknownNodeID)
            unknownNodeIDs.append(unknownNodeID)
            continue
      
        if len(nodeIDAndValues) == 0:
            unknownNodeID = ssinstance.getInstanceIDPath(elemNode,  None)               
            unknownNodeIDs.append(unknownNodeID)
            continue

        #DEBUGPRINT("nodeIDAndValues got ", nodeIDAndValues)
        (nodeIID, value) = nodeIDAndValues[0]
        
        value.update({"elemLXML": elemNode, "nsmap": nsmap})        

        #spaceStrippedNodeIID = addTrimSpaceListPredicate(nodeIID, "strip")
        
        if instanceDataOnly:   
            #DEBUGPRINT("testIID ", nodeIID, " ", value )
            if value["leaflist_node"]:
                # check if this leaflist entry has been created
                if len(nodeIDAndValDictList) >0 and nodeIDAndValDictList[-1][0] == nodeIID: 
                    if not isinstance(nodeIDAndValDictList[-1][1]["value"], str): 
                        nodeIDAndValDictList[-1][1]["value"].append(value["value"])
                    else:
                        nodeIDAndValDictList[-1][1]["value"] =  [value["value"]]
                            
                else:
                    value["value"] = [value["value"]]
                    nodeIDAndValDictList.append((nodeIID, value))            
                                            
            elif value["leaf_node"]:
                if value["listkey_node"]:
                    if includeKeyNode:  
                        nodeIDAndValDictList.append((nodeIID, value))
                else:
                    nodeIDAndValDictList.append((nodeIID, value))
            # do not include presence container in the output since get on this kind of IID 
            # will not result in one single instance                                                
            #elif value["prensence_container_node"]:
            #    nodeIDAndValDictList.append((nodeIID, value))                        
        else:            
            nodeIDAndValDictList.append((nodeIID, value))    
        # decide whether we should remove this entry from the return list  
        if nodeIID in requestIIDToExclude:
            if value["leaflist_node"]:
                if requestIIDToExclude[nodeIID].strip() in value["value"]:
                    nodeIDAndValDictList.remove((nodeIID, value))
            else:
                #leaf node    
                if  requestIIDToExclude[nodeIID].strip() ==  value["value"].strip():
                    nodeIDAndValDictList.remove((nodeIID, value))        
    return nodeIDAndValDictList


def build_module_top_nodeID_List(treeRoot):
    # we need to top IDs to retrieve all data in a module 
    nodeIDs = []
    nsmap = {}
    
    for topChildElem in treeRoot:
        if getStatementValue(topChildElem) in [ "anyxml", "anydata", "container", "list", "leaf-list", "leaf"]:
            (nodeID, mymap) = getNodeIDPath(topChildElem, includeKey=False, topNode=treeRoot)
            nodeIDs.append(nodeID)
            nsmap.update(mymap)            
    return (nodeIDs, nsmap)        


def _getNodeIDPathHelper(node, relative, topNode, excludeChoiceCase=True):      
    # excludeChoiceCase flag used by masterYANG editor                  
    nodeID = ""
    nsmap = {}
    while True:
        statement = getStatementValue(node)
        # choice and case does not appear in XML encode
        #print "get nodeID statement ", statement
        excludeChoiceCaseLst=[]
        if excludeChoiceCase:
            excludeChoiceCaseLst.extend(["choice", "case"])
        #excludeChoiceCaseLst.extend(["choice", "case"])    
        #print " excludeChoiceCaseLst ", excludeChoiceCaseLst    
        if statement not in excludeChoiceCaseLst:
            (myID, mymap) = get_prefix_qualified_name_and_nsmap_helper(node)
            if nodeID != "":                
                nodeID =  myID + "/"+ nodeID
            else:
                nodeID =  myID
            nsmap.update(mymap)                
        node = node.getparent()
        if node is None or node is topNode:
            break
    # finally    
    if not relative and not nodeID.startswith("/"):                        
        nodeID =  "/" + nodeID 

    #if None in nsmap:
    #    del nsmap[None]
        
    return (nodeID, nsmap)
                                    
def getNodeIDPath(node, topNode=None, 
            rootNode=None,
            relative=False, 
            includeKey=False, excludeChoiceCase=True):
    return  _getNodeIDPathAndValueHelper(node, 
        rootNode=rootNode,
        topNode=topNode, relative=relative,
        includeKey=includeKey, getValue=False, 
        excludeChoiceCase=excludeChoiceCase)        
    
def getNodeIDPathAndValue(node, topNode=None, 
                rootNode=None,
                relative=False, 
                includeKey=False):               
    return _getNodeIDPathAndValueHelper(node, 
                rootNode=rootNode,
                topNode=topNode,
                relative=relative, 
                includeKey=includeKey, getValue=True)        
    
def getNodeIDPathValueForEditConfig(node, topNode=None, 
                rootNode=None,
                relative=False, includeKey=True, 
                alreadyStagedNodeIDAndValues=[], 
                onlyDecendantOfSelected=False):
    return _getNodeIDPathAndValueHelper(node, 
                topNode=topNode, 
                rootNode=rootNode,
                relative=relative, 
                includeKey=includeKey, 
                buildEditConfigValDict=True,
                alreadyStagedNodeIDAndValues=alreadyStagedNodeIDAndValues)

def _buildEditConfigValueDict(node, isKeyNode=False):   
    editValue = node.get("content_match_or_set_value")
    if editValue is None:
        # IF buildEditConfigValDict is true
        # we are building xml for edit-config so we report an error if no value for keys are specified            
        if isKeyNode:
            editValue = NEED_A_VALUE_FOR_KEY
        else:
            editValue = ""    
    value =  {"value": editValue}     
    
    operationVal = node.get("operation")       
    if operationVal is not None and operationVal != "unspecified":
        value["operation"] = operationVal


    operationVal = node.get("ordered-by-user")       
    if operationVal is not None and operationVal != "unspecified":
        value["insert_operation"] = operationVal
        
        
    yangInsertBeforeAfterTargetVal = node.get("ordered-by-user-insert-list-value")
    if yangInsertBeforeAfterTargetVal is not None:  
        # yangInsertBeforeAfterTargetVal returned is key1=val1;key2=val2...
        keyNameValList=[]
        keyNameValStrList = yangInsertBeforeAfterTargetVal.split(";")
        for keyNameValStr in keyNameValStrList:
            keyName, keyVal = keyNameValStr.split("=")
            keyNameValList.append((keyName, keyVal))
        value["target_key"] = keyNameValList

    yangInsertBeforeAfterTargetVal = node.get("ordered-by-user-insert-leaf-list-value")
    if yangInsertBeforeAfterTargetVal is not None:
        # yangInsertBeforeAfterTargetVal returned is a value  
        value["target_value"] = yangInsertBeforeAfterTargetVal                

                                
    withDefaultVal = node.get("default-attribute")     
    if withDefaultVal is not None and withDefaultVal != "unspecified":  
        value["with_default"] = withDefaultVal == "true"
    
    XMLDataVal = node.get("raw_XML_data")
    if XMLDataVal is not None and XMLDataVal == "true":
        value["raw_XML_data"] = True
    else:    
        value["raw_XML_data"] = False
    
    return value

def  _checkIfSameInstanceSpecified(keyNodeValueList, alreadyStagedNodeIDAndValues):
    if len(alreadyStagedNodeIDAndValues) == 0:
        return False        
    for i in range (len(alreadyStagedNodeIDAndValues) - len(keyNodeValueList) + 1):
        if alreadyStagedNodeIDAndValues[i:i + len(keyNodeValueList)] == keyNodeValueList:
            return True    
    return False  

def _getNodeIDPathAndValueHelper(
        node, 
        topNode=None,         
        rootNode = None,
        relative=False, 
        includeKey=False,
        getValue=False, 
        buildEditConfigValDict=False,
        alreadyStagedNodeIDAndValues=[], 
        excludeChoiceCase=True):    

    if rootNode is None:
        rootNode = node.getroottree().getroot()
    if topNode is None:
        topNode =  rootNode

    (nodeID, nsmap) = _getNodeIDPathHelper(node, 
            relative, topNode, excludeChoiceCase=excludeChoiceCase)        

    # If there is content match value specified, make nodeID a tuple
    if not buildEditConfigValDict:
        if node.get("content_match_or_set_value") is not None and getValue:            
            nodeID = (nodeID, node.get("content_match_or_set_value"))
        else:
            # Keep the original str form
            pass    
    else:
        nodeID = (nodeID, _buildEditConfigValueDict(node))
        
    #if includeKey and not onlyDecendantOfSelected:
    if includeKey:
        #selectedNodeIDProcessed = False
        # return a list of nodeID with parent keys added
        ancestorsFromTop=[]   
        for ancestor in node.iterancestors():
            if ancestor.tag == " {urn:ietf:params:xml:ns:netconf:base:1.0}module":
                break
            ancestorsFromTop.append(ancestor)
        
        ancestorsFromTop.reverse()
        
        nodeIDsIncludeKeys = []
        theSameListEntryFlag =True    
        listEntryNotChecked = True
        
        if len(ancestorsFromTop):
            for ancestor in ancestorsFromTop:                                                                 
                if isListNode(ancestor):
                    listEntryNotChecked = False
                    # Get the key node as defined in 'key' statement so we are sure about its encoding order
                    #
                    # Add "new_list_entry" to key node's valDict for creating correct xml for multiple lists
                    (ancestorNodeID, mymap) = _getNodeIDPathHelper(ancestor, relative, 
                            topNode, excludeChoiceCase=excludeChoiceCase)

                    if buildEditConfigValDict:
                        ancestorNodeID = (ancestorNodeID, _buildEditConfigValueDict(ancestor))
                        nodeIDsIncludeKeys.append(ancestorNodeID)    
                        nsmap.update(mymap)
                    
                    # Now include the actual key nodes
                    keyLst = getListKey(ancestor).split()
                    keyValueDict={}
                    keyValueOrderedLst = []                        
                    
                    for child in ancestor.iterchildren():
                        if getStatementValue(child) != "leaf":
                            continue
                        
                        (childNodeID, childNodeNSmap) = \
                            _getNodeIDPathHelper(child, relative, topNode, 
                            excludeChoiceCase=excludeChoiceCase)
                        
                        if isListKeyNode(child): 
                            keyName =  getArgumentValue(child)
                                
                            if not buildEditConfigValDict:
                                if child.get("content_match_or_set_value") is not None and getValue:            
                                    childNodeID = (childNodeID, child.get("content_match_or_set_value"))
                            else:
                                childNodeID = (childNodeID, _buildEditConfigValueDict(child, isKeyNode=True))                                
                            keyValueDict[keyName] = childNodeID
                            
                            # add an entry using keyName without prefix. For example, a list defined in a augmenting module
                            # the key defined in augmenting module will have no prefix, but when applied in the augmented 
                            # module, the actual key node name will have prefix qualified. For example:
                            # keyValueDict  {'Context:contextNameId': 
                            #   ('/ComTop:ManagedElement/Context:Context/Context:contextNameId', 
                            #     {'value': 'NEED-A-VALUE-FOR-KEY-NODE!'})}
                            #keyKst  ['contextNameId']
                            if keyName.find(":") != -1: 
                                keyValueDict[keyName.split(":")[1]] = childNodeID                            
                            nsmap.update(childNodeNSmap)
   
                    for key in keyLst:
                        if key in  keyValueDict:
                            if keyValueDict[key] not in nodeIDsIncludeKeys:
                                keyValueOrderedLst.append(keyValueDict[key])                                
                                
                    #print "keyValueOrderedLst ", keyValueOrderedLst       
                    # We also need to make sure this list does not have the same key values that have already been 
                    # processed. This avoids creating duplicated list entries when using
                    # "Add staged values to next edit-config"
                    
                    
                    # check if all key nodes value sequence have already existed in the data assembled previously
                    # by default we assume the same list entry
                    # but once we detect the parent is not the same entry the its children are 
                    if theSameListEntryFlag:                            
                        theSameListEntryFlag = _checkIfSameInstanceSpecified(keyValueOrderedLst,
                                                    alreadyStagedNodeIDAndValues )
                    
                    if not theSameListEntryFlag:                             
                        nodeIDsIncludeKeys.extend(keyValueOrderedLst)
                    else:
                        # get rid of the list entry itself
                        if ancestorNodeID in nodeIDsIncludeKeys:
                            nodeIDsIncludeKeys.remove(ancestorNodeID)                            
                    #print "nodeIDsIncludeKeys ", nodeIDsIncludeKeys  
                    
            # Finally add the leaf node ID in question           
            # this way we can make sure the key node is always encoded first ,
            # before other leaf nodes     
            # if the keyNode is selected and it is already added along with searching for parent keys
            # do not add it again. 
            #print "alreadyStagedNodeIDAndValues: ", alreadyStagedNodeIDAndValues
            DEBUGPRINT("current examing nodeID: ", nodeID)

            # nodetypeNodeCategory : leaf, leaflist etc. 
            # nodeID may just be a string nodeID, not a tuple created earlier 
            if not isinstance(nodeID, str):
                nodetypeNodeCat = getStatementValue(get_elemNode_from_IDPath(nodeID[0], rootNode))
                DEBUGPRINT(" nodetypeNodeCat ", nodetypeNodeCat)
                nodetypeNodeCatNew = True
                nodetypeNodeIDNew = True
                # exclude the same leaf-list value
                for alreadyStagedIDValue in alreadyStagedNodeIDAndValues:
                    if alreadyStagedIDValue[0] == nodeID[0]:
                        nodetypeNodeIDNew = False
                        if "value" in alreadyStagedIDValue[1] and "value" in nodeID[1]:
                            if alreadyStagedIDValue[1]["value"] == nodeID[1]["value"]:
                                nodetypeNodeCatNew = False
                                    
                if nodeID  not in nodeIDsIncludeKeys and (not theSameListEntryFlag or 
                        (listEntryNotChecked and (nodetypeNodeIDNew or 
                        (nodetypeNodeCat =="leaf-list" and nodetypeNodeCatNew))) or 
                        (nodetypeNodeCat=="leaf-list" and nodetypeNodeCatNew)):
                    nodeIDsIncludeKeys.append(nodeID)                 
                return  (nodeIDsIncludeKeys, nsmap)   
            else:
                #if isinstance(nodeID, str):
                #    nodeID = [nodeID]
                return (nodeID, nsmap)                                
        else:
            #if isinstance(nodeID, str):
            #    nodeID = [nodeID]            
            # include key flag is not set, just return nodeID and nsmap    
            return (nodeID, nsmap)
    else:    
        #if isinstance(nodeID, str):
        #    nodeID = [nodeID]        
        return (nodeID, nsmap)

def build_yang_nodeID_dict(treeRoot):
    # build nodeID dictionary
    # nodeID :{ nsmap : {}, keyNodeIDsList :[...]}
    # nsmap is a map merged with nodeID nsmap and its key nodes' nsmap if any
    nodeIDDict = collections.OrderedDict()
    
    nsmap = {}
    prevGroupingNodeID = ""            
    for nodeElem in treeRoot.iter():
        if getStatementValue(nodeElem) in ("grouping", "notification", "rpc") :
            (prevGroupingNodeID, mymap) = getNodeIDPath(nodeElem, includeKey=False, topNode=treeRoot)
        elif getStatementValue(nodeElem) in [ "anyxml", "anydata", "container", "list", "leaf-list", "leaf"]:
            # the returned value has additional nodeIDs with key nodes returned
            
            (nodeID, mymap) = getNodeIDPath(nodeElem, includeKey=False, topNode=treeRoot)
            (nodeIDs, mymap) = getNodeIDPath(nodeElem, includeKey=True, topNode=treeRoot)
            nsmap.update(mymap)

            if len(nodeIDs) == 1:
                if prevGroupingNodeID != "" and nodeIDs[0].startswith(prevGroupingNodeID):
                    continue                
                nodeIDDict[nodeIDs[0]] = {"elemLXML": nodeElem, "nsmap": nsmap, "keyIDList":{}}
                prevGroupingNodeID = ""
            elif len(nodeIDs) > 1:
                if prevGroupingNodeID != "" and nodeIDs[-1].startswith(prevGroupingNodeID):
                    continue                
                
                # the last one is the leaf. The leading IDs are its key
                if isListKeyNode(nodeElem):                    
                    nodeIDDict[nodeID] = {"elemLXML": nodeElem, "nsmap": nsmap, "keyIDList":nodeIDs[:]}
                else:
                    nodeIDDict[nodeID] = {"elemLXML": nodeElem, "nsmap": nsmap, "keyIDList":nodeIDs[:-1]}    
                prevGroupingNodeID = ""               
                                                   
    return nodeIDDict

def always_convert_yang_module_to_format(yangFileFullPath):
    return convert_yang_module_to_format(yangFileFullPath,
                    alwaysConvert=True)

def convert_yang_module_to_format(yangFileFullPath, 
                    outputFileFullPath=None, 
                    convertToFormat="yin", 
                    alwaysConvert=False, 
                    additionalOptions=""):
    # Invokes pyang to convert YANG file to other formatted file
    # convertToFormat: 
    #       Supported formats are: yin

    # If outputFileFullPath is None, then save the converted file 
    # into the same directory as the source YANG file.
    
    # If there is already a corresponding YIN file found, the compiling 
    # is done only when the YANG file is 'newer' than the corresponding 
    # YIN file, unless alwaysConvert is set to True    
            
    errorResult = ""   
    if outputFileFullPath is None:            
        (root, _) = os.path.splitext(yangFileFullPath)
        outputFileFullPath = root + "." + convertToFormat
        
        
    fileNameFullPathResults = os.path.splitext(yangFileFullPath)[0] + ".res" 
    if alwaysConvert:  
        if os.path.isfile(fileNameFullPathResults):
            os.remove(fileNameFullPathResults)   
    else:            
        if not CheckIfmustDoConversionByTimeStamp(yangFileFullPath):
            return ""                          
        
    if outputFileFullPath is not None:        
        with codecs.open(fileNameFullPathResults, "w", "utf-8") as resHandle:        
            try:
                # delete existing file first since pyang won't overwrite the existing one
                try:
                    os.remove(outputFileFullPath)
                except:
                    pass

                commandLst= [common_global_variables.PYTHON_APP,
                            common_global_variables.PyangScript,  
                            "--no-path-recurse",  "--lax-quote-checks",
                            "-f", convertToFormat, "-o", outputFileFullPath]                       
                if additionalOptions != "":                 
                    commandLst.extend(additionalOptions.split(" "))
                                                                                                                    
                if common_global_variables.validate_rfc6087_rules:
                    if "--lint" not in commandLst:
                        commandLst.insert(1, "--lint") 
                        if "--strict" in commandLst:
                            commandLst.remove("--strict")                        
                        
                if common_global_variables.validate_normal_rules:
                    if "--strict" in commandLst:
                        commandLst.remove("--strict")                        
                    if "--lint" in commandLst:
                        commandLst.remove("--lint")                        
                          
                commandLst.append(yangFileFullPath)     
                res = subprocess.check_output(commandLst, stderr=resHandle, 
                        stdin=subprocess.DEVNULL)  
                                         
            except Exception as e:
                errstrLst = str(e).split(']')
                if len(errstrLst) > 1:
                    pyangcremoved = errstrLst[1]
                    resHandle.write('- : error: ' + pyangcremoved)
                else:
                    resHandle.write('- : error: ' + str(e))
            
        # if there is only warning, pyang subprocess won't raise an exception
        # so we must get errorResult for both
        # error and warnings here outside of the try-block
        try:
            with codecs.open(fileNameFullPathResults, "r", "utf-8") as resHandle:                   
                errorResult = resHandle.read()
                # We don't need PAYNG traceback 
                errorResult = errorResult.split("Traceback (most recent call last):")[0]
        except Exception as e:
                errorResult = "Error reading %s. Got %s"%(fileNameFullPathResults, repr(e))
    return errorResult

"""
def add_to_yang_filename_dict(fileFullPath):                   
    useKey = update_Target_YANG_Dict(fileFullPath)
    return useKey
"""

def get_all_sub_folders(topdir):
    newAllPathLst = []         
    newAllPathLst.append(os.path.expanduser(topdir))
    for dirpath, dirnames, _ in os.walk(os.path.expanduser(topdir), followlinks=True):
        for dirname in dirnames:    
            dirFullPath = os.path.join(dirpath, dirname)
            if dirFullPath.find(".svn") == -1 and dirFullPath.find(".cvs") == -1 and dirFullPath.find(".git") == -1:                      
                newAllPathLst.append(dirFullPath)    
    return newAllPathLst

"""
def search_files_importing_the_module_regex(moduleNameValueLst):
    importFileLst = []
    processedFiles = []

    if len(moduleNameValueLst) == 0:
        return []
    
    reLst = [r'import\s+%s\s|include\s+%s\s*;'%(moduleNameValue,moduleNameValue) for moduleNameValue in moduleNameValueLst]
    reStr = "|".join(reLst)

    importingModulePossible = re.compile( 
                reStr,
                re.DOTALL | re.MULTILINE
                )
        
        
    for moduleRevFile in  list(SS_YANG_Dict.keys()):
        yangOrYinFile = SS_YANG_Dict[moduleRevFile]["file"]
        modulename = SS_YANG_Dict[moduleRevFile]["module"]
        if modulename not in  moduleNameValueLst:
            if yangOrYinFile not in processedFiles:
                # the SS_YANG_Dict contains duplicated copies so we skip them
                #print "Search in ",  yangOrYinFile
                processedFiles.append(yangOrYinFile)
                if os.path.isfile(yangOrYinFile):
                    with open(yangOrYinFile, 'r') as f:
                        yangStr = f.read()                                      
                        r = importingModulePossible.search(yangStr, 0, len(yangStr))
                        if r is not None:                            
                            # if it is likely a module that augmenting the current module
                            # then we parse it to confirm  
                            DEBUGPRINT("\tfound one possible importing module" + yangOrYinFile)
                            if yangOrYinFile.lower().endswith(".yang"):                                     
                                importFileLst.append((moduleRevFile, yangOrYinFile,modulename))
                     
    return importFileLst                   

def get_files_importing_the_module_regex(moduleNameList, modules_to_load_list=[]):
    # could have better considered revision 
    importingModuleNames = []
    #for recompiledModule in moduleNameList:
    
    # remove any duplicated names
    moduleNameList = list(set(moduleNameList))    
    #print " moduleNameList ", moduleNameList
    importingFilesList = search_files_importing_the_module_regex(moduleNameList)
    #print " importingFilesList " , importingFilesList
    DEBUGPRINT("found modules  that import these modules,  " + str(moduleNameList))
    #print "found modules ",  importingFilesList , "  that import these modules: " , " ".join(moduleNameList)
    
    for _, importingFile, modulename in importingFilesList:      
        #print " importingFile ", importingFile        
        modules_to_load_list.append((importingFile,True, False) )
        importingModuleNames.append(modulename)
    
    # recursively    
    if len(importingModuleNames):
        get_files_importing_the_module_regex(importingModuleNames, modules_to_load_list)

    # remove any duplicates    
    return list(set(modules_to_load_list)) 

"""      
                                
def create_yang_filename_dict(force=True, Target_YANG_Dict=SS_YANG_Dict):
    # Just scanning filename to create the dict for displaying
    # in module name list window (module_list_model), no actual 
    # compiling or loading is done.

    # Each NETCONF session covert interested YANG file to 
    # YIN (XML format) if needed and then load them into memory. 
    #
    # Don't keep clean lxml tree (unaugmented) globally and 
    # deepcopy it in each sesssion for augmenting since reparsing 
    # the YIN file is cheaper than deepcopy lxml tree.

    # Build Target_YANG_Dict that contains all YANG module files 
    # found in the current YANG_MODPATH   
   
    if force or len(Target_YANG_Dict) == 0:
        Target_YANG_Dict.clear()

        if "YANG_MODPATH" in os.environ:
            path = os.environ['YANG_MODPATH']
        else:
            raise Exception("The environment variable to YANG module " \
                            "path YANG_MODPATH has not been set!")                                  
        for rootdir in path.split(os.pathsep):
            if rootdir =="" or os.path.exists(rootdir) == False:
                continue                         
            for root, dirs, files in os.walk(rootdir, followlinks=True):
                if len(files) == 0:
                    continue
                for name in files:    
                    _, file_extension = os.path.splitext(name)
                    if file_extension.upper() == ".YANG":
                        fileNameFullPath = os.path.join(root, name)     
                        update_Target_YANG_Dict(fileNameFullPath, 
                                    Target_YANG_Dict=Target_YANG_Dict)      
                # do not walk into sub folders since YANF_MODPATH
                # contains desired sub folders explicitly 
                break    
                    
def update_Target_YANG_Dict(fileNameFullPath, Target_YANG_Dict):
    # scan file name to get module name and rev if any
    filename = os.path.basename(fileNameFullPath)
    moduleNameValue, _ = os.path.splitext(filename)

    # The dict key is modulename@revsion
    # modulename@revsion :  this is used when looking up among yang modules.
    # modulename         :  this is used when searching submodules                                                             
    useKeyNoFile = moduleNameValue
    revisionValue = ""

    if moduleNameValue.find("@") != -1:
        moduleNameValue,  revisionValue= moduleNameValue.split("@")
 
    if useKeyNoFile in Target_YANG_Dict:
        # A model may have multiple YANG files scattered 
        # in different folder
        filesExisted = Target_YANG_Dict[useKeyNoFile]["additionalFiles"]
        Target_YANG_Dict[useKeyNoFile]["additionalFiles"] = \
                filesExisted + os.pathsep + fileNameFullPath
    else:    
        moduleItem =   {"module" : moduleNameValue,
                          "revision" : revisionValue,
                          "namespace" : "",
                          "prefix": "",
                          "belongsTo" : "",
                          "file" : fileNameFullPath,
                          "additionalFiles" : "",
                          "lxmlTreeRoot" : None,   
                          "usesGroupsApplied" : False,
                          "augmentsApplied" : False                                               
                       }                        
              
        # Note there could be multiple exactly same YANG files in 
        # different directory and we use the first one scanned                    
        Target_YANG_Dict[useKeyNoFile]      =  moduleItem

def load_yang_module(fileNameFullPath, alwaysConvert=False, 
                Target_YANG_Dict=SS_YANG_Dict,
                Target_NS_To_M_Dict = namespaceToModuleImplementedDict,
                Target_M_To_NS_Dict = moduleToNamespaceImplementedDict):    
    (root, ext) = os.path.splitext(fileNameFullPath)
    if ext.lower() == ".yang": 
        compilingResult = convert_yang_module_to_format(fileNameFullPath, 
                           alwaysConvert=alwaysConvert)

        if os.path.isfile(root +  ".yin"):
            (treeObj, loadResult) = load_yin_module(root +  ".yin", 
                    Target_YANG_Dict=Target_YANG_Dict,
                    Target_NS_To_M_Dict = Target_NS_To_M_Dict,
                    Target_M_To_NS_Dict = Target_M_To_NS_Dict                           
                    )            
            return (treeObj, compilingResult, loadResult)
        else:
            return (None, compilingResult, "yin file %s.yin was not generated"%root)
    else:
        raise Exception("Not a YANG module. Filename must have .yang extension!")     

"""  
def chk_valChk(session, ctxElem, ctxNode, idLocalName, valChk, originalCtexElem): 
    if not valChk.startswith("'") and not valChk.startswith('"') and not is_number(valChk) and  is_likely_a_node_path(valChk) and valChk !="":
        #print "this should be node path"
        valChkLst, val = get_part_subid_list_and_val([valChk,""])
        #print "valChk is a path so we  go check ", valChkLst, " ctxElem ", getArgumentValue(ctxElem), " orignal ctexElm ", getArgumentValue(originalCtexElem)
        #msg = check_xpath_param_reference(ctxElem, valChk, "", session, whenormustElemParent)
        msg = check_xpath_param_reference(ctxElem, ctxElem, valChkLst, val, session, originalCtexElem)
        if msg != "":
            return msg   
    else:                  
        try:
            syntax = session.yang_lookup(ctxNode, "base-type")     
            valChk =valChk.strip("()")   
            #print "base syntax ", syntax
            
            if syntax == "enumeration":    
                res = lookup_property(ctxNode, "enum", ctxNode.getroottree().getroot(), "")    
                if res != "":
                    enumList = res.split()
                    if ast.literal_eval(valChk) not in enumList:
                        return "the value '%s' referenced by '%s' is not found"%(valChk, idLocalName)
             
            elif syntax == "bits":
                res = lookup_property(ctxNode, "bit", ctxNode.getroottree().getroot(), "")    
                if res != "":
                    bitsList = res.split()
                    if ast.literal_eval(valChk) not in bitsList:
                        return "the value '%s' referenced by '%s' is not found"%(valChk, idLocalName)
            
            elif syntax ==  "boolean":
                if ast.literal_eval(valChk) not in ["true", "false"]:
                    return "the value '%s' referenced by '%s' is not found"%(valChk, idLocalName)
            elif syntax == "identityref":
                idrefBase = session.yang_lookup(ctxNode, "base")
                #print "idrefBase chking ", idrefBase, " is the base of ", ast.literal_eval(valChk)
                #print "find in server supported modules ", session.serverSupportedModules
                if not session.is_derived_identity_of(ast.literal_eval(valChk), idrefBase, ctxNode, originalCtexElem):
                    return "the value '%s' referenced by '%s' is not found."%(valChk, idLocalName) 
        except Exception as e:         
            # can't raise in production    
            #traceback.print_exc()         
            pass    
       
    return ""
"""

#source = """(.='true') or (../../mep:shutdown='false' and count(../../service[shutdown='false'][classification/priority-bit=current()/../classification/priority-bit123])=1)"""
#source = """(.='true') or (../../mep:shutdown='false' and count(../../service[shutdown='false'][classification/priority-bit=current()/../classification/priority-bit123]=/a/b[d=1]/c)=1)"""
#source = "../../network[type/type-val/flat/physical-network=current()/type-val/flat/physical-network"
#source = "not(starts-with(../bind[1]/service,'md'))"
#source ="(not(../scheduling/strict) or ((.<../../queue[scheduling/wfq][last()]/queue-id1) and (.<../../queue[scheduling/best-effort2][last()]/queue-id))) and (not(../scheduling/best-effort) or ((.>../../queue[scheduling/strict][last()]/queue-id) and (.>../../queue[scheduling/wfq][last()]/queue-id2)))"
#source = "(not(type-val/flat) or count(../../network[type/type-val/flat/physical-network=current()/type-val/flat/physical-network2])=1) and (not(type-val/vlan) or count(../../network[type/type-val/vlan/physical-network=current()/type-val/vlan/physical-network and type/type-val/vlan/segmentation-id=current()/type-val/vlan/segmentation-id1])=1)"
#source = "(.='true') or (count(../source[direction='rx' or direction='tx-rx']) <=2 and count(../source[direction='tx' or direction='tx-rx']) >=2)"
#source = """/mef-interfaces:mef-interfaces/mef-interfaces:carrier-ethernet/mef-interfaces:subscriber-interfaces/mef-interfaces:uni[mef-interfaces:uni-id][mef-interfaces:uni-id/../mef-interfaces:bundling-enabled = 'true']"""
def get_id_with_non_path_chars(idPathVal):
    #print "idPathValue ###### ", idPathVal
    idWtPredicateLst = idPathVal.split("[")
    idPathLabel = idWtPredicateLst[0].strip(")]")
    
    # 0.75 * ../max-rtr-adv-interval1
    idPathValContainSpaceLst = idPathVal.split()
    #print "idPathValContainSpaceLst ", idPathValContainSpaceLst
    if len(idPathValContainSpaceLst)  > 1:
        idPathLabel = idPathValContainSpaceLst[-1]
        
    idPathLabel = idPathLabel.strip()
    
    lpaidx = idPathLabel.rfind("(")
    # exclude the scenario like: not(current()
    
    if lpaidx != -1:  
        if idPathLabel[lpaidx-7:lpaidx] != "current" and idPathLabel[lpaidx-5:lpaidx] != "deref":
            lpeidx = idPathVal.find(")")
            if lpeidx != -1 :
                if lpeidx > lpaidx:
                    idPathLabel = idPathLabel[lpaidx+1:lpeidx]
            else:
                #print "no end )...", lpaidx
                if len(idPathLabel) > lpaidx:
                    idPathLabel = idPathLabel[lpaidx+1:]   
        elif idPathLabel[lpaidx-7:lpaidx] == "current":
            idPathLabel="current"
        elif  idPathLabel[lpaidx-5:lpaidx] == "deref":    
            DEBUGPRINT("deref ! "     ,   idPathLabel)
              
    # e.g. first-level-key)          
    lpeidx = idPathLabel.find(")")
    if lpeidx != -1:
        idPathLabel = idPathLabel[:lpeidx]
    
    idPathLabel = idPathLabel.strip(" )]=<>!\n")
    return idPathLabel
 
def get_first_unmatched_index(s):     
    # Traverse through all elements
    # starting from i.
    starti = 0
    while True:
        i = s.find("[", starti)        
        if i != -1:
            k = get_matching_index(s, i)
            if k != -1:  
                #?starti = starti + k + 1
                starti =  k + 1            
            else:
                return i
        else:
            return -1        
               

def get_matching_index(s, i):
 
    # If input is invalid.
    if s[i] != '[':
        return -1
 
    # Create a deque to use it as a stack.
    d = deque()
 
    # Traverse through all elements
    # starting from i.
    for k in range(i, len(s)):
        # Pop a starting bracket
        # for every closing bracket
        if s[k] == ']':
            d.popleft()
 
        # Push all starting brackets
        elif s[k] == '[':
            d.append(s[i])
 
        # If deque becomes empty
        if not d:
            return k
 
    return -1

def get_predicates_list(idPath):
    parts = []
    startIdx = 0
    while True:            
        idx = idPath.find('[', startIdx)
        if idx != -1:
            mi = get_matching_index(idPath, idx)
            if mi != -1:
                startIdx =  mi
                parts.append(idPath[idx+1 : mi])
                continue
        break
    return parts 
            
            
def get_part_subid_list_and_val(idPathVal):
    idPaths = idPathVal[0]
    valChk = idPathVal[1]
    parts = []
    startIdx = 0
    
    # strip func such as count(a , b) etc.    
    # not(contains(substring-after(.,'/'),'/'))
    
    idPaths = idPaths.split(",")[0]            

    while True:        
        idx = idPaths.find('/', startIdx)
        if idx != -1:
            pathPartLeft = idPaths[0:idx]   
            umi = get_first_unmatched_index(pathPartLeft)
            if umi != -1:
                startIdx = idx + 1 
                continue
            else:
                parts.append(pathPartLeft)                
                idPaths = idPaths[idx+1:]
                startIdx = 0
                continue
                
        else:
            #print "\t\tno more '/', idPaths ", idPaths
            parts.append(idPaths)           
            break              
    return (parts , valChk)           
    
    
def get_and_or_separated_pathVal(xexpr):
    # e.g.: source6 = "(not(type-val/flat) or count(../../network[type/type-val/flat/physical-network=current()/type-val/flat/physical-network2])=1) and (not(type-val/vlan) or count(../../network[type/type-val/vlan/physical-network=current()/type-val/vlan/physical-network and type/type-val/vlan/segmentation-id=current()/type-val/vlan/segmentation-id1])=1)"
    #parts = re.split('\sor\s|\sand\s', origxv)
    parts = []
    predicatePrefix =""
    startIdx = 0
    prevIdx = 0
    prvAddtoIdx = 0
    while True:        
        idx1 = xexpr.find(' or ', startIdx)
        idx2 = xexpr.find(' and ', startIdx)
        idx =-1
        if idx1 != -1:
            idx = idx1
        if idx2 != -1:
            if idx == -1 or idx > idx2:
                idx = idx2
                
        addtoIdx = 0        
        if idx != -1:
            if idx == idx2:
                addtoIdx = 4
            else:
                addtoIdx = 3
                
        if idx != -1:
            pathPartLeft = xexpr[0:idx]   
            umi = get_first_unmatched_index(pathPartLeft)
            if umi != -1:
                # turn ["count(../source[direction='tx' or direction='tx-rx'])", '2)']
                # into: ["count(../source[direction='tx'], '2'
                #       "../source[direction='tx-rx'], '2'
                if predicatePrefix == "":
                    parts.append(pathPartLeft + "]")
                    predicatePrefix = pathPartLeft[0:umi] 
                   
                else:
                    partToAttach = pathPartLeft[prevIdx + addtoIdx :]
                    parts.append(predicatePrefix + "[" + partToAttach.strip())
                
                startIdx = idx + addtoIdx 
                # remember previous and/or index     
                prevIdx = idx  
                prvAddtoIdx = addtoIdx
                continue
            else:
                if predicatePrefix == "":                    
                    parts.append(pathPartLeft)
                else:    
                    partToAttach = pathPartLeft[prevIdx + addtoIdx :]
                    parts.append(predicatePrefix + "[" + partToAttach.strip())
                    predicatePrefix = ""

                xexpr = xexpr[idx+addtoIdx:]
                startIdx = 0
                # remember previous and/or index     
                prevIdx = 0   
                prvAddtoIdx = 0                
                continue
                
        else:
            if predicatePrefix == "":                    
                parts.append(xexpr)
            else:    
                partToAttach = xexpr[prevIdx + prvAddtoIdx :]
                parts.append(predicatePrefix + "[" + partToAttach.strip())
                predicatePrefix = ""            
           
            break  

                
    return parts             
                
    
            
def get_lge_idx_separate_value_to_check(idPathVal):
    
    # .='true'
    # ../../service[shutdown='false'][classification[uiuc>=1]/priority-bit=current()/../classification/priority-bit123
    startIdx = 0
    origStartIdx = 0
    endIdx = len(idPathVal)
    origEndIdx = endIdx
    remaingPartLeftUncheckedIdx = 0
    while True:
        DEBUGPRINT(" idPathVal get_lge_idx_separate_value_to_check ", idPathVal, " startIdx ", startIdx, " endid ", endIdx)
        idx1 = idPathVal.find("=", startIdx, endIdx)
        idx2 = idPathVal.find("<", startIdx, endIdx)
        idx3 = idPathVal.find(">", startIdx, endIdx)
        idx = -1
        if idx1 != -1:
            idx = idx1
        if idx2 != -1:
            if idx < idx2:
                idx = idx2
        if idx3 != -1:
            if idx < idx3:
                idx = idx3
                
        if idx != -1:
            pathPart = idPathVal[0:idx]  
             
            #if is_idx_in_predicate_bracket(pathPart):
            if get_first_unmatched_index(pathPart) != -1:
                DEBUGPRINT("yes in bracket , new ", idx)
                # reset, search again
                # .>../../queue[scheduling='wfq']/queue-id
                remaingPartLeftUncheckedIdx = idx +1
                startIdx =  origStartIdx 
                endIdx = idx-1
                continue
            #else:
            #    print "not found lge idx break "
            #
            #    if remaingPartLeftUncheckedIdx != 0:
            #        startIdx = remaingPartLeftUncheckedIdx
            #        remaingPartLeftUncheckedIdx = 0
            #        continue
            #    else:            
            #        break
        #else:
        #    print "No more found, idx ", idx          
        #    if remaingPartLeftUncheckedIdx != 0:
        #        startIdx = remaingPartLeftUncheckedIdx
        #        remaingPartLeftUncheckedIdx = 0
        #        continue
        #    else:          
        #        break
        
        if idx == -1 and remaingPartLeftUncheckedIdx != 0:
            startIdx = remaingPartLeftUncheckedIdx
            origStartIdx = remaingPartLeftUncheckedIdx
            remaingPartLeftUncheckedIdx = 0
            endIdx = origEndIdx 
            continue
        else:
            break
        
    DEBUGPRINT("returned idx ", idx)        
    return idx             

def get_partNID_value_list(origxv): 
    nIDVal=[]
    # split by or, and    
    #parts = re.split('\sor\s|\sand\s', origxv)
    parts = get_and_or_separated_pathVal(origxv)
    
    for part in parts:        
        lgeIdx = get_lge_idx_separate_value_to_check(part)
        if lgeIdx != -1:
            pathPart = part[0:lgeIdx].strip("<>=!")
            valPart = part[lgeIdx+1:].strip("<>=!")
            
            
            nIDVal.append([pathPart.strip(), valPart.strip()])
        else:   
            nIDVal.append([part.strip(), ""])        
    DEBUGPRINT("get nIDvAL ",   nIDVal)  
    return nIDVal


"""
def check_xpath_subidpath_predicate (session, ctxElem, ctxNode, idPathVal, idPredicateLst, lastPrefixInExpr):
    #print "checking idPredicateLst ", idPredicateLst, " ctxElem ", getArgumentValue(ctxElem), " ctxNode ", getArgumentValue(ctxNode)
    
    for predicate in idPredicateLst:
        predicatePathValList = get_partNID_value_list(predicate)
        #print "???? process predicate ", predicatePathValList
        for predVal in predicatePathValList:            
            nIDValLst = get_part_subid_list_and_val(predVal)
            nIDLst = nIDValLst[0]          
            val = nIDValLst[1] 
            #print "predicate nIDValLst ", nIDLst, " val ", val, " ctxElem ", getArgumentValue(ctxElem), " ctxNode ", getArgumentValue(ctxNode)
            #res = check_xpath_param_reference(ctxElem, ctxNode, predVal, "", session, lastPrefixInExpr=lastPrefixInExpr)
            res = check_xpath_param_reference(ctxElem, ctxNode, nIDLst, val, session, lastPrefixInExpr=lastPrefixInExpr)
            if res !="":
                return res
              
    return ""        

"""        
        
def find_child_node_of_a_node(ctxNode, idLocalName):
    if idLocalName == "*":
        ctxNodes = ctxNode[:]
    else:    
        xp = "./*[@*='%s']"%idLocalName
        DEBUGPRINT("find_child_node_of_a_node xp ", xp, "ctxNode ", getArgumentValue(ctxNode), " type ", getStatementValue(ctxNode))
        ctxNodes = ctxNode.xpath(xp)               
                
    if  len(ctxNodes):        
        # make sure we got the right ctxNode 
        for cdn in ctxNodes:
            DEBUGPRINT("getStatementValue(cdn)  ", getStatementValue(cdn)) 
            if getStatementValue(cdn) in ["list", "leaf-list", "leaf", "container", "anyxml", "anydata"]:
                ctxNode = cdn
                return ctxNode       
                 
    DEBUGPRINT("find used grouping ", idLocalName, " under ", getArgumentValue(ctxNode))        
    # in grouping or choice/case?
    ctxNode = find_child_node_and_also_may_in_grouping_and_choices(ctxNode, idLocalName) 
    if ctxNode is not None:
        DEBUGPRINT(" found in grouping... ", getArgumentValue(ctxNode))            
    return ctxNode

def get_last_augmentingParts_and_leading_parts(targetIDToChk):

    DEBUGPRINT("targetIDToChk ", targetIDToChk)
    targetIDToChkLst = targetIDToChk.split("/")
    prevPrx = ""       
    tID = targetIDToChkLst[-1]      
    if tID.find(":") !=-1:
        # find the imported module name and rev
        prevPrx, _ = tID.split(":")       
    
    lastModulePartLst = []
    for tID in reversed(targetIDToChkLst):
        DEBUGPRINT("process reversed tID ", tID)
        if tID.find(":") !=-1:
            # find the imported module name and rev
            prx, _ = tID.split(":")       
            if prx != prevPrx:
                # found the last augmenting module
                # get prefix IDs and convert them to namespace qualified form for comparison
                # 
                break                
        lastModulePartLst.append(tID)
        
    #lastModulePartsReversed = reversed(lastModulePartLst)
    lastModulePartLst.reverse()
    
    lastModuleParts = "/".join(lastModulePartLst)
    DEBUGPRINT("lastModuleParts ", lastModuleParts)
         
    augmentingPartExceptLastModulePart = targetIDToChk.rstrip(lastModuleParts)    
    DEBUGPRINT("augmentingPartExceptLastModulePart " , augmentingPartExceptLastModulePart)
        
    return (augmentingPartExceptLastModulePart, lastModuleParts)

            
    
"""
def find_tree_root_for_prefix_used(ctxElem, idPrefix, idMyPrefix):
    ndRoot = None                                                                           
    #idMyPrefix = find_module_own_prefix(ctxElem.getroottree().getroot())
    #if idPrefix != idMyPrefix and idPrefix != lastPrefixInExpr:
    if idPrefix == "" or idPrefix == idMyPrefix:
        ndRoot = ctxElem.getroottree().getroot()
    else:                            
        DEBUGPRINT("it must be the first node ID  " , idPrefix)                              
        importNodes  = ctxElem.getroottree().getroot().xpath("yin:import", 
                namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})                                
        impNode = getImportedModuleTreeRoot(idPrefix, importNodes) 
        if impNode is not None:
            ndRoot = impNode.getroot()  
    return ndRoot        
    
"""

def is_likely_a_node_path(s):
    if s.find("/") !=-1:
        return True
    
    if s.find("current(") !=-1:
        return True

    if not is_number(s):
        return True

    return False

def contain_non_path_char(s):
    if s.find(" ") !=-1:
        return True
    
    if s.find("*") !=-1:
        return True
    
    if s.find("+") !=-1:
        return True
    if s.find("-") !=-1:
        return True
    
    if s.find("/") !=-1:
        return True

    if s.find("(") !=-1:
        return True

    if s.find(")") !=-1:
        return True

    if s.find(".") !=-1:
        return True

    return False


    
def is_number(s):    
    try:
        float(s)
        return True
    except ValueError:
        pass
 
    try:
        import unicodedata
        unicodedata.numeric(s)
        return True
    except (TypeError, ValueError):
        pass
 
    return False

    

def find_node_in_grouping_used(ctxUsesNode, lookName):
    #print " find_node_in_grouping_used for ", lookName,  " is under ", getArgumentValue(ctxUsesNode)
    localUses= False
    rootNode = ctxUsesNode.getroottree().getroot()
    
    usesGroupingName= getArgumentValue(ctxUsesNode)
    
    # find the prefix of the module itself                                            
    #myprefix = ""
    #myprefixNode = rootNode.xpath("yin:prefix", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})
    #if len(myprefixNode):
    #    myprefix =  myprefixNode[0].get("value")       
    # 
    myprefix = find_module_own_prefix(rootNode)
                                       
    if usesGroupingName.find(":") != -1:
        pfx, _ = usesGroupingName.split(":")
        if pfx == myprefix:
            localUses= True
        else:
            localUses = False    
    else:
        #name = usesGroupingName        
        localUses = True
        
    if localUses:
        #print "local find_local_grouping_used, check if there is  ", usesGroupingName
        groupingNode = find_local_grouping_used(ctxUsesNode, usesGroupingName)
    else:
        #print "external find_local_grouping_used , check if there is  ", usesGroupingName
        groupingNode = find_external_grouping_used(ctxUsesNode, usesGroupingName)   
    
    if  groupingNode is not None:
        return find_child_node_and_also_may_in_grouping_and_choices(groupingNode, lookName)
              
def find_node_in_choice_used(ctxChoiceNode, lookName):
    #print "here find_node_in_choice_used for ", lookName, " under ", getArgumentValue(ctxChoiceNode)
    for c in ctxChoiceNode:
        #print "choice getStatementValue(C) ", getStatementValue(c)
        if getStatementValue(c) == "choice":
            ctxNode = find_node_in_choice_used(c, lookName)
            if ctxNode is not None:
                return ctxNode            
        elif getStatementValue(c) == "case":
            ctxNode = find_child_node_and_also_may_in_grouping_and_choices(c, lookName)
            if ctxNode is not None:
                return ctxNode
        elif getStatementValue(c) in ["list", "leaf-list", "leaf", "container", "anyxml", "anydata"]: 
            if getArgumentValue(c) == lookName:                      
                #print "found a choice defined ", getArgumentValue(c)                 
                return c
              
    
def find_local_grouping_used(ctxNode, usesName):
    c =None
    nodeInScopeToChk = ctxNode
    while nodeInScopeToChk is not None:
        for c in nodeInScopeToChk:
            #print "getStatementValue(C) ", getStatementValue(c)
            if getStatementValue(c) == "grouping" and getArgumentValue(c) == usesName:
                #print "found a grouping locally defined ", getArgumentValue(c)
                return c
        nodeInScopeToChk = nodeInScopeToChk.getparent() 
        

def find_external_grouping_used(ctxRoot, usesName):
    c =None
    for c in ctxRoot:
        #print "getStatementValue(C) ", getStatementValue(c)
        if getStatementValue(c) == "grouping" and getArgumentValue(c) == usesName:
            #print "found a grouping externally defined ", getArgumentValue(c)   
            return c

def find_child_node_and_also_may_in_grouping_and_choices(ctxNode, name):       
    if name.find(":") != -1:
        DEBUGPRINT("name to split ", name)
        _, name = name.split(":")
        
    tp = "./*[@*='%s']"%name
    #print "tp to search: ", tp
    if ctxNode is not None:
        if name == "*":
            nNode = ctxNode[:]
            if len(nNode):
                # make sure we got the right ctxNode 
                for cdn in nNode:
                    DEBUGPRINT("getStatementValue grouping (cdn)  ", getStatementValue(cdn)) 
                    if getStatementValue(cdn) in ["list", "leaf-list", "leaf", "container", "anyxml", "anydata"]:
                        return cdn
                
        else:    
            nNode = ctxNode.xpath(tp)              
            # make sure we got the right ctxNode 
            for cdn in nNode:
                DEBUGPRINT("getStatementValue grouping (cdn)  ", getStatementValue(cdn) , " ", getArgumentValue(cdn))
                if getStatementValue(cdn) in ["list", "leaf-list", "leaf", "container", "anyxml", "anydata"]:
                    return cdn   
        
        # possibly in a 'uses' statement
        # so we need to dive into the grouping
        # find all augment node    
        usesNodes  = ctxNode.xpath("yin:uses", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})                
        for useNode in usesNodes:
            # find the grouping used
            ctxNodeNew = find_node_in_grouping_used(useNode, name)
            if ctxNodeNew is not None:
                return ctxNodeNew
            
        # still not found, under choices and cases?
        choicesNodes  = ctxNode.xpath("yin:choice", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})    
        for choiceNode in choicesNodes:
            ctxNode = find_node_in_choice_used(choiceNode, name)
            if ctxNode is not None:
                return ctxNode
                

            
               
    
def find_last_module_parts_augmenting_nodes(rootNode, augmentingPartExceptLastModule, lastModulePartLst):
    DEBUGPRINT("augmentingPartExceptLastModule ", augmentingPartExceptLastModule)
    ctxNode = None
    augmentPathNodePartLst = []    
    # we do not need to compare prefix since pyang guarantee the target exists
    if augmentingPartExceptLastModule == "":
        # In this case. a module augments another one which is not augmenting anything 
        # like
        # augment '/if:interfaces/if:interface' {
        #     when "if:type1 = 'ianaift:fastdsl'" 
        
        ctxNode = rootNode
        
    else:
        auesLst =[]
        auexLst = augmentingPartExceptLastModule.split("/")
        for aue in auexLst:
            if aue.find(":")!= -1:
                auesLst.append(aue.split(":")[1])
        aues = "/".join(auesLst)        
        DEBUGPRINT("aues ", aues)
        DEBUGPRINT(" check root ", getArgumentValue(rootNode), " node ", rootNode.get("name"))  
           
        #find all augment node    
        augmentNodes  = rootNode.xpath("yin:augment", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})
            
        for augNode in augmentNodes:
            #print " check augment node ", getArgumentValue(augNode)
            atasLst=[]
            augTarget = augNode.get("target-node")
            #print " check augment get augTarget ", augTarget
            # we do not need to compare prefix since pyang guarantee the target exists
            for ata in augTarget.split("/"):
                if ata.find(":")!= -1:                
                    atasLst.append(ata.split(":")[1])
            atas = "/".join(atasLst)
            DEBUGPRINT("atas ", atas)
            if atas == aues:
                # augmenting node found
                # now we continue to locate lastModuleParts
                ctxNode = augNode
                            
    if ctxNode is not None:
        DEBUGPRINT("search lastModulePartLst ", lastModulePartLst)            
        for lmp in lastModulePartLst:
            DEBUGPRINT("lmp ", lmp)
            if lmp == "":
                # the empty lmp is due to the leading '/'
                continue
            ctxNode = find_child_node_and_also_may_in_grouping_and_choices(ctxNode, lmp)
            if ctxNode is None:
                # this should not happen if pyang did not complain
                return (ctxNode, augmentPathNodePartLst)   
            augmentPathNodePartLst.append(ctxNode)
        
        # if the last node in the augment path is not a data node
        # then return the first parent that is a data node
        while getStatementValue(ctxNode)   in ["choice", "case"]:
            if len(augmentPathNodePartLst):
                augmentPathNodePartLst = augmentPathNodePartLst[0:-1]
                ctxNode = augmentPathNodePartLst[-1]
                #print " back one got ctxNode ", getArgumentValue(ctxNode)
            else:
                break
                
    return (ctxNode, augmentPathNodePartLst)   


def find_module_own_prefix(rootNode ):
    # find the prefix of the module itself                                            
    myprefix = ""
    myprefixNode = rootNode.xpath("yin:prefix", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})
    if len(myprefixNode):
        myprefix =  myprefixNode[0].get("value")                                      
    return myprefix



def load_yin_module(fileNameFullPathOrWithRev, 
                Target_YANG_Dict=SS_YANG_Dict,
                Target_NS_To_M_Dict = namespaceToModuleImplementedDict,
                Target_M_To_NS_Dict = moduleToNamespaceImplementedDict
                ):
    resultMsg = ""      
    moduleNameRevValue = os.path.splitext(
        os.path.split(fileNameFullPathOrWithRev)[1])[0]    
    treeObjRoot = None                        
    # The dict key is modulename@revsion found in the file name
    # Here useKeyNoFile is  moduleNameRevValue
    useKeyNoFile = moduleNameRevValue
    useKeyNoRevNoFile = moduleNameRevValue
    if useKeyNoFile.find("@") != -1:
        useKeyNoRevNoFile,  revisionValue = useKeyNoFile.split("@")

    if useKeyNoFile in Target_YANG_Dict:
        try:
            treeObjRoot = Target_YANG_Dict[useKeyNoFile]["lxmlTreeRoot"]
            if treeObjRoot is None:          
                #"module", "revision", "namespace", "prefix",
                #"belongsTo", "file", "additionalFiles",
                #"lxmlTreeRoot", "usesGroupsApplied", "augmentsApplied"                                                               
                namespaceValue = ""
                prefix = ""
                belongsTo = ""
                revision = ""
                nodesToIntercept = (
                            '{urn:ietf:params:xml:ns:yang:yin:1}namespace', 
                            '{urn:ietf:params:xml:ns:yang:yin:1}prefix',
                            '{urn:ietf:params:xml:ns:yang:yin:1}belongs-to',
                            '{urn:ietf:params:xml:ns:yang:yin:1}revision',
                            ) 
                context =  etree.iterparse(fileNameFullPathOrWithRev, 
                                                remove_blank_text=True,
                                                events=('end',),
                                                tag=nodesToIntercept)
                for _, element in context:
                    if element.tag == '{urn:ietf:params:xml:ns:yang:yin:1}namespace':
                        namespaceValue = element.get(YIN_YANG_Mapping_Dict["namespace"])  
                    elif element.tag == '{urn:ietf:params:xml:ns:yang:yin:1}prefix':
                        if prefix == "":
                            # Only use the first prefix
                            prefix = element.get(YIN_YANG_Mapping_Dict["prefix"])
                    elif element.tag == '{urn:ietf:params:xml:ns:yang:yin:1}belongs-to':                        
                        belongsTo = element.get(YIN_YANG_Mapping_Dict["belongs-to"])
                    elif element.tag == '{urn:ietf:params:xml:ns:yang:yin:1}revision':
                        if revision == "":
                            # Only use the first revision
                            revision = element.get(YIN_YANG_Mapping_Dict["revision"])
                        
                treeObjRoot = context.root        
                Target_YANG_Dict[useKeyNoFile]["lxmlTreeRoot"] = context.root   
                Target_YANG_Dict[useKeyNoFile]["namespace"] = namespaceValue  
                Target_YANG_Dict[useKeyNoFile]["prefix"] = prefix
                Target_YANG_Dict[useKeyNoFile]["belongs-to"] = belongsTo
                Target_YANG_Dict[useKeyNoFile]["revision"] = revision

                # In case useKeyNoFile does not contain rev (because the filename does not 
                # contain rev), but we parsed out revision. In this case replace the dict
                # key with the parsed out rev added
                # Therefor Target_YANG_Dict may cotnain module name only key but that is for
                # the case where really the module doesn't contain any revision statement
                if revision != "" and useKeyNoFile.find("@") == -1:
                    Target_YANG_Dict[useKeyNoFile+"@"+revision] = Target_YANG_Dict.pop(useKeyNoFile)
                    # update key notion to useKeyNoFile+"@"+revision
                    useKeyNoFile = useKeyNoFile+"@"+revision
                # Create a dict mappting namespace to modrev so that we can
                # find lxmlTreeRoot upon receicing XML reply in NETCONF
                Target_YANG_Dict[namespaceValue] =  Target_YANG_Dict[useKeyNoFile]    
                if useKeyNoFile !="" and namespaceValue !="":  
                    Target_NS_To_M_Dict[namespaceValue] = useKeyNoFile.split("@")[0]                                          
                
                if useKeyNoFile !="": 
                    # Create a dict mapping module name to modrev so that we can
                    # find lxmlTreeRoot upon receicing REST reply in RESTCONF
                    #
                    # This is used to find YANG element in RESTCONF
                    # or build module data trees that include 
                    # submodule or importimg without revision 
                    # Ensure this only point to the most recent or latest revision
                    if useKeyNoRevNoFile in Target_YANG_Dict:
                        if revision != "":
                            if Target_YANG_Dict[useKeyNoRevNoFile]["revision"] <= revision:  
                                Target_YANG_Dict[useKeyNoRevNoFile] = Target_YANG_Dict[useKeyNoFile]
                                Target_M_To_NS_Dict[useKeyNoRevNoFile] = namespaceValue
                        else:
                            Target_YANG_Dict[useKeyNoRevNoFile] = Target_YANG_Dict[useKeyNoFile]
                            Target_M_To_NS_Dict[useKeyNoRevNoFile] = namespaceValue

                    else:
                        Target_YANG_Dict[useKeyNoRevNoFile] = Target_YANG_Dict[useKeyNoFile]    
                        Target_M_To_NS_Dict[useKeyNoRevNoFile] = namespaceValue 

        except Exception as e:
            resultMsg ="Error: %s: %s\n%s"%(fileNameFullPathOrWithRev, e,  traceback.format_exc())
    else:
        resultMsg="Error %s:%s"%(fileNameFullPathOrWithRev, 
                             "YIN file to load was not found!")               
    return (treeObjRoot, resultMsg)          
              
def replace_namespace_with_prefixed_argument(node):
    tag = etree.QName(node)
    statement = tag.localname 
    
    for prefix, namespace in node.nsmap.items(): 
        #print "replace prefix ", prefix, " ns ",namespace, " tag namespace", tag.namespace
        if namespace == tag.namespace:
            if statement in YIN_YANG_Mapping_Dict:
                if prefix is not None:
                    argument = prefix + ":" + node.get(YIN_YANG_Mapping_Dict[statement])
                else:
                    # lxml default namespace in nsmap is keyed on None, {None:my-namespace}
                    # in this case we use the module's prefix 
                    argument = node.get(YIN_YANG_Mapping_Dict[statement])    
            else:    
                # YANG extension argument- TODO-
                argument = prefix + ":" + node.get("name")
            return argument

def compile_yang_models_in_paths(paths=None, Target_YANG_Dict=SS_YANG_Dict, alwaysConvert=False):
    # Compile all YANN modules found in the path. 
    # If path is not given, use YANG_MODPATH.       
    # This method calls 
    # convert_yang_module_to_format 
    fileList =[]
    resultList = []
    
    if paths is None:
        DEBUGPRINT("Target_YANG_Dict len ", len(Target_YANG_Dict))
        for key in Target_YANG_Dict:
            name = Target_YANG_Dict[key]["file"]
            if name.lower().endswith(".yang"):         
                fileList.append(name)    
    else:               
        for dirs in paths.split(os.pathsep):            
            if dirs =="" or os.path.exists(dirs) == False:
                continue                 
            for root, _, files in os.walk(dirs, followlinks=True):                                       
                for name in files:                        
                    if name.lower().endswith(".yang"):
                        fileNameFullPath = os.path.join(root, name)    
                        fileList.append(fileNameFullPath)

    # Check if there are many files needed to be convereted
    # If yes, use multiprocessing 
    count = 0
    #start = time.time()
    for filename in fileList:        
        if  CheckIfmustDoConversionByTimeStamp(filename):
            count += 1
    if count > 10:
        with multiprocessing.Pool() as p:
            if alwaysConvert:
                resultList = p.map(always_convert_yang_module_to_format, fileList)
            else:
                resultList = p.map(convert_yang_module_to_format, fileList)                    
        #DEBUGPRINT("TIME elapsed ", time.time()-start)
    else:
        for filename in fileList:
            if alwaysConvert:
                result = always_convert_yang_module_to_format(filename) 
            else:
                result = convert_yang_module_to_format(filename)                    
            resultList.append(result)
    # remove empty res string
    resultList = [res for res in resultList if res]   
    return resultList       

def load_yin_models_in_paths(paths=None, gaugeCtl=None, 
                Target_YANG_Dict = SS_YANG_Dict,
                Target_NS_To_M_Dict = namespaceToModuleImplementedDict,
                Target_M_To_NS_Dict = moduleToNamespaceImplementedDict                
                ):
    # Load all YIN modules found in the path. 
    # If path is not given, use YANG_MODPATH.       
    # This method calls load_yin_module() 
    resultList = []
    fileList = []
    if paths is None:
        for key in Target_YANG_Dict:
            name = Target_YANG_Dict[key]["file"]
            root, ext = os.path.splitext(name)
            if name.lower().endswith(".yang"):   
                fileNameFullPath = root + ".yin"   
                if os.path.isfile(fileNameFullPath):    
                    fileList.append(fileNameFullPath)                   
                else:
                    resultList.append("Loading %s: YIN file not found!"%fileNameFullPath)  
    else:               
        for dirs in paths.split(os.pathsep):            
            if dirs =="" or os.path.exists(dirs) == False:
                continue                 
            for root, _, files in os.walk(dirs, followlinks=True):                                       
                for name in files:                        
                    if name.lower().endswith(".yin"):
                        if  os.path.isfile(fileNameFullPath): 
                            fileNameFullPath = os.path.join(root, name) 
                            fileList.append(fileNameFullPath)
                    else:
                        resultList.append("Loading %s: YIN file not found!"%fileNameFullPath)                            
    # lxml iterparsing
    for filename in fileList:   
        treeObj, result = load_yin_module(filename,
            Target_YANG_Dict=Target_YANG_Dict,
            Target_NS_To_M_Dict = Target_NS_To_M_Dict,
            Target_M_To_NS_Dict = Target_M_To_NS_Dict            
            )    
        if result.upper() != "":
            #resultList.append("Loading %s: %s." %(filename, result))
            resultList.append("Loading Result: %s." %result)
        else:
            #resultList.append("Successful Loading of %s "%filename)    
            pass

    # remove the empty key if any 
    Target_YANG_Dict.pop("", "")   

    # Process the imported modules to be loaded and any local augments ,
    # submodules, groupings etc. to be resolved frst
    for modrev in Target_YANG_Dict: 
        try:
            DEBUGPRINT("Resolving includes and uses, local augment etc in %s"%modrev)
            resolveUsesIncludesLocalAugments(modrev, 
                Target_YANG_Dict[modrev]["lxmlTreeRoot"],
                Target_YANG_Dict=Target_YANG_Dict)   
        except Exception as e:    
            resultList.append("Resolving  submodules and uses in  %s error: %s. traceback: %s" %(modrev,
                     e, traceback.format_exc()))

    # All external augments will be done by applyExternalAugments    
    if gaugeCtl is not None:
        gaugeCtl.SetRange(len(Target_YANG_Dict))
        gaugeCtlValue = 1  

    # There are multiple key pointing to the same module such as 
    # modulenameRev, namespace, and modulename  so we must exlcude
    # duplicated lxmlTreeRoot
    externalAugmentApplied = set()
    for modrev in Target_YANG_Dict:
        externalAugmentApplied.clear() 
        try:
            applyExternalAugments(modrev, 
                Target_YANG_Dict[modrev]["lxmlTreeRoot"],
                externalAugmentApplied,
                Target_YANG_Dict=Target_YANG_Dict)  
        except Exception as e:
            resultList.append("Applying augments %s: %s. %s" %(modrev, e, 
                traceback.format_exc()))
        if gaugeCtl is not None:
            gaugeCtl.SetValue(gaugeCtlValue)
            gaugeCtlValue+=1

    # remove the empty key if any 
    Target_YANG_Dict.pop("", "")   

    return resultList     


#def resolveUsesApplyAugments(treeRoot):
#    raise Exception("Not implemented")

def getModulePrefixHelper(rootNode):
    prefixNode = rootNode.xpath("yin:prefix", 
                 namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    if prefixNode is not None and len(prefixNode) > 0:
        return prefixNode[0].get("value")                  

def get_prefix_qualified_name_and_nsmap_helper(node):
    pfx =  getModulePrefixHelper(node.getroottree().getroot())

    argument = getArgumentValue(node)
    statement = getStatementValue(node)
    if argument == "" and (statement == "input" or statement == "output"):
        argument = statement
    if argument.find(":") != -1:
        return (argument, node.nsmap)            
    else:
        pfx =  getModulePrefixHelper(node.getroottree().getroot())
        return ("%s:%s"%(pfx, argument), node.nsmap)
        
def getModuleRevision(treeRoot):
    node = treeRoot.xpath("yin:revision", 
        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    if node is not None and len(node) > 0:
        return node[0].get("date")                  
    return ""

def getModuleName(treeRoot):
    return treeRoot.get("name")

def getModuleNamespace(treeRoot):
    namespaceNode = treeRoot.xpath("yin:namespace",
        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    if namespaceNode is not None and len(namespaceNode) > 0:
        return namespaceNode[0].get("uri")     
        
def get_elemNode_from_IDPath(IDPath, 
                            treeRoot, 
                            startNode=None, 
                            nsmap={}, 
                            augmentFlag=False, 
                            augmentingTreeRoot=None):
    # augmentFlag is used by "refine" statement too
    #
    # IDPath    : /id1/id2/prx:id3...
    # namespaces: a prefix:namespace dictionary for prefixes used in the ID
    #             augmentedModulePrefixUsed: prefix used in the ID, only 
    #             needed if it is  not using the default one defined 
    #             in the module 
    #
    # lxml xpath needs to use relative path to search from the context node
    # so must remove the leading "/"   
    #
    # using xpath can't solve all cases  
    # convert mon:netconf-state/mon:datastores/mon:datastore
    # to *[[@attribute1="abc"
    
    # use xapth to match attribute value will not work
    # for choice/augment/input etc.
    # e.g. this won't match *[@name='get-config']/*[@name='input']
        
    choiceNodes = []
    DEBUGPRINT("\tin get_elemNode_from_IDPath Process ID path %s"%IDPath)
    IDPath = IDPath.strip("/")       
    IDPathLst = IDPath.split('/') 
        
    # prefix
    prefix = getModulePrefixHelper(treeRoot)    
    #DEBUGPRINT("prefix here ", prefix)
    if startNode is None:
        startNode = treeRoot
        
    firstPrefix = "" 
    # sometimes nodes in the same level can have the same name 
    # but different category
    # for example /ietf-system:system/clock/timezone-name 
    if augmentFlag:
        nodesToChoose = ["action","input", "output", "case", 
                "choice", "notification", "list", "container"]
    else:
        nodesToChoose = ["action", "notification", "leaf", 
                "leaf-list", "list", "container"]                            
    for i, id in enumerate(IDPathLst):
        foundNode = None                   
        # Remove predicates if there is any
        # ncm:netconf-state/ncm:sessions/ncm:session[ncm:\
        #           session-id='307']/ncm:transport becomes
        # ncm:netconf-state/ncm:sessions/ncm:session/ncm:transport
        idBracket = id.find("[", 1)            
        if idBracket != -1:
            id = id[0:idBracket]
        if id.startswith("{"):
            # This is a namespace qualified id, special case in netconfc.
            # Replace | with /, assuming |  will not appear in a 
            # namespace string
            # see instance_tree_list_model.py
            idToUse = re.sub(r'\|\|\|',r'/', id)
        else:                        
            idcolon = id.find(":", 1)            
            if idcolon!= -1:     
                #idToUse = id           
                idprefix = id[:idcolon]
                if i == 0:
                    # get the prefix used in the first ID 
                    firstPrefix = idprefix
                    
                if firstPrefix != idprefix:
                    # in case the prefix of a particular ID is different 
                    # than the first ID's prefix
                    # it must be an imported ID referencing other module
                    # so we use the full prx:id form 
                    idToUse = id    
                else:                        
                    idToUse = id[idcolon+1:]   
            else:
                if augmentingTreeRoot is not None:
                    # bbf-sub-interface-tagging  
                    # augment '/if:interfaces/if:interface/bbf-subif:frame-processing/'
                    #+ 'bbf-subif:ingress-rule/bbf-subif:rule/bbf-subif:'
                    #+ 'flexible-match/match-criteria/vlan-tag-match-type/vlan-'
                    #+ 'tagged/tag'                         
                    idToUse = getModulePrefixHelper(augmentingTreeRoot)+ ":"+ id
                else:
                    idToUse = id             
        # if the idToUse include a prefix then this must be a node that is
        # augmented and it must have been defined in another module. 
        #
        # Converting to {namespace}id if possbile. This is used when 
        # processing reply messages from the connected server
        DEBUGPRINT("\tidToUse ", idToUse)
        if idToUse.find(":") != -1:
            if idToUse.find('}') != -1:
                # {namespace}id
                # prefix:id This is used by searching in instance tree
                #idToUseNamespaceWithStartingCurly, ifToUseName = idToUse.split("}")
                #idToUseNamespace = idToUseNamespaceWithStartingCurly[1:]
                
                pass # nothing to do since it is already in the correct form
            else:
                # prefix:id This is used by searching in schema tree???
                # Converting to {namespace}id to search if a nsmap is passed down
                idToUsePrefix, ifToUseName = idToUse.split(":")
                if idToUsePrefix in nsmap:
                    # prefix:id
                    idToUseNS = nsmap[idToUsePrefix]
                    idToUse = "{%s}%s"%(idToUseNS,ifToUseName)                     
   
        if idToUse.startswith("{"):
            # This search is used when processing reply XML message from the connected server
            # E.g. /system/authentication/{urn:ietf:params:xml:ns:yang:ietf-system-tls-auth}tls/{urn:ietf:params:xml:ns:yang:ietf-system-tls-auth}cert-maps/{urn:ietf:params:xml:ns:yang:ietf-system-tls-auth}cert-to-name
            # Augmenting nodes
            #"./*[@name='%s']"%idToUse
            #tree.xpath("//*[re:test(@id, '9467')]", 
            #           namespaces={'re':'http://exslt.org/regular-expressions'})
            augmentingNamespace = etree.QName(idToUse).namespace
            augmentingName = etree.QName(idToUse).localname
                
            foundNodes = startNode.xpath("*[re:test(@name, '.+:%s')]"%augmentingName,
                         namespaces={"re": "http://exslt.org/regular-expressions"})
            if len(foundNodes) > 0:
                for foundNodeCandidate in foundNodes:
                    if getStatementValue(foundNodeCandidate) not in nodesToChoose:
                        # skip non data node such as keys etc.
                        # The target node MUST be either a container, list, choice, case, input,
                        # output, or notification node.                            
                        continue 
                        
                    prefixedName = foundNodeCandidate.get("name")
                    prefix = prefixedName.split(":")[0]
                    if prefix in foundNodeCandidate.nsmap:
                        if foundNodeCandidate.nsmap[prefix] ==     augmentingNamespace:
                            foundNode = foundNodeCandidate
                            break
                                        
        else:   
            # The target node MUST be either a container, list, choice, case, input,
            # output, or notification node.   
            # When using this procedure to find node it can be any data node though
            
            if augmentFlag:
                xpathExprStr = ("yin:action[@name='%s'] | "
                                "yin:rpc[@name='%s'] | "
                                "yin:output | "      
                                "yin:input | "       
                                "yin:case[@name='%s'] | "        
                                "yin:choice[@name='%s'] | "      
                                "yin:container[@name='%s'] | "
                                "yin:leaf[@name='%s'] | "      
                                "yin:leaf-list[@name='%s'] | "                                      
                                "yin:notification[@name='%s'] | "
                                "yin:list[@name='%s'] "%(idToUse, idToUse, idToUse, 
                                    idToUse, idToUse, idToUse, idToUse, idToUse, idToUse))
                                        
            else:
                xpathExprStr = ("md:annotation[@name='%s'] | "
                                "yin:action[@name='%s'] | "
                                "yin:rpc[@name='%s'] | "
                                "yin:input | "
                                "yin:container[@name='%s'] | "    
                                "yin:notification[@name='%s'] | " 
                                "yin:leaf[@name='%s'] | "         
                                "yin:leaf-list[@name='%s'] | "    
                                "yin:list[@name='%s'] "%(idToUse, idToUse, idToUse, 
                                        idToUse, idToUse, idToUse, idToUse, idToUse))
            DEBUGPRINT("xpathExprStr ", xpathExprStr, " startNode ", startNode.tag)                              
            foundNodes = startNode.xpath(xpathExprStr,  
                        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1",
                        "md": "urn:ietf:params:xml:ns:yang:ietf-yang-metadata"})   
            DEBUGPRINT("\tfoundNodes ", foundNodes)            
            if len(foundNodes) > 0:
                    foundNode = foundNodes[0]
                    if foundNode.tag == "{urn:ietf:params:xml:ns:yang:yin:1}input":
                        # Go pass the input node
                        foundNodes = foundNode.xpath(xpathExprStr,  
                            namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1",
                            "md": "urn:ietf:params:xml:ns:yang:ietf-yang-metadata"})   

                        DEBUGPRINT("\tnext foundNodes ", foundNodes)            
                        if len(foundNodes) > 0:
                                foundNode = foundNodes[0]            
                            
        # not found or in rare cases such as the case node has the same name as a child leaf?
        if foundNode is None:
            break
        else:
            startNode = foundNode
        
    # Still not found? Any choice or case node under startNode?
    # Note the augment nodes have been attached to the tree so 
    # nothing needs to be done for them
    #
    if foundNode is None:
        IDPathRemains = "/".join(IDPathLst[i:])                             
        choiceNodes = startNode.xpath("yin:choice | yin:case",  
                namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        
        # process choice or case branches
        for choiceNode in choiceNodes:  
            #DEBUGPRINT("choiceNode ", choiceNode.get("name"))                      
            foundNode = get_elemNode_from_IDPath(IDPathRemains, treeRoot,
                    startNode=choiceNode, nsmap=nsmap, 
                    augmentFlag=augmentFlag)
            if foundNode is not None:
                break
            
    # this might be a toplevel non-data node
    # e.g.: lookup category  for "example-last-modified:last-modified"
    #if foundNode is None:
    #        ??
    DEBUGPRINT("\tfound node ", foundNode)
    return foundNode            

def _retouchImportedModule(treeRoot, importNode, Target_YANG_Dict=SS_YANG_Dict):   
    importedModuleName = importNode.get("module")                
    # check if a specific rev is asked
    importedModuleRev = importNode.find("./{urn:ietf:params:xml:ns:yang:yin:1}revision-date")    
    useKey = importedModuleName
    if importedModuleRev is not None:
        revDate = importedModuleRev.get("date")   
        useKey += "@"+ revDate
                            
    if useKey in Target_YANG_Dict:                        
        treeObjRoot = Target_YANG_Dict[useKey]["lxmlTreeRoot"]
        yangFile = Target_YANG_Dict[useKey]["file"]
        if treeObjRoot is None:
             raise Exception("treeObjRoot not found! %s imported module %s isn't " \
                            "loaded."%(useKey, yangFile))
        #  The imported module may also include and import additional submodules                    
        resolveUsesIncludesLocalAugments(useKey, treeObjRoot,
                            Target_YANG_Dict=Target_YANG_Dict )
    else:
        raise Exception("Error! imported module %s by %s not found in module " \
                        "path!"%(useKey, getModuleName(treeRoot)))
                     
def _retouchIncludedSubmodule(treeRoot, includeNode, Target_YANG_Dict=SS_YANG_Dict):
    # Included module name        
    includedModuleName = includeNode.get("module")        
    # check if a specific rev is asked
    includedModuleRev = includeNode.find("./{urn:ietf:params:xml:ns:yang:yin:1}revision-date")    
    useKey = includedModuleName
    if includedModuleRev is not None:
        revDate = includedModuleRev.get("date")   
        useKey += "@"+ revDate

    # Find the included submodule 
    
    if useKey in Target_YANG_Dict:                        
        treeObjRoot = Target_YANG_Dict[useKey]["lxmlTreeRoot"]
        yangFile = Target_YANG_Dict[useKey]["file"]
        if treeObjRoot is None:
            raise Exception("treeObj not found! %s: submodule %s isn't "\
                            "loaded."%(useKey, yangFile))
        DEBUGPRINT("found the included submodule treeObj for %s"%useKey)

        # The included submodule may also include and import additional submodules
        resolveUsesIncludesLocalAugments(useKey, treeObjRoot,
                Target_YANG_Dict=Target_YANG_Dict)

        # Insert nodes defined in submodules    
        # Insert data nodes in submodule that are not defined in augment node
        # find inserting index
        indexToInsertWhenReplacing = treeRoot.index(includeNode)                
        
        # remove include node itself before replacing with real nodes 
        # in submodules
        # Leave the include node there so we know where to  search 
        # typedefs defined in submodules 
        
        # https://bugs.launchpad.net/lxml/+bug/555602
        # Add nsmap in submodule to the main module root
        # lxml nsmap is readonly!
        # insert data nodes 
        for childNode in treeObjRoot:   
            if etree.QName(childNode).localname in _dataNodes:
                # we MUST  get a deepcopy of childNode to insert otherwise 
                # the node in the original sub module is gone
                # then it will fail if we open another session window and build 
                # another datatree
                # lxml moving tree nodes actually moves the node!
                
                # Skip if other submodules included has already made
                # the node existed
                foundDefines = treeRoot.xpath("t:%s"%getStatementValue(childNode),
                            namespaces={'t' : "urn:ietf:params:xml:ns:yang:yin:1"})
                if len(foundDefines) == 0:
                    treeRoot.insert(indexToInsertWhenReplacing, deepcopy(childNode))
                    indexToInsertWhenReplacing  += 1
        # submodule may augment its main module, this is handled
        # as augmenting external modules
    else:
        raise Exception("Error! included submodule %s useKey %s not found in %s!"%(
                        includedModuleName, useKey, Target_YANG_Dict))
                    
def _retouchLocalUsesRefineNodeIfApplicable(treeRoot, refinenode):   
    # augment nodes under 'uses' are re-attached in _retouchUsesNode 
    refineTarget = getArgumentValue(refinenode)        
    if refineTarget.startswith("/"):
        #DEBUGPRINT("this is a local refine: " +  refineTarget)
        refinedNode = get_elemNode_from_IDPath(refineTarget, treeRoot, 
                                    augmentFlag=True)                
    else:
        # must be a  local augment under 'uses' statement
        #DEBUGPRINT("this is a refine under uses: " +  refineTarget)
        refinedNode = get_elemNode_from_IDPath(refineTarget, treeRoot, 
                startNode=refinenode.getparent(), augmentFlag=True)        
              
    if refinedNode is not None:
        for refingNode in refinenode: 
            #DEBUGPRINT("local  refine under uses. retouching local refine node " \
            #    + getStatementValue(refingNode) + " value: " \
            #    + getArgumentValue(refingNode))
            
            deepCopiedNode = deepcopy(refingNode)
            # check if the refinedNode already has the property of the refiningNode
            # if yes, replace it otherwise add it                           
            foundDefines = refinedNode.xpath("t:%s"%getStatementValue(refingNode),
                        namespaces={'t' : "urn:ietf:params:xml:ns:yang:yin:1"})
            if len(foundDefines) > 0:
                #DEBUGPRINT("foundDefines " + getStatementValue(foundDefines[0]) + \
                #     " value: "+ getArgumentValue(foundDefines[0]))
                idx = refinedNode.index(foundDefines[0])                    
                refinedNode.insert(idx, deepCopiedNode )
                # remove the old one            
                refinedNode.remove(foundDefines[0])
            else:                
                refinedNode.append(deepCopiedNode)
                                                    
            # remove this local refine node   
            if refinenode.getparent() is not None: 
                refinenode.getparent().remove(refinenode)          
                        
def _retouchLocalUsesAugmentNodeIfApplicable(treeRoot, augmentnode): 
    augmentedNode = None
    # augment nodes under 'uses' are re-attached in _retouchUsesNode                                    
    augmentTarget = getArgumentValue(augmentnode)        
    if augmentTarget.startswith("/"):
        # this is an augment statement that augments external 
        # module that does not need to
        # be processed now
        return               
    else:
        # must be a  local augment under 'uses' statement
        # This is an augment under 'uses' statement: 
        augmentedNode = get_elemNode_from_IDPath(augmentTarget, 
            treeRoot, startNode=augmentnode.getparent(), 
            augmentFlag=True)            
                    
    if augmentedNode is not None:
        for augmentingNode in augmentnode: 
            deepCopiedNode = deepcopy(augmentingNode)
            augmentedNode.append(deepCopiedNode)                                  
        # remove this local augment node    
        augmentnode.getparent().remove(augmentnode)          
    DEBUGPRINT("Done with local augmenting  %s"%augmentTarget)                        
            
def getImportedAndLocalFeatures(appliedElemNode,
                    Target_YANG_Dict=SS_YANG_Dict):
    return getImportedAndLoalDefinedNodeTypes(\
            appliedElemNode.getroottree().getroot(),
            appliedElemNode, type="feature",
            Target_YANG_Dict=Target_YANG_Dict)

def getImportedAndLocalGroupings(appliedElemNode,
                    Target_YANG_Dict=SS_YANG_Dict):
    return getImportedAndLoalDefinedNodeTypes(\
            appliedElemNode.getroottree().getroot(),            
            appliedElemNode, type="grouping",
            Target_YANG_Dict=Target_YANG_Dict)

def getImportedAndLocalIdentities(appliedElemNode,
                    Target_YANG_Dict=SS_YANG_Dict):
    return getImportedAndLoalDefinedNodeTypes(\
            appliedElemNode.getroottree().getroot(),            
            appliedElemNode, type="identity",
            Target_YANG_Dict=Target_YANG_Dict)

def getImportedAndLocalTypes(appliedElemNode,
                    Target_YANG_Dict=SS_YANG_Dict):
    return getImportedAndLoalDefinedNodeTypes(\
            appliedElemNode.getroottree().getroot(),            
            appliedElemNode, type="typedef",
            Target_YANG_Dict=Target_YANG_Dict)
    
def _retouchUsesNode(treeRoot, usesnode,
            Target_YANG_Dict=SS_YANG_Dict):
    usesGroupName = getArgumentValue(usesnode)
    modulename = getModuleName(usesnode.getroottree().getroot())
    # check if usesGroupName contains a prefix 
    # that is the module itself
    idx = usesGroupName.find(":")
    if idx  != -1:
        localPfx = usesGroupName[:idx]             
        if getModulePrefixHelper(treeRoot) == localPfx:
            usesGroupName = usesGroupName[idx+1:]

    foundGroupingNodesDict = \
        getImportedAndLocalGroupings(usesnode,
              Target_YANG_Dict=Target_YANG_Dict)
    #for k, v in foundGroupingNodesDict.items():
    #    print(" foundGroupingNodesDict k ", k, " v ", v)

    if usesGroupName in foundGroupingNodesDict:
        groupingNode = foundGroupingNodesDict[usesGroupName]
        #print("usesGroupName statement ", getStatementValue(groupingNode), "label ", getArgumentValue(groupingNode))

        # process grouping node, create nodes to be added 
        # to the tree
        # remove the 'uses' node and then replace insert
        # related group children
        usesNodeParentNode = usesnode.getparent()
        indexToInsertWhenReplacing = usesNodeParentNode.index(usesnode)
        usesNodeParentNode.remove(usesnode)
        
        for nodechild in groupingNode:                
            #statement = getStatementValue(nodechild)
            #print("used group child node process statement ", getStatementValue(nodechild),  "label ", getArgumentValue(nodechild))
            # deep copy the node onto augmented tree
            deepCopiedNode = deepcopy(nodechild)      
            # traverse deepCopiedNode to make sure non-built-in types
            # uses proper prrefix, otherwise result in errors when looking up syntax
            # in the target moduel that uses the grouping
            # for example,  type asymmetric-key-algorithm-t in the followin defintion
            #  grouping public-key-grouping {
            #        description
            #        "A public key and its associated algorithm.";
            #        leaf algorithm {
            #        nacm:default-deny-write;
            #        type asymmetric-key-algorithm-t;
            #        mandatory true;
            #        description
            #            "Identifies the key's algorithm.";
            #        reference
            #            "RFC CCCC: Common YANG Data Types for Cryptography";
            #        }
            #        
            for dcelem in deepCopiedNode.iter():
                if getStatementValue(dcelem) == "type":
                    typeVal = getArgumentValue(dcelem)
                    if typeVal not in builtin_types and typeVal.find(":") == -1:
                        localPfx= getModulePrefixHelper(nodechild.getroottree().getroot()) 
                        #print("~~~~~ ttpe node %s:%s"%(localPfx, typeVal))
                        #dcelem.attrib['value'] = 'foo'
                        dcelem.set("name","%s:%s"%(localPfx, typeVal))
            
            #for dcelem in deepCopiedNode.iter():
            #    print("used group child node processed ", getStatementValue(dcelem),  "label ", getArgumentValue(dcelem))              
            
            usesNodeParentNode.insert(indexToInsertWhenReplacing, 
                                    deepCopiedNode)
            indexToInsertWhenReplacing = indexToInsertWhenReplacing + 1
                
        # add any augment or refine statement of uses. 
        # See https://tools.ietf.org/html/draft-ietf-netconf-server-model-01
        # uses network-managers-config {
        #   augment network-managers/network-manager/transport {  ...
        for useChildNode in usesnode:  
            usesNodeParentNode.append(useChildNode)                                        
    else:
        DEBUGPRINT("_retouchUsesNode Error! The grouping '%s' referenced not found!"%usesGroupName)
        raise Exception("Error! The grouping '%s' in %s referenced not found!"%(usesGroupName, modulename))

def getPrefixOfAugmentedModuleUsedInAugmentingModule(treeRoot, augmentingTreeRoot):
    augmentedModuleName = getModuleName(treeRoot)
    augmentedModuleRev = getModuleRevision(treeRoot)

    foundCorrespondentPrefixImportedNodeS = \
            augmentingTreeRoot.xpath("yin:import[@module='%s']"%augmentedModuleName,
            namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    foundCorrespondentPrefixUsed = None
                
    if len (foundCorrespondentPrefixImportedNodeS) > 0:
        # if a module imports another module to augment it 
        # then it can't be that module's submodule
        
        # in yang 1.1 there could be multiple revision of a 
        # module being imported    
        for fcn in foundCorrespondentPrefixImportedNodeS:                                    
            prefixNode = fcn.xpath("yin:prefix", 
                        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
            if len(prefixNode):
                foundCorrespondentPrefixUsed = prefixNode[0].get("value")                
            else:
                # no prefix node found. This is actually impossible because
                #  it got to have a prefix node for import
                continue
                
            prefixRevisionNode = fcn.xpath("yin:revision-date", 
                    namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})            
            if len(prefixRevisionNode):
                prefixRev = prefixRevisionNode[0].get("date")
                if prefixRev == augmentedModuleRev:
                    return (foundCorrespondentPrefixUsed, "augmentOtherModuleFlag")
                else:
                    continue
            else:
                # no revision then should apply to all 
                return (foundCorrespondentPrefixUsed, "augmentOtherModuleFlag")
                
        # no matching revision for augmented and augmenting module found.
        return (None, "augmentOtherModuleFlag")
            
    else:                
        #
        # in case this is a subodule that is augmenting its main module
        foundCorrespondentPrefixUsed = \
            getPrefixOfBelongsToNodeInSubModule(augmentingTreeRoot, augmentedModuleName )            
        return (foundCorrespondentPrefixUsed, "augmentMainModuleFlag")


def getFirstPrefixInNodeIDSequence(augmentTarget, sequenceNo=0):
    # /pfx:id1/pfx:id2 ...
    if augmentTarget.startswith("/"):
        IDNameAtSequencePosition = augmentTarget.split("/")[sequenceNo+1]
    else:
        IDNameAtSequencePosition = augmentTarget.split("/")[sequenceNo]
    
    IDNameAtSequencePositionPrefix = None       
    IDNameAtSequencePositionColonIdx = IDNameAtSequencePosition.find(':')
    if IDNameAtSequencePositionColonIdx != -1:
        IDNameAtSequencePositionPrefix = IDNameAtSequencePosition[0:IDNameAtSequencePositionColonIdx] 
                        
    return IDNameAtSequencePositionPrefix
    
def getPrefixOfBelongsToNodeInSubModule(augmentingTreeRoot, belongsToModuleName):
    foundCorrespondentBelongsToPrefixNode = \
        augmentingTreeRoot.xpath("yin:belongs-to[@module='%s']/yin:prefix"%belongsToModuleName, 
        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
            
    if  len(foundCorrespondentBelongsToPrefixNode) == 1:            
        foundCorrespondentBelongsToPrefix = \
             foundCorrespondentBelongsToPrefixNode[0].get("value")
        return foundCorrespondentBelongsToPrefix

def augmentTargetsDefined(treeRoot, augmentingTreeRoot):       
    # here we make sure the augmentation is only done on matching revision
    # if augmented  revision does not match augmenting,    
    # foundCorrespondentPrefixUsed will be None
    foundCorrespondentPrefixUsed, augmentMainOrOtherModuleFlag = \
        getPrefixOfAugmentedModuleUsedInAugmentingModule(treeRoot, augmentingTreeRoot )
        
    augmentTargetsDefined = []        
    augmentNodes = augmentingTreeRoot.xpath("yin:augment", 
            namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})
   
    for augmentNode in augmentNodes:                
        augmentTarget =  augmentNode.get("target-node")
        firstPrx = getFirstPrefixInNodeIDSequence(augmentTarget)  
        
        # target could be: ['/bbf-fast:fast/bbf-fast:vectors', 
        #   '/bbf-fast:fast/bbf-fast:thresholds',
        #   '/if:interfaces/if:interface/bbf-fastdsl:line/bbf-fast:line']
        # when applying augments for 'if', we must exclude
        #  'bbf-fast' since that will cause  incorrect order of applying augments
            
        if firstPrx == foundCorrespondentPrefixUsed:
            augmentTargetsDefined.append((augmentNode, augmentTarget, augmentMainOrOtherModuleFlag ))
    return augmentTargetsDefined


def getNamespaceAndPrefixInBelongstoMainModule(mainModuleName, 
                    Target_YANG_Dict=SS_YANG_Dict):
    # Normally there should be only one revision of the main
    # module loaded
    for key, val in Target_YANG_Dict.items():
        if key == mainModuleName or key.startswith("%s@"%mainModuleName):
            ns = Target_YANG_Dict[key]["namespace"]
            pfx = Target_YANG_Dict[key]["prefix"]
            return (ns, pfx)

    raise Exception("Error ! could not find the namespace and prefix " \
                " of the main module %s"%mainModuleName)

def applyAugmentingModule(treeRoot, augmentingTreeRoot, augmentNode,
            targetOfThisAugmentNode, augmentMainOrOtherModuleFlag,
            nsmap={},
            Target_YANG_Dict=SS_YANG_Dict):        

    AugmentingModuleName = augmentingTreeRoot.get("name") 
    augmentingNamespace = None
    augmentingPrefix = ""
    
    if augmentMainOrOtherModuleFlag == "augmentOtherModuleFlag" or \
        augmentMainOrOtherModuleFlag == "augmentMainModuleFlag":
        # This is the case this module or submdule augments 
        # another module  (other than submodule's main module)
        belongstoNode = augmentingTreeRoot.xpath("yin:belongs-to", 
            namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})     

        if len(belongstoNode):
            # first find which module include this submodule revision
            belongsToMainModuleName = belongstoNode[0].get("module")
            # then find the namespace and prefx of the main module 
            # since the main module name
            # is the one that is really augmenting the target module
            augmentingNamespace, augmentingPrefix = \
                getNamespaceAndPrefixInBelongstoMainModule(
                        belongsToMainModuleName,
                        Target_YANG_Dict=Target_YANG_Dict)            
        else:            
            augmentingNamespace = getModuleNamespace(augmentingTreeRoot)
            augmentingPrefix =    getModulePrefixHelper(augmentingTreeRoot)

    else:
        # We shouldn't reach here
        DEBUGPRINT("Error! We shouldn't have reached here!")
        pass
        
    augmentedNode = get_elemNode_from_IDPath(targetOfThisAugmentNode, 
            treeRoot,
            augmentFlag=True,  nsmap=nsmap,
            augmentingTreeRoot=augmentingTreeRoot)     

    if augmentedNode is not None:
        # process each child of augmentNode         
        for augmentingNode in augmentNode:                          
            #DEBUGPRINT("The node %s augments target "%(getArgumentValue(augmentingNode)))
            deepCopiedNode = deepcopy(augmentingNode)            
            # this is a hack                                         
            # add back the lost namespace mapping.during deepcopy,
            # deedpcopy discards any unused namespace mapping in nsmap.
            # However we need the augmenting namespace and prefix mapping!
            # lxml so far does not allow change nsmap after fact
            # so here we add a mapping for augmentingPrefix to 
            # cause / force this mapping to be added  
            if augmentMainOrOtherModuleFlag == "augmentOtherModuleFlag":
                nsmapItems = list(augmentingNode.nsmap.items())
                nsmapItems.append((augmentingPrefix, augmentingNamespace ))
                for prefix, ns in nsmapItems:
                    if prefix is None or  ns is None:
                        continue
                    # must register it globally. Does this mean the prefix 
                    # used must be unique?
                    etree.register_namespace(prefix, ns)
                    nsQualifier="{%s}" % ns
                    deepCopiedNode.set(nsQualifier + "%s"%prefix, prefix)
                    
            if augmentMainOrOtherModuleFlag != "augmentMainModuleFlag":         
                for cpElement in deepCopiedNode.iter():  
                    # process all descendants of this child
                                            
                    # change the name to qualified name such as ip:port 
                    # to differentiate with non-qualified name 
        
                    # getStatementValue(cpElement)  
                    #if getStatementValue(cpElement) not in ["enum", "bit"]:
                    #if getStatementValue(cpElement) in _dataNodes:                              
                    #cpElement.set(YIN_YANG_Mapping_Dict[deepCopiedNodeStatement], 
                    # "%s:%s"%(augmentingPrefix, getArgumentValue(cpElement)))

                    cpElemStatement = getStatementValue(cpElement)
                    #DEBUGPRINT("cpElemStatement ", cpElemStatement)
                    if cpElemStatement in YIN_YANG_Mapping_Dict:
                        cpElement.set(YIN_YANG_Mapping_Dict[cpElemStatement], 
                            "%s:%s"%(augmentingPrefix, getArgumentValue(cpElement)))
                        #DEBUGPRINT("augmentingPrefix ", augmentingPrefix, " after set:  ", 
                        #       getStatementValue(cpElement)  ,
                        #       " val ", getArgumentValue(cpElement))
            else:
                # in this case: submodule    
                # we do not use prefix qualified name since a submodule
                #  simply adds node into the main module
                #deepCopiedNode.set(YIN_YANG_Mapping_Dict[deepCopiedNodeStatement],
                #  "%s"%deepCopiedNodeArgument)
                pass  
            #augmentedNode.append(deepCopiedNode)             
            existingChildren = list(augmentedNode)
            existingChildren.sort(key=lambda x: getArgumentValue(x))
            # precomputed list of keys
            existingChildrenKeys =  [getArgumentValue(r) for r in existingChildren] 
            # use bisect to find insert position
            insertIndex = bisect.bisect(existingChildrenKeys, getArgumentValue(deepCopiedNode))
            augmentedNode.insert(insertIndex, deepCopiedNode)             
    else:
        msg =   "In augmenting module  '%s', target '%s' not found. "\
                "Possibly because there is another dependent augmenting "\
                "module not advertised or otherwise not " \
                "found. %s"%(AugmentingModuleName, targetOfThisAugmentNode, traceback.format_exc())
        DEBUGPRINT(msg)
        raise Exception(msg)


def resolveUsesIncludesLocalAugments(modrev, treeRoot, 
                            Target_YANG_Dict=SS_YANG_Dict):   
    # Doing this will cause the imported modules to be 
    # resolved as well. 
    if not Target_YANG_Dict[modrev]["usesGroupsApplied"]:
        if treeRoot is None:           
            raise Exception("Resolving group and imports etc for %s: " \
                            "treeRoot can't be None!"%modrev)
        # since submodule can include submule again. we
        # set the flag to prevent resolving repeatedly                     
        Target_YANG_Dict[modrev]["usesGroupsApplied"] =  True
        DEBUGPRINT("Resolving group and imports etc for %s"%modrev)

        # resolve uses, remove choice , case etc.
        # first we add nodes from include, uses and local augment
        belongstoNode = \
            treeRoot.find("./{urn:ietf:params:xml:ns:yang:yin:1}belongs-to")        
        for nodechild in treeRoot:
            statement = getStatementValue(nodechild)            
            if statement == "include":
                # process included submodules
                _retouchIncludedSubmodule(treeRoot, nodechild,
                    Target_YANG_Dict=Target_YANG_Dict)
            elif statement == "import":
                # process imported module and make its /uses' statement
                # get substituted
                _retouchImportedModule(treeRoot, nodechild,
                        Target_YANG_Dict=Target_YANG_Dict)
                    
        # now process all other interesting nodes        
        useNodes = treeRoot.xpath("//yin:uses", 
                          namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        for useNode in useNodes:
            # we always replace 'uses' with the actual 'grouping' when
            # first loading a module
            # augmented nodes should find grouping in the augmenting module
            _retouchUsesNode(treeRoot, useNode, Target_YANG_Dict=Target_YANG_Dict)    

        localAugmentNodes = treeRoot.xpath("//yin:augment", 
                        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        for localAugmentNode in localAugmentNodes:
            # This handles augment in 'uses' statement
            # If this augments other external modules, nothing to
            # do here since that is handled differently  
            # see applyAugmentingModule                   
            _retouchLocalUsesAugmentNodeIfApplicable(treeRoot, localAugmentNode) 

        refineNodes = treeRoot.xpath("//yin:refine", 
                        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        for refineNode in refineNodes:
            # refine can only be a sub-element uses
            _retouchLocalUsesRefineNodeIfApplicable(treeRoot, refineNode)

def applyExternalAugments(modrev, treeRoot, externalAugmentApplied,
            Target_YANG_Dict=SS_YANG_Dict):     
    if not Target_YANG_Dict[modrev]["augmentsApplied"]:
        #DEBUGPRINT("Processing augments of module: %s"%modrev)   
        augmentingModules = {}    
        augmentingModules[treeRoot] = []    
        treeRootModuleName = treeRoot.get("name")
        for moduleRev in Target_YANG_Dict:
            AtreeObj = Target_YANG_Dict[moduleRev]["lxmlTreeRoot"]
            modulename = Target_YANG_Dict[moduleRev]["module"]
            revision = Target_YANG_Dict[moduleRev]["revision"]
            processKey = modulename+"@"+revision
            if processKey in externalAugmentApplied:
                # this module+revision has been applied through a different 
                # Target_YANG_Dict dict key such as namespace key
                continue
            else:    
                externalAugmentApplied.add(processKey)                

            if modulename != treeRootModuleName:
                # Find in all other modules except itself
                #DEBUGPRINT("\tcheck augmenting ", modulename)
                if AtreeObj is not None:                       
                    # find if there are augments clause at the top level
                    # if there is, check if it is augmenting treeRoot that is
                    # currently being processed
                    # if it is, then apply the augments
                    #                 
                    # For ElementTree, the xpath method performs a global 
                    # XPath query against the document 
                    # (if absolute) or against the root node (if relative):
                    
                    if  _isPossileAugmentingModule(treeRoot, AtreeObj):
                        augmentingModules[treeRoot].append(AtreeObj)
                
        # augmentingModulesOrdered: augmenting 1 level, then 2 level, then 3  ...
        # lowever levels should always processed first so that higher level
        # augment can find its parent node                
        augmentingModulesOrdered = []  
        augmentingModulesTargetLengthDict = {}    
        for augmentingTreeRoot in augmentingModules[treeRoot]:                    
            targetsDefined = augmentTargetsDefined(treeRoot, augmentingTreeRoot)
            #DEBUGPRINT("targetsDefined in %s:"%augmentingTreeRoot.get("name"), " ==> ", targetsDefined)
            for (augmentingNode, target, augmentMainOrOtherModuleFlag) in targetsDefined:
                tlength = len(target.split("/"))
                if tlength not in augmentingModulesTargetLengthDict:                            
                    augmentingModulesTargetLengthDict[tlength] =  \
                        [(augmentingTreeRoot, augmentingNode, target, \
                        augmentMainOrOtherModuleFlag)]
                else:
                    augmentingModulesTargetLengthDict[tlength].append((augmentingTreeRoot,  \
                        augmentingNode, target, augmentMainOrOtherModuleFlag))
        # Scan all keys to get the maximum tlen key (the number of sub-id parts)
        tlenMax = 0
        for tlen in list(augmentingModulesTargetLengthDict.keys()):
            if tlen > tlenMax:
                tlenMax = tlen
        
        for num in range(0, tlenMax+1):
            if num in augmentingModulesTargetLengthDict:
                augmentingModulesOrdered.append(augmentingModulesTargetLengthDict[num])
        
        for augmentingETreeNodeTargetLst in augmentingModulesOrdered:
            for AugmentingTreeRoot, augmentingNode, target,\
                augmentMainOrOtherModuleFlag  in augmentingETreeNodeTargetLst:
                DEBUGPRINT("\n****--- process an augmentingTree candidate: " +
                            AugmentingTreeRoot.get("name") + " target " + target ) 
                applyAugmentingModule(treeRoot, AugmentingTreeRoot, 
                        augmentingNode, target, augmentMainOrOtherModuleFlag,
                        Target_YANG_Dict=Target_YANG_Dict)

        Target_YANG_Dict[modrev]["augmentsApplied"] =  True
 
def findFileFullPathNameAndPrefixByModuleNameAndRevision(modulename,
                                     revisiondate,
                                     Target_YANG_Dict=SS_YANG_Dict):
    fn = ""
    prefix = ""    
    useKeyNoFile = None
    if revisiondate != "":            
        useKeyNoFile = modulename + '@' + revisiondate
        if useKeyNoFile in Target_YANG_Dict:
            fn = Target_YANG_Dict[useKeyNoFile]["file"]
            prefix = Target_YANG_Dict[useKeyNoFile]["prefix"]                     
    else:
        # since no revision date is specified
        # it is the most recent version is used 
        # due to the way Target_YANG_Dict is built in
        # the load_yin_module()
        #DEBUGPRINT("look modulename ", modulename, " revisiondate ", revisiondate)
        if modulename in Target_YANG_Dict:
            if Target_YANG_Dict[modulename]["revision"] !="":
                useKeyNoFile = modulename+"@" + Target_YANG_Dict[modulename]["revision"]
                #DEBUGPRINT("Found no rev useKeyNoFile ", useKeyNoFile)
            fn = Target_YANG_Dict[modulename]["file"]
            prefix = Target_YANG_Dict[modulename]["prefix"]                     
        else:
            # use whatever is found
            for  useKeyNoFile, valDict in  Target_YANG_Dict.items():
                if valDict["module"] == modulename:
                    fn = valDict["file"]
                    prefix = valDict["prefix"]
                    break
                
    return (useKeyNoFile, fn, prefix)                

def parse_restconf_server_capabilities(ssession):
    server_modules_dict = {}
    server_capability_dict = {} # not used in restconf
    nsImplemntedDict= {}    
                
    #DEBUGPRINT("in parse ssession.yang_library_dict ", ssession.yang_library_dict)
    if ssession.yang_library_dict is None:
        ssession.yang_library_dict = {}
        r = ssession.get("ietf-yang-library:modules-state")
        #DEBUGPRINT("rrr ", type(r), " is exception ", isinstance(r, Exception)) 
        if r.ok:
            rtext = r.text
            if rtext.strip().startswith("<"):
                # xml
                #DEBUGPRINT("xml r.text", r.text)
                modulenodes = etree.fromstring(r.text).xpath("yanglib:modules-state/yanglib:module", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                if len(modulenodes):
                    for modulenode in modulenodes:
                        name = ""
                        namenode = modulenode.xpath("yanglib:name", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})                        
                        if len(namenode):
                            name = namenode[0].text
    
                        rev = ""
                        revnode = modulenode.xpath("yanglib:revision", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                        if len(revnode):
                            rev = revnode[0].text
                            
                        conformance = ""    
                        conformancenode = modulenode.xpath("yanglib:conformance-type", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                        if len(conformancenode):
                            conformance = conformancenode[0].text
                    
                        ns = ""
                        namespacenode = modulenode.xpath("yanglib:namespace", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                        if len(namespacenode):
                            ns = namespacenode[0].text
                        
                        if name != "":
                            key = name
                            if rev != "" and rev is not None:
                                key = name + "@" + rev
                            
                            if conformance != "import":      
                                # implement or import (yang 1.1 )                                  
                                nsImplemntedDict[ns] = key
                                
                            ssession.yang_library_dict[key] = (ns, conformance)
            else:
                # json string                                
                #DEBUGPRINT("json r.text", r.text)
                rtextjson = json.loads(rtext)
                modulenodes = []
                try:
                    modulenodes = rtextjson["ietf-yang-library:modules-state"]["module"]                
                except:
                    pass
                if len(modulenodes):
                    for modulenode in modulenodes:
                        name = ""
                        if "name" in modulenode:
                            name = modulenode["name"]
    
                        rev = ""
                        if "revision" in modulenode:                        
                            rev = modulenode["revision"]
                            
                        conformance = ""    
                        if "conformance" in modulenode:                        
                            conformance = modulenode["conformance"]
                    
                        ns = ""
                        if "namespace" in modulenode:                        
                            ns = modulenode["namespace"]

                        if name != "":
                            key = name
                            if rev != "" and rev is not None:
                                key = name + "@" + rev
                            
                            if conformance != "import":      
                                # implement or import (yang 1.1 )                                  
                                nsImplemntedDict[ns] = key
                                
                            ssession.yang_library_dict[key] = (ns, conformance)                                           
        #else:            
        #    if 'wx' in sys.modules:      
        #        import wx
        #        wx.MessageBox("Retrieving modules implemented from ietf-yang-library failed!\n%s"%r.text, "Error", wx.OK | wx.ICON_ERROR)                     
        #    else:
        #        DEBUGPRINT("Retrieving modules implemented from ietf-yang-library failed!\n%s"%r.text)
                    
        # add modules in sesssion.yang_library_dict if it exists
        server_modules_dict.update(ssession.yang_library_dict)  
        
    ssession.yangLibraryNamespaceImplementedDict.update(nsImplemntedDict)            
    # capabilities
    r = ssession.get("ietf-restconf-monitoring:restconf-state/capabilities")
    # unlike netconfc library
    #restconf request will return an RESTRequestErrorException object if fails
    if r.ok:
        rtext = r.text
        
        """
        rtext =  <capabilities
                xmlns="urn:ietf:params:xml:ns:yang:ietf-restconf-monitoring">
             <capability>\
              urn:ietf:params:restconf:capability:defaults:1.0?\
                 basic-mode=explicit\
             </capability>
             <capability>\
              urn:ietf:params:restconf:capability:with-defaults:1.0\
             </capability>
             <capability>\
              urn:ietf:params:restconf:capability:depth:1.0\
             </capability>
             <capability>\
              urn:ietf:params:restconf:capability:fields:1.0\
             </capability>
             <capability>\
              urn:ietf:params:restconf:capability:filter:1.0\
             </capability>
             <capability>\
              urn:ietf:params:restconf:capability:start-time:1.0\
             </capability>
             <capability>\
              urn:ietf:params:restconf:capability:stop-time:1.0\
             </capability>
             <capability>\
              http://example.com/capabilities/myparam\
             </capability>
            </capabilities>
            
            """
        """"
        rtext =  
        {
            "ietf-restconf-monitoring:capabilities" : {
                 "capability" : [                     
                     "urn:ietf:params:restconf:capability:defaults:1.0?basic-mode=explicit",
                     "urn:ietf:params:restconf:capability:with-defaults:1.0",
                     "http://example.com/capabilities/myparam"
                     
                    ]
                }
        }
        """
        capstrLst = []
        if rtext.strip().startswith("<"):
            # xml string                
            for cnode in etree.fromstring(rtext):
                c = cnode.text.strip()
                capstrLst.append(c)
        else:
            # json string       
            rtextjson = json.loads(rtext)  
            #DEBUGPRINT("rtextjson ", rtextjson)
            try:
                capnodes = rtextjson["ietf-restconf-monitoring:capabilities"]["capability"]                
                for c in capnodes:
                    capstrLst.append(c.strip())
            except:
                pass
                
        for c in capstrLst:                
            if c.startswith("urn:ietf:params:restconf:capability"):
                prelen = len("urn:ietf:params:restconf:capability")             
                cstr = c[prelen:]
                capidx = cstr.find(":", 1)
                cap = cstr
                ver = ""
                para = ""
                
                if capidx != -1:
                    cap = cstr[:capidx]
                    ver = cstr[capidx+1:]
                    para =""
                    paraidx=cstr.find("?", capidx)
                    if paraidx != -1 :
                        ver = cstr[capidx+1:paraidx]
                        para = cstr[paraidx:].strip("?")
                        para = para.replace("&", " ")
                
                server_capability_dict[cap+":"+ver] = para.strip() #for searching            
                server_capability_dict[cap] = (ver, para.strip()) #for searching
            else:
                # custom capabilities such as            
                #<capability>urn:com:mycompany:ipos:exec-cli:1.0</capability>
                #<capability>urn:com:mycompany:ipos:invoke-cli:1.0?abc=cde</capability>
                # there could be custom acapability that do not follow the standard 
                # form such as 
                #<capability>http://tail-f.com/ns/netconf/actions/1.0</capability>
                #<capability>http://tail-f.com/ns/netconf/extensions</capability>
                server_capability_dict[c] = c 
                      
    #else:
    #    if 'wx' in sys.modules:      
    #        import wx
    #        wx.MessageBox("Retrieving capabilities implemented from ietf-restconf-monitoring:restconf-state/capabilities failed!\n%s"%r.text, "Error", wx.OK | wx.ICON_ERROR)                     
    #    else:
    #        DEBUGPRINT("Retrieving capabilities implemented from ietf-restconf-monitoring:restconf-state/capabilities failed! failed\n%s"%r.text)
    return (server_modules_dict, server_capability_dict)
    
#parse the advertised server capability and store information
#in data structures        
def parse_server_capabilities(ssession):       
    server_capability_dict = {}
    server_modules_dict = {}
    nsImplemntedDict= {}

    prelen1 = len("urn:ietf:params:netconf")
    prelen2 = len("urn:ietf:params:netconf:capability")        
    
    # test. must remove these
    #a = []
    #for c in ssession.server_capabilities:
    #    a.append(c)        
    #a.extend(["urn:com:ericsson:ebase:0.1.0", "urn:com:ericsson:ebase:1.1.0", "urn:ericsson:com:netconf:action:1.0","urn:com:ericsson:ipos:exec-cli:1.0"])
    
    #for index, item in enumerate(ncsession.server_capabilities):
    for c in ssession.server_capabilities:
        idx = c.find("module=")  
        if c.startswith("urn:ietf:params:netconf"):
            # standard capabilities
            # custom capabilites are handled in the following block
            prelen = prelen1
            if c.startswith("urn:ietf:params:netconf:capability"):
                prelen = prelen2

            cstr = c[prelen:]
            capidx = cstr.find(":", 1)
            cap = cstr
            ver = ""
            para = ""
            
            if capidx != -1:
                cap = cstr[:capidx]
                ver = cstr[capidx+1:]
                para =""
                paraidx=cstr.find("?", capidx)
                if paraidx != -1 :
                    ver = cstr[capidx+1:paraidx]
                    para = cstr[paraidx:].strip("?")
                    para = para.replace("&", " ")
            
            server_capability_dict[cap+":"+ver] = para #for searching            
            server_capability_dict[cap] = (ver, para) #for searching
            
        elif idx != -1:
            namespace = c[:idx-1]
            #urn:ietf:params:xml:ns:netconf:notification:1.0?module=notifications&revision=2008-07-14
            #RFC6020 In the parameter list, each named parameter MUST 
            #occur at most once.
            idx2 = c.find("&", idx)
            if idx2 == -1:
                idx2 = None
            
            module= c[idx+7:idx2]
            
            rdate = ""
            idx = c.find("revision=")                                              
            if idx != -1:
                idx2 = c.find("&", idx)
                if idx2 == -1:
                    idx2 = None
                rdate = "@"+c[idx+9:idx2]
            
            server_modules_dict[module+rdate] = (namespace, "implement") #for searching
            nsImplemntedDict[namespace] = module+rdate

        else:
            # custom capabilities such as            
            #<capability>urn:com:mycompany:ipos:exec-cli:1.0</capability>
            #<capability>urn:com:mycompany:ipos:invoke-cli:1.0?abc=cde</capability>
            # there could be custom acapability that do not follow the standard 
            # form such as 
            #<capability>http://tail-f.com/ns/netconf/actions/1.0</capability>
            #<capability>http://tail-f.com/ns/netconf/extensions</capability>
            server_capability_dict[c] = c 

    if ":yang-library" in server_capability_dict:          
        lib_ver, lib_para = server_capability_dict[":yang-library"]            
        # issue a get to retrieve ietf-yang-library contents
        #r = ssession.get("/yanglib:modules-state/yanglib:name",
        #                      "/yanglib:modules-state/yanglib:revision",
        #                      "/yanglib:modules-state/yanglib:conformance-type",
        #DEBUGPRINT("ssession.yang_library_dict ", ssession.yang_library_dict)
        if ssession.yang_library_dict is None:
            ssession.yang_library_dict = {}
            r = ssession.get("/yanglib:modules-state", 
                      namespaces={"yanglib": "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
            if r[0] == True:    
                modulenodes = r[2].xpath("yanglib:modules-state/yanglib:module", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                if len(modulenodes):
                    for modulenode in modulenodes:
                        name = ""
                        namenode = modulenode.xpath("yanglib:name", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})                        
                        if len(namenode):
                            name = namenode[0].text
    
                        rev = ""
                        revnode = modulenode.xpath("yanglib:revision", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                        if len(revnode):
                            rev = revnode[0].text
                            
                        conformance = ""    
                        conformancenode = modulenode.xpath("yanglib:conformance-type", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                        if len(conformancenode):
                            conformance = conformancenode[0].text
                    
                        ns = ""
                        namespacenode = modulenode.xpath("yanglib:namespace", namespaces={'yanglib' : "urn:ietf:params:xml:ns:yang:ietf-yang-library"})
                        if len(namespacenode):
                            ns = namespacenode[0].text
                        
                        if name != "":
                            key = name
                            if rev != "" and rev is not None:
                                key = name + "@" + rev
                            
                            if conformance != "import":      
                                # implement or import (yang 1.1 )                                  
                                nsImplemntedDict[ns] = key
                                
                            ssession.yang_library_dict[key] = (ns, conformance)
            #else:            
            #    if 'wx' in sys.modules:      
            #        import wx
            #        wx.MessageBox("Retrieving modules implemented from ietf-yang-library failed!", "Error", wx.OK | wx.ICON_ERROR)                     
            #    else:
            #        DEBUGPRINT("Retrieving modules implemented from ietf-yang-library failed!")
                    
        # add modules in sesssion.yang_library_dict if it exists
        server_modules_dict.update(ssession.yang_library_dict)  
        
    # update ssession's yangLibraryNamespaceImplementedDict
    # this is used to map instance received into module name properly
    ssession.yangLibraryNamespaceImplementedDict.update(nsImplemntedDict)                      
    #testing need to be removed!        
    #server_modules_dict["ietf-netconf"+"@"+"2011-03-08"] = "urn:ietf:params:xml:ns:netconf:base:1.0"
    #server_modules_dict["ietf-snmp"+"@"+"2014-05-06"] = "urn:ietf:params:xml:ns:yang:ietf-snmp"
    #server_modules_dict["toaster"+"@"+"2009-11-20"] = "urn:ietf:params:xml:ns:yang:ietf-snmp"
    #server_modules_dict["ietf-system"+"@"+"2014-08-06"] = "urn:ietf:params:xml:ns:yang:ietf-system"
    #if ":with-defaults" in server_capability_dict:
    #    del server_capability_dict[":with-defaults"]           
    return (server_modules_dict, server_capability_dict)

        
def getImportedAndLoalDefinedNodeTypes_Helper(modelNodeOrImportedMNode,
                         foundNodes, type, includeFlag=False,
                         Target_YANG_Dict=SS_YANG_Dict):
    # E.g. <include module="ietf-snmp-common">
    #DEBUGPRINT("modelNodeOrImportedMNode type: ", getStatementValue(modelNodeOrImportedMNode), " includeFlag ? ", includeFlag)
    modulename = modelNodeOrImportedMNode.get("module")       
    rd = modelNodeOrImportedMNode.find("./{urn:ietf:params:xml:ns:yang:yin:1}revision-date")                                     
    if rd is not None:
        rdt = rd.get("date")
    else:
        rdt =""

    localPrefixNode = modelNodeOrImportedMNode.find("./{urn:ietf:params:xml:ns:yang:yin:1}prefix")                                     
    if localPrefixNode is not None:
        localPrefix = localPrefixNode.get("value")
    else:
        localPrefix =""
                  
    (useKeyNoFile, filename, prefix) = \
         findFileFullPathNameAndPrefixByModuleNameAndRevision(modulename, rdt,
                Target_YANG_Dict=Target_YANG_Dict)        
    #DEBUGPRINT("Find for modulename", modulename , " rdt", rdt, " got useKeyNoFile: ", useKeyNoFile, 
    #    " filename: ", filename, " prefix: ", prefix, " in Target_YANG_Dict? ", useKeyNoFile in Target_YANG_Dict )
    if useKeyNoFile is not None and \
            useKeyNoFile in Target_YANG_Dict and filename != "" \
            and prefix !="":                
        # check if it has been parsed.
        if Target_YANG_Dict[useKeyNoFile]["lxmlTreeRoot"] is None:
            raise Exception("treeRoot is None %s"%useKeyNoFile)
                                                    
        treeObjRoot = Target_YANG_Dict[useKeyNoFile]["lxmlTreeRoot"]       
        if treeObjRoot is not None:
            namespaceToUse = "urn:ietf:params:xml:ns:yang:yin:1"            
            if type == "augmentTargets":
                # iterate to find all augmentable node schema id
                for augElem in treeObjRoot.iter("{%s}container"%namespaceToUse, 
                                       "{%s}list"%namespaceToUse,
                                       "{%s}choice"%namespaceToUse,
                                       "{%s}case"%namespaceToUse,
                                       "{%s}input"%namespaceToUse,
                                       "{%s}output"%namespaceToUse,
                                       "{%s}notification"%namespaceToUse):
                    
                    if isGroupingDecendentNode(augElem):
                        continue                    
                                              
                    #DEBUGPRINT("%s - %s" % (augElem.tag, augElem.text))
                    foundNodes.append([augElem, localPrefix])
            elif type == "pathTargets":
                # iterate to find all leaf node schema id
                for pathElem in treeObjRoot.iter("{%s}leaf"%namespaceToUse, 
                                       "{%s}leaf-list"%namespaceToUse):
                                        
                    bt = lookup_property(pathElem, "base-type", treeObjRoot)
                    if isGroupingDecendentNode(pathElem) or \
                            isNotificationDecendentNode(pathElem) or \
                            isRPCDecendentNode(pathElem) or \
                        bt == "leafref" or bt == "empty":
                        continue                    
                    foundNodes.append([pathElem, localPrefix])                
            else:    
                # Find grouping type etc.
                #DEBUGPRINT("to find type ", type)
                findXpathCompiled = etree.XPath("t:%s"%type, namespaces={'t' : namespaceToUse } )
                foundNodesInThisModule = findXpathCompiled(treeObjRoot)
                for eachFoundNode in foundNodesInThisModule:
                    foundNodes.append([eachFoundNode, localPrefix])                 
                if includeFlag:
                    # a submodule can include additional submodules
                    # so we need to add these groupings if there is any???????
                    pass
    else:
        DEBUGPRINT("error! useKeyNoFile: ", useKeyNoFile, " returned! but no module key found in SS YIN dict")
        raise Exception("no module key found in SS YIN dict: " + str(useKeyNoFile))

def get_relative_node_ID(groupAugmentSubNode):    
    rid = getArgumentValue(groupAugmentSubNode)
    
    for node in groupAugmentSubNode.iterancestors():
        statement = getStatementValue(node)
        if statement != "grouping":
            rid = getArgumentValue(node) + "/" + rid
        else:
            break
    return rid        
        
def convert_absolute_ID_to_descentdent(aid, usesval):
    rid = ""
    aidLst = aid.split("/")

    includeFlag = False
    for idv in aidLst:
        hasPrefix =  idv.find(":")
        idr = idv
        if hasPrefix != -1 :
            idr = idv.split(":")[1]
        
        if includeFlag:
            rid = rid + idr +"/"    
        else:
            if usesval.find(":") != -1:
                if idv == usesval:
                    includeFlag = True
            else:
                if idr == usesval:
                    includeFlag = True
                                            
    # remove trailing slash    
    rid = rid.strip("/")
    return rid
        
def getImportedAndLoalDefinedNodeTypes(elemRoot, selectedElemNode,
            type="typedef",
            Target_YANG_Dict=SS_YANG_Dict):
    # find all type known to the given  selectedElemNode
    foundNodes = []
    foundNodeTypes = collections.OrderedDict()         
    includedSubModuleNodes = elemRoot.findall("./{urn:ietf:params:xml:ns:yang:yin:1}include")
    for m in includedSubModuleNodes:
        getImportedAndLoalDefinedNodeTypes_Helper(m, foundNodes, type, 
                        includeFlag=True,        
                        Target_YANG_Dict=Target_YANG_Dict)
    
    importedModuleNodes = elemRoot.findall("./{urn:ietf:params:xml:ns:yang:yin:1}import")            
    for m in importedModuleNodes:
        getImportedAndLoalDefinedNodeTypes_Helper(m, foundNodes, type,        
                        Target_YANG_Dict=Target_YANG_Dict)
                     
    #process imported and included modules to find types
    if type == "augmentTargets":
        if getStatementValue(selectedElemNode) != "uses" and \
                getStatementValue(selectedElemNode.getparent()) != "uses" :                            
            for nodeLocalPrefixPair in foundNodes:
                augmentTgtNode = nodeLocalPrefixPair[0]
                ssTreeRoot = augmentTgtNode.getroottree().getroot()
                (nodeID, _) = getNodeIDPath(augmentTgtNode, 
                                excludeChoiceCase=False, topNode=ssTreeRoot)
                foundNodeTypes[nodeID] = augmentTgtNode
            return foundNodeTypes 
    elif type == "pathTargets":                           
            for nodeLocalPrefixPair in foundNodes:
                pathTgtNode = nodeLocalPrefixPair[0]                
                if isGroupingDecendentNode(pathTgtNode):
                    continue
                ssTreeRoot = pathTgtNode.getroottree().getroot()
                (nodeID, _) = getNodeIDPath(pathTgtNode, excludeChoiceCase=True, 
                                                    topNode=ssTreeRoot)
                #print "pathTargetNodeIDandvalue ", nodeID
                foundNodeTypes[nodeID] = pathTgtNode
                         
    else:    
        for nodeLocalPrefixPair in foundNodes:
            #print "nodeLocalPrefixPair", nodeLocalPrefixPair
            typedefNode = nodeLocalPrefixPair[0]
            typedefNameLocalPrfx = nodeLocalPrefixPair[1]
            #print "typedefNameLocalPrfx ", typedefNameLocalPrfx
            typedefName = replace_namespace_with_prefixed_argument(typedefNode)
            #print "typedefName replace_namespace_with_prefixed_argument: ", typedefName
            
            if typedefName.find(":") == -1:
                if typedefNameLocalPrfx != "":
                    # included submodule does not have prefix. Any typedefs defined in a submodule is 
                    # equivalent as if it is defined in the main module             
                    typedefName = typedefNameLocalPrfx + ":" + typedefName
            foundNodeTypes[typedefName] = typedefNode
                               
    if selectedElemNode is not None:
        if type == "augmentTargets":
            groupNameUsed = ""
            if getStatementValue(selectedElemNode) == "uses":
                groupNameUsed = getArgumentValue(selectedElemNode)
            elif getStatementValue(selectedElemNode.getparent()) == "uses" :
                groupNameUsed = getArgumentValue(selectedElemNode.getparent())
                
            if getStatementValue(selectedElemNode) == "uses" or \
                        getStatementValue(selectedElemNode.getparent()) == "uses" :
                # find relative scheme ID
                foundGroupings = getImportedAndLoalDefinedNodeTypes(\
                                            selectedElemNode.getroottree().getroot(),
                                            selectedElemNode, type="grouping")
                namespaceToUse = "urn:ietf:params:xml:ns:yang:yin:1"
                for grpName, grpNode in list(foundGroupings.items()):
                    if groupNameUsed == grpName:
                        prevRoot = None
                        prevssTree = None
                        for groupAugmentTgt in grpNode.iter("{%s}container"%namespaceToUse, 
                                               "{%s}list"%namespaceToUse,
                                               "{%s}choice"%namespaceToUse,
                                               "{%s}case"%namespaceToUse,
                                               "{%s}input"%namespaceToUse,
                                               "{%s}output"%namespaceToUse,
                                               "{%s}notification"%namespaceToUse):
                            

                            nodeID = get_relative_node_ID(groupAugmentTgt)
                            foundNodeTypes[nodeID] = groupAugmentTgt
                        return foundNodeTypes
        elif type == "pathTargets":
            currentDefines = []
            #for ancestor in selectedElemNode.iterancestors():
            foundAncestorDefines = elemRoot.xpath("//t:leaf | //t:leaf-list",
                         namespaces={'t' : "urn:ietf:params:xml:ns:yang:yin:1"})
            if foundAncestorDefines is not None and len(foundAncestorDefines) > 0:
                # Scoped definitions MUST NOT shadow definitions at a higher scope ...
                currentDefines.extend(foundAncestorDefines)
            #print "foundAncestorDefines ", foundAncestorDefines
            #from copy import deepcopy
            # make a copy of eleRoot to build SSYangTee, otherwise the program
            # crashes( not sure why 7/18/2016)            
            #ssTree = ssyangtree.SSYangTree(treeRoot =deepcopy(elemRoot))

            for pathTgtNode in currentDefines:
                bt = lookup_property(pathTgtNode, "base-type", elemRoot)
                if isGroupingDecendentNode(pathTgtNode) or \
                    isNotificationDecendentNode(pathTgtNode) or \
                    isRPCDecendentNode(pathTgtNode) or \
                    bt == "leafref" or bt == "empty":
                    continue
                                                
                (nodeID, _) = getNodeIDPath(pathTgtNode,
                         excludeChoiceCase=True, topNode=elemRoot)
                #print "pathTargetNodeIDandvalue ", nodeID                
                #firstPrefix =  get_iid_first_prefix(nodeID)
                #print " firstPrefix ", firstPrefix
                # RFC6087 recommends using qualified label
                #nodeID = nodeID.replace("%s:"%firstPrefix, "", 1000)
                if nodeID.find(":input") == -1 and nodeID.find(":ouput") == -1:  
                    # hack to remove the first field prefix:modulename
                    nodeID = nodeID.strip("/")
                    #nodeID = "/"+ "/".join(nodeID.split("/")[1:])                    
                    nodeID = "/".join(nodeID.split("/")[1:])                    
                    if not nodeID.startswith("/"):
                        # augmented nodes may already contains the leading "/"
                        nodeID = "/" + nodeID
                    foundNodeTypes[nodeID] = pathTgtNode            
 
        else:    
            currentDefines = []
            if getStatementValue(selectedElemNode) == "module" or \
                    getStatementValue(selectedElemNode) == "submodule":
                # when trying to find imported types, what is passed in is the module node
                foundToprDefines = selectedElemNode.xpath("t:%s"%type, 
                        namespaces={'t' : "urn:ietf:params:xml:ns:yang:yin:1"})
                if foundToprDefines is not None and len(foundToprDefines) > 0:
                    currentDefines.extend(foundToprDefines)            
            else:    
                for ancestor in selectedElemNode.iterancestors():
                    foundAncestorDefines = ancestor.xpath("t:%s"%type, 
                        namespaces={'t' : "urn:ietf:params:xml:ns:yang:yin:1"})
                    if foundAncestorDefines is not None and len(foundAncestorDefines) > 0:
                        # Scoped definitions MUST NOT shadow definitions at a higher scope ...
                        currentDefines.extend(foundAncestorDefines)
                         
            for e in currentDefines:
                foundNodeTypes[e.get("name")] = e    
          
    return foundNodeTypes    

def isExtensionArgumentMappedToYinElement(node):
    # return true is the extenion node's argument will defined to be mapped to a yin element
    tag = getStatementValue(node)
    # an extension statement must contain :
    if tag.find(":") != -1:
        if len(node):
            return True
    return False    
          
def _getDisplayText(node, fullText):
    val = None
    statement = getStatementValue(node)
    if statement in ["when", "must"]:
        val = node.get(YIN_YANG_Mapping_Dict[statement])
    else:
        # description, error-messages are mapped as subelements    
        #print "statement ", statement
        if len(node):
            val = node[0].text
        
    if val is None:
        val = ""
        
    if not fullText:  
        # if contact/ description has an empty text node, lxml node.text will return None 
        if len(val) > 80:
            val = val[0:80]            
        lfd = val.find("\n")
        if lfd != -1:
            val  = val[0:lfd] + "..."
            
    return val

def getStatementValue(node):     
    if node is None:
        return None
    # get the value of statement (the value displayed in the first (statement) column in the dataviewCtrol) given a statement.
    # this method is used to obtain unqualified localname or prefixed name imported from another module 
    tag = etree.QName(node)
    statement = tag.localname
    namespace = tag.namespace
    
    if namespace != "urn:ietf:params:xml:ns:yang:yin:1":
        # get the original prefix qualified extension name
        for prefix, ns in node.nsmap.items(): 
            if ns == namespace and prefix is not None:
                #print "getStatementValue prefx ", prefix, " state", statement
                
                statement = prefix + ":" + statement
    return statement


def getArgumentValue(node, fullText=True):     
    # get the value of argument (the value displayed in the second (argument) column in the dataviewCtrol) given a statement.
    # if fullText is False, the description text etc. will only return
    #if node is None:
    #    return None
    if node is None:
        return ""
    argument = None
    #tag = etree.QName(node)
    statement = getStatementValue(node)
    if statement in YIN_YANG_MAPPING_TEXT_EXCEPTION + YIN_YANG_MAPPING_MULTILINE_EXCEPTION:
        argument = _getDisplayText(node, fullText)
                     
    elif statement in YIN_YANG_MAPPING_RPC_EXCEPTION:
        argument = ""
    else: 
        argument = ""
        if statement in YIN_YANG_Mapping_Dict:
            argument = node.get(YIN_YANG_Mapping_Dict[statement])                   
        else:
            # sometimes yang statements can come from an imported module, for example
            # netconf-acm rfc6536 extension 'default-deny-all' as used in ietf-system
            # In these cases, we have to handle it differently because lxml does not
            # allow prefix:statement as tag name in a YIN tree
            # in lxml, the tag name will be {urn:ietf:params:xml:ns:yang:ietf-netconf-acm}default-deny-all
            #
            # This must be an unknown extension. The extension may have a 'argument' that is mapped
            # in the module that uses the extension as a 'name' attribute
            # See RFC6020 11.1.1.  Usage Example
            
            # get the original prefix qualified extension name
            if isExtensionArgumentMappedToYinElement(node):
                # YANG extension so far allows only a single yin element subnode  so we can do
                # (just like YIN_YANG_MAPPING_TEXT_EXCEPTION)
                argument = node[0].text                            
            else:
                # YANG extension so far allows only a single attribute so we can do the following
                if len(list(node.items())): 
                    argument = list(node.items())[0][1]
                
    if argument is None:
        argument = "" 
                                
    return argument



def includeAllModulesAsSupportedByDummpySession():
    # moduleRevKey:
    # rad-double-key@@C:\SegueSoft\NETCONFc\YANG-modules\rad-double-key.yang, or
    # rad-double-key@2011-01-01@C:\SegueSoft\NETCONFc\YANG-modules\rad-double-key@2015-01-01.yang
    serverSupportedModules=[]
    for moduelRevKey, _ in SS_YIN_module_dict.items():    
        #print "moduelRevKey ", moduelRevKey
        if (len(moduelRevKey.split('@'))) > 1:  
            modulename =  moduelRevKey.split('@')[0];
            rev =  moduelRevKey.split('@')[1];
             
            if rev == "":
                serverSupportedModules.append(modulename) 
            else:    
                serverSupportedModules.append(modulename + "@" + rev)
                     
        serverSupportedModules.sort()            
    
    return " ".join(serverSupportedModules)            
        

def get_iid_first_prefix(iid):
    # return the first prefix of an yang IID
    #print "get_iid_first_prefix iidlst ", iid
    iidLst = iid.split("/")
    DEBUGPRINT(" iidLst ", iidLst)
    if iid.startswith("/"):        
        # if iid start with "/" then the first item after splitting is an empty string
        firstLst = iidLst[1].split(":")
    else:
        firstLst = iidLst[0].split(":")    
    #print "firstLst ", firstLst    
    if len(firstLst) > 1:
        return firstLst[0] 
    else:
        return ""

def pairwise_every_n(iterable, n):
    "s -> (s0,s1 ), (s2,s3), (s4, s5), ..."
    a = iter(iterable)
    arglist = []
    for i in range(n):
        arglist.append(a)
    return zip(*arglist)

def pairwise_every_two(iterable):
    "s -> (s0,s1), (s2,s3), (s4, s5), ..."
    a = iter(iterable)
    return zip(a, a)

def pairwise(iterable):
    """yields "s -> (s0,s1), (s1,s2), (s2, s3), ..."""
    # Return 2 independent iterators from a single iterable.
    # itertools.tee(iterable, n=2)
    a,b = tee(iterable)
    # Retrieve the next item from the iterator by calling its next() method. 
    # If default (None here) is given, it is returned if the iterator is
    # exhausted
    # If b has only one element, IterStop encountered but we force it to 
    # to return None
    next(b, None)
    return zip(a,b)

def dequote(s):
    """
    If a string has single or double quotes around it, remove them.
    Make sure the pair of quotes match.
    If a matching pair of quotes is not found, return the string unchanged.
    """
    if (s[0] == s[-1]) and s.startswith(("'", '"')):
        return s[1:-1]
    return s

def get_imported_module_revs(treeRoot):
    moduleRevs = []
    importNodes = treeRoot.xpath("//yin:import", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    for n in importNodes:
        modueName = getArgumentValue(n)  
        impRev = ""
        impRevNode = n.xpath("yin:revision-date", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})
        if len(impRevNode):
            impRev =  impRevNode[0].get("date")  

        if impRev != "":
            moduleRevs.append(modueName+"@"+impRev)
        else:
            moduleRevs.append(modueName)
    return moduleRevs

def get_included_submodule_revs(treeRoot):
    moduleRevs = []
    includeNodes = treeRoot.xpath("//yin:include", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    for n in includeNodes:
        modueName = getArgumentValue(n)  
        impRev = ""
        impRevNode = n.xpath("yin:revision-date", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})
        if len(impRevNode):
            impRev =  impRevNode[0].get("date")  

        if impRev != "":
            moduleRevs.append(modueName+"@"+impRev)
        else:
            moduleRevs.append(modueName)

    return moduleRevs

def isGroupingDecendentNode(node):
    while node is not None:
        statement = getStatementValue(node)  
        if statement == "grouping":
            return True
        node = node.getparent()  
    return False
    
def isNotificationDecendentNode(node):
    while node is not None:
        statement = getStatementValue(node)  
        if statement == "notification":
            return True
        node = node.getparent()  
    return False

def isAnyXMLOrAnyDataNode(node):
    if node is not None:
        statement = getStatementValue(node)  
        #print "check grooing got  " , statement
        if statement == "anyxml" or statement == "anydata":
            return True
    return False
    
def isRPCDecendentNode(node):
    while node is not None:
        statement = getStatementValue(node)  
        #print "check grooing got  " , statement
        if statement == "rpc":
            return True
        node = node.getparent()  
    return False
            
def IsConfigNodeAndSetFlag(node):
    if node is not None and node.getparent() is not None:       
        if node.get("config_node_flag") is None:                
            statement = getStatementValue(node)  
            if statement == "module" or statement == "input" or \
                statement == "output" or statement == "rpc":
                node.set("config_node_flag", str(False))
                return False
                        
            for elemChild in node:
                statement = getStatementValue(elemChild)
                argument = getArgumentValue(elemChild)
                #DEBUGPRINT("Child statement " , statement , " argument ", argument)
                # If there is a config node defined we just set and return its value 
                if statement == "config":
                    if argument == "false":
                        node.set("config_node_flag", "false")
                        return False
                    elif argument == "true":
                        node.set("config_node_flag", "true")
                        return True
                    
            # Otherwise we look for  parent's config flag
            parentLst=[]
            pnode = node
            pnode = pnode.getparent()        
            while pnode is not None:
                parentLst.append(pnode)    
                # If the parent's config_node_flag has been set previosuly            
                if pnode.get("config_node_flag") is not None:
                    return pnode.get("config_node_flag") == "true" 
                pnode = pnode.getparent() 

            # From top, explicitly set config  so future search is faster    
            for parentNode in parentLst:   
                IsConfigNodeAndSetFlag(parentNode)

            # Now the parent's config_node_flag must have been set properly
            return IsConfigNodeAndSetFlag(node)   
        else:
            return node.get("config_node_flag") == "true"        
    else:
        #DEBUGPRINT("Top parent node None")
        node.set("config_node_flag", "true")
        return True
                    
def isMandatoryNode(node):
    if node is not None and node.getparent() is not None:
        if node.get("mandatory_node_flag") is None:
            parentSatement = getStatementValue(node)              
            for elemChild in node:
                statement = getStatementValue(elemChild)
                argument = getArgumentValue(elemChild)
                if statement == "mandatory":
                    if argument == "true":
                        node.set("mandatory_node_flag", "true")
                        return True
                elif statement == "min-element" and  (parentSatement == "leaf-list" or statement == "list"):
                    if int(argument) >= 1:
                        node.set("mandatory_node_flag", "true")
                        return True
                    
            node.set("mandatory_node_flag", "false")
            return False                   
        else:
            return node.get("mandatory_node_flag") == "true"
    return False       

#    
#def isInstanceDatatNode(node):              
#    if getStatementValue(node)  == "leaf-list":
#        return True
#    elif getStatementValue(node)  == "leaf":
#        return True
#    elif getStatementValue(node)  == "container":
#        presenceNode = node.xpath("yin:presense",  namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
#        if presenceNode is not None and len(presenceNode) == 1:
#            keyValue = keyNode[0].get("value")
#            if keyValue != None:
#                #keyLst = keyValue.split()
#                return keyValue
#        
#        return True        
#    return False
    
def isLeafNode(node):              
    if getStatementValue(node)  == "leaf":
        return True
    return False

def isLeafListNode(node):              
    if getStatementValue(node)  == "leaf-list":
        return True
    return False

def isContainerNode(node):              
    if getStatementValue(node)  == "container":
        return True
    return False
    
def isPreseceContainerNode(node):              
    if getStatementValue(node)  == "container":
        if lookup_property(node,"presence"):
            return True
    return False

def isListNode(node):              
    if getStatementValue(node)  == "list":
        return True
    return False

def getListKey(listNode):
    keyNode = listNode.xpath("yin:key",  
        namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
    if keyNode is not None and len(keyNode) == 1:
        keyValue = keyNode[0].get("value")
        if keyValue != None:
            #keyLst = keyValue.split()
            return keyValue
    return ""
            
def isListKeyNode(node):              
    keyLst = []
    if node is not None and node.getparent() is not None:
        if node.get("list_key_flag") is None:
            if getStatementValue(node.getparent())  == "list":
                nodeNameToCheck = getArgumentValue(node)
                            
                for elemChild in node.getparent():
                    statement = getStatementValue(elemChild)
                    argument = getArgumentValue(elemChild)
                    
                    if statement == "key":
                        keyLst = argument.split()
                        break
                
                # loop again to determine if a node is key node    
                for elemChild in node.getparent():   
                    # since key must be first nodes so we can continue check if leaf node is a key in the same loop
                    #print "keyLst ", keyLst
                    
                    # sometimes the node is augmented and use a name with prefix so we need to stip :
                    
                    nodeNameToCheckNoPfx = nodeNameToCheck
                    if nodeNameToCheck.find(":") != -1:         
                        nodeNameToCheckNoPfx = nodeNameToCheck.split(":")[1]       
                                    
                    if nodeNameToCheck in keyLst or nodeNameToCheckNoPfx in keyLst:
                        node.set("list_key_flag", "true")
                        return True
                    else:
                        node.set("list_key_flag", "false")
                        return False          
            else:
                # if parent is not a list then this must not a key node
                node.set("list_key_flag", "false")
                return False
        # list_key_flag has been set so return True or False   
        else:
            return node.get("list_key_flag") == "true"                                
    else:
        # None
        return False

def lookup_property(yangElemNode, property, rootNode=None, union_type="",
        Target_YANG_Dict=SS_YANG_Dict):      
    #DEBUGPRINT("passing in union_type ", union_type , " lookup_property ", property)
    if yangElemNode is not None:
        if property.lower() == "access":
            if IsConfigNodeAndSetFlag(yangElemNode):
                return "readwrite"
            else:
                return "readonly"                        
        if property.lower() == "category":
            return getStatementValue(yangElemNode)            
        elif property.lower() == "config":
            return IsConfigNodeAndSetFlag(yangElemNode)                        
        elif property.lower() == "base-type" and union_type == "":
            return get_type_helper(yangElemNode, rootNode, baseFlag=True,
                        Target_YANG_Dict=Target_YANG_Dict)            
        elif property.lower() == "default":            
            r = yangElemNode.xpath('t:default',  namespaces={'t': YIN10NS})
            if r is not None and len(r) > 0:
                return r[0].get("value")    
            else:
                return ""                        
        elif property.lower() == "bit" or property.lower() == "base" or  property.lower() == "fraction-digits" or \
            property.lower() == "path" or (property.lower() == "base-type" and union_type != "") or \
            property.lower() == "pattern"  or   \
            property.lower() == "require-instance" or property.lower() == "enum" or \
            property.lower() == "default"  or property.lower() == "if-feature" or\
            property.lower() == "must" or property.lower() == "unique" or \
            property.lower() == "min-elements" or property.lower() == "max-elements" \
            or property.lower() == "ordered-by":       
            
            #for dcelem in yangElemNode.iter():
            #    print("used group child node processed ", getStatementValue(dcelem),  "label ", getArgumentValue(dcelem))              

            return get_type_helper(yangElemNode, rootNode, baseFlag=True, 
                    op=property.lower(), union_type=union_type,
                    Target_YANG_Dict=Target_YANG_Dict)
            
        elif property.lower() == "key":
            return get_key_helper(yangElemNode, rootNode,
                        Target_YANG_Dict=Target_YANG_Dict)                                                            
        elif property.lower() == "length":
            length = get_type_helper(yangElemNode, rootNode, baseFlag=True, op="length", union_type=union_type)    
            if length != "":                            
                lengthLst = length.split("|")
                newLengLst = []
                for leng in lengthLst:
                    # remove spaces 
                    leng = leng.strip()
                    lengLst =  leng.split("..")
                    if len(lengLst) == 1:
                        lengLst.append(lengLst[0])                    
                    
                    # compare with lower and upperlimit 
                    if lengLst[0].strip() == "min":
                        lengLst[0] = "0"
                    elif lengLst[1].strip() == "max":
                        lengLst[1] = "18446744073709551615"                    
                    newLengLst.append("..".join(lengLst))                    
                return "|".join(newLengLst)    
            return ""
            
        elif property.lower() == "mandatory":
            return isMandatoryNode(yangElemNode)                                    
        elif property.lower() == "presence":
            r = yangElemNode.xpath('t:presence',  namespaces={'t': YIN10NS})
            if r is not None and len(r) > 0:
                return True    
            else:
                return False            
        elif property.lower() == "range":
            range = get_type_helper(yangElemNode, rootNode, baseFlag=True, op="range", union_type=union_type) 
            # further process to subsitute min max and find the deault min max (when no specific range defined)
            if union_type == "":
                basetype = get_type_helper(yangElemNode, rootNode, baseFlag=True)
            else:
                basetype = get_type_helper(yangElemNode, rootNode, baseFlag=True, op="base-type", union_type=union_type)    
                
            if basetype == "decimal64":
                fracdig = get_type_helper(yangElemNode, rootNode, baseFlag=True, op="fraction-digits", union_type=union_type)
                basetype = "decimal64.%s"%fracdig.strip()
                
            if basetype not in numerical_builtin_types_extended:
                # should not really happen because if there is range defined then it has to be one of numerical_builtin_types
                return range                   
            newRangLst=[]
            if range != "":                    
                rangeLst = range.split("|")
                newRangeLst = []
                for rang in rangeLst:
                    # remove spaces 
                    rang = rang.strip()
                    rangLst =  rang.split("..")
                    if len(rangLst) == 1:
                        rangLst.append(rangLst[0])                    
                    
                    # compare with lower and upperlimit
                    # must strip because there could be space such as in range "1 .. 3.14 | 10 | 20..max";
                    if rangLst[0].strip() == "min":
                        rangLst[0] = numericTypeMin[basetype]
                    elif rangLst[1].strip() == "max":
                        rangLst[1] = numericTypeMax[basetype]                    
                    newRangLst.append("..".join(rangLst))                    
                return "|".join(newRangLst)            
            else:
                return "%s..%s"%(numericTypeMin[basetype], numericTypeMax[basetype])
            
        elif property.lower() == "status":
            r = yangElemNode.xpath('t:status',  namespaces={'t': YIN10NS})
            if r is not None and len(r) > 0:
                return r[0].get("value")    
            else:
                return ""            
        elif property.lower() == "union-type":
            return get_type_helper(yangElemNode, rootNode, baseFlag=True, op="union-type", union_type=union_type)            
        elif property.lower() == "type":
            return get_type_helper(yangElemNode, rootNode)
        
        else:
            raise Exception("Unknown option %s"%property)
            
        #argument = getArgumentValue(yangElemNode)
        #return argument
            
def get_key_helper(node, rootNode, nsmap=None):
    ancestorsFromTop=[]
    for ancestor in node.iterancestors():
        #print "ancestor ", ancestor.tag
        if ancestor.tag == " {urn:ietf:params:xml:ns:netconf:base:1.0}module":
            break
        ancestorsFromTop.append(ancestor)
    # add the node itself in case an entry node is given    
    ancestorsFromTop.append(node)        
    ancestorsFromTop.reverse()    
    
    keyValueOrderedLst = []    
    for ancestor in ancestorsFromTop:                                                                 
        if isListNode(ancestor):
            (ancestorNodeID, mymap) = _getNodeIDPathHelper(ancestor, False, rootNode)
            # now to to include actualy key through the 'key' names
            keyLst = getListKey(ancestor).split()
            
            keyValueDict={}                    
            
            for child in ancestor.iterchildren():
                if getStatementValue(child) != "leaf":
                    continue
                
                (childNodeID, childNodeNSmap) = _getNodeIDPathHelper(child, False, rootNode) 
                if isListKeyNode(child): 
                    keyName =  getArgumentValue(child)                        
                    keyValueDict[keyName] = childNodeID
                    
                    # add an entry using keyName without prefix. For example, a list defined in an augmenting module
                    # the key defined in augmenting module will have no prefix, but when applied in the augmented 
                    # module, the actual key node name will have prefix qualified. For example:
                    #keyValueDict  {'Context:contextNameId': ('/ComTop:ManagedElement/Context:Context/Context:contextNameId', {'value': 'NEED-A-VALUE-FOR-KEY-NODE!'})}
                    #keyKst  ['contextNameId']
                    if keyName.find(":") != -1: 
                        keyValueDict[keyName.split(":")[1]] = (childNodeID, childNodeNSmap)
                    else:
                        keyValueDict[keyName] = (childNodeID, childNodeNSmap)
            
            #print "keyValueDict ", keyValueDict
            #print "keyKst ", keyLst     
                               
            for key in keyLst:
                # it is possible the key node contains a key name that is not actually defined in the leaf nodes 
                if key in  keyValueDict:
                    keyValueOrderedLst.append(keyValueDict[key])
    return keyValueOrderedLst


# Find the lower layer typedef' property value 
# If this is not a typedef, then just find its type value
def get_lower_type_helper(typenode, rootNode, baseFlag=False, op="", union_type="",
            Target_YANG_Dict=SS_YANG_Dict):
    # Since an augmenting node type contains augmenting prefix shown as below                         
    # /if:interfaces/interface/ip:ipv4/enabled  ip:boolean
    # we however can remove the prefix if it is not a derived type
    # since typedef must not use the same name as built-in types

    modulePrefixNode = rootNode.xpath("yin:prefix", namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})    
    if len(modulePrefixNode) == 0:
        # no prefix node then this must be a submodule
        #raise Exception("No prefix node found for %s"%rootNode)
        belongsToxNode = rootNode.xpath("yin:belongs-to", namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})
        if len(belongsToxNode):
            modulePrefixNode = belongsToxNode[0].xpath("yin:prefix", namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})
    
    modulePrefixOfThisModule = ""        
    if len(modulePrefixNode):
        modulePrefixNode = modulePrefixNode[0]
        modulePrefixOfThisModule = getArgumentValue(modulePrefixNode)
    #DEBUGPRINT("getArgumentValue(modulePrefixNode): ", getArgumentValue(modulePrefixNode))

    mytype = typenode.get("name")
    
    mytypePfx = ""    
    if mytype.find(":") != -1:
        # may may get the form 'ip:yang:dotted-quad' in an augmented module
        mytypeSplits = mytype.split(":")                       
        if len(mytypeSplits) == 3:
            # we must find the typedefs in the original augmenting module
            #  ip:inet:ipv4-address-no-zone
            # discard the first prefix that is added during automating deepcpopy
            #mytypePfx = mytypeSplits[-3]
            #mytypename = mytypeSplits[-2]+":"+mytypeSplits[-1]                         
            mytypePfx = mytypeSplits[-2]    
            mytypename = mytypeSplits[-1]           
            
        elif len(mytypeSplits) == 2:
            mytypePfx = mytypeSplits[-2]    
            mytypename = mytypeSplits[-1]   
        else:
            mytypename = mytypeSplits[-1]           
           
            
        # check if the prefix is the same as the module's own prefix            
        if mytypePfx == modulePrefixOfThisModule:
            mytype =  mytypename                    

        #print("mytypePfx in get_lower_type_helper " + mytypePfx + " mytypename: " + mytypename)    
        if mytypename in builtin_types:
            if op!= "":
                return get_property_of_type(typenode, op, union_type=union_type,
                         rootNode=rootNode, Target_YANG_Dict=Target_YANG_Dict)                                                
            return  mytypename
        else:
            # for a type is a imported type return modulename:typename

            #DEBUGPRINT("mytypePfx ", mytypePfx)
            # the root node always contain imported module prefix/namespacce in nsmap so we can do
            # the following directly. But the real root could be different after applying augments etc.
            #for prefix, namespace in list(typenode.getroottree().getroot().nsmap.items()):
            #    DEBUGPRINT("module imported ", prefix, " ns ", namespace)

            nodeNsmapMerged = {}
            nodeNsmapMerged.update(typenode.nsmap)
            #if ssession is not None:
            #    nodeNsmapMerged.update(ssession.nsmapMerged)
            #    #DEBUGPRINT("nodeNsMapMerged ", nodeNsmapMerged)

            for pfx, namespace in nodeNsmapMerged.items():
                if pfx ==  mytypePfx:
                    #DEBUGPRINT("found matching pfx "  + pfx + " ns: " + namespace)
                    
                    if  namespace in Target_YANG_Dict:
                        modulename = Target_YANG_Dict[namespace]["module"]
                        AtreeObj = Target_YANG_Dict[namespace]["lxmlTreeRoot"]

                        if baseFlag:                               
                            if AtreeObj is None:
                                continue          

                            uidx=union_type.find(":")
                            if uidx != -1:
                                uprx = union_type[0:uidx]
                                if uprx == pfx:
                                    union_type = union_type[uidx+1:]
                                DEBUGPRINT_SYN("union_type now: ", union_type)       
                            return get_base_type_property(mytypename, op, AtreeObj, typenode, AtreeObj, union_type)                                                                     
                        else:
                            #print "baseFlag false Imported module found already: ", modulename, " ", Target_YANG_Dict[namespace]["revision"]
                            if op!= "":
                                return get_property_of_type(typenode, op, union_type=union_type, 
                                        rootNode=rootNode, Target_YANG_Dict=Target_YANG_Dict)            
                            return "%s:%s"%(modulename, mytypename)
            raise Exception("%s type is not found in any loaded modules!"%mytype)               
    else:        
        if mytype in builtin_types:
            #DEBUGPRINT_SYN("get base-type of ",     mytype)
            if op!= "":
                return get_property_of_type(typenode, op, union_type=union_type, rootNode=rootNode)                      
            return mytype
        else:
            if baseFlag:
                # A reference to an unprefixed type or grouping, or one which uses the
                #    prefix of the current module, is resolved by locating the closest
                #    matching "typedef" or "grouping" statement among the immediate
                #    substatements of each ancestor statement. 
                return get_base_type_property(mytype, op, rootNode, typenode, typenode,
                                union_type,
                                Target_YANG_Dict=Target_YANG_Dict)
            else:
                if op!= "":
                    return get_property_of_type(typenode, op, 
                            union_type=union_type, rootNode=rootNode,
                            Target_YANG_Dict=Target_YANG_Dict)        
                return mytype
                
def get_type_helper(yangElemNode, rootNode, baseFlag=False, 
        op="", union_type="",
        Target_YANG_Dict=SS_YANG_Dict):
    # Only imported types use modulename:type form
    # a derived type used by the data nodes in the same 
    # module do not output with modulename prefixed 
    r = yangElemNode.xpath('t:type',  namespaces={'t': YIN10NS})
    #DEBUGPRINT_SYN("rootNode ", rootNode, " ", rootNode.get("name"))
    if len(r) > 0:          
        # found type node, go ahead to retrieve the type node's  type value
        return get_lower_type_helper(r[0], rootNode, baseFlag=baseFlag, 
                op=op, union_type=union_type,
                Target_YANG_Dict=Target_YANG_Dict)     
    else:
        raise Exception("No type definition is found in any loaded modules for " \
            "%s (%s)!"%(getArgumentValue(yangElemNode),
            getStatementValue(yangElemNode)))
        
def get_base_type_property(mytype, op, rootNode, typenode,  
            scopeNode, union_type,
            Target_YANG_Dict=SS_YANG_Dict):
    if rootNode is None:
        raise Exception("Tree root for %s is None! Check if the module@revision has been loaded!")
    
    # first check in the original definition module 
    # e.g.: for v4ur::outgoing-interface, ietf-ipv4-ucast-routing module is checked first
    #print("to find in ", rootNode.get("name"), " union_type: ", union_type)
    baseTypeFound =  do_get_base_type_property(rootNode, mytype, 
                scopeNode, typenode, op, union_type,
                Target_YANG_Dict=Target_YANG_Dict)
    #print(" baseTypeFound ", baseTypeFound)
    if baseTypeFound is not None:
        return baseTypeFound
    else:
        # if not found then this could be an augmented node
        # e.g. v4ur::outgoing-interface (ietf-ipv4-unicast-routing augment ietf-routing) and it 
        # uses if:interface-ref as type, which is only exists in the the augmenting module's import
        
        if mytype.find(":") != -1:
            pfx, mytype = mytype.split(":")         
            if pfx in typenode.nsmap:
                ns = typenode.nsmap[pfx]
                if ns in Target_YANG_Dict:       
                    treeObj = Target_YANG_Dict[ns]["lxmlTreeRoot"]
                    yangFile = Target_YANG_Dict[ns]["file"]
                                        
                    if treeObj is not None:
                        #augTreeRoot = treeObj.getroot()
                        # treeObj is already the root 
                        augTreeRoot = treeObj
                        # if this is an type with prefix then it must be defined in an imported module
                        # so we must get all top level typedefs there by using the root as scopeNode
                        scopeNode = augTreeRoot
                        
                        baseTypeFound =  do_get_base_type_property(augTreeRoot, 
                                mytype, scopeNode, typenode, op, union_type,
                                Target_YANG_Dict=Target_YANG_Dict)
                    if baseTypeFound is not None:
                        return baseTypeFound        
    raise Exception("No base type found for type %s"%mytype)         

def do_get_base_type_property(rootNode, mytype, scopeNode,
        typenode, op, union_type="",
        Target_YANG_Dict=SS_YANG_Dict):                                 
    typesDict = getImportedAndLocalTypes(scopeNode, 
                   Target_YANG_Dict=Target_YANG_Dict)    
    if union_type !="":
        # mytype may be a typedef and its base type is actually union
        #e.g. /ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host"
        # If union_type is passed down then we must be searching the base of the 
        # union_type instead
        mytype = union_type
        union_type = ""
 
    #print("do_get_base_type_property mytype: ", mytype)
    if mytype in typesDict:
        typdefnode = typesDict[mytype]
        r = typdefnode.xpath('t:type',  namespaces={'t': YIN10NS})
        if len(r) > 0: 
            typedeftypenode = r[0] 
            #print("typedeftypenode ", typedeftypenode.get("name"), " op ",op) 
            if (op!= "" and  op != "base-type"):
                
                return get_type_property_smart(typenode, typedeftypenode, 
                    op, union_type=union_type, rootNode=rootNode,
                    Target_YANG_Dict=Target_YANG_Dict
                    )
              
            if typedeftypenode.get("name") not in builtin_types:
                return get_lower_type_helper(typedeftypenode, rootNode, 
                    baseFlag=True, op=op, union_type=union_type,
                    Target_YANG_Dict=Target_YANG_Dict)
            else:                
                return typedeftypenode.get("name")
                
        
        
def get_type_property_smart(typenode, typedeftypenode, op, 
        union_type="", rootNode=None,
        Target_YANG_Dict=SS_YANG_Dict):
    propertyValOfThisNode= get_property_of_type(typenode, op, 
            union_type=union_type, rootNode=rootNode,
            Target_YANG_Dict=Target_YANG_Dict)
    #DEBUGPRINT("propertyValOfThisNode: ", propertyValOfThisNode)
    if op != "pattern":                                                
        if propertyValOfThisNode !="":
                #print " smart propertyValOfThisNode ", propertyValOfThisNode, " op ", op
                # for example, if a derived type is further restricted by the data node
                propertyValOfBaseNode = get_property_of_type(typedeftypenode, op, 
                        union_type=union_type, rootNode=rootNode,
                        Target_YANG_Dict=Target_YANG_Dict)
                # replace min max value with the min max defined in the base 
                # that is, if min, max is defined then it will be replaced with the actual number
                # otherwise we can know the min max based on the actual base-type in the validation procedures 
                if op == "length" or op == "range":
                    #print "propertyValOfThisNode ", propertyValOfThisNode
                    if propertyValOfThisNode.find("min") != -1:
                        if propertyValOfBaseNode != "":
                            #print "propertyValOfBaseNode: ", propertyValOfBaseNode
                            if propertyValOfBaseNode.find("min") != -1:
                                if typedeftypenode.get("name") not in builtin_types:
                                    # find the lower layer typedef' property value
                                    propertyValOfBaseNode = get_lower_type_helper(typedeftypenode,
                                         rootNode, baseFlag=True, op=op, union_type=union_type,
                                         Target_YANG_Dict=Target_YANG_Dict)
                                else:
                                    propertyValOfBaseNode = get_property_of_type(typedeftypenode, 
                                        op, union_type=union_type, rootNode=rootNode,
                                        Target_YANG_Dict=Target_YANG_Dict)
                                    
                            propertyValOfBaseNodeLst = propertyValOfBaseNode.split("|")                                
                            p = propertyValOfBaseNodeLst[0]
                            # strip spaces
                            p = p.strip()
                            pl = p.split("..")
                            minbase = pl[0]
                            propertyValOfThisNode = propertyValOfThisNode.replace("min", minbase)
                                
                    if propertyValOfThisNode.find("max") != -1:
                        if propertyValOfBaseNode != "":
                            if propertyValOfBaseNode.find("max") != -1:
                                if typedeftypenode.get("name") not in builtin_types:
                                    # find the lower layer typedef' property value
                                    propertyValOfBaseNode = get_lower_type_helper(typedeftypenode, 
                                            rootNode, baseFlag=True, op=op, union_type=union_type,
                                            Target_YANG_Dict=Target_YANG_Dict) 
                                else:    
                                    get_property_of_type(typedeftypenode, op, 
                                        union_type=union_type, rootNode=rootNode,
                                        Target_YANG_Dict=Target_YANG_Dict)
                            
                            propertyValOfBaseNodeLst = propertyValOfBaseNode.split("|")
                            p = propertyValOfBaseNodeLst[-1]
                            # strip spaces
                            p = p.strip()
                            pl = p.split("..")
                            if len(pl) > 1:
                                maxbase = pl[1]
                            else:    
                                maxbase = pl[0]
                            propertyValOfThisNode = propertyValOfThisNode.replace("max", maxbase)                
                return propertyValOfThisNode                                     
        else:
            # continue to check base type property of this typedef 
            if typedeftypenode.get("name") not in builtin_types:
                # find the lower layer typedef' property value
                return get_lower_type_helper(typedeftypenode, rootNode, 
                    baseFlag=True, op=op, union_type=union_type,
                    Target_YANG_Dict=Target_YANG_Dict) 
            else:    
                return get_property_of_type(typedeftypenode, op, 
                        union_type=union_type, rootNode=rootNode,
                        Target_YANG_Dict=Target_YANG_Dict)
        return propertyValOfThisNode.strip()                                                                        
    else:   
        #DEBUGPRINT("is pattern op :", op)                                 
        # pattern restriction must include patterns defiined in the derived types and base types 
        # get patterns in base derived types (the typedef is defiend based on a derived type)
        # patterns are returned as a list
        #if propertyValOfThisNode is not None:
            #if propertyValOfThisNode == "":
            #    propertyValOfThisNode = []
        if typedeftypenode.get("name") not in builtin_types:
            propertyValOfThisNode.extend(get_lower_type_helper(typedeftypenode, 
                rootNode, baseFlag=True, op=op, union_type=union_type,
                Target_YANG_Dict=Target_YANG_Dict))
        else:
            propertyValOfThisNode.extend(get_property_of_type(typedeftypenode, 
                op, union_type=union_type, rootNode=rootNode,
                Target_YANG_Dict=Target_YANG_Dict))
        return propertyValOfThisNode    

def  get_property_of_type(typenode, op, union_type="", rootNode=None,
        Target_YANG_Dict=SS_YANG_Dict):
    nval = ""    
    if op == "union-type":
        origop = op
        op="type"
    else:
        origop = op
            
    # if an actual value union_type is passed down then we just search the property
    # for that specific union_type    
    if union_type!="":
        r = typenode.xpath('t:type',  namespaces={'t': YIN10NS})
        if len(r) > 0:
            for n in r:                                     
                if union_type in builtin_types or union_type.split(":") [-1] in builtin_types:
                    if op == "base-type":
                        return ""
                    return get_property_of_type(n, op,  rootNode=rootNode,
                            Target_YANG_Dict=Target_YANG_Dict)                      
                else:
                    return get_base_type_property(union_type, op, rootNode, n, n, "",
                            Target_YANG_Dict=Target_YANG_Dict)
                            

    #print "get_property_of_type typenode ", getArgumentValue(typenode)    , " op ",op
    nval = ""          
    npaternLst = []  
    if op in ["base", "bit",  "default", "enum", "fraction-digits", "if-feature", "length", "ordered-by", 
              "min-elements", "max-elements",  "must", "path", "pattern", "range",  "require-instance",
              "type", "unique"]:           
        r = typenode.xpath('t:%s'%op,  namespaces={'t': YIN10NS})
        if len(r) > 0:
            for n in r:
                anval = getArgumentValue(n)    
                mytypename = anval            
                if anval.find(":") != -1:
                    # may may get the form 'ip:yang:dotted-quad' in an augmented module
                    mytypeSplits = anval.split(":")                       
                    if op in ["enum", "bit"]:
                        # enum bit does not have use prefix added wen augmenting
                        mytypename =   mytypeSplits[-1]             
                    
                    elif len(mytypeSplits) == 3:
                        # we must find the typedefs in the original augmenting module
                        #  ip:inet:ipv4-address-no-zone
                        # discard the first prefix that is added during automating deepcpopy                   
                        mytypename = mytypeSplits[-2] + ":" + mytypeSplits[-1]           
                        
                # augmented node must return with the form modulePrefix:type
                # such as modulePrefix:enumeration so that we can find the original module 
                # the defines it        
                #if mytypename.find(":") != -1:   
                #    nnval = mytypename.split(":") [-1]  
                #    if nnval in builtin_types:
                #        mytypename = nnval
               
                # we may get multiple patterns    
                """
                if nval == "":                             
                    nval = mytypename
                else:                   
                    if op == "pattern":
                        DEBUGPRINT("!!!!!!!!!pattern ", mytypename)
                    nval = nval + " " + mytypename
                """
                #DEBUGPRINT("got mytypename ", mytypename)
                if op == "pattern":
                    # multiple patterns are returned in a list, rather than a string 
                    # separated by space
                    npaternLst.append(mytypename)
                    #DEBUGPRINT("got npaternLst: ", npaternLst)
                else:    
                    if nval == "":                             
                        nval = mytypename
                    else:                   
                        nval = nval + " " + mytypename
                
            typename = getArgumentValue(typenode)
            #DEBUGPRINT(" op ", op, "nval: ", nval  ,  " typename ", typename)
            
            # may get union inside a union
            if typename == "union":
                # e.g.:
                # s.yang_lookup("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='335']/ncm:source-host",
                # "union-type",     #nsmap={'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring'}, 
                # union_type="inet:ip-address"
                nvalList = nval.split()
                newnval = ""
                for nvl in nvalList:
                    snval  = get_property_of_type(typenode, "union-type", 
                            union_type=nvl, rootNode=rootNode,
                            Target_YANG_Dict=Target_YANG_Dict)
                    if snval != "":
                        newnval = newnval + " " + snval
                    else:
                        newnval = newnval + " " + nvl
                nval =newnval.strip()                    

            # may get the form 'ip:yang:dotted-quad' in an augmented module
            elif typename  == "identityref" or typename.endswith(":identityref"):
                # return modulename:identity form
                DEBUGPRINT("process identityref: ",nval)
                if nval.find(":") == -1:
                    if nval !="":
                        nval = rootNode.get("name") + ":" + nval
                else:
                    pfx, nval = nval.split(":")
                    if pfx in typenode.nsmap:
                        ns = typenode.nsmap[pfx]
                        
                        # we can just find the module name using 
                        # Target_YANG_Dict (namespace keyed on the most recent 
                        # revision, in most times it is the module that is implemented but not guaranteed
                                            
                        # if needed we can locate the exact revision that is implemented
                        # by taking ssession into consideration since
                        # there must be only one version of a module implemented                        
                        # e.g. when calling getIdentityOfBaseType (not actually used but it is an example
                        # where ssession can be passed down
                        
                        if  ns in Target_YANG_Dict:
                                modulename = Target_YANG_Dict[ns]["module"]
                                nval = modulename + ":" + nval                           
                    else:
                        raise Exception("prefix of %s:%s not found!"%(pfx,nval))            
    else:
        raise Exception("unknown property %s", origop)            
        #pass
        
    if op == "pattern":
        #DEBUGPRINT("return  npaternLst : ",npaternLst)
        return npaternLst
    return nval.strip()    



def getTopTreeRootKeys():
    topTreeRootKeys =  [moduelRevKey for \
        moduelRevKey, dictv in SS_YANG_Dict.items() \
        if moduelRevKey.find(":") ==-1 and moduelRevKey.split("@")[0] !="" \
                and (len(moduelRevKey.split("@")) !=1 or \
                        len(moduelRevKey.split("@")) ==1 and dictv["revision"] =="")]  

    topTreeRootKeys.sort()
    noDataNodeKey =[]
    for tKey in topTreeRootKeys:
        if tKey in SS_YANG_Dict.keys():
            tRoot = SS_YANG_Dict[tKey]["lxmlTreeRoot"]
            if getChildrenCountFromElemNode(tRoot) ==0:
                noDataNodeKey.append(tKey)
        
    for rKey in  noDataNodeKey:
        topTreeRootKeys.remove(rKey)    
    return  topTreeRootKeys


def  getChildrenCountFromElemNode(elemNode):
    if elemNode is None:
        return 0                  
    if  getStatementValue(elemNode) == "submodule":
        return 0
    dataNodeChidren=[]
    for nodechild in elemNode:
        if getStatementValue(nodechild) in _dataNodes:
            dataNodeChidren.append(nodechild)                                                     
    return len(dataNodeChidren)        