#!/bin/bash

# Set up a default search path.
PATH="/bin:/usr/bin:/usr/local/bin"
export PATH

CACERT_BASE=ca

CA_C="US"
CA_ST="Illinois"
CA_L="Champaign"
CA_O="Seguesoft"
CA_OU="Seguesoft CA generator"

CA_CN="example..example.tld"
CA_EMAIL="nobody@example.tld"
 
CA_EMAIL="xiangli@seguesoft.com"

CA_CN=`hostname -f`
SUBJ="/C=${CA_C}/ST=${CA_ST}/L=${CA_L}/O=${CA_O}/OU=${CA_OU}/CN=${CA_CN}/emailAddress=${CA_EMAIL}"

DIGEST_ALG="-sha512"

# Returns OK (0) if $1 contains $2.
# Otherwise returns Not OK (1).
strstr() {
  [ "${1#*$2*}" = "$1" ] && return 1
  return 0
}

if [ -f ${CACERT_BASE}.crt ] || [ -f ${CACERT_BASE}.key ] ; then
  echo -n 'Prior CA files exist.  Do you wish to replace them? (Y)es/(N)o? [N] '
  read answer
  if ( strstr "nN" "${answer}" ) || [ -z "${answer}" ] ; then
  	 echo "Not proceeding.  Nothing has been done.  You may run this script again."
  	 exit 1
  fi
fi

rm -f ${CACERT_BASE}.crt ${CACERT_BASE}.key

openssl req -new -x509 -nodes ${DIGEST_ALG} -days 367890 -extensions v3_ca -keyout ${CACERT_BASE}.key -out ${CACERT_BASE}.crt -subj "${SUBJ}"

echo "======================================================================"
openssl x509 -text -noout -subject -in ${CACERT_BASE}.crt
echo "======================================================================"
openssl rsa  -check -noout -in ${CACERT_BASE}.key
echo "======================================================================"
