######################################################################
# Copyright (C) 2011 - 2021 Seguesoft Inc. All rights reserved.
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
######################################################################

from wx.core import Center
import check_license

import datetime, os,  time, sys, socket, platform
from copy import deepcopy
import traceback
from lxml import etree as etree
import uuid
import re
import regex
import six
import common_global_variables   

import decimal
import copy
import json

from xmljson import RestConfYANG
from common_global_variables import YIN10NS
from common_global_variables import numerical_builtin_types
from common_global_variables import numericTypeMin
from common_global_variables import numericTypeMax
from common_global_variables import DEBUGPRINT, DEBUGPRINT_SYN
from ncclient.operations.errors import TimeoutError
from ncclient.operations.errors import ReplyParsingError

from ncclient.operations import util

from ncclient import manager
from ncclient import xml_

# ssclient only uses the following two exceptions
from ncclient.operations.errors import TimeoutError
from ncclient.operations.errors import ReplyParsingError

from ncclient.operations import util
from threading import Event

from collections import OrderedDict
# Import helper class and functions
#from parse_module import find_first_node_with_tag
from parse_module import YIN_YANG_Mapping_Dict
from parse_module import parse_server_capabilities
from parse_module import parse_restconf_server_capabilities

# from .. import ... a dict still gets a reference.
# from .. import ... a variable that is not an object gets a value copy



from parse_module import convert_yang_module_to_format
from parse_module import load_yang_module
from parse_module import load_yin_module

from parse_module import get_iid_first_prefix

#from parse_module import convert_yang_modules_in_paths_to_yin

import parse_module


#from  build_rpc_helper import NamespaceMissingError
from  build_rpc_helper import ParameterError
from  build_rpc_helper import _build_getssubtree_expr
from  build_rpc_helper import _build_nodePathAndValueList
from  build_rpc_helper import _build_subtree_toplevel_elem_list_item
#from build_rpc_helper import _construct_namespace_qualified_name
from  build_rpc_helper import _get_rpc_helper
from  build_rpc_helper import _get_data_rpc_helper
from  build_rpc_helper import _get_config_rpc_helper
from  build_rpc_helper import _query_yes_no

DEFAULT_NS_PREFIX = "n_"
#from parse_module import resolveUsesApplyAugments
from parse_module import searchForIdentitiesOfBase
from ssyangtree import SSYangTree


#from  ssinstance import getInstanceNodeYangElem
#from  ssinstance import getYangTreeRoot
from ssinstance import getAndReturnInstNodeYANGInstanceID

from parse_module import dequote
from parse_module import pairwise_every_two, pairwise
from parse_module import build_nodeIDAndValDictList
from parse_module import addTrimSpaceListPredicate

#from parse_module import getStatementValue
from parse_module import getArgumentValue

from rcclient.restconf.jsonRestClient import JSONRestConfSession
from rcclient.restconf.xmlRestClient import XMLRestConfSession

from rcclient.restconf.restClient import RESTRequestErrorException
import requests
import dualsocket

ActiveSession = None
ActiveSessionType = "SSH"

MODULE_STORE_INITIALIZED = False

USE_INTERNAL_TESTING_DATA_FILE = None
USE_INTERNAL_TESTING_CONFIG_DATA_FILE = None
    
import logging
#logging.basicConfig(level=logging.DEBUG)
logger = logging.getLogger(__name__)




# RESET logging level so that these modules don't print
# stuff to SegueTester log file
# To set the level on root explicitly do logging.getLogger().setLevel(logging.DEBUG). 
# But ensure you've called basicConfig() before hand so the root logger initially has some setup   
logging.basicConfig()

#print("logging.getLogger :", logging.getLogger("paramiko.transport"))
logging.getLogger("paramiko").setLevel(logging.ERROR)
logging.getLogger("paramiko.transport").setLevel(logging.CRITICAL)
#logging.getLogger('ncclient.operations').setLevel(logging.WARNING)
# config logger to avoid: No handlers could be found for logger "ncclient.transport.ssh"
#logging.getLogger('ncclient.transport').setLevel(logging.WARNING)
#logging.getLogger('ncclient.transport.ssh').setLevel(logging.ERROR)
#logging.getLogger('ncclient.transport.tls').setLevel(logging.ERROR)
logging.getLogger('ssinstance').setLevel(logging.WARNING)
logging.getLogger('parse_module').setLevel(logging.WARNING)
logging.getLogger('ssyang').setLevel(logging.WARNING)
logging.getLogger('ssyangtree').setLevel(logging.WARNING)
logging.getLogger('rcclient').setLevel(logging.ERROR)
logging.getLogger('ncclient.transport.ssh').setLevel(logging.ERROR)
# turn it on for tracing while connecting via SSH
#logging.getLogger('ncclient.transport.ssh').setLevel(logging.DEBUG)

if not sys.version_info.major == 3 and sys.version_info.minor >= 8:
    print("Python 3.8 or higher is required.")
    print("You are using Python {}.{}.".format(sys.version_info.major, 
            sys.version_info.minor))
    sys.exit(1)

def my_current_func(context):
    # The context node is the Element where the current function is called:
    context.context_node
    
def set_basens_flag(flag):
    if flag == True:
        xml_.NO_BASE_NS_1_0 =True
    else:      
        xml_.NO_BASE_NS_1_0 =False

def isIntValue(s):
    try: 
        int(s)
        return True
    except ValueError:
        return False    
    
def isFloatValue(s):
    try: 
        float(s)
        return True
    except ValueError:
        return False        
    
IID_pattern = r'^/[a-zA-Z_][a-zA-Z0-9_.-]*:[a-zA-Z_][a-zA-Z0-9_.-]*([a-zA-Z_][a-zA-Z0-9_.-]*:[a-zA-Z_][a-zA-Z0-9_.-]*\[[ \t]*=[ \t]*[\'\"].*[\'\"]\])*$'
IID_pattern_re = re.compile(IID_pattern)
    
def isInstanceID(value):
    #to-do-regular expression
    if IID_pattern_re.match(value) is None:
        return False
    return True
    
# callback for notification                
def _cb_trap(ip, xml):            
    recTime = datetime.datetime.now()
    recTime.strftime("%Y-%m-%d %H:%M")                    
    DEBUGPRINT((recTime, " Notification from ", ip, " ", xml))
    
# TODO    
def set_keepalive(sock, after_idle_sec=60, max_fails=5):    
    """Set TCP keepalive on an open socket.

    It activates after 10 second (after_idle_sec) of idleness,
    then sends a keepalive ping 
    """
    if after_idle_sec == 0:
        return
    
    if platform.system() == "Linux":
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_KEEPALIVE, 1)            
        sock.setsockopt(socket.IPPROTO_TCP, socket.TCP_KEEPIDLE, after_idle_sec)
        #sock.setsockopt(socket.IPPROTO_TCP, socket.TCP_KEEPINTVL, interval_sec)
        #sock.setsockopt(socket.IPPROTO_TCP, socket.TCP_KEEPCNT, max_fails)
    elif platform.system() == "Windows":
        # struct tcp_keepalive {
        # u_long  onoff;
        # u_long  keepalivetime;
        # u_long  keepaliveinterval;
        # };
        # The value specified in the onoff member determines if TCP keep-alive is enabled or disabled. 
        # If the onoff member is set to a nonzero value, TCP keep-alive is enabled and the other
        # members in the structure are used. The keepalivetime member specifies the timeout, 
        # in milliseconds, with no activity until the first keep-alive packet is sent. 
        # The keepaliveinterval member specifies the interval, in milliseconds, between
        # when successive keep-alive packets are sent if no acknowledgement is received.            
        sock.ioctl(socket.SIO_KEEPALIVE_VALS, (1, after_idle_sec * 1000, 30000))        
    elif platform.system() == "Darwin": 
        # scraped from /usr/include, not exported by python's socket module
        TCP_KEEPALIVE = 0x10
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_KEEPALIVE, 1)
        #sock.setsockopt(socket.IPPROTO_TCP, TCP_KEEPALIVE, interval_sec)
    else:
        DEBUGPRINT("No keep-alive is set")

cb_answer = "Ture"

def confirm_dialog(question, confirm_event, caption=""):
    global cb_answer
    if caption=="":
        caption =  "Unknown host. Continue?"
    import wx    
    dlg=wx.MessageDialog(None, question, caption,
                                   wx.YES_NO | wx.ICON_WARNING)
    cb_answer = dlg.ShowModal() == wx.ID_YES
    dlg.Destroy()
    confirm_event.set()
    
    return cb_answer        
                
# callback for unknown host key
def _wxPyAppExisted():
    try:
        import wx     
        wx.CallAfter(len, "")
        return True
    except:
        return False    

if not check_license.LICENSE_CHECKED_OK:       
    check_license.checkLicense() 
    
def _unknown_host_cb_m(host, fingerprint="", key=""):
    global cb_answer
    if fingerprint=="":
        # must be tls 
        question = "hostname specified does not match what was found in server certificate: %s.\nAre you sure you want to connect?"%host
    else:    
        question = "Unknown host: %s.\nAre you sure you want to connect?"%fingerprint
    if "wx" in sys.modules and _wxPyAppExisted():    
        import wx            
        confirm_event = Event()
        wx.CallAfter(confirm_dialog, question, confirm_event)
        confirm_event.wait()        
    else:
        cb_answer=_query_yes_no(question);
        
    if cb_answer == True:  
        DEBUGPRINT("Confirm SegueManager.hostKey ", host, " key ", key)        
        SegueManager.hostKey =(host, key)
    return cb_answer

def listen_callhome(port, mutableSocketList=[], stopEvent=None, timeout=360):    
    # Create a tcp server listening 
    # port: 4334 ssh, 4335 tl, 4336 restconf-ch-tls
    # when a connection is made, set the client_socket in
    # a mutable list variable so that thread can retrieve it
    # stopEvent is Event to be used to stop if used in a Thread
    # Python 3.8 already has a create_server and has dual_stack()
    # methods built-in
    exceptionErr =None
    try:
    
        server_socket = dualsocket.create_server_sock(("", int(port)))
        if not dualsocket.has_dual_stack(server_socket):
            server_socket.close()
            server_socket = dualsocket.MultipleSocketsListener([("0.0.0.0", int(port)), ("::", int(port))])
    
        server_socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        server_socket.settimeout(int(1)) # timeout for accept()
        
        DEBUGPRINT("start listening ", server_socket.getsockname()[0:2])
        
        if sys.stdout is not None:
            sys.stdout.flush()
            
        i=0
        #read_list = [server_socket]
        while i < int(timeout) or timeout == 0:         
            """
            No need to use select
            
            On Windows ERROR: TypeError: argument must be an int, or have a fileno() method.
            # gUESS MUST USE WinSock calls?
            # accept() block 1 second each iteration
            i = i + 1
            readable, writable, errored = select.select(read_list, [], [], 1) 
            for s in readable: 
                if s is server_socket: 
                    client_socket, address = server_socket.accept() 
                    # handle new connection    
                    mutableSocketList[:] = [client_socket]    
                    server_socket.close()  
                    return     
            """
            # accept blocks for 1 second timeout
            try:        
                client_socket, address = server_socket.accept() 
            except socket.timeout:
                # continue while outer loop
                pass
            except:
                raise
            else:            
                DEBUGPRINT(" client_socket, address ", client_socket, " " , address)
                # handle new connection    
                mutableSocketList[:] = [client_socket, exceptionErr]    
                server_socket.close()  
                return  (client_socket, exceptionErr) 
                
                                  
            if stopEvent is not None and stopEvent.isSet():
                DEBUGPRINT("stopEvent set")
                break
        # timeout or stopped by event.set()    
        server_socket.close()  
    except Exception as err:
        try:
            server_socket.close()  
        except:
            pass    
        mutableSocketList[:] = [None, err]       
        return (None, err)    
        

def create_session_restconf_json(**kwargs):
    kwargs["data_encoding"] = "json"
    return create_session_restconf(**kwargs)

def create_session_restconf_xml(**kwargs):
    kwargs["data_encoding"] = "xml"
    return create_session_restconf(**kwargs)
                            
def create_session_restconf(host="localhost", port=8443,
                    client_sock=None,
                    data_encoding = "json",         
                    user="", password="",
                    scheme="https",
                    authType="basic",
                    client_cert = None,
                    client_key=None, 
                    cacert=None,
                    verify=True,
                    timeout=30,                      
                    http_version="1.1",
                    defaultRootResource="/restconf",
                    useDefaultRootResource = False,
                    socks_proxy={"server":'', "port":1080, "type":"SOCKS5", "user": '', "password":''}):
    
    
    #DEBUGPRINT("passed down http ver ", http_version)
    http_version = str(http_version)
    if data_encoding.lower() == "json":
        rcsession = JSONRestConfSession(host,
                                        port=str(port), 
                                        client_sock=client_sock,
                                        username=user,
                                        password=password,
                                        scheme=scheme, 
                                        authType=authType,
                                        client_cert=client_cert,
                                        client_key=client_key,
                                        cacert=cacert,
                                        verify=verify,
                                        timeout=int(timeout),
                                        http_version=http_version,
                                        socks_proxy=socks_proxy
                                        ) 
        
        
        s= SegueManager(rcsession, restconfSession=1)
        s.restconfJSONSessionFlag = 1
        s.restconfXMLSessionFlag = 0
    
        
    else:
        rcsession = XMLRestConfSession(host,
                                        port=str(port), 
                                        client_sock=client_sock,
                                        username=user,
                                        password=password,
                                        scheme=scheme, 
                                        authType=authType,
                                        client_cert=client_cert,
                                        client_key=client_key,
                                        cacert=cacert,
                                        verify=verify,
                                        timeout=int(timeout),
                                        http_version=http_version,                                        
                                        socks_proxy=socks_proxy
                                        ) 
        
        
        s= SegueManager(rcsession, restconfSession=1)
        s.restconfXMLSessionFlag = 1
        s.restconfJSONSessionFlag = 0
    
    s.defaultRootResource= defaultRootResource
    # Check if object is a boolean in Python3
    if  type(useDefaultRootResource) == str:
        if useDefaultRootResource.upper() == "YES":
            s.useDefaultRootResource = "Yes"
        else:
            s.useDefaultRootResource = "No"
    elif   type(useDefaultRootResource) == bool:
        if  useDefaultRootResource == True:
            s.useDefaultRootResource = "Yes"
        else:
            s.useDefaultRootResource = "No"    

    s.data_encoding = data_encoding
    # rememberSessionParameters()
    s.host = host
    s.port = str(port)
    s.user = user
    s.password = password
    #s.key_filename = private_keyfile
    s.client_cert=client_cert
    s.client_key=client_key
    s.cacert=cacert
    s.verify=verify
    s.http_version = http_version
    #DEBUGPRINT("saved s.http_version  ", s.http_version) 
    s.scheme=scheme
    s.socks_proxy = socks_proxy
    s.authType = authType
    s.restSession = True    
    s.retrieveRootResourceDone = False
    s.selectedModels =""
    
    # set the RPC timeout the same as session connection timeout          
    s.timeout = int(timeout)   
    s.rcy =  RestConfYANG(s)
    s.restSession=True

    s.retrieveRootResourceIfHasnt()

    return s
    
    
    

# callback for unknown host key when check_unknown_host =False
def _no_unknown_host_cb_m(host, fingerprint="", key=""):
    SegueManager.hostKey =(host, key)
    return True
   
# Create NETCONF session
def create_session(host="localhost", port=830, user="", 
                    password="", private_keyfile=None, 
                    timeout=30, 
                    verify_connection=False,
                    ssh_ciphers=None,
                    check_unknown_host=True,
                    capabilities=None,
                    custom_capabilities=None,  
                    netconf_version="1.1",
                    keep_alive=0,
                    client_sock =None,
                    socks_proxy={"server":'', "port":1080, "type":"SOCKS5", "user": '', "password":''}):
    """ capabilities are space or newline separated strings which are 
        added to the built-in capability statements
        custom_capabilities are also space or newline separated strings but they are 
        used to substitute for the built-in capabilities"        
    """
          
        
    #allow_agent = False
    #if private_keyfile is not None:
    #    allow_agent =True 
    SegueManager.hostKey = None
    if check_unknown_host:
        cb = _unknown_host_cb_m
    else:
        cb = _no_unknown_host_cb_m    
    #print("custom_capabilities here", custom_capabilities)
    if custom_capabilities is not None:
        if type(custom_capabilities) == list:
            capabilitiesLst = custom_capabilities
        else:    
            if custom_capabilities.strip() == "":
                capabilitiesLst = None
            else:
                capabilitiesLst = custom_capabilities.split()                        
    else:
        if capabilities is not None:
            if type(capabilities) == list:
                capabilitiesLst = capabilities
            else:    
                if capabilities.strip() == "":
                    capabilitiesLst = None
                else:
                    capabilitiesLst = capabilities.split()
                    capabilitiesLst.append("EXTEND_CAPABILITY_FLAG_SET")
        else:
            capabilitiesLst = None            
   
    #print ("create_session nc ver before", netconf_version, " capabilitiesLst:", capabilitiesLst)
    if netconf_version == "1.0":
        if capabilitiesLst is None:
            capabilitiesLst=["DO_NOT_SEND_1.1_CAPABILITY"]
        else:
            capabilitiesLst.append("DO_NOT_SEND_1.1_CAPABILITY")    

    elif netconf_version == "1.1":
        if capabilitiesLst is None:
            capabilitiesLst=["DO_NOT_SEND_1.0_CAPABILITY"]
        else:
            capabilitiesLst.append("DO_NOT_SEND_1.0_CAPABILITY")    
   
    ncmgr = manager.connect(capability=capabilitiesLst,
                                host=host,
                                port=str(port), 
                                username=user,
                                password=password,
                                unknown_host_cb=cb,  
                                key_filename=private_keyfile,
                                ssh_ciphers=ssh_ciphers,
                                look_for_keys=False, 
                                timeout=int(timeout),
                                client_sock =client_sock,
                                socks_proxy=socks_proxy
                                ) 
    # remember this hostKey        
    DEBUGPRINT("SegueManager.hostKey", SegueManager.hostKey)
    if SegueManager.hostKey is not None: 
        nhost = SegueManager.hostKey[0]
        nkey = SegueManager.hostKey[1]
        DEBUGPRINT("nkey ", nkey)
        if os.pathsep == ";":
            userssh = os.path.expanduser('~\\ssh')
        else:
            userssh = os.path.expanduser('~/.ssh')
        
        if not os.path.isdir(userssh):
            try:            
                os.makedirs(userssh)       
            except:
                raise Exception("Create directory %s for known host key file failed!"%userssh) 
        try:               
            ncmgr.session._host_keys.add(nhost, nkey.get_name(), nkey)                 
            ncmgr.session.save_host_keys()
        except:
            raise Exception("Save host key failed!")
                    
    #send keep-alive 
    #interval (int) - seconds to wait before sending a keepalive packet (or 0 to disable keepalives).
    # must force keep_alive to be an int- -it may be a string when passed from GUI text entry
    # in that case the remote server will terminate the session immediately
    ncmgr.session.transport.set_keepalive(int(keep_alive))     
    s =  SegueManager(ncmgr)
    # rememberSessionParameters()
    s._keep_alive = int(keep_alive)
    s.host = host
    s.port = str(port)
    s.user = user
    s.password = password
    s.unknown_host_cb = cb
    s.key_filename = private_keyfile
    s.sshSession=True
    s.sshSessionObj = ncmgr.session
    s.selectedModels =""

    # set the RPC timeout the same as session connection timeout          
    s.timeout = int(timeout)      
    if ncmgr.session.transport:
        print("Local cipher in effect:",  ncmgr.session.transport.local_cipher)
        print("Local ssh version in effect:",  s.sshSessionObj.transport.local_version)
    return s

create_session_ssh = create_session
    
def create_session_tls(host="localhost", port=6513,
                    client_cert=None, 
                    client_key=None, 
                    trusted_certs=None,                        
                    check_unknown_host=True,
                    capabilities=None, 
                    tls_minimum_version=None, 
                    tls_maximum_version=None, 
                    tls_ciphers=None,                    
                    custom_capabilities=None,
                    netconf_version="1.1",
                    keep_alive=0,
                    timeout=30,
                    client_sock =None,
                    socks_proxy={"server":'', "port":1080, "type":"SOCKS5", "user": '', "password":''}
                    ):
    
    if check_unknown_host:
        cb = _unknown_host_cb_m
    else:
        cb = _no_unknown_host_cb_m    
    
        
    if custom_capabilities is not None:
        if isinstance(custom_capabilities, str):
            if custom_capabilities.strip() == "":
                capabilitiesLst = None
            else:
                capabilitiesLst = custom_capabilities.split()
        else:
            capabilitiesLst = custom_capabilities                                
    else:
        if capabilities is not None:
            if isinstance(capabilities, str):
                if capabilities.strip() == "":
                    capabilitiesLst = None
                else:
                    capabilitiesLst = capabilities.split()
                    capabilitiesLst.append("EXTEND_CAPABILITY_FLAG_SET")
            else:
                capabilitiesLst = capabilities        
                capabilitiesLst.append("EXTEND_CAPABILITY_FLAG_SET")
        else:
            capabilitiesLst = None            
    
    if netconf_version == "1.0":
        if capabilitiesLst is None:
            capabilitiesLst=["DO_NOT_SEND_1.0_CAPABILITY"]
        else:
            capabilitiesLst.append("DO_NOT_SEND_1.0_CAPABILITY")    
    elif netconf_version == "1.1":
        if capabilitiesLst is None:
            capabilitiesLst=["DO_NOT_SEND_1.0_CAPABILITY"]
        else:
            capabilitiesLst.append("DO_NOT_SEND_1.0_CAPABILITY")    

    
    ncmgr = manager.connect_tls(capability=capabilitiesLst,
                                host=host,
                                port=str(port), 
                                client_sock=client_sock,
                                client_cert=client_cert, 
                                client_key=client_key, 
                                trusted_certs=trusted_certs, 
                                tls_minimum_version=tls_minimum_version, 
                                tls_maximum_version=tls_maximum_version, 
                                tls_ciphers=tls_ciphers,                                
                                unknown_host_cb=cb,  
                                timeout=int(timeout),
                                socks_proxy=socks_proxy
                                ) 
                    
    #send keep-alive 
    #interval (int) - seconds to wait before sending a keepalive packet (or 0 to disable keepalives).
    # must force keep_alive to be an int- -it may be a string when passed from GUI text entry
    # in that case the remote server will terminate the session immediately
    set_keepalive(ncmgr.session.transport, int(keep_alive))     
        
    
    s =  SegueManager(ncmgr)
    # rememberSessionParameters()
    s._keep_alive = int(keep_alive)
    s.host = host
    s.port = str(port)
    #s.user = user
    #s.password = password
    s.unknown_host_cb = cb
    #s.key_filename = private_keyfile
    s.client_cert=client_cert
    s.client_key=client_key
    s.trusted_certs=trusted_certs
    s.socks_proxy = socks_proxy
    s.selectedModels =""
    # set the RPC timeout the same as session connection timeout          
    s.timeout = int(timeout)   
    s.tlsSession=True
    s.tlsSessionObj = ncmgr.session
    return s

def extract_notification_name_timestamp(notificationXML):
    """parse a notification XML string
       return (eventTime, notificationName, notificationNamespace)
    """
    evtTime=""
    # Use ensure_binary to avoid the error below:
    # Error  Unicode strings with encoding declaration are not supported. 
    # Please use bytes input or XML fragments without declaration.

    replyelem= etree.fromstring(six.ensure_binary(notificationXML))
    
    #eventTime
    evtTimeNode = replyelem.find("./{urn:ietf:params:xml:ns:netconf:notification:1.0}eventTime")
    if evtTimeNode is not None:
        evtTime= evtTimeNode.text
    else:
        evtTime= ""
        
    #notification name should be the second child (after event)
    #and usually belongs to a user defined namespace
    notiNmNode=replyelem[1]
    name=notiNmNode.tag.strip()
    namename=name[name.find("}")+1:]  
    namespace=name[name.find("{")+1:name.find("}")]            
    return (evtTime, namename, namespace)
    
def wait_notification():
    while True:
        time.sleep(0.2)

    
class SegueManager(object):   
    hostKey  =None
    def __init__(self, ncmgr, restconfSession=0):
        # reset class variable to None when create a new instance
        SegueManager.hostKey = None
        self.ncmgr=ncmgr
        # We need a much better dictionary that hold all prefix/namespace/revision info
        # Perhaps in __init__.py we can use lxml expat fast pasing all YIN modules?
        self.namepaceIndex = 0
        self.session_prefix_namespace_dict = {}
        self.session_namespace_prefix_dict = {}
        
        self._keep_alive = None
        #self.host = None
        self.port = None
        self.user = None
        self.password = None
        self.unknown_host_cb = None
        self.key_filename = None
        #self.timeout = None
        self.identityDict = {}
        self.identityAndItsBaseDict = None
        # namespace implemented dict populated through reading yang library module
        self.yangLibraryNamespaceImplementedDict= {}
        if restconfSession:
            self.restconfSession =1
            self.restconfSessionFlag = 1
            self.requests_session = ncmgr
        else:
            self.restconfSession=0    
        
        self.yang_library_dict = None

        # By default this session uses the global loaded models
        # unless overwritten in load_yang_modules_in_paths()
        self.SS_YANG_Dict = parse_module.SS_YANG_Dict
        self.moduleToNamespaceImplementedDict = parse_module.moduleToNamespaceImplementedDict
        self.namespaceToModuleImplementedDict = parse_module.namespaceToModuleImplementedDict

        self.serverSupportedModulesValue =None
        self.serverSupportedCapValue = None        

    def load_yang_modules_in_paths(self, *args, recursive=True): 
        # In CLI each session can have its own set of modules to load
        # this is used to search modules based on module@revision
        self.SS_YANG_Dict= {}

        # this is use for mapping modulename to namespace, used by RESTCONF
        self.moduleToNamespaceImplementedDict = {}
        self.namespaceToModuleImplementedDict = {}
        self.namespaceToModuleImplementedDict.update({None : None}) # <config> node in None namespace
        print("SET YANG_PATH ", *args)
        parse_module.load_yang_modules_in_paths(*args, recursive=recursive,
                Target_YANG_Dict=self.SS_YANG_Dict,
                Target_NS_To_M_Dict = self.namespaceToModuleImplementedDict,
                Target_M_To_NS_Dict = self.moduleToNamespaceImplementedDict        
        )

        return parse_module.get_all_load_modules_in_session(self)

    def build_yang_nodeID_dict(self, treeRoot):
        return parse_module.build_yang_nodeID_dict(treeRoot)
        
               
    def build_module_top_nodeID_List(self, treeRoot):
        return parse_module.build_module_top_nodeID_List(treeRoot)
                                    
    def _isTwoNodePathSame(self, nodeIDValue, nodeIDValuePrev):
        for (a, b) in zip(nodeIDValue, nodeIDValuePrev):
            #print "comparing two: ", a[0], " and ", b[0]
            # check nodeIDPath
            if a[0] != b[0]:
                return False
            
        return True   


                                                                    
    def build_editsubtree_config(self, nodeIDValueList):
        topLevelConfigElementList=[]
        ###compareToNodeIDValueList = nodeIDValueList[:]
        #for i, nodePathItem in enumerate(nodeIDValueList):
        
        for nodePathItem in nodeIDValueList:           
            _build_subtree_toplevel_elem_list_item(topLevelConfigElementList, 
                nodePathItem, 
                prefix_namespace_dict=self.session_prefix_namespace_dict)    
        confignode= etree.Element("config")
        if topLevelConfigElementList is not None:
            for f in topLevelConfigElementList:
                confignode.append(f)
        return confignode

    def build_action_subtree(self, nodeIDValueList):
        topLevelConfigElementList=[]
        ###compareToNodeIDValueList = nodeIDValueList[:]
        for _, nodePathItem in enumerate(nodeIDValueList):   
            DEBUGPRINT("nodePathItem ", nodePathItem)
            DEBUGPRINT("topLevelConfigElementList ", topLevelConfigElementList)        
            _build_subtree_toplevel_elem_list_item(topLevelConfigElementList, 
                    nodePathItem, 
                    prefix_namespace_dict=self.session_prefix_namespace_dict)    
        #actionnode= etree.Element("{urn:ietf:params:xml:ns:yang:1}action")
        actionnode = etree.Element("action", nsmap={None:"urn:ietf:params:xml:ns:yang:1"})   
         
        if topLevelConfigElementList is not None:
            for f in topLevelConfigElementList:
                actionnode.append(f)
                
        rpcNode = etree.Element("rpc", nsmap={None:"urn:ietf:params:xml:ns:netconf:base:1.0"})   
        msgID = str(uuid.uuid1())
        rpcNode.set("message-id", msgID)
        
        rpcNode.append(actionnode)        
        return rpcNode


    def build_rpc_subtree(self, nodeIDValueList):     
        topLevelElementList=[]
        for nodePathItem in nodeIDValueList:
            _build_subtree_toplevel_elem_list_item(topLevelElementList, 
                    nodePathItem, 
                    prefix_namespace_dict=self.session_prefix_namespace_dict)
            
        rpcNode = etree.Element("rpc", nsmap={None:"urn:ietf:params:xml:ns:netconf:base:1.0"})   
        msgID = str(uuid.uuid1())
        rpcNode.set("message-id", msgID)
        
        if topLevelElementList is not None:
            #there is only one top level element in this case, i.e.: <user-rpc-name>
            rpcNode.append(topLevelElementList[0])
        return rpcNode
        
    def build_subtree_filter(self, *args, **kwargs):
        """
        Create a subtree filter expression used with <get>, <get-config> or <creates-subscription>
        args: nodePathItem1, nodePathItem2, ....
        NID can be absolute-schema-nodeid, or a (absolute-schema-nodeid, contentValueToMatch) tuple
        e.g.:  "/netconf-state/datastores/datastore" or
               ("/netconf-state/datastores/datastore", "running")
        
            if qualified name is used, call register_namespace to register prefix and namespace first
            
               kwargs:
               namespaces=
               getdataFilter= True/False, indicates if the filter to create is for get-data NMDA
               
        """
        
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
        getdataFilter =False
        if "getdataFilter" in kwargs:
            getdataFilter =kwargs["getdataFilter"]

        # the nodeIDValueList is in the form 
        # [[(netconf-state, ""), (datastores, ""), ("datastore","")], [(),()...]], or
        # [[(netconf-state, ""), (datastores, ""), ("datastore","running")], [(),()...]]
        nodeIDValueList=_build_nodePathAndValueList(args)                         
        expr= _build_getssubtree_expr(nodeIDValueList, prefix_namespace_dict= self.session_prefix_namespace_dict,
                    getdataFilter=getdataFilter)
        
        return expr
        
    def cancel_commit(self, persistID=None):
        """
        persistID: when canceling a confirmed-commit with a persiste-ID.        
        """
        result = self.ncmgr.cancel_commit(persistID)
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)

    def close_session(self):
        """       close current session        """
        result = self.ncmgr.close_session()
        if hasattr(result, "ok"):
            # dummysession does not have ok attributes
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
            
    def commit(self, persistID=None):
        """ 
        Send a normal <commit> or a follow-up <commit> after a <confirmed-commit>
        persistID: 
            This value is a string token used by a follow-up commit confirming 
            the previous commit (a confirming commit across reboot)
            
            The persistID should have been set in the preceding confirmed 
            <commit> request.                 
        """    
        result = self.ncmgr.commit(persistid=persistID)
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
                
    def copy_config(self, source, target, withDefaults=None):
        """
          Copy config data.
          
          For example, the current running config can be saved by using a file url as the target:
          "Target:  file://localhost/checkpoint.conf, or if host name is omitted,
          "Target:  file:///checkpoint.conf,  #note it has three '/' 
          "Target:  ftp://user:pass@host/config
          source: 'candidate' | 'running' | 'startup'  | 'url' 

          target: 'candidate' | 'running' | 'startup' | 'url'      
            
          withDefaults: Optional, one of 'explicit' | 'report-all' | 'trim' | 'report-all-tagged'.
                       The <copy-config> operation is only affected by the <with-defaults> parameter
                       if the target of the operation is  specified with the <url> parameter

        return: (True/False, ReplyXML, replyElem, requsetXML, requestElem)      
                    
        """        
        if withDefaults in ["not-specified", "unspecified"]:
            withDefaults = None        
            
        result = self.ncmgr.copy_config(source, target, withDefaults=withDefaults)  
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
         
    def create_subscription(self, stream="default", 
                            start_time=None, 
                            stop_time=None,
                            subtree_filter=None, 
                            xpath_filter=None,
                            namespaces={},
                            callback=None
                            ):
        """
        Description:

          This operation initiates an event notification subscription that
          will send asynchronous event notifications to the initiator of the
          command until the subscription terminates.

        Parameters:

          stream:

             An optional parameter, <stream>, that indicates which stream of
             events is of interest.  If not present, events in the default
             NETCONF stream will be sent.

          subtree_filter/xpath_filter:

             An optional parameter, <filter>, that indicates which subset of
             all possible events is of interest.  The format of this
             parameter is the same as that of the filter parameter in the
             NETCONF protocol operations.  If not present, all events not
             precluded by other parameters will be sent.  See section 3.6
             for more information on filters.

          start_time:
                input as "YYYY-MM-DD HH:MM:SS"

             A parameter, <startTime>, used to trigger the replay feature
             and indicate that the replay should start at the time
             specified.  If <startTime> is not present, this is not a replay
             subscription.  It is not valid to specify start times that are
             later than the current time.  If the <startTime> specified is
             earlier than the log can support, the replay will begin with
             the earliest available notification.  This parameter is of type
             dateTime and compliant to [RFC3339].  Implementations must
             support time zones.


          stop_time:
             input as "YYYY-MM-DD HH:MM:SS"

             An optional parameter, <stopTime>, used with the optional
             replay feature to indicate the newest notifications of
             interest.  If <stopTime> is not present, the notifications will
             continue until the subscription is terminated.  Must be used
             with and be later than <startTime>.  Values of <stopTime> in
             the future are valid.  This parameter is of type dateTime and
             compliant to [RFC3339].  Implementations must support time
             zones.
          callback:
            A python function to handle the received notification.
            The function must declare "From IP address" and "notificaiotn XML" 
            as its arguments.
            
            If no callback funtion then the default is to print it in stdout
            
           namespaces ={} : prefix/namespace mapping if xpath filter is used
              
        """        

        for k,v in list(namespaces.items()):
            self.register_namespace(k, v)
                        
        self.register_namespace("noti", "urn:ietf:params:xml:ns:netconf:notification:1.0")                
        if start_time is not None:
            #input as "YYYY-MM-DD HH:MM:SS"
            stm = start_time.split(" ")
            #print "stm", stm
            start_time = stm[0] + "T" + stm[1] + "Z"
            
        if stop_time is not None:
            #input as "YYYY-MM-DD HH:MM:SS"
            stm = stop_time.split(" ")
            stop_time = stm[0] + "T" + stm[1]+"Z"
        
        filterExpr = None
        if subtree_filter is not None and subtree_filter != "":    
            filterExpr = subtree_filter            
        if xpath_filter is not None and xpath_filter != "":    
            filterExpr = ('xpath', xpath_filter)
        if callback is None:
            callback = _cb_trap
            
        result=self.ncmgr.create_subscription(
                    stream=stream, 
                    startTime=start_time, 
                    stopTime=stop_time,
                    filter=filterExpr, 
                    xPathNamespacePrefixMap=self.session_prefix_namespace_dict,
                    callback=callback
                    )                
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
        
    def delete_config(self, target):
        """
          delete the given config datastore.      
          target: 'startup' | 'url'      
          
          For url:
          "Target:  file://localhost/checkpoint.conf, or if host name is omitted,
          "Target:  file:///checkpoint.conf,  #note it has three '/' 
          "Target:  ftp://user:pass@host/config 

          When deleting <startup> config store, serfver will reset
          the devic to its factory defaults 
          
        return: (True/False, ReplyXML)      
                    
        """        
        result=self.ncmgr.delete_config(target)  
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
        
    def discard_changes(self):
        """
        If the client decides that the candidate configuration is not to be
        committed, the <discard-changes> operation can be used to revert the
        candidate configuration to the current running configuration.           
        """        
        result = self.ncmgr.discard_changes()
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
   
    def getNodeIDArgListFromIID(self, *args, **kwargs):
        return self._get_helper("sget_convert", *args, **kwargs)

    # sget_*:  does the same thing as get_* except it accept instannce ID
    #
    # when using sget you don't need to load related YANG modules first. 
  
    def sget(self,  *args, **kwargs):
        return self._get_helper("sget", *args, **kwargs)

    def sget_config(self,  *args, **kwargs):
        # This command does the same thing as get_config except it accept instannce ID
        return self._get_helper("sget_conf", *args, **kwargs)

    # hget_* : high level get commands using instance IDs.
    #         
    # When using hget_* you must load related YANG modules first. The returned
    # XML is turned into a list of IID based on the loaded modules

    # Returns: A tuple of ((IID, valueAndnsmapDict) , unknownIIDList, resultTuple)  
    #
    # All leafs excepting keys are included in the returned IID list.         
    # All content matching node is removed from the reply (a normal reply contains
    # the content match noded in the request
    #
    # If segueIID form is used the result will also use segueIID form
    # A segueIID uses module name as prefix, rather than module prefix.
    # Processing a segueIID does no need a prefix to namespace map argument
    #

    def hget(self, *args, **kwargs):
        kwargs["reqtype"] = "sget2"
        kwargs["remove_content_match_node_in_reply"] = True
        return self._sget_getconf_with_IID(*args, **kwargs )

    def hget_config(self, *args, **kwargs):
        kwargs["reqtype"] = "sget2_conf"
        kwargs["remove_content_match_node_in_reply"] = True
        return self._sget_getconf_with_IID(*args, **kwargs )

    # Keep content match nodes in the result    
    def hget_return_all(self, *args, **kwargs):
        kwargs["reqtype"] = "sget2"
        kwargs["remove_content_match_node_in_reply"] = False
        return self._sget_getconf_with_IID(*args, **kwargs )

    # Keep content match nodes in the result        
    def hget_config_return_all(self, *args, **kwargs):
        kwargs["reqtype"] = "sget2_conf"
        kwargs["remove_content_match_node_in_reply"] = False
        return self._sget_getconf_with_IID(*args, **kwargs )

    def _sget_getconf_with_IID(self, *args, **kwargs):
        #getUnknownIDList = False
        #if "unknownIDList" in kwargs:
        #    getUnknownIDList = True            
        #    del kwargs["unknownIDList"]
        
        # if nothing matches the server simply return empty data
        # so there is no need to return a True/False to indicate if the request went ok  as we 
        # have been doing in get and xget etc.  
        newargs =[]

        # Check if the input is segueiid and needs to be converted to yangiid
        # yangiid: i.e. /prefix:name/...
        # or segueiid : i.e.  /modulename:name/...
        # if segueiid is input then output is also converetd to segueiid format
        converted = False
        for arg in args:
            if isinstance(arg, str):
                newarg = self.segueiid_yangiid(arg, **kwargs)
                if newarg != arg or "namespaces" not in kwargs:
                    converted = True
                newargs.append(newarg)
            else:
                newarg = self.segueiid_yangiid(arg[0], **kwargs)
                if newarg != arg[0] or "namespaces" not in kwargs:
                    converted = True                
                newargs.append((newarg, arg[1]))        
        #DEBUGPRINT("newargs ", newargs)        
        IIDvalDictList, unknownIDList, resultTuple = self._sget_sgetconf_ret_instance_valueDict_List(*newargs, **kwargs)
        
        # if the caller wants to get if there are any unknownIDList        
        #if getUnknownIDList:
        #    kwargs["unknownIDList"] = unknownIDList
        # return a list of (IID, valueAndNSMapDict)
        if len(IIDvalDictList):
            if converted:
                if "namespaces" not in kwargs:
                    # we are requesting using modulename:ID form so we return the same form
                    #return [(self.yangiid_to_segueiid(k, nsmap=v["nsmap"]), v["value"])  for (k, v) in IIDvalDictList], resultTuple                    
                    return [(self.yangiid_to_segueiid(k, nsmap=v["nsmap"]), v)  for (k, v) in IIDvalDictList], unknownIDList, resultTuple

                else:  
                    # older Python doesn't support updatig dict using this syntax
                    #return [(self.yangiid_to_segueiid(k), {**v, "value": v["value"], "nsmap": self._remove_unused_nsmap(k, v["nsmap"]) })  for (k, v) in IIDvalDictList], unknownIDList, resultTuple
                    #return [(self.yangiid_to_segueiid(k), {**v, "nsmap": self._remove_unused_nsmap(k, v["nsmap"]) })  for (k, v) in IIDvalDictList], unknownIDList, resultTuple
                    for k, v in IIDvalDictList:
                            v.update({"nsmap": self._remove_unused_nsmap(k, v["nsmap"])})
                    return [(self.yangiid_to_segueiid(k), v)  for (k, v) in IIDvalDictList], unknownIDList, resultTuple  
            else:   
                # older Python doesn't support updatig dict using this syntax
                #return [(k, {**v, "value": v["value"], "nsmap": self._remove_unused_nsmap(k, v["nsmap"]) })  for (k, v) in IIDvalDictList], unknownIDList, resultTuple
                #return [(k, {**v, "nsmap": self._remove_unused_nsmap(k, v["nsmap"]) })  for (k, v) in IIDvalDictList], unknownIDList, resultTuple              
                for k, v in IIDvalDictList:
                        v.update({"nsmap": self._remove_unused_nsmap(k, v["nsmap"])})
                return IIDvalDictList, unknownIDList, resultTuple

        return  [], unknownIDList, resultTuple
        
    def _stripPredicateAndValue(self, IID, value):
        #"/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='   251   ']/ncm:session-id": '   251   '
        nIID = "/"
        for subid in IID.strip("/").split("/"):
            if subid.endswith("]"):
                # process predicate parts
                # ['ex:server', "ex:ip='192.0.2.1']", "ex:port='80']"]
                subIDWithPredicates = subid.split("[")
                if nIID == "/":
                    nIID = nIID + subIDWithPredicates[0]
                else:
                    nIID = nIID + "/" + subIDWithPredicates[0]    
                subIDWithPredicatesRemains  = subIDWithPredicates[1:]
                
                keyParts = []
                for keyPart in subIDWithPredicatesRemains:
                    # "ex:ip='192.0.2.1']", 
                    # "ex:port='80']"]                                                            
                    key, keyval = keyPart.split("=")                    
                    keyValReal = keyval[1: keyval.find("]") -1].strip()                                                              
                    keyParts.append((key,keyValReal ))
               
                for k, v in keyParts:
                    nIID = nIID + "[" + k + "=" + "'" + v + "']"    
                
            else:
                if nIID == "/":
                    nIID = nIID +  subid
                else:        
                    nIID = nIID + "/" + subid
                    
        return nIID, value.strip()
    
    def _sget_sgetconf_ret_instance_valueDict_List(self, *args, **kwargs):
        """
        return a tuple of list of (IID, vakDict), unknownIDList, resultXML
        An item is something like:
         ("/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='93']/ncm:in-bad-rpcs", 
            {'prensence_container_node': False, 
            'nsmap': {'yang': 'urn:ietf:params:xml:ns:yang:ietf-yang-types', 'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring', 'inet': 'urn:ietf:params:xml:ns:yang:ietf-inet-types'}, 
            'value': '0', 
            'listkey_node': False, 
            'leaflist_node': False, 
            'list_node': False, 
            'elemLXML': <Element {urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring}in-bad-rpcs at 0x36dfd50>, 
            'leaf_node': True})
            
        list key instance is represented as
        /ncm:netconf-state/ncm:schemas/ncm:schema[ncm:identifier='ietf-inet-types'][ncm:version='2010-09-24']/ncm:format='YANG']/ncm:identifier
        
        leaf list instance is represented as
        IID: /ncm:netconf-state/ncm:schemas/ncm:schema[ncm:identifier='ietf-inet-types'][ncm:version='2010-09-24']/ncm:format='YANG']/ncm:location 
        valDict['value'] = [leaflistVal1,leaflistVal2, leaflistVal3...]
        
        When performing set on leaf list instance using the full leaflist IID such as
        set /ncm:netconf-state/ncm:schemas/ncm:schema[ncm:identifier='ietf-inet-types'][ncm:version='2010-09-24']/ncm:format='YANG']/ncm:location[.='NETCONF']
        
        instance-identifier for a list entry without keys, for example:
        /ex:stats/ex:port[3]        
                
        key node instance is included in the resultList unless it is used a content filter in the  request
            
        """
        unknownIDList = []
        remove_content_match_node_from_reply_list  = kwargs["remove_content_match_node_in_reply"]
        del kwargs["remove_content_match_node_in_reply"]
          
        # content match node is NOT included it the return value      
        #print "get args ", args
        if kwargs["reqtype"] == "sget2":                                                 
            del kwargs["reqtype"]
            r = self._get_helper("sget", *args, **kwargs)
        else:
            del kwargs["reqtype"]
            r=  self._get_helper("sget_conf", *args, **kwargs)

        argValue=""              
        rmargs ={}
        noRmKeys = {}
        for arg in args:    
            if not isinstance(arg, str):
                if remove_content_match_node_from_reply_list:                    
                    if arg[1].strip() != "":
                        # also it is a content match but since it'actually empty so it actually a selection node                        
                        # a content match node is given as a (IID, value) tuple in the request
                        rmargs[addTrimSpaceListPredicate(arg[0], "strip")] =  arg[1]
                
                # extract IID part to continue processing IID 
                # save argValue to compare with  the special "INSERT_ATTRIBUTE_TEST_SEGUESOFT"
                argValue = arg[1]       
                arg = arg[0]       
            
            # remove list key nodes. 

            #The list's key nodes are encoded as subelements to the list's
            #identifier element, in the same order as they are defined within the
            #"key" statement.

            # check predicates and convert them to content matching node form
            # from /ex:system/ex:server[ex:ip='192.0.2.1'][ex:port='80']/ex:location
            # to exclude:
            # /ex:system/ex:server[ex:ip='192.0.2.1'][ex:port='80']/ex:ip
            # /ex:system/ex:server[ex:ip='192.0.2.1'][ex:port='80']/ex:port
            # nested lists also apply
            rmkey = []
            for subid, subidnext in pairwise(arg.strip("/").split("/")):
                rmkey.append(subid)         
                if subid.endswith("]"):                        
                    # process predicate parts
                    # ['ex:server', "ex:ip='192.0.2.1']", "ex:port='80']"]
                    #    print "sinid ", subid
                    for keyPart in subid.split("[")[1:]:
                        # "ex:ip='192.0.2.1']", 
                        # "ex:port='80']"]                                                            
                        key, keyval = keyPart.split("=")
                        
                        #DEBUGPRINT("key ", key, " netxt", subidnext)
                        keyid =  "/"+ "/".join(rmkey) +"/" + key
                        keyValReal = keyval[1: keyval.find("]") -1]                                                              
                        
                        if key != subidnext:
                            #DEBUGPRINT("noRmKeys ", noRmKeys)
                            if keyid in noRmKeys:
                                if noRmKeys[keyid] != keyValReal:
                                    rmargs[keyid] = keyValReal
                            else:
                                rmargs[keyid] = keyValReal
                            #DEBUGPRINT("!!! rmargs ", rmargs)          
                        else:
                            # we want to get the key value itself
                            # when we are trying to get key node itself we do not remove key value                                

                            # We also need to remember not to remove it in any
                            # subsequent IIDs. For example, if the request includes two IIDs:  
                            #"/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='137']/ncm:session-id", 
                            #"/ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='137']/ncm:transport")
                            
                            if  argValue  == "INSERT_ATTRIBUTE_TEST_SEGUESOFT":
                                rmargs[keyid] = keyValReal    
                            else:            
                                noRmKeys[keyid] = keyValReal
                            #DEBUGPRINT("--- noRmKeys else ", noRmKeys)
                            #DEBUGPRINT("--- rmargs ", rmargs)   
                            # If this keyid has been added whe processing earlier arg, remove it  
                            if keyid in rmargs:
                                if rmargs[keyid] == keyValReal:
                                    del rmargs[keyid]
                            #DEBUGPRINT("--- rmargs ", rmargs)                     
        nrmargs = {}
        for k, v in list(rmargs.items()):
            nk, nv = self._stripPredicateAndValue(k,v)
            nrmargs[nk] = nv
        #DEBUGPRINT("nrmargs ", nrmargs) 
        nodeIDAndValDictList = build_nodeIDAndValDictList(r[2], self, instanceDataOnly=True, includeKeyNode=True, requestIIDToExclude=nrmargs, unknownNodeIDs=unknownIDList)
        return (nodeIDAndValDictList, unknownIDList, r)


    def _edit_helper_convert_id(self, *args, **kwargs):
        if isinstance(args[0], str):            
            #covert arg1, val1, arg2, val2 to (arg1, val1), (arg2,val2),,, form
            ai=iter(args)
            newargList=[]
            for arg1, arg2 in zip(ai,ai):
                    newargList.append((arg1, arg2))        
        else:
            # the input is already (id1, val1), (id2, val2) ...
            newargList = args        
        
        newargsConverted =[]
        for arg in  newargList:   
            
            newarg = self.segueiid_yangiid(arg[0], **kwargs)
            newargsConverted.append(newarg)
            newargsConverted.append(arg[1])
            
        return newargsConverted
        
        
    # higher level api. When creating list entry. use IID and do not speciffy key node's IID    
    def create(self, *args, **kwargs):
        """
        args:  ID1, value1_or_valueDict1, ID2, value2_or_valueDict2...

        ID is a node ID or YANG instance ID

        It  can be given in the form of either "/module-name:ID/module-
        name:ID" ... or "/prefix:instance-ID/prefix:ID ...". 

        If the module- name or prefix of any node-name is the same as its 
        previous node then it can be skipped. For example:

        * /ietf-system:system/contact
        * /sys:system/contact", "Joe",
        * /if:interfaces/interface/ip:ipv4/enabled
        * /if:interfaces/if:interface/ip:ipv4/ip:enabled

        When using prefix an nsmap dictionary maps the prefix used to its 
        corresponding namespace {"if":"urn:ietf:params:xml:ns:yang:ietf-interfaces"} 
        must also be given

        The valueDict is a dict that may contain one of more of the following keys:          

        'value'     : value to set the targeted node to
        'insert_operation': first | last | before| after,
        'target_key'      : List instance-identifier predicates
        'target_value'    : Leaf-list value,
        'with_default'    : True | False


        The purpose of each dictionary key element above is explained below.


        The purpose of each dictionary key element above is explained below.

        The 'value' is the value that you want to modify for the node identified 
        by the nodeID, For container node, list entry node, etc. it is an empty string.

        For details of each operation means see RFC6241 <edit-config>

        The 'insert_operation' is only applicable for YANG list or leaf-list 
        that is defined as "ordered-by-user". It can be one of the following values: '
        
            'first' | 'last' | 'before'| 'after'

        When using 'insert_operation', you must also pass in 'target_key' for 
        a YANG list, or 'target_value' for leaf-list. They are used for creating 
        yang:key or yang:value attribute (RFC6020 7.8.6)           

        For a 'ordered-by-user' list, you must include "target_key" in the valueDict. 
        The value of 'targe_key' is an YANG instance-identifier predicates. Example:
                        [ex:name='fred']
                        [ex:ip='192.0.2.1'][ex:port='80']
                        
        For the complete syntax of predicates, see RFC6020: 9.13.
        
        For an 'ordered-by-user' leaf-list, you must include "target_value" 
        element in the valueDict.
            
        The 'with_default' element in valueDict indicates whether to set 'default:true' 
        attribute on the targeted node. When "'with_default': True" is included in the 
        valueDict, the value of the "value" key must be the schema default value of the 
        node identified by nodeID.  As defined in RFC6243, section 4.5.2.

        Note for "delete" and "remove" operation, "with_default" does not apply.

        **kwargs:

        target = 'candidate' | 'running' | 'startup'      
                Default: 'candidate'
                        
        default_operation ="merge" | "replace" | "none"
                The default value for the <default-operation> parameter is "merge".

                The <default-operation> parameter is optional.

                    test_operation = "test-then-set" | "set" | "test-only"
        error_option = "rollback-on-error" |  "stop-on-error" | "continue-on-error"

        namespaces =  prefix/namespace mapping dict used  in IDs

        """

        newargsConverted = self._edit_helper_convert_id(*args, **kwargs)
        return self._edit_helper("create", *newargsConverted, **kwargs)

    def merge(self, *args, **kwargs):
        newargsConverted = self._edit_helper_convert_id(*args, **kwargs)
        return self._edit_helper("merge", *newargsConverted, **kwargs)

    def replace(self, *args, **kwargs):
        newargsConverted = self._edit_helper_convert_id(*args, **kwargs)
        return self._edit_helper("replace", *newargsConverted, **kwargs)

    def remove(self, *args, **kwargs):
        newargsConverted = self._edit_helper_convert_id(*args, **kwargs)
        return self._edit_helper("remove", *newargsConverted, **kwargs)

    def delete(self, *args, **kwargs):
        newargsConverted = self._edit_helper_convert_id(*args, **kwargs)
        return self._edit_helper("delete", *newargsConverted, **kwargs)


    def _iid_first_prefix(self, iid):
        return get_iid_first_prefix(iid)
    
    def _remove_unused_nsmap(self, iid, nsmaps):
        # given an IID, returns a list of prefixes used
        pfxLst=[]
        #print("\n new iid ", iid)
        iidLst = iid.split("/")
        #print("\n new iidLst ", iidLst)
        for iid in iidLst:
            if iid.find(":") != -1:
            #>>> a="ex:server[ex:ip='192.0.2.1'][ex:port='80']"
            #>>> a.split(":")
            #['ex', 'server[ex', "ip='192.0.2.1'][ex", "port='80'"]                
                pfxPart = iid.split(":")[0]
                #print(" pfxPart ? ", pfxPart)
                bracketIdx = pfxPart.find("[")
                if bracketIdx != -1:
                    if pfxPart[bracketIdx:] not in pfxLst:
                        pfxLst.append(pfxPart[bracketIdx:])
                        #print("??? pfxLst ", pfxLst)
                else:   
                    if pfxPart not in pfxLst: 
                        pfxLst.append(pfxPart)
                        #print("!!! pfxLst ", pfxLst)
        #print("iid ", iid)                
        #print("pfxLst ", pfxLst)                
        #print("nsmap ", nsmaps)
        # [ expression for item in list if conditional ]
        return { pfx:nsmaps[pfx] for pfx in pfxLst if pfx in nsmaps}
    
    
    def extract_key_from_iid(self, iid):
        kIIDLst = []
        if iid.startswith("/"):   
            iidLst = iid.split("/")[1:]
        else:
            iidLst = iid.split("/")
            
        # /ncm:netconf-state/schemas/schema[identifier='ietf-netconf-monitoring'][version='2010-10-04'][format='yang']/ncm:identifier            
        nIIDLst = []            
        for iidItem in iidLst:
            idxStart = iidItem.find("[")
            if idxStart  == -1:
                nIIDLst.append(iidItem)
            else:
                nIIDLst.append(iidItem[0:idxStart])                   
                while idxStart != -1:             
                    idxEnd = iidItem.find("]", idxStart)
                    if idxEnd == -1:
                        raise Exception("No matching closing ']' found! Wrong IID.")
                    
                    predicate = iidItem[idxStart+1:idxEnd]                    
                    if predicate.find("=") == -1:
                        raise Exception("No '=' found in key predicate! Wrong IID.")
                    keyName, keyVal = predicate.split("=")
                    
                    kIID = "/" + "/".join(nIIDLst) + "/" + keyName
                    kIIDLst.append((kIID, keyVal))
                    
                    idxStart = iidItem.find("[", idxStart + 1)
        return kIIDLst          
                    
                        
    def strip_iid_predicate(self, iid):
        # strip ID's predicate so we can find the corresponding YANG node in the lxml tree
        nIIDLst = []
        if iid.startswith("/"):   
            iidLst = iid.split("/")[1:]
        else:
            iidLst = iid.split("/")
                    
        for iidItem in iidLst:
            if iidItem.find("[") == -1:
                nIIDLst.append(iidItem)
            else:
                nIIDLst.append(iidItem[:iidItem.find("[")])
        return "/" + "/".join(nIIDLst)
                   
    def _restescape(self, val):
        #val = val.strip("'\"")
        # int 
        if not isinstance(val, str):
            return val
        
        if val == "":
            return  val
        
        if val[0] == "'":
            val = val[1:]
        if val[-1] == "'":
            val = val[:-1]
            
        # comma, single-quote, colon, double-quote, space, and forward slash (,'":" /)
        # double-quote is not a reserved value here
        newval = ""
        for c in val:
            if c ==",":
                c="%2C"
            elif c == "'":
                c="%27"
            elif c == ":":
                c="%3A"
            elif c == " ":
                c="%20"
            elif c == "/":
                c="%2F"
                
            newval = newval + c    
                    
        return newval
                        
    def yangiid_to_segueiid(self,iid, nsmap=None, restconfid=False, nsmodulenameMap={}):
        # if nsmap is provided that assumes we want to use module name as prefix
        # convering an YANG iid to segueIID, where the first id contains prefix, the 
        # subsequent IDs uses the prefix in its closest ancestor unless it uses a different prefix
        DEBUGPRINT_SYN("iid to convert: ", iid, " nsmap ", nsmap)
        preFixLst = []
        firstPrefix = self._iid_first_prefix(iid)
        DEBUGPRINT_SYN("FirstPrefix ", firstPrefix)
        if firstPrefix == "":
            return iid
        
        # if nsmap is provided assuming we want to use module name as prefix
        if nsmap is not None and len(nsmap) !=0:
            if  firstPrefix in nsmap:
                moduleNS = nsmap[firstPrefix] 
                if moduleNS in  self.SS_YANG_Dict:
                    firstPrefix = self.SS_YANG_Dict[moduleNS]["module"]
            elif firstPrefix in nsmodulenameMap:
                firstPrefix =       nsmodulenameMap[firstPrefix]
        preFixLst.append(firstPrefix)
        
        segueiidLst = []
        if iid.startswith("/"):   
            iidLst = iid.split("/")[1:]
        else:
            iidLst = iid.split("/")
                    
        for iidItem in iidLst:
            if iidItem.find("[") == -1:
                # this does not contain a predicate
                if iidItem.find(":") == -1:
                    # this does not have a prefix qualified 
                    segueiidLst.append(iidItem)
                else:
                    # we remove it if this prefix is the same as the last known prefix
                    p, n = iidItem.split(":")
                    # if nsmap is provided assuming we want to use module name as prefix
                    if nsmap is not None and len(nsmap) !=0:
                        if  p in nsmap:
                            moduleNS = nsmap[p] 
                            if moduleNS in  self.SS_YANG_Dict:
                                p = self.SS_YANG_Dict[moduleNS]["module"]
                        elif p in nsmodulenameMap:
                            p =       nsmodulenameMap[p]
                                                        
                    if p == preFixLst[-1]:
                        segueiidLst.append(n)                    
                    else:
                        # a new prefix encountered
                        segueiidLst.append("%s:%s"%(p,n))
                        preFixLst.append(p)
            else:
                # this contains a predicate
                predicateParts = []    
                for pfxPart in iidItem.split("["):                     
                    #>>> a="ex:server[ex:ip='192.0.2.1'][ex:port='80'"
                    #>>> a.split("[")
                    #['ex:server', "ex:ip='192.0.2.1']", "ex:port='80'"]        
                    if pfxPart.find("=") != -1:        
                        # "ex:ip='192.0.2.1']"   maxsplit set to 1 in case leaflist's value itself contains '='
                        pfx, predicateVal = pfxPart.split("=", 1)
                    else:
                        #['ex:server',
                        pfx = pfxPart
                        predicateVal = None
                            
                    if pfx.find(":") == -1:                        
                        newPfx =  pfx                        
                    else:
                        p, n = pfx.split(":") 
                        # if nsmap is provided assuming we want to use module name as prefix
                        if nsmap is not None and len(nsmap) !=0:
                            if  p in nsmap:
                                moduleNS = nsmap[p] 
                                if moduleNS in  self.SS_YANG_Dict:
                                    p = self.SS_YANG_Dict[moduleNS]["module"]
                        
                        if p == preFixLst[-1]:
                            newPfx = n                  
                        else:
                            newPfx = "%s:%s"%(p,n)
                            preFixLst.append(p)
                            
                    if predicateVal is not None:    
                        #print "predicateVal: ", predicateVal
                        if restconfid:
                            predicateParts.append("%s"%(self._restescape(predicateVal.rstrip("]"))))                         
                        else:    
                            predicateParts.append("%s=%s"%(newPfx, predicateVal))
                    else:
                        predicateParts.append(newPfx)    
                        
                if restconfid:
                    #print "predicateParts ", predicateParts
                    # check if all key value are empty
                    allempty= True
                    for apredict in predicateParts[1:]:
                        if apredict != '':
                            allempty =False
                            break
                    
                    if allempty:
                        segueiidLst.append(predicateParts[0])
                    else:        
                        segueiidLst.append(predicateParts[0] +"=" + ",".join(predicateParts[1:]))
                else:            
                    segueiidLst.append("[".join(predicateParts))
                
        return "/%s:"%preFixLst[0] +  "/".join(segueiidLst)
        
    def get_namespace_by_module_name(self, modulename):
        # module identifier is used in this case
        if modulename in self.SS_YANG_Dict:
            return self.SS_YANG_Dict[modulename]["namespace"]
        else:    
            raise Exception("module name '%s' used as prefix not found in the module path"%(
                    modulename,))
      
    def segueiid_yangiid(self, iid, **kwargs):
        # segueiid: subsequent IDs uses the prefix in its closest ancestor unless it uses a different prefix
        # convering a segueiid to an YANG IID
        # from /ex:system/server[ip='192.0.2.1'][port='80']
        # to  /ex:system/ex:server[ex:ip='192.0.2.1'][ex:port='80']
        preFixLst = []
        firstPrefix = self._iid_first_prefix(iid)
        #print "FirstPrefix ", firstPrefix
        if firstPrefix == "":
            return iid
        
        # if the prefix is not speified in the nsmap
        # then we must have used module name as prefix
        # if this is the case we update nsmap and make this modulename namespace mapping
        # available to use if needed        
        nsmap= {}
        if "nsmap" in kwargs:
            nsmap = kwargs["nsmap"]
        if "namespaces" in kwargs:
            nsmap = kwargs["namespaces"]                   
        
        if firstPrefix not in nsmap:
            nsmap[firstPrefix] = self.get_namespace_by_module_name(firstPrefix)      
            
        preFixLst.append(firstPrefix)
        
        yangiidLst = []
        if iid.startswith("/"):   
            iidLst = iid.split("/")[1:]
        else:
            iidLst = iid.split("/")
                    
        for iidItem in iidLst:
            if iidItem.find("[") == -1:
                # this does not contain a predicate
                if iidItem.find(":") == -1:
                    # this also does not have a prefix qualified so we add the first prefix
                    yangiidLst.append("%s:%s"%(preFixLst[-1], iidItem))
                else:
                    myPfx = iidItem.split(":")[0]
                    preFixLst.append(myPfx)
                    yangiidLst.append(iidItem)                    
                    if myPfx not in nsmap:
                        nsmap[myPfx] = self.get_namespace_by_module_name(myPfx)                               
                    
            else:
                # this contains a predicate
                predicateParts = []    
                for pfxPart in iidItem.split("["):                     
                    #>>> a="ex:server[ex:ip='192.0.2.1'][ex:port='80'"
                    #>>> a.split("[")
                    #['ex:server', "ex:ip='192.0.2.1']", "ex:port='80'"]        
                    if pfxPart.find("=") != -1:        
                        # "ex:ip='192.0.2.1']"   
                        pfx, predicateVal = pfxPart.split("=",1 )
                    else:
                        #['ex:server',
                        pfx = pfxPart
                        predicateVal = None
                            
                    if pfx.find(":") == -1:                        
                        newPfx = "%s:%s"%(preFixLst[-1], pfx)
                    else:
                        myPfx = pfx.split(":")[0]
                        preFixLst.append(myPfx)                        
                        newPfx = pfx                  
                        if myPfx not in nsmap:
                            nsmap[myPfx] = self.get_namespace_by_module_name(myPfx)                               
                        
                        
                    if predicateVal is not None:    
                        predicateParts.append("%s=%s"%(newPfx, predicateVal))
                    else:
                        predicateParts.append(newPfx)    
                
                yangiidLst.append("[".join(predicateParts))
        
        #print "yangiidLst ", yangiidLst          
        return "/"+ "/".join(yangiidLst)
        
    def _get_helper(self, type, *args, **kwargs ):        
        # "alwaysNewListEntry" is no longer used and may be removed
        #if "alwaysNewListEntry" in kwargs:
        #    alwaysNewListEntry =kwargs["alwaysNewListEntry"]        
        #    del kwargs["alwaysNewListEntry"]    
        #else:
        #    alwaysNewListEntry =False
        #DEBUGPRINT("old args ", args)
        newargs = []
        listEntrySets = set()
        for arg in args:
            if isinstance(arg, str):
                iid = arg
                value = None
            else:
                # a tuple (iid, vontentMatchValue)
                iid, value = arg
                
            # check if this iid contains list key predicates
            listEntryPathOrScalarPath = "/"
            iidPrefix= "/"
            iidLst = iid.split("/")
            isListNode = False
            for iidItem in iidLst:
                start = iidItem.find("[")
                if start !=-1:
                    isListNode = True
                    iidPrefix = iidPrefix + iidItem
                    listEntryPathOrScalarPath = listEntryPathOrScalarPath + "/"+iidItem[:start]
                    listPredicate = iidItem[start:]                                                            
                    
                    #if iidPrefix not in listEntrySets or alwaysNewListEntry:
                    if iidPrefix not in listEntrySets:
                        listEntrySets.add(iidPrefix)
                        
                        # Add list entry
                        newargs.append(listEntryPathOrScalarPath)                                                
                        # Add list entry key leafs
                        for predicate in re.split(r"\[|\]", listPredicate):
                            if predicate =="": 
                                continue
                            
                            # e.g.: ex:ip='192.0.2.1'  ex:port='80'
                            (keyName, keyValue) = predicate.split("=")
                            
                            # remove extra spaces such as the space around '=' in:  [version = '2010-10-04']
                            keyName = keyName.strip()
                            keyValue = keyValue.strip()
                            if keyName == ".": #leaflist predicate should not be included in the request
                                continue
                            
                            keyValue = dequote(keyValue)
                            listKeyPath = listEntryPathOrScalarPath + "/" + keyName
                            newargs.append((listKeyPath, keyValue))                                                      
                else:
                    if listEntryPathOrScalarPath == "/" and iidPrefix == "/":
                        listEntryPathOrScalarPath = listEntryPathOrScalarPath + iidItem
                        iidPrefix =  iidPrefix + iidItem
                    else:    
                        listEntryPathOrScalarPath = listEntryPathOrScalarPath + "/" +  iidItem
                        iidPrefix =  iidPrefix + "/" + iidItem
                        
            if value is None:                                
                # Now add this non key leaf 
                newargs.append(listEntryPathOrScalarPath)
            else:    
                prevContained = False
                if value  == "INSERT_ATTRIBUTE_TEST_SEGUESOFT":
                    for k, karg in enumerate(newargs):
                        if not isinstance(karg, list) and not isinstance(karg, tuple):
                            continue
                        elif karg[0] == listEntryPathOrScalarPath and karg[1] != "INSERT_ATTRIBUTE_TEST_SEGUESOFT":                            
                            newargs[k] = (listEntryPathOrScalarPath, value)
                            prevContained = True
                if not prevContained:
                    newargs.append((listEntryPathOrScalarPath, value))
        
        if type == "sget":          
            return self.get(*newargs, **kwargs)
        elif type == "sget_conf":                        
            return self.get_config(*newargs, **kwargs)
        elif type == "sget_convert":
            return newargs
        
    def _edit_helper(self, operation, *args, **kwargs):
        newargs = []
        listEntrySets = set()
        for iid, value in pairwise_every_two(args):
            # check if this iid contains list key predicates
            listEntryPathOrScalarPath = "/"
            iidPrefix= "/"
            iidLst = iid.split("/")
            isListNode = False
            for iidItem in iidLst:
                start = iidItem.find("[")
                if start !=-1:
                    isListNode = True
                    iidPrefix = iidPrefix + iidItem
                    
                    listEntryPathOrScalarPath = listEntryPathOrScalarPath + "/"+iidItem[:start]
                    listPredicate = iidItem[start:]                                                            
                    
                    if iidPrefix not in listEntrySets:
                        listEntrySets.add(iidPrefix)
                        
                        # Add list entry
                        newargs.append(listEntryPathOrScalarPath)                        
                        if not isinstance(value, str):
                            # value must be a dictionary
                            if "insert_operation" in value:
                                insertOp = value["insert_operation"]
                                if insertOp == "before" or insertOp == "after":
                                    if "target_key" in value:                                    
                                        reference_list_entry = value["target_key"]
                                    elif "target_value" in value:
                                        reference_list_entry = value["target_value"]
                                    else:
                                        raise Exception("Missing targe_key and target_value dictionary key for inserting operation")
                                
                                    target_key_list = []
                                    # only the last ID with predicate is useful here
                                    targetEntryIID = reference_list_entry.split("/")[-1]
                                    start = targetEntryIID.find("[")
                                    if start !=-1:
                                        targetEntryIIDPredicate = targetEntryIID[start:]                                
                                    else:
                                        targetEntryIIDPredicate=""
                                        
                                    for predicate in re.split("\[|\]", targetEntryIIDPredicate):
                                        if predicate =="":
                                            continue
                                        # e.g.: ex:ip='192.0.2.1'  ex:port='80'
                                        (keyName, keyValue) = predicate.split("=")
                                        # remvoe extra spaces around the = sign
                                        keyName = keyName.strip()
                                        keyValue = keyValue.strip()
                                        keyValue = dequote(keyValue)
                                        if keyName == ".":
                                            # leaflist
                                            target_key_type = "target_value"
                                            target_key_list = keyValue
                                        else:    
                                            target_key_type = "target_key"
                                            target_key_list.append((keyName, keyValue))
                                    
                                    newargs.append({"operation":operation, "insert_operation":insertOp, target_key_type:target_key_list})
                                elif insertOp == "first" or insertOp == "last":
                                    newargs.append({"operation":operation, "insert_operation":insertOp})
                            else:
                                newargs.append({"operation":operation})    
                        else:
                            # just a string value to edit
                            newargs.append({"operation":operation})
                            
                        # Add list entry key leafs
                        for predicate in re.split("\[|\]", listPredicate):
                            if predicate =="":
                                continue
                            # e.g.: ex:ip='192.0.2.1'  ex:port='80'
                            (keyName, keyValue) = predicate.split("=")
                            keyValue = dequote(keyValue)
                            listKeyPath = listEntryPathOrScalarPath + "/" + keyName
                            newargs.append(listKeyPath)
                            newargs.append(keyValue)                            
                else:
                    # this subid does not contain key predicate
                    if listEntryPathOrScalarPath == "/" and iidPrefix == "/":
                        listEntryPathOrScalarPath = listEntryPathOrScalarPath + iidItem
                        iidPrefix =  iidPrefix + iidItem
                    else:    
                        listEntryPathOrScalarPath = listEntryPathOrScalarPath + "/" +  iidItem
                        iidPrefix =  iidPrefix + "/" + iidItem
                        
            if isinstance(value, str):      
                if  listEntryPathOrScalarPath not in newargs:                         
                    # Now add this non key leaf 
                    newargs.append(listEntryPathOrScalarPath)
                    if isListNode:
                        newargs.append(value)
                    else:
                        # if the leaf in not in a list, then the operation is not specified in the list
                        # entry ID. So we muse add 'operation' here
                        newargs.append({"operation":operation, "value":value})
            elif isinstance(value, list) or isinstance(value, tuple):
                # leaf-list values
                for val in value:
                    newargs.append(listEntryPathOrScalarPath)
                    newargs.append(val)
            else:    
                # value must be tuple such as dict {insert_operation": "after", "target_key" : "[nacm:name='allow-ncm']"}
                # we have handled this case earlier                
                pass
                  
        return self.edit_config(*newargs, **kwargs)                        
    
    def send_any_action(self, *args, **kwargs):
        # see edit_config for reference of arguemts
        msgid = None
        if "msgid" in kwargs:     
            msgid=kwargs["msgid"]
                    
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
        newargList = []   
        if len(args):        
            if isinstance(args[0], str):
                
                #covert arg1, val1, arg2, val2 to (arg1, val1), (arg2,val2),,, form
                ai=iter(args)
                for arg1, arg2 in zip(ai,ai):
                        newargList.append((arg1, arg2))        
            else:
                # the input is already (id1, val1), (id2, val2) ...
                newargList = args
        DEBUGPRINT("Send action newargList ", newargList)               
        nodeIDValueList = []                
        if len(newargList) !=0:
            nodeIDValueList=_build_nodePathAndValueList(newargList)   
            
        DEBUGPRINT("nodeIDValueList ", nodeIDValueList)                  
        actionnode= self.build_action_subtree(nodeIDValueList)
  
        xmlstring = etree.tostring(actionnode,pretty_print=True)

        logger.debug("send action xml " + xmlstring.decode("utf8"))
        result = self.ncmgr.send_xml(xmlstring, msgid=msgid)

        #print "resss ", result._root, " err", result.error
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
                
    # send non-standard RPCs
    # we do not use keyword argument to build because some input parameters contain hyphen and that make
    # it an illegal parameter
    def send_any_rpc(self, rpc_name, *args, **kwargs):            
        """
        rpc_name: the name of the rpc. For example:, 'prefix:get-schema'
        args: "input_parameter_name", "input_parameter_value", ...    
               All input parameters that need to be assigned a value.
                           
               input_parameter_name is a relative node path, starting from the rpc "input" node:           
               
            example:
                    "ncm:identifier", identifier                    
                    
                    #foo is a container
                    "pfx:foo/pfx:bar", "barvalue"   
                    
                    #foo is a list
                    "pfx:foo/pfx:key", "key_value"
                    "pfx:foo/pfx:leaf1", "leaf1_value"
                    "pfx:foo/pfx:leaf2", "leaf2_value"
                    
       kwargs:
        namespaces = {} : prefix/namspace mapping                         
        """ 
        
        msgid = None
        if "msgid" in kwargs:     
            msgid=kwargs["msgid"]
        
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)

        newargsList=[]                 
        if not isinstance(rpc_name, str):
            # nodeIDAndValuesAddedDictList  passed from GUI RPC builder
            #
            # [('/heat:createSfc/heat:input/heat:sfcName', {'raw_XML_data': False, 'value': '11'}), 
            # ('/heat:createSfc/heat:input/heat:instance', {'raw_XML_data': False, 'value': ''}),  ...
            # get rpc_name from first absPathID
            absRpcName = "/" + rpc_name[0].split("/")[1]
            newargsList.append((absRpcName, ""))                
            for arg1 in args:                   
                # e.g. remove /heat:input in the path
                #print "arg1", arg1
                arg1Lst = arg1[0].split("/")
                if len(arg1Lst)>2:
                    # Make sure it is not the rpc node IDPath (no input subid)
                    del arg1Lst[2]                
                absArg1 = "/".join(arg1Lst)
                newargsList.append((absArg1, arg1[1]["value"]))
            
        else:    
            # normal argument passed in as required by the method            
            absRpcName="/%s"%rpc_name        
            newargsList.append((absRpcName, ""))        
            ai=iter(args)            
            for arg1, arg2 in zip(ai,ai):                   
                # prepend rpc name as the first node in the path
                absArg1 = absRpcName+"/%s"%arg1
                newargsList.append((absArg1, arg2))
        #print " newargsList ", newargsList
        nodeIDValueList=_build_nodePathAndValueList(newargsList) 
        
        # here the returned config contains the top <filter> 
        rpcnode = self.build_rpc_subtree(nodeIDValueList)        
        xmlstring = etree.tostring(rpcnode,pretty_print=True)
        result = self.ncmgr.send_xml(xmlstring, msgid=msgid)

        #print "resss ", result._root, " err", result.error
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
        
    def edit_data(self, *args, **kwargs):
        """
        base edit-data operation        
        args: AbsoluteNodeID1, Val1, AbsoluteNodeID2, Val2, ... or
              (AbsoluteNodeID1, Val1), (AbsoluteNodeID2, Val2), ...
                
              The AbsoluteNodeIDs is YANG absolute schema node identifier as defined in RFC6020.

              The AbsoluteNodeIDs should  be passed in the order they will appear in the RPC message. 

              The AbsoluteNodeIDs should be qualified with prefix. If no prefix is used then RPC generated
              will not contain namespace attributes, and it is expected that the Netconf server will search
              all it's namespaces for a match. For fast processing, qualified names in AbsoliteNodeID are
              recommended.
              
              The val is the value that you want to set the node to. 
                                         
        kwargs:
              url=urlValue
                   The config is given in the url. If this option is specifed,
                   the arguments AbsoluteNodeID1,AbsoluteNodeID2 as well as the 'config=' option will be ignored.
                   
              config=configData
                    If you already have manually constructed config xml data, use this option.        
                    When this option is used, the arguments AbsoluteNodeID1, AbsoluteNodeID2 etc. will be ignored.
                    It must be a well formatted xml config data such as:
                    For example:
                    <config>
                        <interfaces xmlns="http://netconfcentral.org/ns/yuma-interfaces">
                            <interface>
                                <name>eth0</name>
                                </interface>
                            </interfaces>
                    </config>
              target = 'candidate' | 'running' | 'startup'      
                        Default: 'candidate'
                        
              default_operation="merge" | "replace" | "none"
                The default value for the <default-operation> parameter is "merge". 
                The <default-operation> parameter is optional. It has one of the following values:
                   merge:  The configuration data is merged with the configuration at the corresponding level in the target datastore.  This is the default behavior.
                   replace:  The configuration data completely replaces the configuration in the target datastore.  This is useful for loading previously saved configuration data.
                   none:  The target datastore is unaffected by the configuration data, unless and until the incoming configuration data uses the "operation" attribute to
                           request a different operation.  If the configuration data contains data for which there is not a corresponding level in the target datastore, an <rpc-error>
                           is returned. Using "none" allows operations like "delete" to avoid unintentionally creating the parent hierarchy of the element to be deleted.
                
              namespaces /nsmap = {}: prefix/namepsace mapping dict
              
              return: (True/False, result.xml, result._root, result.request_xml, result.request_ele)                          
        """
        # [('interfaces', ''), ('interface', ''), ('name', u'ggg']
        # [('interfaces', ''), ('interface', ''), ('name', (u'ggg', 'replace with-default'))]               
        for key in list(kwargs.keys()):
            if key not in ["config", "default_operation", "namespaces", "nsmap", "target",  "url", "msgid", "forceUrl"]:    
                raise ParameterError("Unknown keyword argument: %s" % key)
                
        target='candidate'
        if "target" in kwargs:
            target=kwargs["target"]
            
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)

        if "nsmap" in kwargs:
            nsmap=kwargs["nsmap"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
        
        msgid = None
        if "msgid" in kwargs:     
            msgid=kwargs["msgid"]

        #forceUrl = False
        #if "forceUrl" in kwargs:     
        #    forceUrl=kwargs["forceUrl"]
                        
        default_operation=None    
        if "default_operation" in kwargs:     
            default_operation=kwargs["default_operation"]
            
        if "url" in kwargs:
            url= kwargs["url"]
            reqnode= etree.Element("url")
            reqnode.text = url
            #config  = etree.tostring(reqnode,pretty_print=True)         
            config=reqnode
            
        elif "config" in kwargs:
            #here the specified config does not contain the top <filter> 
            config=kwargs["config"]
        else:    
            if isinstance(args[0], str):
                #covert arg1, val1, arg2, val2 to (arg1, val1), (arg2,val2),,, form
                ai=iter(args)
                newargList=[]
                for arg1, arg2 in zip(ai,ai):
                        newargList.append((arg1, arg2))        
            else:
                # the input is already (id1, val1), (id2, val2) ...
                newargList = args
                            
            if len(newargList) !=0:
                nodeIDValueList=_build_nodePathAndValueList(newargList)      
                config= self.build_editsubtree_config(nodeIDValueList)                
            else:
                config =""       
                
        #result=self.ncmgr.edit_data(target, config, default_operation, msgid=msgid, forceUrl=forceUrl)
        result=self.ncmgr.edit_data(target, config, default_operation, msgid=msgid)
        #result.ok: Boolean value indicating if there were no errors.
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)     


    def edit_config(self, *args, **kwargs):    
        """
        base edit-config operation        
        args: AbsoluteNodeID1, Val1_or_ValDict1, AbsoluteNodeID2, Val2_or_ValDict2, ... or
              (AbsoluteNodeID1, Val1_or_ValDict1), (AbsoluteNodeID2, Val2_or_ValDict2), ...
                
              The AbsoluteNodeIDs is YANG absolute schema node identifier as defined in RFC6020.

              The AbsoluteNodeIDs should  be passed in the order they will appear in the RPC message. 

              The AbsoluteNodeIDs should be qualified with prefix. If no prefix is used then RPC generated
              will not contain namespace attributes, and it is expected that the Netconf server will search
              all it's namespaces for a match. For fast processing, qualified names in AbsoliteNodeID are
              recommended.
              
              The val_or_valDict can either be a simple value or a dict (ValDict). 
              
              The value is what you want to edit (merge/create/replace/delete/remove) on the target node.
              For container node, list entry node, etc. it is an empty string.
              
              If you want to assigned XML attributes to a node, pass in a valDict.
              The ValDict is a dict that may contain one of more of the following elements:          
              
                'value':value, 
                'operation': operation 
                insert_operation', 
                'target_key':(), 
                'target_value':tvalue, 
                'with_default':True/False 
                'new_list_entry': anyValue
              
              The 'new_list_entry' is used to indicate a new list entry when editing multiple list entries. It is used in the list node
              (this case is really not necessary) or the first key node's valueDict (this must be done).                
                
              The 'value' is the value that you want to set the node to. 
              
              The 'operation' can be one of standard Netconf edit-config operations: 'merge' | 'replace' | 'create' | 'delete' | 'remove' 
              
              For all nodes that are not explicitly assigned an 'operation' attribute, they will default to 
              use the "default-operation" element in the RPC. If there is no "defeault-operation" element in the RPC,
              the effective default operation will be "merge".

              The 'insert_operation' is only applicable for YANG list or leaf-list that is defined as "ordered-by-user".
              It can be one of the following values: 'first' | 'last' | 'before'| 'after'

              when using 'insert_operation', you must also pass in 'target_key' for list, or
              'target_value' for leaf-list. They are used for yang:key or yang:value attribute (RFC6020 7.8.6)           
              
              For a 'ordered-by-user' list, you must include "target_key" in the valDict. The value of 'targe_key' is
              a list of (keyname, value) tuple:
              [ (KeyName, 'fred'), ]
              [ (ip, '192.0.2.1'), (port,'80')] or a already built YANG instance-identifier predicates. Example:
                 [ex:name='fred']
                 [ex:ip='192.0.2.1'][ex:port='80']
                 
                 For the complete syntax of predicates, see RFC6020: 9.13. The instance-identifier Built-In Type.     
                 
                 
              For a 'ordered-by-user' leaf-list, you must also include "target_value" element in the valDict.
                    
              The 'with_default' element in valDict indicates whether to use with-default flag (RFC6243)

              When "with_default": True is included in the valDict, the :value" must be the schema default value
              of the node identified by AbsoluteNodeID.  As defined in RFC6243, section 4.5.2.:
              
              If the 'default' attribute is present and  set to 'true' or '1', then the 
              server MUST treat the new data node as a request to return that node to 
              its default value (i.e., remove it from the configuration datastore).  
              The data node within the NETCONF  message MUST contain a value in this case, which 
              MUST be equal to the schema default value.  If not, the server MUST return an <rpc-error>
              response with an 'invalid-value' error-tag.
         
              Note for "delete" and "remove" operation, "with_default" does not apply.
              
        kwargs:
              url=urlValue
                   The config is given in the url. If this option is specifed,
                   the arguments AbsoluteNodeID1,AbsoluteNodeID2 as well as the 'config=' option will be ignored.
                   
              config=configData
                    If you already have manually constructed config xml data, use this option.        
                    When this option is used, the arguments AbsoluteNodeID1, AbsoluteNodeID2 etc. will be ignored.
                    It must be a well formatted xml config data such as:
                    For example:
                    <config>
                        <interfaces xmlns="http://netconfcentral.org/ns/yuma-interfaces">
                            <interface>
                                <name>eth0</name>
                                </interface>
                            </interfaces>
                    </config>
              target = 'candidate' | 'running' | 'startup'      
                        Default: 'candidate'
                        
              default_operation="merge" | "replace" | "none"
                The default value for the <default-operation> parameter is "merge". 
                The <default-operation> parameter is optional. It has one of the following values:
                   merge:  The configuration data is merged with the configuration at the corresponding level in the target datastore.  This is the default behavior.
                   replace:  The configuration data completely replaces the configuration in the target datastore.  This is useful for loading previously saved configuration data.
                   none:  The target datastore is unaffected by the configuration data, unless and until the incoming configuration data uses the "operation" attribute to
                           request a different operation.  If the configuration data contains data for which there is not a corresponding level in the target datastore, an <rpc-error>
                           is returned. Using "none" allows operations like "delete" to avoid unintentionally creating the parent hierarchy of the element to be deleted.
                
              test_operation="test-then-set" | "set" | "test-only"
              error_option="rollback-on-error" |  "stop-on-error" | "continue-on-error"
              namespaces /nsmap = {}: prefix/namepsace mapping dict
              
              return: (True/False, result.xml, result._root, result.request_xml, result.request_ele)                          
        """
        # [('interfaces', ''), ('interface', ''), ('name', u'ggg']
        # [('interfaces', ''), ('interface', ''), ('name', (u'ggg', 'replace with-default'))]               
        for key in list(kwargs.keys()):
            if key not in ["config", "default_operation", "error_option", "namespaces", "nsmap", "target", "test_option", "url", "msgid", "forceUrl"]:    
                raise ParameterError("Unknown keyword argument: %s" % key)
                
        target='candidate'
        if "target" in kwargs:
            target=kwargs["target"]
            
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)

        if "nsmap" in kwargs:
            nsmap=kwargs["nsmap"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
        
        msgid = None
        if "msgid" in kwargs:     
            msgid=kwargs["msgid"]

        # forceUrl forces the edit-config target to be an URL, instead of normal datastore.
        forceUrl = False
        if "forceUrl" in kwargs:     
            forceUrl=kwargs["forceUrl"]
                        
        default_operation=None    
        if "default_operation" in kwargs:     
            default_operation=kwargs["default_operation"]
            
        test_option=None
        if "test_option" in kwargs:
            test_option=kwargs["test_option"]
        
        error_option=None
        if "error_option" in kwargs:
            error_option=kwargs["error_option"]
        
        if "url" in kwargs:
            url= kwargs["url"]
            reqnode= etree.Element("url")
            reqnode.text = url
            #config  = etree.tostring(reqnode,pretty_print=True)         
            config=reqnode
            
        elif "config" in kwargs:
            #here the specified config does not contain the top <filter> 
            config=kwargs["config"]
        else:    
            if isinstance(args[0], str):
                #covert arg1, val1, arg2, val2 to (arg1, val1), (arg2,val2),,, form
                ai=iter(args)
                newargList=[]
                for arg1, arg2 in zip(ai,ai):
                        newargList.append((arg1, arg2))        
            else:
                # the input is already (id1, val1), (id2, val2) ...
                newargList = args
                            
            if len(newargList) !=0:
                nodeIDValueList=_build_nodePathAndValueList(newargList)      
                config= self.build_editsubtree_config(nodeIDValueList)                
            else:
                config =""       
                
        result=self.ncmgr.edit_config(target, config, default_operation, test_option, error_option, msgid=msgid, forceUrl=forceUrl)
        #result.ok: Boolean value indicating if there were no errors.
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)     
    
               

    def extract_rpc_error_from_rpc_reply (self, replyXML_or_elem, sequence=0):
        """
        Extract error code from rpc_reply that contains rpc_error
        errorName : error_type,  error_tag,  error_severity,  error_app_tag
            error_path, error_message,           
            error_info name such as bad_attribute,  bad_element,  bad_namespace
            session_id,  ok_element,  err_element, noop_element
            and user defined names.
            
        
        sequence: specify the number of rpc_error to retrieve if
                there are multiple rpc_errors
        
        return: a ditionary containing instiated error names
        
        """
        if isinstance(replyXML_or_elem, str):            
            rep = etree.fromstring(replyXML_or_elem.encode("utf-8")) 
        elif isinstance(replyXML_or_elem, (bytes, bytearray)):
            rep = etree.fromstring(replyXML_or_elem) 
        else:
            rep = replyXML_or_elem    
        
        errornode=rep[sequence]
        errorDict = {}
        nc="urn:ietf:params:xml:ns:netconf:base:1.0"
        for c in errornode:
            if c.tag == "{%s}error-type"%nc:
                error_type=c.text            
                errorDict["error_type"] = error_type
                 
            if c.tag == "{%s}error-tag"%nc:
                error_tag=c.text            
                errorDict["error_tag"] = error_tag
            
            if c.tag == "{%s}error-severity"%nc:
                error_severity=c.text
                errorDict["error_severity"] = error_severity
                            
            if c.tag == "{%s}error-app-tag"%nc:
                error_app_tag=c.text
                errorDict["error-app-tag"] = error_app_tag
                
            if c.tag == "{%s}error-path"%nc:
                error_path=c.text
                errorDict["error_path"] = error_path
                        
            if c.tag == "{%s}error-message"%nc:
                error_message=c.text
                errorDict["error_message"] = error_message
            
            if c.tag == "{%s}error-info"%nc:
                for einfo in c:
                    if einfo.tag =="{%s}bad-attribute"%nc:
                        bad_attribute=einfo.text
                        errorDict["bad_attribute"] = bad_attribute
                        
                    if einfo.tag =="{%s}bad-element"%nc:
                        bad_element=einfo.text
                        errorDict["bad_element"] = bad_element
                        
                    if einfo.tag =="{%s}bad-namespace"%nc:
                        bad_namespace=einfo.text
                        errorDict["bad_namespace"] = bad_namespace
                        
                    if einfo.tag =="{%s}session-id"%nc:
                        session_id=einfo.text
                        errorDict["session_id"] = session_id
                                            
                    if einfo.tag =="{%s}ok-element"%nc:
                        ok_element=einfo.text
                        if "ok-element" in errorDict:     
                            errorDict["ok_element"] = errorDict["ok_element"] + " " + ok_element    
                        else:
                            errorDict["err_element"] = ok_element
                    
                        
                    if einfo.tag =="{%s}err-element"%nc:
                        err_element=einfo.text
                        if "err-element" in errorDict:     
                            errorDict["err_element"] = errorDict["err_element"] + " " + err_element    
                        else:
                            errorDict["err_element"] = err_element

                        
                    if einfo.tag =="{%s}noop-element"%nc:
                        noop_element=einfo.text
                        if "noop_element" in errorDict:     
                            errorDict["noop_element"] = errorDict["noop_element"] + " " + noop_element    
                        else:
                            errorDict["noop_element"] = noop_element
                    else:
                        # use {customer-namespace}cutom_error_info_name
                        errorDict[einfo.tag] = einfo.text
                            
        return errorDict
    
    def extract_value_from_rpc_reply(self, replyXML_or_elem, 
                    relative_node_path_with_prefix, namespaces={}):
        """
        replyXML_or_elem:  this can be a rpc reply XML string, or
                                    a rpx reply lxml element

        relative_node_path_with_prefix:  This is the relative node path  under top level element. 
           For example:
           
           If the reply contains  a RPC output, this parameter contains the node path starting from
           any 'output' element since YANG 'output'  element is not encoded in xml message:
           
               pl:lock-id,
               px:foo/px:bar
               
           if the reply contains a rpc-error, this parameter contains the node path starting from
           'rpc-error', 
           
            nc:rpc-error/nc:error-info/ncx:error-number
           
           if the reply contains a data element, this parameter contains the node path starting from
           'data', 
           
            nc:rpc-error/nc:error-info/ncx:error-number
           
           Qualified names must be used to specify xml node path. 
           Use register_namespace to register prefix and namespace pair.
           
           namespaces={}: prefix/namespace mapping 
           
        """
        

        for k,v in list(namespaces.items()):
            self.register_namespace(k, v)
                        
        val=""
        if isinstance(replyXML_or_elem, str):            
            root = etree.fromstring(replyXML_or_elem.encode("utf-8")) 
        elif isinstance(replyXML_or_elem, (bytes, bytearray)):
            root = etree.fromstring(replyXML_or_elem) 
        else:
            root = replyXML_or_elem    

        relative_node_path_with_prefix = relative_node_path_with_prefix.strip()
        
        #if node_path_with_prefix.startswith("/") ==False:
        #    raise ParameterError("A absolute node ID is required. Each node name must be qualified with appropriate prefix!")
            
        pathList = relative_node_path_with_prefix.split("/")

        newPath="."
        #first convert name to qualified name for the given prefix 
        for elname in pathList:  
            if elname == "":
                continue 
            idx = elname.find(":")
            if idx != -1:
                elnamePfx=elname[0:idx]
                elnameName=elname[idx+1:]
                if elnameName == "output":
                    continue

                if elnamePfx in self.session_prefix_namespace_dict:
                    elnameNs= self.session_prefix_namespace_dict[elnamePfx]
                    #create node with augmenting namespace
                    elname = "/{%s}%s"%(elnameNs,elnameName)   
                else:
                    raise ParameterError("Prefix not found. use register_namespace(prefix, namespace) to register it first!")
            else:
                raise ParameterError("must use qualified name. Use prefix:identifier!")
            newPath=newPath +elname  

        #then use etree xpath to find
        #print "newpath", newPath
        
        node = root.findall(newPath)
        
        for en in node:
            #print "en   .. ", en.text
            if val == "":
                val=en.text
            else:    
                val=val + " "+ en.text
        try:
            return val.decode('utf-8')
        except:
            return val


    def compute_restconf_post_data_dsi(self, reqtype, dsid, *args, **kwargs):
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            # remove nodes that have been included in the target resource ID
            DEBUGPRINT("nsmap here ", nsmap)
            if None in nsmap:
                # to satisfy xpath function
                nsmap.pop(None)
            
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
        # compute data (xml or json string)

        if len(args) and isinstance(args[0], str):            
            #covert arg1, val1, arg2, val2 to (arg1, val1), (arg2,val2),,, form
            ai=iter(args)
            newargList=[]
            for arg1, arg2 in zip(ai,ai):
                    newargList.append((arg1, arg2))        
        else:
            # the input is already (id1, val1), (id2, val2) ...
            newargList = args

        restRPCActInput = False                
        if len(newargList) !=0:
            DEBUGPRINT("post compute data newargList ", newargList)
            DEBUGPRINT("selected dsid:  ", dsid)
                                 
            if reqtype.upper() in ["PATCH", "PUT"]:
                dsidLst = dsid.rstrip("/").split("/")[:-1]
            elif reqtype.upper() in ["POST_OPERATIONS", "POST_ACTIONS"] :
                dsidLstParts = dsid.rstrip("/").split("/")
                dsidLst =[]
                for di in dsidLstParts:
                    if di == "input":
                        restRPCActInput = True
                        break
                    else:
                        dsidLst.append(di)
                dsid =  "/".join(dsidLst)
    
            else:
                dsidLst = dsid.rstrip("/").split("/")    
            DEBUGPRINT("new dsidLst ", dsidLst)
            DEBUGPRINT("new dsid: ", dsid)

            nodeIDValueList=_build_nodePathAndValueList(newargList)      
            DEBUGPRINT("!debug nodeIDValueList ", nodeIDValueList)     
            config= self.build_editsubtree_config(nodeIDValueList)
            DEBUGPRINT("config xml :" , etree.tostring(config, 
                                pretty_print=True).decode("utf-8"))
                                
            # Convert xml data to json string 
            jt=self.rcy.data(config, nsmap=self.namespaceToModuleImplementedDict)
                        
            DEBUGPRINT("reqtype ", reqtype, " start jt: ", jt)   

            # remove dict items that are already specified in dsid
            idModulename = ""
            lastKeysvals = ""
            jt = jt["config"]

            for id in  dsidLst:
                if id == "":
                    continue
                if id.find(":") !=-1 and idModulename=="":
                    idModulename, _ = id.split(":")
                    
                if id.find("=") != -1:
                    id, lastKeysvals = id.split("=")
                    jt = jt[id]
                    #  if jt is a list here and there must only one entry
                    # unlike neconf, because restconf uses a target for edting
                    # if a list entry appears in a target then there is only one single
                    # entry data can be used                        
                    jt= jt[0]
                    # remove key nodes for post , but not for put and patch
                    for oid, val in list(jt.items()):
                        DEBUGPRINT("val", val, " isList", isinstance(val, list))
                        if isinstance(val, (OrderedDict, dict, list)):
                            continue
                        DEBUGPRINT("reqtype ", reqtype, " lastKeysvals", lastKeysvals)
                                                
                        if reqtype.upper() in ["POST_DATA", "PUT", "PATCH"]:
                            if self._restescape(val) in lastKeysvals.split(","):
                                DEBUGPRINT("Remove ", oid)
                                # this is a key node item 
                                jt.pop(oid)
                else:    
                    jt = jt[id]
                    #keysval = ""
                        
            DEBUGPRINT("now jt: ", jt)      

            if restRPCActInput:
                # Add input node in arglist for rest RPC
                newjt = OrderedDict()
                newjt[idModulename+":input"] =jt
                jt = newjt  
            # add module qualifier if needed for the json dict remained
            #for oid in list(jt.keys()):            
            #    DEBUGPRINT(" oid ", oid)
            #    if oid.find(":") == -1:                        
            #        if idModulename != "":
            #            nid = idModulename + ":"+ oid 
            #            jt[nid] = jt[oid] 
            #            jt.pop(oid)
                        
            DEBUGPRINT("jt ", jt)                        
            if self.restconfJSONSessionFlag:          
                if dsid == "" and  reqtype.upper() in ["PATCH", "PUT"]:
                    newjt = {"ietf-restconf:data": jt}
                    jtstr=json.dumps(newjt, indent=4)
                else:           
                    jtstr=json.dumps(jt, indent=4)                    
                
                DEBUGPRINT("converted jstr ", jtstr)
                if jtstr == '{}':
                    jtstr = ""
                return (dsid, jtstr)
            else:                
                #return etree.tostring(config, pretty_print=True)
                #print "test to again convert back to xml", 
                #print "nsmap ", nsmap                
                #rtt = json.loads(jtstr)
                # loads from jtstr won't keep the order in a json object
                ####
                
                if dsid == "" and  reqtype.upper() in ["PATCH", "PUT"]:
                    newjt = {"ietf-restconf:data": jt}
                    jt = newjt
                
                rtxmlElem = self.rcy.etree(jt, 
                            root=etree.Element('{urn:ietf:params:xml:ns:netconf:base:1.0}data',
                                    nsmap= {None : "urn:ietf:params:xml:ns:netconf:base:1.0"}), 
                            nsmap=self.moduleToNamespaceImplementedDict)
                rtxml = etree.tostring(rtxmlElem, pretty_print=True)
                DEBUGPRINT("before return xml ", rtxml.decode("utf-8"))

                rtxml = rtxml.decode("utf-8")
                
                if '<data xmlns="urn:ietf:params:xml:ns:netconf:base:1.0"/>' in rtxml:
                    # empty data
                    rtxml = rtxml.replace('<data xmlns="urn:ietf:params:xml:ns:netconf:base:1.0"/>', "").strip()
                else:
                    # non empty data
                    rtxml = rtxml.replace('<data xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">', "").strip()
                    # removing the end '</data>'
                    rtxml = rtxml[:-7].strip()                           
                DEBUGPRINT("return xml ", rtxml)                                                      
                ####
                return (dsid, rtxml)       
        else:
            return (dsid, "")    
    
    def compute_restconf_post_dsid_and_data(self, rtype, *args, **kwargs):
        DEBUGPRINT("in ssmanager compute_restconf_post_dsid_and_data ", " args ", args, " kwargs !!! ", kwargs) 
        nsmap = {}
        #insert_dict = {}
        #data = ""
        # Used by generating Restconf RPC
        if "keepInputNode" in kwargs:
            keepInputNodeNode = True
            del  kwargs["keepInputNode"]
        else:
            keepInputNodeNode = False

        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            del kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
                
                
        computedTargetID = ""    
        if "computedTargetID" in kwargs:
            computedTargetID = kwargs["computedTargetID"]
            del kwargs["computedTargetID"]


        fakedTargetSelection =False    
        if "fakedTargetSelection" in kwargs:
            fakedTargetSelection = kwargs["fakedTargetSelection"]
            del kwargs["fakedTargetSelection"]
            
            
        insertPointPathID = ""
        for nodePathItem in args:       
            valueDict = nodePathItem[1]
            if isinstance(valueDict,  dict):
                if "insert_operation" in valueDict:
                    kwargs["insert"] = valueDict["insert_operation"]
                    valueDict.pop("insert_operation")
                if  "target_value" in valueDict:
                    kwargs["point"] = valueDict["target_value"]
                    insertPointPathID =  nodePathItem[0]
                    valueDict.pop("target_value")
                if "target_key" in valueDict:
                    kwargs["point"] = valueDict["target_key"]
                    insertPointPathID =  nodePathItem[0]
                    valueDict.pop("target_key")


        # if restconf get got a resource id properly formed we do not
        # need to convert it 
        # we only need to convert when arguments passed down are 
        # like netconfc (GUI or CLI) form prefx:name 
        # (('/yanglib:modules-state/yanglib:module/yanglib:name', '1'),
        # ('/yanglib:modules-state/yanglib:module/yanglib:revision', '2'), 
        #'/yanglib:modules-state/yanglib:module/yanglib:schema')  
        
        topLevelConfigElementList=[]
        nodeIDValueList=_build_nodePathAndValueList(args)
        DEBUGPRINT("nodeIDValueList before computing dsi ", nodeIDValueList)
        
        # remove 'insert_operation'  'target_key':(),  'target_value':tvalue, 
        # in restconf they are encode in target uri
        #
        for nodePathItem in nodeIDValueList:
            _build_subtree_toplevel_elem_list_item(topLevelConfigElementList, 
                        nodePathItem, 
                        prefix_namespace_dict=self.session_prefix_namespace_dict,
                        keepInputNode= keepInputNodeNode)    
        
        # in restconf we normally only allow one single top level target in a get
        # but when we use fields expr we can retrieve nodes in different modules

        # here we fake this to be a get-reply <data> so we can use existing procedure to 
        # get yang-iid
        root = etree.Element("{urn:ietf:params:xml:ns:netconf:base:1.0}data")
        
        for topLevelConfigElement in topLevelConfigElementList:            
            root.append(topLevelConfigElement)
        
        if computedTargetID == "":
            computedTargetID = args[-1]

        if computedTargetID is None:
            computedTargetID = ""
            
        if not isinstance(computedTargetID, str):
            computedTargetID = computedTargetID[0]

        # xpath does not allow None in nsmap
        if None in nsmap:
            nsmap.pop(None)
        
        DEBUGPRINT("post root content ", etree.tostring(root,  pretty_print=True).decode("utf-8"))
                            
        DEBUGPRINT("compute URI API part for selectedschemaID ", computedTargetID)    
        if computedTargetID != "":                
            correspondingInstNode =  root.xpath(computedTargetID.lstrip("/"), namespaces=nsmap)
            DEBUGPRINT("correspondingInstNode ", correspondingInstNode)
            # there must be node inst node found for post data or for posting RPC
            fidAndValueDict, instNsmap=getAndReturnInstNodeYANGInstanceID(self, correspondingInstNode[0])  
            
            # ("/yanglib:modules-state/yanglib:module", {'prensence_container_node': False, 'value': '', 'listkey_node': False, 'leaflist_node': False, 'raw_XML_data': False, 'list_node': False, 'leaf_node': True}
            DEBUGPRINT("fid ", fidAndValueDict[0][0])
            # fid such as /yanglib:modules-state/yanglib:module[yanglib:name='aa'][yanglib:revision='']/yanglib:submodule
            dsi = self.yangiid_to_segueiid(fidAndValueDict[0][0], nsmap=instNsmap, restconfid=True)  
            
            if fakedTargetSelection:
                # remove the last node from the path ID since it is added 
                # by the application to get list entry
                dsi = dsi[0:dsi.rfind("/")]  

        else:
            dsi = ""    
                
        DEBUGPRINT("First calculateddsi: ", dsi)
        
        # compute point value
        if insertPointPathID != "":
            DEBUGPRINT("insertPointPathID ", insertPointPathID)
            correspondingInstNode =  root.xpath(insertPointPathID.lstrip("/"), namespaces=nsmap)
            DEBUGPRINT("insert point correspondingInstNode ", correspondingInstNode)
            # there must be node inst node found
            fidAndValueDict, instNsmap=getAndReturnInstNodeYANGInstanceID(self, correspondingInstNode[0])  
            
            # ("/yanglib:modules-state/yanglib:module", {'prensence_container_node': False, 'value': '', 'listkey_node': False, 'leaflist_node': False, 'raw_XML_data': False, 'list_node': False, 'leaf_node': True}
            DEBUGPRINT("insert fid ", fidAndValueDict[0][0])
            # fid such as /yanglib:modules-state/yanglib:module[yanglib:name='aa'][yanglib:revision='']/yanglib:submodule
            insdsi = self.yangiid_to_segueiid(fidAndValueDict[0][0], nsmap=instNsmap, restconfid=True)  
            
            DEBUGPRINT("insdsi ", insdsi)      
            kwargs["insPointDsi"] = insdsi      
            
        # compute data to post or put etc.
        dsi, data = self.compute_restconf_post_data_dsi(rtype, dsi, *args, **kwargs )
        DEBUGPRINT("dsi ", dsi, " data ", data)     
        return (dsi, data, kwargs)
    
    
    def compute_selected_data_source_id_and_filter(self, *args, **kwargs):
        #
        # args is yang IID such as
        # /ncm:netconf-state/ncm:capabilities
        # namsp : 'ncm': 'urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring
        # kwars: depth, level etc.
        #
        DEBUGPRINT("in ssmanager ", " args ", args, " kwargs !!! ", kwargs) 
        nsmap = {}
        filterexpr = ""
        selectedTargetInstNode = None
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            del kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
                
                
                
        #schemaTreeRetrieTargetLstKey = False
        #if "schemaTreeRetrieTargetLstKey" in kwargs:
        #    schemaTreeRetrieTargetLstKey=kwargs["schemaTreeRetrieTargetLstKey"]
        #    del kwargs["schemaTreeRetrieTargetLstKey"]
                
        fakedTargetSelection =False
        if "fakedTargetSelection" in kwargs:
            fakedTargetSelection=kwargs["fakedTargetSelection"]
            del kwargs["fakedTargetSelection"]
           
        selectedTargetID = ""    
        if "selectedTargetID" in kwargs:
            selectedTargetID = kwargs["selectedTargetID"]
            del kwargs["selectedTargetID"]
            
                        
        fieldsIDs = []
        fieldsIDdsis = []
        if "fieldsIDs" in kwargs:
            fieldsIDs = kwargs["fieldsIDs"]
            del kwargs["fieldsIDs"]    
            
        # in restconf, target (data source identifier) can only be one node 
        DEBUGPRINT("got args ", args)
        if len(args) > 0:
            # if restconf get got a resource id properly formed we do not
            # need to convert it 
            # we only need to convert when arguments passed down are 
            # like netconfc (GUI or CLI) form prefx:name 
            # (('/yanglib:modules-state/yanglib:module/yanglib:name', '1'),
            # ('/yanglib:modules-state/yanglib:module/yanglib:revision', '2'), 
            #'/yanglib:modules-state/yanglib:module/yanglib:schema')  
            
            topLevelConfigElementList=[]
            nodeIDValueList=_build_nodePathAndValueList(args)
            
            for nodePathItem in nodeIDValueList:           
                _build_subtree_toplevel_elem_list_item(topLevelConfigElementList, 
                    nodePathItem, 
                    prefix_namespace_dict=self.session_prefix_namespace_dict)    
            
            # in restconf we normally only allow one single top level target in a get
            # but when we use fields expr we can retrieve nodes in different modules

            # here we fake this to be a get-reply <data> so we can use existing procedure to 
            # get yang-iid
            root = etree.Element("{urn:ietf:params:xml:ns:netconf:base:1.0}data")
            
            for topLevelConfigElement in topLevelConfigElementList:            
                root.append(topLevelConfigElement)
            
            if selectedTargetID == "":
                selectedTargetID = args[-1]

            if selectedTargetID is None:
                selectedTargetID = ""
                
            if not isinstance(selectedTargetID, str):
                selectedTargetID = selectedTargetID[0]

            # xpath does not allow None in nsmap
            if None in nsmap:
                nsmap.pop(None)
            
            DEBUGPRINT("retrieving root content ", etree.tostring(root,  pretty_print=True))
                                
            DEBUGPRINT("compute URI API part for selectedschemaID ", selectedTargetID)    
            if selectedTargetID != "":                
                correspondingInstNode =  root.xpath(selectedTargetID.lstrip("/"), namespaces=nsmap) 
                selectedTargetInstNode = correspondingInstNode[0]
                # there must be node inst node found. must have found a corresponding node here
                fidAndValueDict, instNsmap=getAndReturnInstNodeYANGInstanceID(self, correspondingInstNode[0])  
                
                # ("/yanglib:modules-state/yanglib:module", {'prensence_container_node': False, 'value': '', 'listkey_node': False, 'leaflist_node': False, 'raw_XML_data': False, 'list_node': False, 'leaf_node': True}
                DEBUGPRINT("fid ", fidAndValueDict[0][0])
        
                        
                # fid such as /yanglib:modules-state/yanglib:module[yanglib:name='aa'][yanglib:revision='']/yanglib:submodule
                dsi = self.yangiid_to_segueiid(fidAndValueDict[0][0], nsmap=instNsmap, restconfid=True)   
                DEBUGPRINT("got initial dsi ", dsi, " fakedTargetSelection here  ", fakedTargetSelection) 
                if fakedTargetSelection:
                    # remove the last node from the path ID since it is added 
                    # by the application to get list entry
                    dsi = dsi[0:dsi.rfind("/")]                 
                DEBUGPRINT("dsi ", dsi) 
                                
            else:
                dsi = ""    
            
            DEBUGPRINT("compute URI API part for fieldsIDs ", fieldsIDs)   
            filterexpr = ""
            for fieldID in fieldsIDs:      
                #print "fieldID: ", fieldID
                if not isinstance(fieldID, str):  
                    # tuple. e.g.: ('/yanglib:modules-state/yanglib:module/yanglib:name', 'a')
                    fieldID =fieldID[0]         
                correspondingInstNode =  root.xpath(fieldID.lstrip("/"), namespaces=nsmap) 
                # there must be node inst node found
                fidAndValueDict, instNsmap=getAndReturnInstNodeYANGInstanceID(self, correspondingInstNode[0])  
                
                # ("/yanglib:modules-state/yanglib:module", {'prensence_container_node': False, 'value': '', 'listkey_node': False, 'leaflist_node': False, 'raw_XML_data': False, 'list_node': False, 'leaf_node': True}
                #print "fid ", fidAndValueDict[0][0]
                # fid such as /yanglib:modules-state/yanglib:module[yanglib:name='aa'][yanglib:revision='']/yanglib:submodule
                fielddsi = self.yangiid_to_segueiid(fidAndValueDict[0][0], nsmap=instNsmap, restconfid=True)                 
                #print "fielddsi ", fielddsi 
                fieldsIDdsis.append(fielddsi)
            
            # compute fieldexpr
            fieldsIDdsisLen = len(fieldsIDdsis)
            for i, fieldid in enumerate(fieldsIDdsis):
                if i + 1 < fieldsIDdsisLen:
                    # skip the node if the following holds:
                    #fieldid  /example-jukebox:jukebox/library/artist
                    #fieldid  /example-jukebox:jukebox/library/artist=a/name                    
                    if fieldsIDdsis[i+1].startswith(fieldid + "="):
                        continue
                                
                DEBUGPRINT("fieldid ", fieldid)
                
                if fieldid.startswith(dsi):                    
                    fielder = fieldid.replace(dsi, "")
                else:
                    instidx = dsi.rfind("=")
                    if instidx != -1:
                        dsiNoInst = dsi[:instidx]                        
                        if fieldid.startswith(dsiNoInst):
                            fielder = fieldid.replace(dsiNoInst, "")
                                
                filterexpr = fielder.lstrip("/") if filterexpr == "" else filterexpr + ";" + fielder.lstrip("/")  
            DEBUGPRINT("filterexpr ", filterexpr)
            
            if dsi != "":
                # Do not do this if the retrieving is done on datastore resource /data 
                #
                # compute the tree nodes represented by 'target' so we can attach response nodes
                # to form a complete data tree        
                # fakedSTarget is the last sibling so we use preceding=True
                DEBUGPRINT("selectedTargetInstNode found earlier", selectedTargetInstNode)
                if selectedTargetInstNode is not None: 
                    selectedTargetInstNodeHasSibling =False
                    if selectedTargetInstNode is not None and len(selectedTargetInstNode.getparent()) == 1:
                        selectedTargetInstNodeHasSibling =True
                    
                    if fakedTargetSelection:
                        # if there is a faked target selection then the user must be
                        # getting a list entry with keys specified                                
                        nodeToRemove= selectedTargetInstNode.getparent()
                        nodeToRemove.getparent().remove(nodeToRemove)                                
                    else:
                        selectedTargetInstNode.getparent().remove(selectedTargetInstNode)
                    
                    
                    ###myiters = correspondingInstNode[0].itersiblings(preceding=True)
                    ###for elemNode in myiters:
                    ###    elemNode.getparent().remove(elemNode) 
                
                DEBUGPRINT("trimed root content: ", etree.tostring(root,  pretty_print=True))
                kwargs["trimmedRootNode"] = root
            
                
        # determine what do do when attaching nodes in reply for displaying in "data tree" pane
        if dsi != "":
            dsiList = dsi.split("/")
            DEBUGPRINT("dsiList ", dsiList)
            
            if dsiList[-2].find("=") != -1:            
                if selectedTargetInstNodeHasSibling:
                    # the target node  in question  has no siblings and has been removed 
                    kwargs["AddAsSblingToTargetSelection"] = False
                else:    
                    kwargs["AddAsSblingToTargetSelection"] = True
            else:
                kwargs["AddAsSblingToTargetSelection"]  =False
        
                
        return (dsi, filterexpr, kwargs)
    
    def put(self,  *args, **kwargs):
        self.retrieveRootResourceIfHasnt()     
        if "namespaces" in kwargs:
            # nodeIDAndValues is args
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("put", *args,  **kwargs)        
        else:
            # target (resource id) and data entered directly
            dsid = args[0]     
            data = args[1]       
            kwargspruned = kwargs
        DEBUGPRINT("dsid put ", dsid)
        return self.requests_session.put(dsid, data, **kwargspruned)
        
    def put_datastore(self,  *args, **kwargs):
        self.retrieveRootResourceIfHasnt()     
        if "namespaces" in kwargs:
            # nodeIDAndValues is args
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("put", *args,  **kwargs)        
        else:
            # target (resource id) and data entered directly     
            data = args[0]       
            kwargspruned = kwargs
        return self.requests_session.put("", data, **kwargspruned)

    def delete(self,  *args, **kwargs):
        self.retrieveRootResourceIfHasnt()     
        if "namespaces" in kwargs:
            # nodeIDAndValues is args
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("delete", *args,  **kwargs)        
        else:
            # target (resource id) and data entered directly
            dsid = args[0]       
            kwargspruned = kwargs

        return self.requests_session.delete(dsid,  **kwargspruned)

    def patch(self,  *args, **kwargs):
        self.retrieveRootResourceIfHasnt()     
        if "namespaces" in kwargs:
            # nodeIDAndValues is args
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("patch", *args,  **kwargs)        
        else:
            # target (resource id) and data entered directly
            dsid = args[0]     
            data = args[1]       
            kwargspruned = kwargs

        return self.requests_session.patch(dsid, data, **kwargspruned)
        
    def post_datastore(self,  *args, **kwargs): 
        self.retrieveRootResourceIfHasnt()     
        if "namespaces" in kwargs:
            # nodeIDAndValues is args
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("post_data", *args,  **kwargs)        
        else:
            # target (resource id) and data entered directly 
            data = args[0]
            kwargspruned = kwargs

        return self.requests_session.post_data("", data, **kwargspruned)

    
    def post_data(self,  *args, **kwargs): 
        self.retrieveRootResourceIfHasnt()     
        if "namespaces" in kwargs:
            # nodeIDAndValues is args
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("post_data", *args,  **kwargs)        
        else:
            # target (resource id) and data entered directly
            dsid = args[0]     
            data = args[1]       
            kwargspruned = kwargs

        return self.requests_session.post_data(dsid, data, **kwargspruned)

    def post_actions(self,  *args, **kwargs):         
        self.retrieveRootResourceIfHasnt()     
        if "namespaces" in kwargs:
            kwargs["keepInputNode"] = True
            # nodeIDAndValues is args
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("post_actions", *args,  **kwargs)        
        else:
            # target (resource id) and data entered directly
            dsid = args[0]     
            data = args[1]       
            kwargspruned = kwargs

        return self.requests_session.post_data(dsid, data, **kwargspruned)

    def post_operations(self, *args, **kwargs):
        self.retrieveRootResourceIfHasnt()        
        if "namespaces" in kwargs:
            kwargs["keepInputNode"] = True
            dsid, data, kwargspruned = self.compute_restconf_post_dsid_and_data("post_operations", *args,  **kwargs)        
        else:
            # target (resource id) entered directly
            dsid = args[0] 
            data = ""
            try:           
                data = args[1]
            except Exception:
                pass
                    
            kwargspruned = kwargs
            
        return self.requests_session.post_operations(dsid, data, **kwargspruned) 
        
    def retrieve_schema (self, identifier="", version=""):
        """ RESTCONF retrieving schema """
        url = ""
        self.register_namespace("yanglib", "urn:ietf:params:xml:ns:yang:ietf-yang-library")
        r = self.get("ietf-yang-library:modules-state/module=%s,%s/schema"%(identifier, version))
        DEBUGPRINT("r received  ", r)
        if r.ok:
            rtext = r.text
            #rtext = """<yanglib:schema xmlns:yanglib="urn:ietf:params:xml:ns:yang:ietf-yang-library">https://example.com/mymodules/example-jukebox/2016-08-15</yanglib:schema>"""
            if not rtext.strip().startswith("<"):
                # json               
                rdict = json.loads(rtext)
                if "ietf-yang-library:schema" in rdict:
                    url = rdict["ietf-yang-library:schema"]                                      
            else:
                # xml       
                relem = etree.fromstring(rtext)
                url = relem.text
                
            # RFC8040 3.7.  Schema Resource
            DEBUGPRINT("schema url ", url)
            #url = "https://raw.githubusercontent.com/YangModels/yang/master/standard/ietf/DRAFT/example-jukebox.yang"
            r = requests.get(url, headers={'Accept': 'application/yang'}) 
            #r = requests.get(url) 
            #print "rr ",  r.ok, " text ", r.text, " request headers ", r.request.headers, " response headers ", r.headers
            return r    
        else:
            return r
        
    # restconf only    
    def options(self, *args, **kwargs):
        self.retrieveRootResourceIfHasnt()      
        #filterexpr = ""      
        if "namespaces" in kwargs:
            # this indicate the restconf target has been passed down
            # rather than a list of selected schemaID paths
            dsid, _, kwargspruned =  self.compute_selected_data_source_id_and_filter(*args, **kwargs)
            DEBUGPRINT("kwargspruned ", kwargspruned)
        else:
            # target (resource id) entered directly
            dsid = args[0]
            kwargspruned = kwargs
            
        #if "withDefaults" in kwargspruned:                
        #    kwargspruned["with-defaults"] = kwargspruned["withDefaults"]
        #    del kwargspruned["withDefaults"]
        
        #if filterexpr != "":
        #    kwargspruned["fields"] = filterexpr
                
            
        #if "depth"  in kwargspruned:
        #    if kwargspruned["depth"] == "unspecified" or kwargspruned["depth"] == 0:
        #        del kwargspruned["depth"]
        #        
        #if "content"  in kwargspruned:
        #    if kwargspruned["content"] == "unspecified":
        #        del kwargspruned["content"]
        self.AddAsSblingToTargetSelection =False
        if "AddAsSblingToTargetSelection" in kwargspruned:
            self.AddAsSblingToTargetSelection=kwargspruned["AddAsSblingToTargetSelection"]
            del kwargspruned["AddAsSblingToTargetSelection"]
        
        self.trimmedRootNode =None
        if "trimmedRootNode" in kwargspruned:
            #self.trimmedRootNode=kwargspruned["fakedTargetSelection"]
            self.trimmedRootNode=kwargspruned["trimmedRootNode"]
            del kwargspruned["trimmedRootNode"]
        
                 
        return self.requests_session.options(dsid, **kwargspruned)
        
        
    def head(self, *args, **kwargs):    
        self.retrieveRootResourceIfHasnt()      
        filterexpr = ""      
        if "namespaces" in kwargs:
            # this indicate the restconf target has been passed down
            # rather than a list of selected schemaID paths
            dsid, filterexpr, kwargspruned =  self.compute_selected_data_source_id_and_filter(*args, **kwargs)
            DEBUGPRINT("kwargspruned ", kwargspruned)
        else:
            # target (resource id) entered directly
            if len(args) == 0:
                dsid = ""
            else:    
                dsid = args[0]
            kwargspruned = kwargs
            
        if "withDefaults" in kwargspruned:                
            kwargspruned["with-defaults"] = kwargspruned["withDefaults"]
            del kwargspruned["withDefaults"]
        
        if filterexpr != "":
            kwargspruned["fields"] = filterexpr
                
            
        #if "depth"  in kwargspruned:
        #    if kwargspruned["depth"] == "unspecified" or kwargspruned["depth"] == 0:
        #        del kwargspruned["depth"]
        #        
        #if "content"  in kwargspruned:
        #    if kwargspruned["content"] == "unspecified":
        #        del kwargspruned["content"]
        
        self.AddAsSblingToTargetSelection =False
        if "AddAsSblingToTargetSelection" in kwargspruned:
            self.AddAsSblingToTargetSelection=kwargspruned["AddAsSblingToTargetSelection"]
            del kwargspruned["AddAsSblingToTargetSelection"]
        
        self.trimmedRootNode =None
        if "trimmedRootNode" in kwargspruned:
            #self.trimmedRootNode=kwargspruned["fakedTargetSelection"]
            self.trimmedRootNode=kwargspruned["trimmedRootNode"]            
            del kwargspruned["trimmedRootNode"]
        
                 
        return self.requests_session.head(dsid, **kwargspruned)
        
    def rget(self, *args, **kwargs):
        # Perform a rest get
        # args can either be 1) arget (resource id), or
        # a list of nodeIDs and "namespaces" in kawrgs
        # 
        return self.get(*args, **kwargs)

    def get_data(self, *args, **kwargs):    
        """
        It is recommended to use sget which also accepts Instance ID
        A high level Netconf <get> command for retrieving data using subtree filtering.        
        args: nodePathItem_1, nodePathItem_2, ....
                Each nodePathItem can be an absoluteNodeID, or a (absoluteNodeID, valueToMatch) tuple              
                Exmaple:  "/netconf-state/datastores/datastore"        
                        ("/netconf-state/datastores/datastore", "running")
        kwargs:
                filter=filterExpression
                        If you already have a filter expression, use this option.        
                        When this option is used, the arguments nodePathItem_1, nodePathItem_2 etc. will be ignored.
                        filterExpression must be a well formatted XML filter expression string. 
                        Example:
                        <if:interfaces xmlns=http://netconfcentral.org/ns/yuma-interfaces>
                            <if:interface>
                                <if:name />
                                </if:interface>
                        </if:interfaces>

                xPathNamespacePrefixMap: None or used by xPath filter
                msgid: default to auto generated ID
                datastore: default: "running"                          
                config: 2 = unspecified, 1 = config True,  0 = config False
                originFilter:  can be a list of ['intended', 'system', 'dynamic', 'learned', 'default', 'unknown']
                negatedOriginFilter: can be a list of ['intended', 'system', 'dynamic', 'learned', 'default', 'unknown']
                maxDepth: 0 or "unspecified", or "unbounded"  or 1..65535
                withOrigin: False
                withDefaults= 'explicit' | 'report-all' | 'trim' | 'report-all-tagged'
                namespaces /nsmap = {}: prefix/namepsace mapping dict
                
        Return: (SucceededFlag, ReplyXML, ReplyElem,
                    RequestXML, RequestElem)                  
        """
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            del kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
                
        if "nsmap" in kwargs:
            nsmap=kwargs["nsmap"]
            del kwargs["nsmap"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
                                        
        #[('interfaces', ''), ('interface', ''), ('name', (u'ggg', 'replace with-default'))]
        #inner tuple ('replace with-default')) is used only with edit-config   
        if "filter" in kwargs:
            # Here the specified expr does not contain the top <filter> element
            expr=kwargs["filter"]
            del kwargs["filter"]
        else:    
            if len(args) !=0:
                expr = self.build_subtree_filter(*args, getdataFilter=True)
            else:
                expr =None

        withDefaults=None
        if "withDefaults" in kwargs:
            withDefaults=kwargs["withDefaults"]        
            del kwargs["withDefaults"]

        xpath=False
        if "xpath" in kwargs:
            xpath=kwargs["xpath"]        
            del kwargs["xpath"]
        print("Expr ", expr)
        result = _get_data_rpc_helper(self.ncmgr, expr, withDefaults=withDefaults, xpath=xpath, **kwargs)                    
        #return a tuple
        retElem = result.data 
        if result.data is not None:
            res = True
        else:
            res = False
            # if an error is returned
            retElem = result._root
        # Debugging testing
        if USE_INTERNAL_TESTING_DATA_FILE is not None:
            #self.load_module_by_name_revision("segue-test-module", "2015-10-11")
            # force setting reply to the contents of the file
            testDataTree = etree.parse(USE_INTERNAL_TESTING_DATA_FILE) 
            # the element returned is the 'data' element
            retElem = testDataTree.getroot()[0]
            resultXML = etree.tostring(testDataTree)
            return (res, resultXML, retElem, result.request_xml, result.request_ele)
                            
        return (res, result.xml, retElem, result.request_xml, result.request_ele)

    def get(self, *args, **kwargs):    
        if not hasattr(self, "restconfSessionFlag"):
            """
            It is recommended to use sget which also accepts Instance ID
            A high level Netconf <get> command for retrieving data using subtree filtering.        
            args: nodePathItem_1, nodePathItem_2, ....
                  Each nodePathItem can be an absoluteNodeID, or a (absoluteNodeID, valueToMatch) tuple              
                  Exmaple:  "/netconf-state/datastores/datastore"        
                            ("/netconf-state/datastores/datastore", "running")
            kwargs:
                  filter=filterExpression
                         If you already have a filter expression, use this option.        
                         When this option is used, the arguments nodePathItem_1, nodePathItem_2 etc. will be ignored.
                         filterExpression must be a well formatted XML filter expression string. 
                         Example:
                            <if:interfaces xmlns=http://netconfcentral.org/ns/yuma-interfaces>
                                <if:interface>
                                  <if:name />
                                  </if:interface>
                            </if:interfaces>
                        
                  withDefaults= 'explicit' | 'report-all' | 'trim' | 'report-all-tagged'
                  namespaces /nsmap = {}: prefix/namepsace mapping dict
                  
            Return: (SucceededFlag, ReplyXML, ReplyElem,
                     RequestXML, RequestElem)                  
            """
            if "namespaces" in kwargs:
                nsmap=kwargs["namespaces"]
                del kwargs["namespaces"]
                for k,v in list(nsmap.items()):
                    self.register_namespace(k, v)
                    
            if "nsmap" in kwargs:
                nsmap=kwargs["nsmap"]
                del kwargs["nsmap"]
                for k,v in list(nsmap.items()):
                    self.register_namespace(k, v)
                                            
            #[('interfaces', ''), ('interface', ''), ('name', (u'ggg', 'replace with-default'))]
            #inner tuple ('replace with-default')) is used only with edit-config   
            if "filter" in kwargs:
                # Here the specified expr does not contain the top <filter> element
                expr=kwargs["filter"]
                del kwargs["filter"]
            else:    
                if len(args) !=0:
                    expr = self.build_subtree_filter(*args)
                else:
                    expr =None
    
            withDefaults=None
            if "withDefaults" in kwargs:
                withDefaults=kwargs["withDefaults"]        
                del kwargs["withDefaults"]
                
            result = _get_rpc_helper(self.ncmgr, expr, withDefaults=withDefaults, xpath=False, **kwargs)             
            #return a tuple
            #print("dirs data ", dir(result))
            retElem = result.data 
            if result.data is not None:
                res = True
            else:
                res = False
                # if an error is returned
                retElem = result._root
            
            # Debugging testing
            if USE_INTERNAL_TESTING_DATA_FILE is not None:
                #self.load_module_by_name_revision("segue-test-module", "2015-10-11")
                # force setting reply to the contents of the file
                testDataTree = etree.parse(USE_INTERNAL_TESTING_DATA_FILE) 
                # the element returned is the 'data' element
                retElem = testDataTree.getroot()[0]
                resultXML = etree.tostring(testDataTree)
                return (res, resultXML, retElem, result.request_xml, result.request_ele)
                               
            return (res, result.xml, retElem, result.request_xml, result.request_ele)
        else:
            self.retrieveRootResourceIfHasnt()      
            filterexpr = ""      
            if "namespaces" in kwargs:
                # this indicate the restconf target has been passed down
                # rather than enterin  the target (resource id) directly
                dsid, filterexpr, kwargspruned =  self.compute_selected_data_source_id_and_filter(*args, **kwargs)
                DEBUGPRINT("kwargspruned ", kwargspruned)
            else:
                # target (resource id) entered directly
                if len(args) == 0:
                    dsid = ""
                else:    
                    dsid = args[0]
                kwargspruned = kwargs
                
            if "withDefaults" in kwargspruned:                
                kwargspruned["with-defaults"] = kwargspruned["withDefaults"]
                del kwargspruned["withDefaults"]
            
            
            if filterexpr != "":
                kwargspruned["fields"] = filterexpr
                    
                
            #if "depth"  in kwargspruned:
            #    if kwargspruned["depth"] == "unspecified" or kwargspruned["depth"] == 0:
            #        del kwargspruned["depth"]
            #        
            #if "content"  in kwargspruned:
            #    if kwargspruned["content"] == "unspecified":
            #        del kwargspruned["content"]
            #DEBUGPRINT("ssmanger get ...", dsid)
                        
            self.AddAsSblingToTargetSelection =False
            if "AddAsSblingToTargetSelection" in kwargspruned:
                self.AddAsSblingToTargetSelection=kwargspruned["AddAsSblingToTargetSelection"]
                del kwargspruned["AddAsSblingToTargetSelection"]
            
            self.trimmedRootNode =None
            if "trimmedRootNode" in kwargspruned:
                self.trimmedRootNode=kwargspruned["trimmedRootNode"]
                del kwargspruned["trimmedRootNode"]
            
            
            return self.requests_session.get(dsid, **kwargspruned)
            
       
    def get_config(self, *args, **kwargs):    
        """
        It is recommended to use sget which also accepts Instance ID
        
        A high level Netconf <get> command for retrieving data using subtree filtering.        
        args: nodePathItem_1, nodePathItem_2, ....
              Each nodePathItem can be an insntaceID, or a (insntaceID, valueToMatch) tuple              
              Exmaple:  "/netconf-state/datastores/datastore"        
                        ("/netconf-state/datastores/datastore", "running")
        kwargs:
              filter=filterExpression
                     If you already have manually constructed filter expression, use this option.        
                     When this option is used, the arguments nodePathItem_1, nodePathItem_2 etc. will be ignored.
                     It must be a well formatted filter expression string such as:
                     For example, 
                          <if:interfaces xmlns=http://netconfcentral.org/ns/yuma-interfaces>
                            <if:interface>
                              <if:name />
                              </if:interface>
                          </if:interfaces>
              source = 'candidate' | 'running' | 'startup'      
                        Default: 'running'
              withDefaults= 'explicit' | 'report-all' | 'trim' | 'report-all-tagged'
              namespaces/nsmp = {}: prefix/namepsace mapping dict
        Return: (SucceededFlag, ReplyXML, ReplyElem, RequestXML, RequestElem)                
        """       
        #[('interfaces', ''), ('interface', ''), ('name', (u'ggg', 'replace with-default'))]
        #inner tuple ('replace with-default')) is used only with edit-config   
        if "source" in kwargs:
            source=kwargs["source"]
            del kwargs["source"]
        else:
            source='running'
                       
        # here the returned expr contains the top <filter>
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            del kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
            
        if "nsmap" in kwargs:
            nsmap=kwargs["nsmap"]
            del kwargs["nsmap"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)       
                     
        if "filter" in kwargs:
            #here the specified expr does not contain the top <filter> 
            expr=kwargs["filter"]
            del kwargs["filter"]
        else:    
            if len(args) !=0:
                #here the returned expr contains the top <filter> 
                expr = self.build_subtree_filter(*args)                
            else:
                expr =None
                
        withDefaults=None
        if "withDefaults" in kwargs:
            withDefaults=kwargs["withDefaults"]
            del kwargs["withDefaults"]    
        result = _get_config_rpc_helper(self.ncmgr, source, expr, withDefaults=withDefaults, xpath=False, **kwargs)         

        retElem = result.data 
        if result.data is not None:
            res = True
        else:
            res = False
            # if an error is returned
            retElem = result._root
            
        # Debugging for testing
        if USE_INTERNAL_TESTING_CONFIG_DATA_FILE is not None:
            self.load_module_by_name_revision("segue-test-module", "2015-10-11")
            # force setting reply to the contents of the file
            testDataTree = etree.parse(USE_INTERNAL_TESTING_CONFIG_DATA_FILE) 
            # the element returned is the 'data' element
            retElem = testDataTree.getroot()[0]
            resultXML = etree.tostring(testDataTree)
            return (res, resultXML, retElem, result.request_xml, result.request_ele)
                  
        return (res, result.xml, retElem, result.request_xml, result.request_ele)

    def get_notification_stream_names(self):
        """
        RFC5277. This basically issues get request to retrieve
        available netconf event streams.
        urn:ietf:params:xml:ns:netmod:notification
        """
        #self.register_namespace("nc", "urn:ietf:params:xml:ns:netconf:base:1.0")
        #self.register_namespace("noti", "urn:ietf:params:xml:ns:netmod:notification")
        pfx = self.get_registered_prefix("urn:ietf:params:xml:ns:netmod:notification")
        if pfx == "" or pfx.startswith(DEFAULT_NS_PREFIX):
            pfx = "manageEvent"
            self.register_namespace("%s"%pfx, "urn:ietf:params:xml:ns:netmod:notification")
            
        try:    
            res = self.get("/%s:netconf/%s:streams"%(pfx,pfx))
        except:
            raise
            
        if res[2] is not None:
            streamPath = "%s:netconf/%s:streams/%s:stream/%s:name"%(pfx,pfx,pfx,pfx)
            return self.extract_value_from_rpc_reply(res[2], streamPath)
        else:
            return ""
        
                            
    def get_schema(self, identifier="", version="", schemaFormat=""):
        """
        NETCONFc 
        identifier: string, Identifier for the schema list entry.
        
        version: Version of the schema requested.  If this parameter is not present,
           and more than one version of the schema exists on the server, a
           'data-not-unique' error is returned, as described above.
           
        schemaFormat: "yang" | "yin" | "xsd" | "rng" | "rnc"
        
          The data modeling language of the schema.  If this parameter is not
           present, and more than one formats of the schema exists on the
           server, a 'data-not-unique' error is returned, as described
           above.

        
        """
        self.register_namespace("ncm", "urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring")

        #check if prefix used to qualify the name
        idx = schemaFormat.find(":")
        if idx == -1:
            schemaFormat="ncm:%s"%schemaFormat
            
        if version !="" and schemaFormat !="":    
            return self.send_any_rpc("ncm:get-schema",
                                "ncm:identifier", identifier,
                                "ncm:version", version,
                                "ncm:format", schemaFormat)
        elif version !="" and schemaFormat =="":    
            return self.send_any_rpc("ncm:get-schema",
                                "ncm:identifier", identifier,
                                "ncm:version", version)
        else:    
            return self.send_any_rpc("ncm:get-schema",
                                "ncm:identifier", identifier,
                                "ncm:format", schemaFormat)
            
    def confirmed_commit(self, timeout=600, persistID=None):
        """
        Send a <confirmed-commit> that needs a follow-up <commit> to confirm
        
        timeout: Timeout period for confirmed commit, in seconds.  If
                unspecified, the confirm timeout defaults to 600 seconds
        persist: Make the confirmed commit survive a session termination, and
                set a string token on the ongoing confirmed commit.
                This value is a string token used by a follow-up commit or 
                a confirming commit from any session.
            
        After issuing a <confirmed-commit> , a follow-up <commit> must be
        issued within the timeout period set forth to complete the operation.
        """            
        result = self.ncmgr.commit(confirmed=True, timeout=str(timeout), persist=persistID)
        if result is not None:              
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)

    def kill_session(self, session_id):
        """        kill session        """
        result = self.ncmgr.kill_session(session_id)
        if result is not None:              
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
        
    def lock(self, target):
        #if target not in ["running", "candidate", "startup"]:
        #    raise ParameterError("The config store to lock must be 'running', 'candidate', or 'startup'")            
        result = self.ncmgr.lock(target)
        if result is not None:
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
    
    def unlock(self, target):
        result = self.ncmgr.unlock(target)
        if result is not None:
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)

    def partial_lock(self, *args, **kwargs):
        """
        A NETCONF operation that locks parts of the running datastore.
        XPath expression that specifies the scope of the lock. An Instance
        Identifier expression MUST be used unless the :xpath capability
        is supported, in which case any XPath 1.0 expression is
        allowed.

        namespaces = {} : prefix/namspace mapping 
        
        """
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
                        
        self.register_namespace("pl", "urn:ietf:params:xml:ns:netconf:partial-lock:1.0")  
        newargs = []
        for arg in args:
            # A single element tuple must have a training ','
            newargs.append(("/pl:partial-lock/pl:select", arg))    
        nodeIDValueList=_build_nodePathAndValueList(newargs)    
       
        # here the returned config contains the top <filter> 
        rpcnode = self.build_rpc_subtree(nodeIDValueList)
              
        xmlstring=etree.tostring(rpcnode, pretty_print=True)
        
        result=self.ncmgr.send_xml(xmlstring)
        if result is not None:
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)

    def partial_unlock(self, lock_id=""):
        """
        lock-id:  Identity of the lock to be unlocked.  This lock-id MUST
                 have been received as a response to a lock request by the
                 manager during the current session, and MUST NOT have been
                 sent in a previous unlock request

        """
        self.register_namespace("pl", "urn:ietf:params:xml:ns:netconf:partial-lock:1.0")  
                                   
        # A single element tuple must have a training ','
        args=(("/pl:partial-unlock/pl:lock-id", str(lock_id)),)    
        nodeIDValueList=_build_nodePathAndValueList(args)              
        # here the returned config contains the top <filter> 
        rpcnode = self.build_rpc_subtree(nodeIDValueList)
        
                
        xmlstring=etree.tostring(rpcnode, pretty_print=True)        
        result=self.ncmgr.send_xml(xmlstring)
        if result is not None:              
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
        
            
    def register_namespace(self, prefix, namespace):
        # if this prefix has been used by another module, overwrite it
        if prefix is not None:
            self.session_prefix_namespace_dict[prefix] = namespace        
            self.session_namespace_prefix_dict[namespace] = prefix
            
            #used by elementree to render reply (so no ns0, ns1, etc.)
            etree.register_namespace(prefix, namespace)  

    def get_registered_namespace(self, prefix):
        if prefix in self.session_prefix_namespace_dict:
            return self.session_prefix_namespace_dict[prefix]
         
        return ""   
        
    def get_registered_prefix(self, namespace):
        if namespace in self.session_namespace_prefix_dict:
            return self.session_namespace_prefix_dict[namespace]
         
        return ""   
        
        
    def send_restconf_raw_request(self, type_spaces_url_spaces_data):
        # split() instead, the program will take into account multiple spaces, newlines, 
        # tabs and all other forms of whitespace.
        req = ""
        url = ""
        data = ""
        DEBUGPRINT("type_spaces_url_spaces_data ", type_spaces_url_spaces_data)
        itms = type_spaces_url_spaces_data.split(None,2)
        itmn =len(itms)
        DEBUGPRINT("itemn ", itmn)
        if itmn == 1:
            raise Exception("url can't be empty!")
        elif itmn == 2:
            req = itms[0]
            url = itms[1]            
        elif itmn == 3:  
            req = itms[0]
            url = itms[1]            
            data = itms[2]
        elif itmn == 3:  
            req = itms[0]
            url = itms[1]            
            data = itms[2:]
                    
        DEBUGPRINT("req ", req, "url ", url, "data", data)
                    
        #type_spaces_url_spaces_data = type_spaces_url_spaces_data.strip() 
        #idx = type_spaces_url_spaces_data.find(" ")
        #if idx != -1:
        #    req = type_spaces_url_spaces_data[0:idx]
        #    url_spaces_data = type_spaces_url_spaces_data[idx:].strip()
        #    idx =  url_spaces_data.find("\n")
        #    if idx != -1:
        #        url = url_spaces_data[:idx]
        #        data = url_spaces_data[idx:].strip()
        DEBUGPRINT("raw request ", req)
        if req == "" or req.lower() not in ["get", "post", "patch", "put", "head", "options"]:
            raise Exception("%s is an invalid request type!"%req)
                    
        if url == "" :
            raise Exception("url can't be empty!")
                
        if req.lower() == "get":
            return self.requests_session.get(url)    
        elif req.lower() == "post":
            return self.requests_session.post(url, data)    
        elif req.lower() == "put":
            return self.requests_session.put(url, data)
        elif req.lower() == "patch":
            return self.requests_session.patch(url, data)
        elif req.lower() == "head":
            return self.requests_session.head(url)
        elif req.lower() == "option":
            return self.requests_session.option(url)
            
                
    def send_rpc_raw_xml(self, msgxml, xmldeclaration=True):
        result = self.ncmgr.send_xml(msgxml, xmldeclaration=xmldeclaration)
        return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)
        
                
    def validate(self, source):
        """
        Validate a config datastore.
        The source can be 'running', 'candidate', 'startup', or a url that points to a config file, or 
        an inline config content. 

        The inline config content must be a well-formed <config> element representing an entire 
        configuration datastore, not a subset of the running datastore.        
        """
        config=""        
        if source in ["running", "candidate", "startup", "nmda-running", "nmda-startup",
                       "nmda-candidate", "nmda-operational", "nmda-intended"]:
            config = source                
        elif source.strip().startswith("<config>"):
            config = source.strip()        
        elif "://" in source:
            config = source.strip()                    
        else:
            raise ParameterError("The name of the configuration datastore to validate must be a configuration "
                                "store such as 'candidate', 'startup', 'running', 'nmda-candidate', 'nmda-running', "
                                "'nmda-operational', ''nmda-intended', 'nmda-startup',a url, or an inline <config> "
                                " element containing the complete configuration to validate.")

        result = self.ncmgr.validate(config)         
        if result is not None:               
            return (result.ok, result.xml, result._root, result.request_xml, result.request_ele)

    def xget(self, filterExpr=None, **kwargs):    
        """get_xpath
        filterExpr: xpath exprssion as defined in RFC6241
                Default :None
        e.g.:  "/ncm:netconf-state/ncm:sessions/ncm:session[ncm:username='aaa']"
        kwargs:              
              withDefaults= 'explicit' | 'report-all' | 'trim' | 'report-all-tagged'
              namspaces = prefix/namespace mapping used
              
        return: (True/False, ReplyXML)      
        """
        withDefaults = None
        if "withDefaults" in kwargs:
            withDefaults = kwargs["withDefaults"]  
            del   kwargs["withDefaults"]
            
        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            del kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
                                        
        result = _get_rpc_helper(self.ncmgr, filterExpr, withDefaults=withDefaults, xpath=True, xPathNamespacePrefixMap=self.session_prefix_namespace_dict, **kwargs)
        retElem = result.data                        
        if result.data is not None:
            res = True
        else:
            res = False
            # if an error is returned
            retElem = result._root
        #print "retElem ", etree.tostring(retElem)                           
        return (res, result.xml, retElem, result.request_xml, result.request_ele)
        
    def xget_config(self, filterExpr=None, **kwargs):    
        """get_xpath
        filterExpr: xpath exprssion as defined in RFC6241
                Default :None
        e.g.:  "/ncm:netconf-state/ncm:sessions/ncm:session[ncm:username='aaa']"
        kwargs:              
              withDefaults= 'explicit' | 'report-all' | 'trim' | 'report-all-tagged'
              source = 'candidate' | 'running' | 'startup'      
                        Default: 'running'
              namespaces = prefix/namespace mapping used
                        
        return: (True/False, ReplyXML)      
        """
        if "source" in kwargs:
            source = kwargs["source"]
            del kwargs["source"]
        else:
            source = 'running'
        withDefaults = None
        if "withDefaults" in kwargs:
            withDefaults = kwargs["withDefaults"]
            del kwargs["withDefaults"]    

        if "namespaces" in kwargs:
            nsmap=kwargs["namespaces"]
            del kwargs["namespaces"]
            for k,v in list(nsmap.items()):
                self.register_namespace(k, v)
                
        result = _get_config_rpc_helper(self.ncmgr, source, filterExpr, withDefaults=withDefaults, xpath=True, xPathNamespacePrefixMap=self.session_prefix_namespace_dict, **kwargs)              
        retElem = result.data        
        if result.data is not None:
            res = True
        else:
            res = False                        
            # if an error is returned
            retElem = result._root
        #print "retElem ", etree.tostring(retElem)    
        return (res, result.xml, retElem, result.request_xml, result.request_ele)            
    
    @staticmethod
    def print_rpc_stdout(flag=True):
        FORMAT = "%(asctime)s  %(message)s"

        logging.basicConfig(stream=sys.stdout, format=FORMAT)
        # debug uses INFO
        #print "Non DEBUG LOGGING"
        logging.getLogger('ncclient.transport').setLevel(logging.ERROR)
        logging.getLogger('ncclient.transport.ssh').setLevel(logging.ERROR)
        logging.getLogger('ncclient.transport.tls').setLevel(logging.ERROR)

        if flag:
            logging.getLogger('ncclient').setLevel(logging.INFO)
            logging.getLogger('rcclient').setLevel(logging.INFO)
            logging.getLogger('rcclient').setLevel(logging.INFO)

            # restclient
            logging.getLogger('rcclient').setLevel(logging.INFO)            

        else:
            logging.getLogger('ncclient').setLevel(logging.ERROR)
            logging.getLogger('rcclient').setLevel(logging.ERROR)

            # restclient
            logging.getLogger('rcclient').setLevel(logging.ERROR)            
            
        # no debug for paramiko                           
        logging.getLogger('paramiko').setLevel(logging.ERROR)
        logging.getLogger('paramiko.transport').setLevel(logging.ERROR)

            
    @staticmethod                    
    def set_indent_flag(flag=True):
        if flag == True:
            util.indent_flag =True
        else:      
            util.indent_flag =False
        
    def getElemPrefixedNameInReply(self, elem):       
        nsdict = elem.nsmap
        qtag = etree.QName(elem)  
        ns = qtag.namespace
        tag = qtag.localname

        # if not found use this one ns0, ns1, etc.
        self.namepaceIndex += 1    
        prefix = "%s%s"%(DEFAULT_NS_PREFIX, self.namepaceIndex)

        # try to find the correct one
        registeredPfx = self.get_registered_prefix(ns)
        if registeredPfx != "":
            prefix = registeredPfx
        else:
            # prefer to use whatever mapping available in the XML reply        
            for k, v in list(nsdict.items()):
                if v == ns:                
                    if k is not None:
                        prefix = k
                        break      
            
            # no registration has done so we supply the default one
            self.register_namespace(prefix, ns)
                
        return "%s:%s"%(prefix,tag)

        
    def _output2list(self, rpyElem,  resultList=[], path="", nsmap={}):     
        pfxTag = self.getElemPrefixedNameInReply(rpyElem)
        
        # make None map to the new prefix added to the previously unqualified name
        if None in rpyElem.nsmap:
            prfx = pfxTag.split(":")[0]
            nsmap[prfx] = rpyElem.nsmap[None]
            
        path = path+ "/" + pfxTag
        
        nsmap.update(rpyElem.nsmap)

        vtext = rpyElem.text
        if vtext is None:
            vtext  = ""
        else:
            vtext = vtext.strip()
                    

        # skip intermediate nodes, only keep leafs
        #if vtext != "":   
        #    resultList.append((path, vtext))
        
        if  len(rpyElem) == 0:                    
            resultList.append((path, vtext))
            
        for n in rpyElem:                        
            self._output2list(n, resultList, path, nsmap)    
            
        # remove None key
        # This will return my_dict[key] if key exists in the dictionary, and None otherwise            
        nsmap.pop(None, None)
            
        return resultList, nsmap
    
    def extract_module_qualified_node_id_and_value_from_rpc_reply(self, replyXML_or_elem):        
        nodeidLst, nsmap = self.extract_prefixed_node_id_and_value_from_rpc_reply(replyXML_or_elem)
        mnodeidLst = []
        for nid, value in nodeidLst:
            mnodeidLst.append((self.yangiid_to_segueiid(nid, nsmap), value))
        return mnodeidLst
            
    def extract_prefixed_node_id_and_value_from_rpc_reply(self, replyXML_or_elem):       
        if isinstance(replyXML_or_elem, str):            
            rpyElem = etree.fromstring(replyXML_or_elem) 
        else:
            rpyElem = replyXML_or_elem    

        # skip the top <data> element in <get> and <get-config>
        # skip the top <rpc-reply> element in <get> and <get-config>
        resList = []
        nsmap = {}
        
        for topNode in rpyElem:
            rList, rnsmap = self._output2list(topNode)
            resList.extend(rList)
            nsmap.update(rnsmap)
        
        return resList, nsmap     
        

    def getnodeIDPathSchemaTreeRoot(self, nodeElemOrNodeIDPath, nsmap):
        if isinstance(nodeElemOrNodeIDPath, str):
            firstPrefix = parse_module.getFirstPrefixInNodeIDSequence(nodeElemOrNodeIDPath)
            
        namespace = ""
        if firstPrefix in nsmap:
            namespace = nsmap[firstPrefix]
        elif firstPrefix in self.SS_YANG_Dict:
            # module identifier is used in this case
            namespace = self.SS_YANG_Dict[firstPrefix]["namespace"]
        else:
            raise Exception("%s is neither a known prefix or module identifier!")                
        # the top namespace determines which yang module it is defined in
        # including augmented nodes by other yang modules
        if namespace in self.SS_YANG_Dict:    
            treeObj = self.SS_YANG_Dict[namespace]["lxmlTreeRoot"]
            if treeObj is not None:
                return treeObj    
            else:
                DEBUGPRINT("treeObj is none")    
                    
    def get_schema_tree_elementNode_and_root(self, nodeElemOrNodeIDPath, nsmap=None):
        yangElemNode = None
        if isinstance(nodeElemOrNodeIDPath, str): 
            foundTreeRoot = self.getnodeIDPathSchemaTreeRoot(nodeElemOrNodeIDPath, nsmap)            
            if foundTreeRoot is not None:
                #ssYangTreeInst = SSYangTree(treeRoot=foundTreeRoot)           
                yangElemNode = parse_module.get_elemNode_from_IDPath(nodeElemOrNodeIDPath, 
                                    treeRoot=foundTreeRoot, nsmap=nsmap)                
        else:            
            yangElemNode =  nodeElemOrNodeIDPath
            foundTreeRoot = yangElemNode.getroottree().getroot()
                    
        if yangElemNode is None:
            raise Exception("Module that defines %s not found or hasn't been loaded!"%nodeElemOrNodeIDPath)     
        return (yangElemNode, foundTreeRoot)             
    
    def yang_property(self, nodeElemOrNodeIDPath, property, nsmap=None, union_type="", convertID=False):
        # See full list of property name in
        # ssyang tree lookup_property


        # usage: type = s.yang_lookup("/nacm:nacm/nacm:enable-nacm", "type", {"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})
        # usage: type = s.yang_lookup("/ietf-netconf-nacm:nacm/enable-nacm", "type")
        # Why placing this methid in a session?
        # because module imported without using revision  may be determined by server's hello        
                   
        yangElemNode, foundTreeRoot = self.get_schema_tree_elementNode_and_root(nodeElemOrNodeIDPath, nsmap=nsmap)
        DEBUGPRINT_SYN("nodeElemOrNodeIDPath", nodeElemOrNodeIDPath, " yangElemNode ", yangElemNode.get("name"), " foundTreeRoot ", foundTreeRoot.get("name"))
        res = parse_module.lookup_property(yangElemNode, property, 
                    foundTreeRoot, union_type,
                    Target_YANG_Dict=self.SS_YANG_Dict)
        if property == "key":
            if convertID:
                if nsmap is None or len(nsmap) ==0:
                    return [self.yangiid_to_segueiid(k, v)  for (k, v) in res]
                else:   
                    return [(self.yangiid_to_segueiid(k), self._remove_unused_nsmap(k, v)) for (k, v) in res]
        DEBUGPRINT_SYN("yang_property res: ", res)
        return res
    
        
    def get_data_tree_elementNode(self, dataRoot, iid, nsmap):
        # make sure we have valid  prefixed yang iid 
        yangiid = self.segueiid_yangiid(iid, nsmap=nsmap)
        
        # When xpath() is used on an Element, the XPath expression is evaluated against the element 
        # (if relative) or against the root tree (if absolute)
        # since IID is always absolute, we must add back the leading path /ns0:rpc-reply/nc:data
        # Event though dataRoot is <data> , it has a parent <rpc-reply> that will affect xpath! 
        #
        yangiid = "/ns0:rpc-reply/ns0:data" + yangiid   
        nsmap["ns0"] =  "urn:ietf:params:xml:ns:netconf:base:1.0"
        
        #print "nsmap ", nsmap
        #print "yangiid ", yangiid
                
        resNode = dataRoot.xpath(yangiid, namespaces=nsmap)
        if len(resNode) > 0:
            #print "resNode length: ", len(resNode) 
            if len(resNode) == 1:
                return resNode[0]
            else:
                for r in resNode:
                    DEBUGPRINT("get_data_tree_elementNode ", r.tag, "  ", r.text)
                raise Exception("More than one instance node found while locating leafref context node for %s!"%iid)
        else:    
            raise Exception("No instance node found while context node for %s!"%iid)
        
        
    def normalize_yang_xpath(self, contextNode, path, nsmap, currentNodeAbsPath=None):
        # lxml needs all node name to use a prefix, if it is in a namespace
        # update nsmap and find the prefix to use for contextNode         
        tag = etree.QName(contextNode)
        nsmap.update(contextNode.nsmap)        
        mypfx = "ns0"
        if tag.namespace in self.SS_YANG_Dict:
            mypfx = self.SS_YANG_Dict[tag.namespace]["prefix"] 
            DEBUGPRINT(" mypfx ", mypfx)       
        nsmap[mypfx] = tag.namespace
        
        # we also need to prepend <path> to the path that starts with '/'
        # since the dataElem returned in get operation starts with <data> element
        if path.startswith("/") and not path.startswith("//"):
            path = "/ns1:rpc-reply/ns1:data" + path 
            nsmap["ns1"] =  "urn:ietf:params:xml:ns:netconf:base:1.0"  
        DEBUGPRINT("original leafref path ", path)  
        
        #../../interface[name = current()/../ifname][name2 = current()/../ifname2]/address[name=current()/../../ifname3]/ip
        # first split based on [, then we have
        #../../interface  name = current()/../ifname]  name2 = current()/../ifname2]/address  name=/interface/ifname3]/ip
        # then we split based on "/", and remove the trailing ] before processing
        pathLst = path.split("[")
        newBracketSepPathLst = []
        for pt in pathLst:
            DEBUGPRINT("pt ", pt)            
            pLst = pt.split("/")
            newPathLst = []
            for p in pLst:
                if p == "":
                    # this will take care of //
                    newPathLst.append("/")
                elif p == "." or p == "..":
                    newPathLst.append(p)                
                elif p.find("=") == -1:
                    endBracket = ""
                    if p.endswith("]"):
                        endBracket = "]"
                        p=p.strip("]")
                    # only node name no predicate
                    if p.find(":") == -1:
                        p = "%s:%s"%(mypfx, p)
                    p = p + endBracket    
                    newPathLst.append(p)               
                else:
                    # contains predicate's '=' part
                    pfx, predicateVal = p.split("=")
                    pfx = pfx.strip()
                    if pfx.find(":") == -1:
                        newPfx = "%s:%s"%(mypfx, pfx)
                    else:                    
                        newPfx = pfx                  

                    # predicateVal must be current()
                    # such as name = current()
                    if currentNodeAbsPath is not None:
                        # lxml xpath does not have current() 
                        # so we replace it with the current nodes' absolute path
                        predicateVal = currentNodeAbsPath
                    else:     
                        predicateVal = predicateVal.strip()                                                
                    newPathLst.append(newPfx + "=" + predicateVal)
            newBracketSepPathLst.append("/".join(newPathLst)) 
            
        newPath = "[".join(newBracketSepPathLst)
        
        if newPath.startswith("//ns1:rpc-reply"):
            newPath = newPath[1:]
        # lxml xpath does not allow emptry namespace mapping! If this item in nsmap
        # xpath() will error out!
        if None in nsmap:
            del nsmap[None]
        return newPath   
    
    """
    def find_identity_base_elemNode(self, identityValue):
        # identityValue is given in the form modulename:identity
        # the identity may have been defined in another module
        mymodulename,  myidentityValue =    identityValue.split(":")
          
        print "check identityValue ", myidentityValue, " of ", mymodulename   
                
        treeRoots = []    
        if self.serverSupportedModules is not None:
            moduleRevs = self.serverSupportedModules.keys()
            treeRoot = None
            for moduleRev in moduleRevs:
                #if self.serverSupportedModules[moduleRev][1] != "implement":
                #    continue 
                #print "check moduleRevs ", moduleRev
                if moduleRev in self.SS_YANG_Dict:
                    AtreeObj = self.SS_YANG_Dict[moduleRev]["lxmlTreeRoot"]
                    modulename = self.SS_YANG_Dict[moduleRev]["module"]
                    if modulename == mymodulename:                        
                        if AtreeObj is None:
                            yinFile = self.SS_YANG_Dict[moduleRev]["file"]
                            # load it 
                            (AtreeObj, compileResult, loadResult) = load_yang_module(yinFile)                          
                        treeRoot = AtreeObj.getroot()
                        if treeRoot is not None:
                            treeRoots.append(treeRoot)
                                                 
            
        rbs = []
        for treeRoot in treeRoots: 
            print "treeRoot ", treeRoot.tag, " " , getArgumentValue(treeRoot)   
            identityNodesDefined = treeRoot.xpath('t:identity',  namespaces={'t': YIN10NS})
            if len(identityNodesDefined) > 0:
                for n in identityNodesDefined: 
                    #print "found n ", getArgumentValue(n), " compare to ", identityValue                        
                    if  getArgumentValue(n) == identityValue:                                                        
                        nb = n.xpath('t:base',  namespaces={'t': YIN10NS})
                        if len(nb) == 1:
                            #foundBase = getArgumentValue(nb[0])
                            print "foundBase ", getArgumentValue(nb[0])
                            rbs.append(nb[0])
                           
        # this must be an identity defined from scratch                   
        return rbs
    """
    
    # derived-from-or-self
    def is_derived_identity_of(self, value, idrefBase, identityRefNode = None, ctxElem=None, nsmap={} ):
        # ctxElem for xpath validating?
        # value modulename:identity
        # idrefBase : modulename:identity
        if identityRefNode is not None:
            nsmap  = nsmap.update(identityRefNode.nsmap)
        nsmodulenameMap={}
        if ctxElem is not None:
            mRootNode = ctxElem.getroottree().getroot()    
            DEBUGPRINT_SYN(" identityRefNode ", mRootNode.get("name"))  
            # add prefix of the identity to be checked
            if value.find(":") != "-1":
                valuePfx, _ = value.split(":")
                
                modulePrefixNode = mRootNode.xpath("yin:prefix", namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})    
                if len(modulePrefixNode):
                    mPfx = parse_module.getArgumentValue(modulePrefixNode[0])
                    if mPfx == valuePfx:
                        nsmodulenameMap[valuePfx] = mRootNode.get("name")
                        
            # add prefix is provided by imported modules 
            DEBUGPRINT_SYN("ctxElem in is_derived_identity_of ", ctxElem, " ", parse_module.getArgumentValue(ctxElem))

        if ctxElem is not None:
            importNodes  = ctxElem.getroottree().getroot().xpath("yin:import", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})
            for im in importNodes:
                DEBUGPRINT_SYN("imporetd ", getArgumentValue(im))
    
                fp = im.xpath("yin:prefix", namespaces={'yin' : "urn:ietf:params:xml:ns:yang:yin:1"})
                if len(fp):
                    nsmodulenameMap[parse_module.getArgumentValue(fp[0])] = parse_module.getArgumentValue(im)
            DEBUGPRINT_SYN("nsmodulenameMap ", nsmodulenameMap)    
            
        value = self.yangiid_to_segueiid(value, nsmap= nsmap, nsmodulenameMap=nsmodulenameMap).strip("/")
        
        DEBUGPRINT_SYN("isDerived name identity ", value)
        if value.find(":") == -1:
            raise Exception("No module name is specified for the identity %s"%value)

        if  idrefBase.find(":") == -1:
            raise Exception("No module name is specified for the identity %s"%idrefBase)

        
        basemodule, baseidentity = idrefBase.split(":")
        
        # get all identityref base
        baseChoices = self.getIdentityOfBaseType(basemodule, baseidentity)
        #aseChoices = []
        DEBUGPRINT_SYN("basemodule ", basemodule, " baseidentity" , baseidentity, " look in baseChoices ", baseChoices)
        DEBUGPRINT_SYN("Search value: ",  value)
        if value in baseChoices:
            return True
        
        return False
        
             
        
    def get_all_required_data_for_ID(self, ID, nsmap, union_type, datastore):
        allDataXMLElem = None
        DEBUGPRINT_SYN("Is config ? ", self.yang_lookup(ID, "config", 
            nsmap, union_type=union_type), " basic ", self.get_basic_mode(), 
            " support all ? ", self.is_mode_supported("report-all"))
        
        # get all data based on if ID node is config or state               
        if self.yang_lookup(ID, "config", nsmap, union_type=union_type):
            if self.get_basic_mode() == "report-all" or self.is_mode_supported("report-all"):                    
                (_, _, allDataXMLElem, _, _)  = self.sget_config(source=datastore, withDefaults="report-all")
            else:    
                (_, _, allDataXMLElem, _, _)  = self.sget_config(source=datastore)
        else:
            if self.get_basic_mode() == "report-all" or self.is_mode_supported("report-all"):
                (_, _, allDataXMLElem, _, _) =  self.sget(withDefaults="report-all")
            else:
                (_, _, allDataXMLElem, _, _) =  self.sget()
        return  allDataXMLElem
            
    def yang_lookup(self, ID, propertyName="category", nsmap={}, union_type="" ):
        DEBUGPRINT_SYN("\nyang_lookup!", "propertyName: ", propertyName, " union_type: ", union_type)
        # SEE FULL LIST OF property name in ssyangtree.lookup_property()


        # ID can be absolute schema ID (SID) or Instance ID (IID)
        # if a node's type is union, and you want to search an union type's range etc. use union_type option 
        # to specify an union subtype
        converted = False        
        if isinstance(ID, str):
            nID = self.segueiid_yangiid(ID, nsmap=nsmap)
            #logger.debug("nID to lookup" + nID)
            if nID != ID:
                converted = True
            # remove IID predicate from nID
            nID = self.strip_iid_predicate(nID)
        else:
            # elemnetNode Passed down
            nID = ID     
        return self.yang_property(nID, propertyName, nsmap, union_type, convertID=converted)

    
    # to be done
    def yang_validate_min_element(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass

    def yang_validate_max_element(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass

    def yang_validate_when(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass

    def yang_validate_must(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass

    def yang_validate_unique(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass

    def yang_validate_key(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass

    def yang_validate_default(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass

    def yang_validate_mandatory(self, ID, value, nsmap={}, union_type="", datastore="running"):
        pass
        
    def yang_validate_value(self, ID, values, nsmap={}, union_type="", datastore="running"):
        DEBUGPRINT_SYN("\nVerify iid ", ID)
        message = ""
        syntax = self.yang_lookup(ID, "base-type", nsmap, union_type)
        if syntax == "" and union_type != "":
            # The union type has no base-type, then it should be treated as base type
            syntax = union_type
        DEBUGPRINT_SYN("\ngot syntax: " + syntax + " union_type: " + union_type, " check values ", values)
        # leaflist can have a list of value
        if not isinstance(values, list) and not isinstance(values, tuple): 
            values= [values]        
        for count, value in enumerate(values):
            DEBUGPRINT_SYN("Index ", count, " Validate value: ", value)
            if syntax == "binary":
                # binary is the same as octet-string, a sequece of oectets base64 encoded 
                # check length
                length = self.yang_lookup(ID, "length", nsmap, union_type=union_type)  
                lengthLst = length.split("|")
                lengthOk = False
                for leng in lengthLst:
                    # remove spaces 
                    leng = leng.strip()
                    lengLst =  leng.split("..")
                
                    # 'length' . 'range' will always return normalized form  like a..b | c..c                
                    if len(value) < int(lengLst[0].strip()):
                        return (False, "Wrong binary octets length. Allowed length %s"%length)
                
                    if len(value) <= int(lengLst[1].strip()):
                        lengthOk = True
                        break
 
                if not lengthOk:
                    DEBUGPRINT_SYN("Result: " , False) 
                    return (False, "Out of the allowed %s length %s."%(union_type, length))
                
                #return(True, "") 
            
            elif syntax == "bits":
                bits = self.yang_lookup(ID, "bit", nsmap, union_type=union_type)            
                bitsLst = bits.split()
            
                # bit value is a space separated value
                valueLst = value.split()
                for val in valueLst:
                    if val not in bitsLst:
                        DEBUGPRINT_SYN("Result: " , False) 
                        return (False, "No such bit defined!")
                #return (True, "")            
            
            elif syntax == "boolean":
                if value not in ["false", "true"]:
                    message = message + "boolean value must be lowercase 'false' or 'true'."
                    DEBUGPRINT_SYN("Result: " , False) 
                    return (False, message) 
                #return (True, "")
            elif syntax == "enumeration":
                enums = self.yang_lookup(ID, "enum", nsmap, union_type=union_type)            
                enumsLst = enums.split()
                DEBUGPRINT_SYN("enumsLst ", enumsLst)
                if value not in enumsLst:
                    DEBUGPRINT_SYN("Result: " , False) 
                    return (False, "No such enumeration defined!")
                
                #return (True, "")            
            elif syntax == "empty":
                if value != "":
                    DEBUGPRINT_SYN("Result: " , False) 
                    return (False, "Not empty!")
                #return (True, "")    
                    
            elif syntax == "identityref":
                idrefBase = self.yang_lookup(ID, "base", nsmap, union_type=union_type)
                DEBUGPRINT_SYN("idrefBase found: ", idrefBase)
                DEBUGPRINT_SYN("value to look ", value, " for ID ", ID, " map ", nsmap)
                if value.find(":") == -1:
                    _, rootNode = self.get_schema_tree_elementNode_and_root(ID, nsmap)
                    value = rootNode.get("name") + ":" + value
                    nsmap.update(rootNode.nsmap)
                DEBUGPRINT_SYN("value obtained: ", value)    
                # check if foundBase is derivef from idrefBase                
                if not self.is_derived_identity_of(value, idrefBase, nsmap=nsmap): 
                    DEBUGPRINT_SYN("Result: " , False)                                  
                    return (False, "No matching identity %s supported by the server found!"%value)                
                #return (True, "")                    
                  
            elif syntax == "instance-identifier":
                oldValue =value
                requireInstance = self.yang_lookup(ID, "require-instance", nsmap, union_type=union_type)
            
                DEBUGPRINT_SYN("requireInstance: ", requireInstance)
                if requireInstance == "true" or requireInstance=="":
                    # get corresponding instance node  
                    allDataXMLElem = self.get_all_required_data_for_ID(ID, nsmap, union_type,datastore)                
                    # the nsmap may be updated by get_data_tree_elementNode!
                    contextNode = self.get_data_tree_elementNode(allDataXMLElem, ID, nsmap)                
                    # normalize xpath express by adding <reply> <date> element etc,                
                    value = self.normalize_yang_xpath(contextNode, value, nsmap)
                    DEBUGPRINT_SYN("normalized value ", value, " nsmap ", nsmap)
                    # xpath matching         
                    # since IID starts with / so the matching will be againt the root element
                    matchNodes = contextNode.xpath(value, namespaces=nsmap)
                    if len(matchNodes) == 0:
                        return (False, "The instance identifier value %s of ID %s does not exist or invalid!"%(oldValue, ID))
                    DEBUGPRINT_SYN("matched node count %s ", len(matchNodes))
                    #return (True, "") 

                else:                
                    if not isInstanceID(value):
                        DEBUGPRINT_SYN("Result: " , False) 
                        return(False, "Not a valid instance identifier value %s"%oldValue)
                #return (True, "")
        
            elif syntax == "leafref":
                logger.debug("check leafref ID " + ID)
                # All leafref nodes MUST reference
                # existing leaf instances or leafs with default values in use for the data to be valid. 
                # get path
                oldPath = self.yang_lookup(ID, "path", nsmap, union_type=union_type)            
                # get all data                        
                # get corresponding instance node  
                allDataXMLElem = self.get_all_required_data_for_ID(ID, nsmap, union_type,datastore)                    
                #DEBUGPRINT("got allDataXMLElem ", etree.tostring(allDataXMLElem))
                # since the root in allDataXMLElem returned is the <data> element, so if the path usng absolute path "/a/b/c"
                # then it would never match
                # we need to add the <data> as the leading element before searching
                # leafref 'path' needs to be placed into the current module's namespace            
            
                # we need a proc to add "prefix" to the path that does not contain any prefix (namespace)
                # lxml xpath must use a prefix if the related data is in a namespace!         
                # find contextNode

                # the nsmap may be updated by get_data_tree_elementNode!
                contextNode = self.get_data_tree_elementNode(allDataXMLElem, ID, nsmap)
            
                # normalize path for lxml          
                # the nsmap may be updated by get_data_tree_elementNode!

                # ElementTree objects have a method getpath(element), 
                # which returns a structural, absolute XPath expression 
                # to find that element:
                # we use this to replace current()
            
                currentNodeAbsPath = contextNode.getroottree().getpath(contextNode)
                DEBUGPRINT_SYN("currentNodeAbsPath ", currentNodeAbsPath)            
                path = self.normalize_yang_xpath(contextNode, oldPath, nsmap, currentNodeAbsPath=currentNodeAbsPath)
                DEBUGPRINT_SYN("normalized path: ", path)
                DEBUGPRINT_SYN("nsmap ", nsmap)
                        
                # xpath matching       
                DEBUGPRINT_SYN("contextNode parent ", contextNode.getparent(), " ", contextNode.getparent().getparent())  
                matchNodes = contextNode.xpath(path, namespaces=nsmap)
                DEBUGPRINT_SYN("matchNodes ", matchNodes)
                foundMatch = False
                if len(matchNodes) > 0:
                    # check if any value in the found nodes is the same as leafrefed
                    for mn in matchNodes:
                        mnVal = mn.text
                        DEBUGPRINT_SYN("mnVal ", mnVal)
                        if mnVal.strip() == value:
                            foundMatch = True
                            break
                if not foundMatch:                    
                    DEBUGPRINT_SYN("Result: " , False) 
                    return (False, "The leaf referenced by path %s of leafref %s does not exist!"%(oldPath, ID))
                        
            elif syntax == "string":
                # check pattern
                patterns = self.yang_lookup(ID, "pattern", nsmap, union_type=union_type)  
            
                # When a string representing a union data type is validated, the string
                # is validated against each member type, in the order they are
                # specified in the "type" statement, until a match is found.            
                for pt in patterns:
                    DEBUGPRINT_SYN("check value: " + value + " against pattern: "+ pt)
                    # use regexp to match patter
                    # A period (.) matches any character except a newline character.
                
                    # A string of characters enclosed in square brackets ([]) matches any 
                    # one character in that string. If the first character in the brackets
                    # is a caret (^), it matches any character except those in the string. 
                    # For example, [abc] matches a, b, or c, but not x, y, or z. However,
                    # [^abc] matches x, y, or z, but not a, b, or c.
                    #
                    # https://stackoverflow.com/questions/2428117/casting-raw-strings-python
                    rpt = r"^%s$"%pt
                    #p = regex.compile(rpt)
                    if regex.match(rpt, value) is None:
                        # If the type has multiple "pattern" statements, the expressions are
                        # ANDed together, i.e., all such expressions have to match.
                        return (False, "Unmatched %s pattern %s"%(union_type, pt))            
                    
                # check length
                length = self.yang_lookup(ID, "length", nsmap, union_type=union_type)  
                lengthLst = [] if length==""  else length.split("|")
            
                lengthOk = False
                for leng in lengthLst:
                    # remove spaces 
                    leng = leng.strip()
                    lengLst =  leng.split("..")
                
                    # 'length' . 'range' will always return normalized form  like a..b | c..c                
                    if len(value) < int(lengLst[0].strip()):
                        DEBUGPRINT_SYN("Result: " , False) 
                        return (False, "Wrong string length. Allowed length %s"%length)
                
                    if len(value) <= int(lengLst[1].strip()):
                        lengthOk = True
                        break
 
                if not lengthOk and length !="":
                    DEBUGPRINT_SYN("Result: " , False) 
                    return (False, "Out of the allowed %s length %s."%(union_type, length))                
                #return(True, "")                            
            elif syntax in numerical_builtin_types:
                # check the value is an integer type or decimal64
                if syntax != "decimal64":
                    if not isIntValue(value):
                        DEBUGPRINT_SYN("Result: " , False) 
                        return (False, "Not a valid numerical value %s!"%value) 
                else:
                    if isFloatValue(value):
                        DEBUGPRINT_SYN("Result: " , False)     
                        return (False, "Not a valid decimal64 value %s!"%value)
                # check range
                range_s = self.yang_lookup(ID, "range", nsmap, union_type=union_type)  
                rangeLst = range_s.split("|")
                DEBUGPRINT_SYN("checking if value "+ value + " is in the defined range " + range_s)

                rangeOk = False
                for range in rangeLst:
                    # remove spaces 
                    ran = range.strip()
                    ranLst =  ran.split("..")
                    # 'length' . 'range' will always return normalized form  like a..b | c..c
                    #if len(lengLst) == 1:
                    #    lengLst.append(lengLst[0])                    
                
                    lowerVal = ranLst[0].strip()
                    upperVal = ranLst[1].strip()
                
                    if lowerVal.find(".") != -1:
                        # decimal64 type
                        lowerVal = decimal.Decimal(lowerVal)
                        value = decimal.Decimal(value)
                    else:
                        lowerVal = int(lowerVal)
                        value = int(value)
                    
                    if upperVal.find(".") != -1:
                        # decimal64 type
                       upperVal = decimal.Decimal(upperVal)
                       value = decimal.Decimal(value)
                    else:
                       upperVal = int(upperVal)
                       value = int(value)
                        
                    if value < lowerVal:
                        DEBUGPRINT_SYN("Result: " , False) 
                        return (False, "Wrong value range. Allowed range %s"%range_s)
                
                    if value <= upperVal:
                        rangeOk = True
                        break
 
                if not rangeOk:
                    DEBUGPRINT_SYN("Result: " , False) 
                    return (False, "Out of the allowed %s range %s."%(union_type, range_s))                
                #return(True, "")             
            elif syntax == "union":
                DEBUGPRINT_SYN("Check union syntax ")
                # this is a union, find out what are alowed type in this union 
                usyntax = self.yang_lookup(ID, "union-type", nsmap)
                unionRes = False            
                unionResMsg = ""            
                for usyn in usyntax.split():                    
                    resFlag, resMsg = self.yang_validate_value(ID, value, nsmap=nsmap, union_type=usyn)
                    DEBUGPRINT_SYN("Union syntax " + usyn + " against val: " + value, " Res: ", resFlag)
                    if resFlag:
                        unionRes = True
                        break
                    else:
                        unionResMsg =  resMsg + "\n" + unionResMsg 
            
                if not unionRes:
                    DEBUGPRINT_SYN("Result: " , False, "msg: ",unionResMsg ) 
                    return (False, unionResMsg)          
                #return(True, "")       
            else:
                #return (False, "No syntax definition found!")    
                raise Exception("No syntax specified to look up!")   
        DEBUGPRINT_SYN("Result: " , True)                 
        return(True, "")   

    def is_capability_supported(self, cap, version=""):
        # return (True , parameters) or False
        if cap[0] != ':':
            # in case the cap is not entered with a leading :
            cap = ":" + cap
        
        if version != "":    
            cap = cap + ":" + version
        # ':with-defaults:1.0': 'basic-mode=explicit also-supported=report-all,report-all-tagged,trim,explicit',    
        if cap in self.serverSupportedCaps:
            return (True, self.serverSupportedCaps[cap])
        else:
            return False
            
        
    def is_module_implemented(self, module, version=""):
        # return (True, namespace) or False
        #serverSupportedModules =     
        if version != "":
            module = module + "&" + version
            
        if module in self.serverSupportedModules:
            #return namespace
            if self.serverSupportedModules[module][1] != "import":
                return (True, self.serverSupportedModules[module][0])
        else:
            return False
                
    def get_basic_mode(self):
        #
        # there are two keys for the same cap 
        #':with-defaults': ('1.0', 'basic-mode=explicit also-supported=report-all,report-all-tagged,trim,explicit'), ':interleave:1.0': '', ':base': ('1.1', ''), ':writable-running:1.0': '', ':candidate:1.0': '', ':validate:1.0': '', ':validate:1.1': '', ':rollback-on-error:1.0': '', ':rollback-on-error': ('1.0', ''), ':startup': ('1.0', ''), ':candidate': ('1.0', '')}
        #':with-defaults:1.0': 'basic-mode=explicit also-supported=report-all,report-all-tagged,trim,explicit', 
        # 
        basicMode = ""
        if self.is_capability_supported("with-defaults") != False:
            # basic-mode=explicit also-supported=report-all,report-all-tagged,trim,explicit                
            _, parameter = self.is_capability_supported("with-defaults")
            if isinstance(parameter, str):                
                basicModePart, alsoSupportPart  = parameter.split()[0]
            else:
                parameter = parameter[1]
                basicModePart, alsoSupportPart  = parameter.split()    
            basicMode = basicModePart.split("=")[1]
        return basicMode
        
    def is_mode_supported(self, mode):
        if self.is_capability_supported("with-defaults") != False:
            # basic-mode=explicit also-supported=report-all,report-all-tagged,trim,explicit                
            _, parameter = self.is_capability_supported("with-defaults")
            if isinstance(parameter, str):                
                basicModePart, alsoSupportPart  = parameter.split()[0]
            else:
                parameter = parameter[1]
                basicModePart, alsoSupportPart  = parameter.split()    
            basicMode = basicModePart.split("=")[1]
            if basicMode == mode.lower():
                return True
                    
            alsoSupport = alsoSupportPart.split("=")[1] 
            alsoSupportLst = alsoSupport.split(",")
            if mode.lower() in alsoSupportLst:
                return True
        return False   


    def getIdentityOfBaseType(self, baseIdentModuleName,  baseIdentName):
        # base passed down is of form: module:identityname
        # scan all supported modules and find identities
        #print "YIN dict ",  self.SS_YANG_Dict
        key = baseIdentModuleName  + ":" + baseIdentName
        if key not in self.identityDict:
            searchForIdentitiesOfBase(self, baseIdentModuleName, baseIdentName, self.serverSupportedModules, self.identityDict)
            self.identityDict[key].sort()
            
        identiyFound =  self.identityDict[key]            
        return identiyFound
        
        
        
    # RESTCONF 3.1.  Root Resource Discovery    
    # When first connecting to a RESTCONF server, a RESTCONF client MUST
    # determine the root of the RESTCONF API.  There MUST be exactly one
    # "restconf" link relation returned by the device.        
   
    def retrieveRootResourceIfHasnt(self):    
        if not hasattr(self, "retrieveRootResourceDone") or self.retrieveRootResourceDone :
            return 
        else:
            self.retrieveRootResourceDone = True
        
        #DEBUGPRINT("Retrieving .... ")
        # Requests: Sometimes you'll want to omit session-level keys 
        # from a dict parameter. To do this, you simply 
        # set that key's value to None in the method-level 
        # parameter. It will automatically be omitted.

        rootResource = ""

        r=self.requests_session.get("/.well-known/host-meta", 
            headers={'Content-Type': None, 'Accept': 'application/xrd+xml'})
        #print "request url: ", r.request.url
        #print "request body: ", r.request.body
        #print "request headers: ", r.request.headers 
        common_global_variables.SSDEBUG = True
        DEBUGPRINT("resource discovery result: ", r.text)
        #print "result code: ", r.status_code
        #print "result reason: ", r.reason
        DEBUGPRINT("useDefaultRootResource ", self.useDefaultRootResource)
        common_global_variables.SSDEBUG = False

        if  isinstance(r, Exception):
            DEBUGPRINT("Got exception ", "\n", traceback.format_exc())
            raise r   
                     
        if r :
            if r.status_code == 200:
                #r.text = "<XRD xmlns='http://docs.oasis-open.org/ns/xri/xrd-1.0'><Link rel='restconf' href='/restconf'/></XRD>"
                rtext = r.text
                #rtext = "<XRD xmlns='http://docs.oasis-open.org/ns/xri/xrd-1.0'><Link rel='restconf' href='/restconf'/></XRD>"            
                relem = etree.fromstring(rtext)
                for rele in relem:
                    if rele.get("rel") == "restconf":
                        rootResource =  relem[0].get("href")
                    #if rele.get("rel") == "restconf2":
                    #    rootResource2 =  relem[0].get("href")                        
        else:  
            rootResource = ""          
            if 'wx' in sys.modules: 
                import wx     
                wx.MessageBox("GET /.well-known/host-meta failed! Use default \n%s"%(r.text, ),
                                "Error", wx.OK | wx.ICON_ERROR)                        
            else:
                print("GET /.well-known/host-meta failed! use default \n%s"%r.text)

        if self.useDefaultRootResource.upper() == "YES":
            rootResource = self.defaultRootResource #default
            
        self.requests_session.root_resource = rootResource
        self.rootResource = rootResource
        return 
                     
    @property
    def session(self):
        "SSHSession or TLSSsession of this netconf session."
        return self.ncmgr._session
        
    
    @property
    def server_capabilities_dict_tuple(self):
        ":class:`~ncclient.capabilities.Capabilities` object representing the server's capabilities."
        "(self.serverSupportedModules, self.serverSupportedCaps)"        
        return parse_server_capabilities(self)
        
    @property
    def serverSupportedModules(self):
        ":class:`~ncclient.capabilities.Capabilities` object representing the server's capabilities."
        if self.serverSupportedModulesValue is None:
            if  self.restconfSession:
                self.serverSupportedModulesValue, _ = parse_restconf_server_capabilities(self)
            else:    
                self.serverSupportedModulesValue, _ = parse_server_capabilities(self)
        return self.serverSupportedModulesValue
    

    @property
    def serverYangLibraryModules(self):
        if self.yang_library_dict is None:
            parse_server_capabilities(self)
        return self.yang_library_dict
                
            
    @property
    def serverSupportedCaps(self):
        ":class:`~ncclient.capabilities.Capabilities` object representing the server's capabilities."
        if self.serverSupportedCapValue is None:
            if  self.restconfSession:
                _, self.serverSupportedCapValue = parse_restconf_server_capabilities(self)
            else:    
                _, self.serverSupportedCapValue = parse_server_capabilities(self)
        return self.serverSupportedCapValue

    # return original ncclient capabilities 
    @property
    def client_capabilities(self):
        ":class:`~ncclient.capabilities.Capabilities` object representing the client's capabilities."
        return self.ncmgr._session._client_capabilities
        
    @property
    def server_capabilities(self):
        ":class:`~ncclient.capabilities.Capabilities` object representing the server's capabilities."
        if hasattr(self.ncmgr, "session")  and  self.ncmgr.session is None:
            # this must an internal_testing session
            return {}
        else:
            if hasattr(self.ncmgr, "_session") and hasattr(self.ncmgr._session, "_server_capabilities"):     
                return self.ncmgr._session._server_capabilities
            else:
                return {}
        """
        
        if  self.ncmgr.session is None:
            # this must an internal_testing session
            return {}
        else:  
            return self.ncmgr._session._server_capabilities
        """    

    @property
    def session_id(self):
        "`session-id` assigned by the NETCONF server."
        return self.ncmgr._session.id
    
    @property
    def session_ciphers(self):
        "`session_ciphers` supported by openSSL."
        return self.ncmgr._session.ciphers


    @property
    def connected(self):
        "Whether currently connected to the NETCONF server."
        return self.ncmgr._session.connected

    #@property
    #def host(self):
    #    return self.ncmgr._session._host
                
    #@property    
    #def raise_mode(self):
    #    return self.ncmgr._raise_mode
    #@raise_mode.setter
    #def raise_mode(self, mode):
    #    self.ncmgr._raise_mode = mode
                
    # the following two can be configured/set after session has been created        
    @property
    def timeout(self):
        return self.ncmgr._timeout        
    @timeout.setter
    def timeout(self,n):        
        self.ncmgr._timeout = n
        
    def get_active_netconf_version(self):
        if self.ncmgr.session._delim_ver == 1:
            return "1.0"
        elif self.ncmgr.session._delim_ver == 2:
            return "1.1"
        
        
    @property
    def keep_alive(self):
        return self._keep_alive        
    @keep_alive.setter
    def keep_alive(self,n):        
        self.ncmgr.session.transport.set_keepalive(n)     
        
        
