'''
Created on Mar 6, 2015

@author: seguesoft Inc.
'''
from tokenize import group
from lxml import etree
import os, sys, re, platform
import tempfile, subprocess
import threading
import tempfile

from matplotlib.pyplot import csd
import ssmanager
import common_global_variables
import parse_module
from parse_module import build_nodeIDAndValDictList
from parse_module import build_yang_nodeID_dict
from ssyangtree import SSYangTree
from parse_module import addTrimSpaceListPredicate
import robot, regex
from robot.libraries.BuiltIn import BuiltIn
from robot.api import logger as rblogger
import pathlib
from configobj import ConfigObj
import uriValidate
import logging
if platform.system() == "Windows":
    import win32api

logger = logging.getLogger(__name__)

#import logging_tree
#logging_tree.printout()


class ConfTestClient(object):
    # The leading "_" is a convention used 
    # by Robotframework to 
    # indicate the procedure is not exported 
    # as a keyworkd
    def __init__(self, **kwargs):
        """
        yang_modpath = "",
        #use_netconf_1_dot_1 = True,
        #use_netconf_1_dot_0 = False,  
        netconf_version = "1.1",       # "1.0" or "1.1
        #dataStoreType = "classic",     # classic or ndma
        modulesToTest="ietf-netconf-monitoring@2010-10-04,ietf-netconf-acm@2012-02-22",                
        connType="SSH", 
        host="seguesoft.com",
        port=830, 
        user="testconf", 
        password="testconf2",
        ssh_privkey_file="",                
        chsshport= 4334, 
        timeout = 15,
        keep_alive = 300,
        customCaps=None,
        tlsPort=6513,
        chtlsport =4335, 
        trustedCerts="", 
        clientCert="", 
        clientKey="",
        httpVersion = "1.1",
        httpPort = 8443,
        httpCertVerify ="Yes",
        httpUser = "",
        httpPassword = "", 
        useScheme ="HTTPS",
        authType ="Basic",
        dataEncoding = "JSON",
        httpClientCert = "",
        httpClientKey = "",
        httpTrustedCerts = "",
        chrestport  = 4336,
        defaultRootResource ="",
        useDefaultRootResource ="No",
        socksServer="", 
        socksPort=1080, 
        socksType="SOCKS5", 
        socksUser="", 
        socksPassword=""
        """

        # Retrieve the particular test result dirname for this running
        # intance of RIDE. The DUT info and modules to tests for this
        # particular RIDE instance are stored there when the RIDE is
        # invoked. The --outpurdir x in RIDE's "Arguments" links
        #  
        if platform.system() == "Windows":
            self.configfile = \
                os.path.expandvars("%APPDATA%\\Seguesoft\\GUITools\\settings.cfg")
        else:
            self.configfile = \
                os.path.expanduser("~/.seguesoft/GUITools/settings.cfg")

        dirname = os.path.dirname(self.configfile)
        pathlib.Path(dirname).mkdir(parents=True, exist_ok=True)

        # Robotframework used configObj, while 
        # netconfc preferences uses config            
        config = ConfigObj(self.configfile, unrepr=True,  encoding='utf-8')

        curVal = ""
        if "robot_arguments" in config["Plugins"]["Test Runner"]:
            curVal = config["Plugins"]["Test Runner"]["robot_arguments"]

        self.testResDirName = ""
        if curVal.find("--outputdir") != -1:
            match =  regex.search(' --outputdir +(\S+)', curVal)            
            if match != None:
                # match.group(0) always returns the fully matched string 
                # match.group(1) match.group(2), ... return the capture 
                # groups in order from left to right in the input string 
                # match.group() is equivalent to match.group(0) 
                self.testResDirName = match.group(1)

        self.testConfigFileName = \
            os.path.join(self.testResDirName, "segue_netconfc_preferences.ini")
        #print("testConfigFileName file", self.testConfigFileName)
        #print("is file ? ", os.path.isfile(self.testConfigFileName))

        # Order of prefrenece: (e.g.):
        # 1) yang_path passed in kwargs 2) NETCONFc preference file 
        # 3) Robotframework commnand line variable passed down (like when
        #    running tests in CLI)
        self.preferences = common_global_variables.obtainPreferencesObj(
                self.testConfigFileName,
                common_global_variables.MasterYANGdefaultPreferenceDict)   

        if "netconf_version" not in kwargs:
            netconfVersion11=self.preferences.get("Main", "use_netconf_1_dot_1")
            netconfVersion10=self.preferences.get("Main", "use_netconf_1_dot_0")
            netconf_version= "1.0"            
            if netconfVersion11:
                netconf_version= "1.1"
        else:
            netconf_version = kwargs["netconf_version"]

        if "yang_modpath" not in kwargs:
            yang_modpath = self.preferences.get("Main", "YANG_MODPATH")
        else:
            yang_modpath =  kwargs["yang_modpath"]

        if "modulesToTest" not in kwargs:
            modulesToTest = self.preferences.get("Main", "selectedModules")
        else:
            modulesToTest =  kwargs["modulesToTest"] 

        if "connType" not in kwargs:            
            connType = self.preferences.get("Main", "ActiveSessionType")
        else:
            connType = kwargs["connType"] 

        if "host" not in kwargs:
            host  =  self.preferences.get("Main", "ssh_host")
        else:
            host = kwargs["host"]

        if "port" not in kwargs:    
            port  =  self.preferences.get("Main", "ssh_port")  
        else:
            port = kwargs["port"]

        if "chsshport" not in kwargs:               
            chsshport  =  self.preferences.get("Main", "callhome_ssh_port")
        else:
            chsshport  = kwargs["chsshport"]  

        if "user" not in kwargs:    
            user = self.preferences.get("Main", "ssh_user_name")
        else:
            user = kwargs["user"]    

        if "password" not in kwargs:                
            password = self.preferences.get("Main", "ssh_user_password")
        else:
            password = kwargs["password"]

        if "ssh_privkey_file" not in kwargs:
            ssh_privkey_file =  self.preferences.get("Main", "ssh_privkey_file")
        else:
            ssh_privkey_file = kwargs["ssh_privkey_file"]

        if "timeout" not in kwargs:    
            timeout = self.preferences.get("Main", "ssh_timeout")
        else:
            timeout = kwargs["timeout"]

        if "keep_alive" not in kwargs:        
            keep_alive =self.preferences.get("Main", "ssh_keep_alive")
        else:
            keep_alive = kwargs["keep_alive"]

        if "customCaps" not in kwargs:
            customCaps =  self.preferences.get("Main", "add_custom_caps")     
        else:
            customCaps = kwargs["customCaps"]

        if "tlsPort" not in kwargs:
            tlsPort  =  self.preferences.get("Main", "tls_port")
        else:
            tlsPort = kwargs["tlsPort"]

        if "chtlsport" not in kwargs:                    
            chtlsport  =  self.preferences.get("Main", "callhome_tls_port")
        else:
            chtlsport = kwargs["chtlsport"]

        if "clientCert" not in kwargs:   
            clientCert = self.preferences.get("Main", "client_cert")
        else:
            clientCert = kwargs["clientCert"]

        if "clientKey" not in kwargs:    
            clientKey = self.preferences.get("Main", "client_key")
        else:
            clientKey = kwargs["clientKey"]

        if "trustedCerts" not in kwargs: 
            trustedCerts = self.preferences.get("Main", "trusted_certs")                
        else:
            trustedCerts = kwargs["trustedCerts"]

        if "httpVersion" not in kwargs:    
            httpVersion = self.preferences.get("Main", "http_version")
        else:
            httpVersion = kwargs["httpVersion"]

        if "httpPort" not in kwargs:   
            httpPort = self.preferences.get("Main", "http_port")       
        else:
            httpPort = kwargs["httpPort"]

        if "httpCertVerify"  not in kwargs:   
            httpCertVerify = self.preferences.get("Main", "http_cert_verify")
        else:
            httpCertVerify  =kwargs["httpCertVerify"]

        if "httpUser" not in kwargs:   
            httpUser = self.preferences.get("Main", "http_user_name")
        else:
            httpUser = kwargs["httpUser"]

        if "httpPassword" not in kwargs:                
            httpPassword = self.preferences.get("Main", "http_user_password")       
        else:
            httpPassword = kwargs["httpPassword"]

        if "useScheme" not in kwargs:    
            useScheme = self.preferences.get("Main", "use_scheme")
        else:
            useScheme = kwargs["useScheme"]

        if "authType" not in kwargs:
            authType = self.preferences.get("Main", "http_auth")
        else:
            authType = kwargs["authType"]

        if "dataEncoding" not in kwargs:     
            dataEncoding = self.preferences.get("Main", "data_encoding")
        else:
            dataEncoding = kwargs["dataEncoding"]

        if "httpClientCert" not in kwargs:      
            httpClientCert = self.preferences.get("Main", "http_client_cert")
        else:
            httpClientCert = kwargs["httpClientCert"]

        if "httpClientKey" not in kwargs:  
            httpClientKey = self.preferences.get("Main", "http_client_key")
        else:
            httpClientKey = kwargs["httpClientKey"]

        if "httpTrustedCerts" not in kwargs:  
            httpTrustedCerts = self.preferences.get("Main", "http_trusted_certs")           
        else:
            httpTrustedCerts = kwargs["httpTrustedCerts"]

        if "defaultRootResource" not in kwargs:   
            defaultRootResource = self.preferences.get("Main", "defaultRootResource")
        else:
            defaultRootResource = kwargs["defaultRootResource"]

        if "useDefaultRootResource" not in kwargs:    
            useDefaultRootResource = self.preferences.get("Main", "useDefaultRootResource")
        else:
            useDefaultRootResource = kwargs["useDefaultRootResource"]

        if "chrestport" not in kwargs:    
            chrestport  =  self.preferences.get("Main", "callhome_rest_port")     
        else:
            chrestport = kwargs["chrestport"]

        if "socksServer" not in kwargs:    
            socksServer = self.preferences.get("Main", "socks_server")
        else:
            socksServer = kwargs["socksServer"]

        if "socksPort" not in kwargs:        
            socksPort = self.preferences.get("Main", "socks_port")
        else:
            socksPort = kwargs["socksPort"]

        if "socksType" not in kwargs:  
            socksType = self.preferences.get("Main", "socks_type")
        else:
            socksType = kwargs["socksType"]

        if "socksUser" not in kwargs:      
            socksUser = self.preferences.get("Main", "socks_user")
        else:
            socksUser = kwargs["socksUser"]

        if "socksPassword" not in kwargs:      
            socksPassword = self.preferences.get("Main", "socks_password")
        else:
            socksPassword = kwargs["socksPassword"]
            
        # Give priority to the values passed in from robotframework
        # command line --variable param:value
        self.netconfVersion = BuiltIn().get_variable_value("${netconfVersion}", netconf_version)
        #print("netconfVersion ", self.netconfVersion)

        self.yangModulePath = BuiltIn().get_variable_value("${yangModulePath}", yang_modpath)
        #print("YANG Module Path ", self.yangModulePath)
        self.modulesToTest = BuiltIn().get_variable_value("${modulesToTest}", modulesToTest)
        if not isinstance(self.modulesToTest, list):
            # must be passed down from --variables moda,modb
            self.modulesToTest = self.modulesToTest.split(",")
        #print("YANG Moddules selected to be tested by running 'Standard' tests: ", self.modulesToTest)           
        
        #dataStoreType = common_global_variables.dataStoreRadio1       
        #if dataStoreType == "ndma":
        #    dataStoreType = common_global_variables.dataStoreRadio2
        #self.dataStoreType = BuiltIn().get_variable_value("${dataStoreType}", dataStoreType)
        #print("dataStoreType ", self.dataStoreType)           
                     
        self.connType = BuiltIn().get_variable_value("${connType}", connType).lower()
        #print("connType:", self.connType)
        self.host = BuiltIn().get_variable_value("${host}", host)
        self.port =   BuiltIn().get_variable_value("${port}", port)
        self.user =   BuiltIn().get_variable_value("${user}", user)
        self.password = BuiltIn().get_variable_value("${password}", password)
        #print("host port user password:", self.host, self.port, self.user, self.password)
        self.chsshport =BuiltIn().get_variable_value("${sshCallHomePort}", chsshport)
        #print("sshCallHomePort ", chsshport)
        self.sshPrivKeyFile = BuiltIn().get_variable_value("${sshPrivKeyFile}", ssh_privkey_file)
        #print("sshPrivKeyFile ", self.sshPrivKeyFile)
        self.timeout =  BuiltIn().get_variable_value("${timeout}", timeout)
        #print("timeout ", self.timeout)        
        self.keepAlive = BuiltIn().get_variable_value("${keepAlive}", keep_alive)
        #print("keepAlive ", self.keepAlive)                    
        self.customCaps = BuiltIn().get_variable_value("${customCaps}", customCaps)     
        #print("customCaps ", self.customCaps)

        self.tlsPort =    BuiltIn().get_variable_value("${tlsPort}", tlsPort)
        #print("tlsPort:", self.tlsPort)        
        self.chtlsport =    BuiltIn().get_variable_value("${tlsCallHomePort}", chtlsport)  
        #print("chtlsport :", self.chtlsport)        
        self.clientCert =    BuiltIn().get_variable_value("${clientCert}", clientCert)  
        #print("clientCert :", self.clientCert)
        self.clientKey =    BuiltIn().get_variable_value("${clientKey}", clientKey)  
        #print("clientKey :", self.clientKey) 
        self.trustedCerts =    BuiltIn().get_variable_value("${trustedCerts}", trustedCerts)  
        #print("trustedCerts :", self.trustedCerts)         

        self.httpVersion = BuiltIn().get_variable_value("${httpVersion}", httpVersion)
        self.httpPort = BuiltIn().get_variable_value("${httpPort}", httpPort)
        self.httpCertVerify = BuiltIn().get_variable_value("${httpCertVerify}", httpCertVerify)
        self.httpUser = BuiltIn().get_variable_value("${httpUser}", httpUser)
        self.httpPassword = BuiltIn().get_variable_value("${httpPassword}", httpPassword)
        self.useScheme = BuiltIn().get_variable_value("${useScheme}", useScheme)
        self.authType = BuiltIn().get_variable_value("${authType}", authType)
        self.dataEncoding = BuiltIn().get_variable_value("${dataEncoding}", dataEncoding)
        self.httpClientCert = BuiltIn().get_variable_value("${httpClientCert}", httpClientCert)
        self.httpClientCert = BuiltIn().get_variable_value("${httpClientCert}", httpClientCert)
        self.httpClientKey = BuiltIn().get_variable_value("${httpClientKey}", httpClientKey)
        self.httpTrustedCerts = BuiltIn().get_variable_value("${httpTrustedCerts}", httpTrustedCerts)
        self.defaultRootResource = BuiltIn().get_variable_value("${defaultRootResource}", defaultRootResource)
        self.useDefaultRootResource = BuiltIn().get_variable_value("${useDefaultRootResource}", useDefaultRootResource)
        self.chrestport = BuiltIn().get_variable_value("${chrestport}", chrestport)

        self.socksServer = BuiltIn().get_variable_value("${socksServer}", socksServer)
        self.socksPort =   BuiltIn().get_variable_value("${socksPort}", socksPort)
        self.socksType =  BuiltIn().get_variable_value("${socksType}", socksType)
        self.socksUser =  BuiltIn().get_variable_value("${socksUser}", socksUser)
        self.socksPassword = BuiltIn().get_variable_value("${socksPassword}", socksPassword)
        #print("socksServer :", self.socksServer)  
        #print("socksPort :", self.socksPort)  
        #print("socksType :", self.socksType)  
        #print("socksUser :", self.socksUser)  
        #print("socksPassword :", self.socksPassword)  
        """
        # create tmp cert and key files
        self.caCert = ""
        cacert =   robot.libraries.BuiltIn.BuiltIn().get_variable_value("${DUT_CA_CERT}", "")   
        #sys.stderr.write('MY CA %s\n\n'%cacert)
        cacertFile =   robot.libraries.BuiltIn.BuiltIn().get_variable_value("${DUT_CA_CERT_FILE}", cacertFile)   

        #sys.stderr.write('init got caCertFile %s\n'%cacertFile)          
        if cacert == "":
            if os.path.isfile(cacertFile):
                with open(cacertFile, 'r') as myfile:
                    cacert=myfile.read()
            elif cacertFile != "" :
                raise Exception("CA Cert File not found %s!"%cacertFile)       
        
        #sys.stderr.write('aaaa%s\n'%cacert)
        if cacert != "":
            f = tempfile.NamedTemporaryFile(delete=False)                    
            f.write(cacert.encode())
            f.close()
            #sys.stderr.write('aaaa%s\n'%f.name)
            self.caCert = f.name
        else:
            self.caCert = ""  
        
        self.clientCert = ""
        clientCert =   robot.libraries.BuiltIn.BuiltIn().get_variable_value("${DUT_CLIENT_CERT}", "")
        #sys.stderr.write('MY CLIENT CA %s\n\n'%clientCert)
        clientCertFile =   robot.libraries.BuiltIn.BuiltIn().get_variable_value("${DUT_CLIENT_CERT_FILE}", clientCertFile)
        if clientCert == "":
            if os.path.isfile(clientCertFile):
                with open(clientCertFile, 'r') as myfile:
                    clientCert=myfile.read()
            elif clientCertFile != "":
                raise Exception("Client Cert File not found %s!"%clientCertFile)       

        if clientCert != "":
            f = tempfile.NamedTemporaryFile(delete=False)        
            f.write(clientCert.encode())
            f.close()
            #sys.stderr.write('bbb%s\n'%f.name)
            self.clientCert = f.name
        else:
            self.clientCert = ""  

        self.clientPrivKey = ""
        clientPrivKey =   robot.libraries.BuiltIn.BuiltIn().get_variable_value("${DUT_CLIENT_PRIV_KEY}", "")
        #sys.stderr.write('MY Client key  %s\n\n'%clientPrivKey)
        clientPrivKeyFile =   robot.libraries.BuiltIn.BuiltIn().get_variable_value("${DUT_CLIENT_PRIV_KEY_FILE}", clientPrivKeyFile)
        if clientPrivKey == "":
            if os.path.isfile(clientPrivKeyFile):
                with open(clientPrivKeyFile, 'r') as myfile:
                    clientPrivKey=myfile.read()       
            elif clientPrivKeyFile != "":
                raise Exception("Client Key File not found %s!"%clientPrivKeyFile)  

        if clientPrivKey != "":
            f = tempfile.NamedTemporaryFile(delete=False)        
            f.write(clientPrivKey.encode())
            f.close()
            #sys.stderr.write('ccc%s\n'%f.name)
            self.clientPrivKey = f.name
        else:
            self.clientPrivKey = ""

        self.tlsVersion = BuiltIn().get_variable_value("${DUT_TLS_VERSION}", "") 
        """


    #def __del__(self):
        #if  hasattr(self, 'clientPrivKey') and os.path.isfile(self.clientPrivKey):
        #    os.unlink(self.clientPrivKey)

        #if  hasattr(self, 'clientCert') and os.path.isfile(self.clientCert):
        #    os.unlink(self.clientCert)

        #if  hasattr(self, 'caCert') and os.path.isfile(self.caCert):
        #    os.unlink(self.caCert)
        # Do not send close_session since send it here under the cover can cause
        # robotframework rebot utility generates "incompatible element" error when it 
        # parses output.xml 
        #try:
        #    if self.test_session is not None:
        #        self.test_session.close_session()    
        #except:
        #    pass

    #def _retrieve_int_value_safely(self, var_namestr, defaltVal):
    #    val = BuiltIn().get_variable_value(var_namestr, defaltVal)
    #    if val == "":
    #        # Got empty value. That is. the var_namestr is programmed
    #        # to transfe by socketid in
    #        # server index.js but the user does not enter anay value
    #        val = defaltVal
    #
    #    if val == "false":
    #        val = 0
    #    elif  val == "true":
    #        val =1
    #    return int(val)

    #def _retrieve_bool_value_safely(self, var_namestr, defaltVal):
    #    val = BuiltIn().get_variable_value(var_namestr, defaltVal)
    #    if val == "":
    #        # Got empty value. That is. the var_namestr is programmed to transfe by socketid in
    #        # server index.js but the user does not enter anay value
    #        val = defaltVal
    #
    #    if val == "false" or val == 0:
    #        val = False
    #    elif  val == "true" or val == 1:
    #        val = True
    #
    #    return val           
    #
    # Any method with name starting with _ is treated as help method 


    # testClient set YANG module path and load modules
    # load_yang_modules_in_paths is not done in session.load_yang_modules_in_paths()
    # since we don't want to load load modules every time
    # a session is created
    def load_yang_modules_in_paths(self): 
        if len(parse_module.SS_YANG_Dict) == 0:
            parse_module.load_yang_modules_in_paths(self.yangModulePath)

    def create_confSession(self):
        #print("connecting the DUT at %s. Module top path %s "%(self.host, self.YANG_PATH))
        if  self.connType == "ssh":
            s = ssmanager.create_session(host=self.host, 
                    port=self.port, 
                    user=self.user, 
                    password=self.password,
                    custom_capabilities=self.customCaps,                    
                    check_unknown_host=False,
                    netconf_version=self.netconfVersion,
                    timeout=self.timeout,
                    keep_alive=self.keepAlive,
                    private_keyfile=self.sshPrivKeyFile, 
                    socks_proxy={  "server": self.socksServer,
                                    "port":  self.socksPort,
                                    "type":   self.socksType,
                                    "user":   self.socksUser,
                                    "password":  self.socksPassword,                                                      
                                },
                    )
        elif  self.connType == "tls":
            s = ssmanager.create_session_tls(
                    host=self.host, 
                    port=self.port,                   
                    netconf_version=self.netconfVersion,                    
                    client_cert = self.clientCert,
                    client_key = self.clientKey,
                    trusted_certs = self.trustedCerts,
                    check_unknown_host=False,
                    custom_capabilities=self.customCaps,
                    timeout=self.timeout,
                    keep_alive=self.keepAlive,
                    socks_proxy={"server": self.socksServer,
                                    "port":  self.socksPort,
                                    "type":   self.socksType,
                                    "user":   self.socksUser,
                                    "password":  self.socksPassword,                                                      
                                },
                    )       
        elif   self.connType == "rest_http":
            print("Not implemented...")
            pass
        elif   self.connType == "rest_https":
            print("Not implemented...")
            pass
            
        else:
            raise AssertionError("Must be either a ssh, tls, rest_http, rest_https session type!")       

        # Initialize YNAG module store
        # This sets YANG_MODPATH env variable that is also used by PYANG
        #s.load_yang_modules_in_paths(self.YANG_PATH)

        self.test_session = s        
        return s


    def errorType(self, errElem, idx=0):
        if isinstance(errElem, str):
            errElem = etree.fromstring(errElem)                
        foundNodes = errElem.xpath("nc:rpc-error/nc:error-type", namespaces={"nc":"urn:ietf:params:xml:ns:netconf:base:1.0"})
        if foundNodes is not None and len(foundNodes) >= 1:
            # return the idx-th value
            return foundNodes[idx].text          
            
        #return errElem.findtext("./{%s}rpc-error/{%s}error-type"%(nc_ns,nc_ns))            

    def errorTag(self, errElem, idx=0):
        if isinstance(errElem, str):
            errElem = etree.fromstring(errElem)         
        foundNodes = errElem.xpath("nc:rpc-error/nc:error-tag", namespaces={"nc":"urn:ietf:params:xml:ns:netconf:base:1.0"})
        if foundNodes is not None and len(foundNodes) >= 1:
            # return the idx-th value
            return foundNodes[idx].text                  
        #return errElem.findtext("./{%s}rpc-error/{%s}error-tag"%(nc_ns,nc_ns))            

    def rsp2text(self, respTuple):
        # respTuple: (True/False, recvXML, recvElem, sentXML, sentElem)        
        if len(respTuple) >= 4:
            # decode as utf-8 ensures line break to be display in web browser
            return "Sent: %s\nRecv: %s" %(respTuple[3], respTuple[1])
           
        return ""
        
    def check_conformance_parameter(self, c):
        if c.startswith("urn:ietf:params:xml:ns"):
            #This is yang modules advertisement
            idx= c.find("?")
            cpara=c[idx+1:]
            paralist= cpara.split("&")
            for pf in paralist:
                pidx=pf.find("=")
                p=pf[:pidx+1]
                if p not in ["module=", "revision=", "features=", "deviations="]:
                    RFUtils.test_failed_stop("HELLO_PARAMETER_UNKNOWN" + ": " + p)
                    return (False, "unknown %s"%p)
        for pa in ["module=", "revision=", "features=", "deviations="]:
            n= c.count(pa)
            if n>1:
                return (False, "too many %s"%pa)

        return (True, "Ok")

    def validate_uri(self, uri):
        uri= uri.strip()
        if re.match("^%s$" % uriValidate.URI, uri, re.VERBOSE) == False:
            return (False, "Invalid URI")    
        return self.check_conformance_parameter(uri)

        
    # if the DUT reboots then the current session must have been lost
    # so we don't tneed to change sysupTime as we do in SNMP
    #def check_system_reboot():
    #    create_default_test_session_if_disconnected()
    #    default_session.load_module_by_name_revision('ietf-system')
    #    resLst, _ = default_session.hget("/ietf-system:system-state/clock/current-datetime")
    #    my_system_date = resLst[0][1] 
    #    if last_system_date != my_system_date:
    #        error("The device under test has rebooted unexpectedly! last boot-datetome: %s, current boot-datetime: %s "%(last_system_date, my_system_date))



 

    def _xmllint_error_code2str(self, code):
        if code == 1:
            return "Unclassified"

        elif code == 2:
            return "Error in DTD"

        elif code == 3:
            return "Validation error"

        elif code == 4:
            return "Validation error"

        elif code == 5:
            return "Error in schema compilation"

        elif code == 6:
            return "Error writing output"

        elif code == 7:
            return "Error in pattern (generated when --pattern option is used)"

        elif code == 8:
            return "Error in Reader registration (generated when --chkregister option is used)"

        elif code == 9:
            return  "Out of memory error"



    def pyang_validate_instance(self, type, resultXML, yangFile ):
        bad_msg = ""
        ok_msg = ""
        fd, path = tempfile.mkstemp()
        try:
            with os.fdopen(fd, 'w') as tmp:
                # do stuff with temp file
                tmp.write(resultXML.decode("utf-8"))

            #/usr/bin/yang2dsdl -t get-reply -v path ietf-netconf-monitoring@2010-10-04.yang
            try:
                out =subprocess.check_output(['yang2dsdl', '-d', '/tmp', '-t', type, 
                        '-v', path, 
                        yangFile],
                        #'/Users/xiangli/YANG-Modules/ietf-netconf-monitoring@2010-10-04.yang'],
                         stderr=subprocess.STDOUT)
            except subprocess.CalledProcessError as exc:
                    bad_msg = "Status : FAIL " + self._xmllint_error_code2str(exc.returncode) \
                        + "\nOutput:" + exc.output.decode('utf-8')

            else:
                    ok_msg = "validating out: " + out.decode("utf-8")                    
        finally:
            os.remove(path)
            return (ok_msg, bad_msg)


    # if the DUT reboots then the current session must have been lost
    # so we don't tneed to change sysupTime as we do in SNMP
    #def check_system_reboot():
    #    create_default_test_session_if_disconnected()
    #    default_session.load_module_by_name_revision('ietf-system')
    #    resLst, _ = default_session.hget("/ietf-system:system-state/clock/current-datetime")
    #    my_system_date = resLst[0][1] 
    #    if last_system_date != my_system_date:
    #        error("The device under test has rebooted unexpectedly! last boot-datetome: %s, current boot-datetime: %s "%(last_system_date, my_system_date))

    

    def get_all_data (self):
        module_path, module_name_revs, treeRootList = get_top_level_tree_roots()
        instanceNodeIDdictListAll = []
        unknownIDList=[]
        for treeRoot in treeRootList:
            topNodeIDs, nsmap = parse_module.build_module_top_nodeID_List(treeRoot)
            instanceNodeIDdictList, r = default_session.hget(*topNodeIDs, namespaces=nsmap, unknownIDList=unknownIDList)
            if not r[0]:
                error("The request to get all data model failed unexpectedly!", rsp2text(r))
            else:
                if len(r[2]) > 0:
                    instanceNodeIDdictListAll.extend(instanceNodeIDdictList)
        
        return (instanceNodeIDdictListAll, unknownIDList)
        


def get_top_level_tree_roots(s, module_name_revs):  
    """
    module_name_revs:
        A string mod@rev separated by , +, |, or space, 
        E.g.: "ietf-netconf-monitoring&2010-10-04,ietf-system@2014-08-06" is specified
    """        
    #print("module_name_revs ", module_name_revs)                                     
    # figure out what modules to test
    module_name_rev_dict = {}
    mvs =[]
    if isinstance(module_name_revs, str):
        # a string like "ietf-netconf-monitoring&2010-10-04 ietf-system@2014-08-06" is specified
        mvs = re.split(' +|,',module_name_revs)
    else:
        mvs = module_name_revs
    
    #print("Get PID ", os.getppid())

    for mv in mvs:
        print("\n-- c\Check module@revision: ", mv)
        if mv.find("@") !=-1:
            mod, rev = mv.split('@')
            module_name_rev_dict[mod] =  rev
        else:
            module_name_rev_dict[mv] =  ""

    treeRootList = []  
    for tKey in module_name_rev_dict:
        if tKey in s.SS_YANG_Dict.keys():
            tRoot = s.SS_YANG_Dict[tKey]["lxmlTreeRoot"]
            if parse_module.getChildrenCountFromElemNode(tRoot) !=0:
                treeRootList.append(tRoot)                                        
    return treeRootList    

