import sys, os
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) , "..", "..", "ssclient"))
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) , "..", ".."))
#sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) , ".."))

from xmljson import RestConfYANG
from lxml.etree import fromstring, tostring, Element
import json

import ssmanager
import parse_module

# Create a session
s=ssmanager.create_session(host="seguesoft.com", port=830, user="testconf", password="testconf2")
print("Session ID assigned by server: ", s.session_id)

# Load Modules
parse_module.load_yang_modules_in_paths("C:/SegueSoft/NETCONFc/YANG-modules")
print("YANG PATH:" , os.environ["YANG_MODPATH"])

rcy = RestConfYANG(s)

def recursive_dict(element):
     return element.tag, \
            dict(list(map(recursive_dict, element))) or element.text

# convert json stting to data and then to xml

#rtext = {"ietf-restconf:restconf" : { "data" : {}, "operations" : {}, "yang-library-version" : "2016-06-21" } }
"""
rtext = { "{http://example.org/}restconf" : {
          "{http://seguesot.com}data" : {},
          "operations" : {},
          "yang-library-version" : "2016-06-21"
           }
}




rtext = 
      {
        "example:interface" : [
          {
            "name" : "eth1",
            "mtu" : 1500,
            "@mtu" : {
               "ietf-netconf-with-defaults:default" : true
            },
            "status" : "up"
          }
        ]
      }



rtext = 
      <interface
        xmlns="urn:example.com:params:xml:ns:yang:example-interface">
        <name>eth1</name>
        <mtu xmlns:wd="urn:ietf:params:xml:ns:netconf:default:1.0"
          wd:default="true">1500</mtu>
        <status>up</status>
      </interface>
      
      
      
      

"""
"""

<?xml version='1.0' encoding='UTF-8'?>
<rpc-reply xmlns="urn:ietf:params:xml:ns:netconf:base:1.0" message-id="0">
  <data>
    <modules-state xmlns="urn:ietf:params:xml:ns:yang:ietf-yang-library">    
       <module-set-id>1</module-set-id>
       <module n:a=b>
         <name>ietf-system</name>
         <revision>2014-08-06</revision>	
         <namespace>urn:ietf:params:xml:ns:yang:ietf-system</namespace>
         <conformance-type>implement</conformance-type> 
       </module>
       <module>
         <name>ietf-netconf-monitoring</name>
         <revision>2010-10-04</revision>	
         <namespace>urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring</namespace>
         <conformance-type>implement</conformance-type> 
       </module>
       <module>
         <name>ietf-yang-types</name>
         <revision>2013-07-15</revision>	
         <namespace>urn:ietf:params:xml:ns:yang:ietf-yang-types</namespace>
         <conformance-type>implement</conformance-type> 
       </module>
       <module>
         <name>ietf-yang-types</name>
         <revision>2013-07-15</revision>	
         <namespace>urn:ietf:params:xml:ns:yang:ietf-inet-types</namespace>
         <conformance-type>implement</conformance-type> 
       </module>

       <module>
         <name>a</name>
         <revision>2015-01-01</revision>	
         <namespace>urn:example:a</namespace>
         <conformance-type>implement</conformance-type> 
       </module>

       <module>
         <name>b</name>
         <revision>2015-04-04</revision>	
         <namespace>urn:example:b</namespace>
         <conformance-type>implement</conformance-type> 
       </module>

       <module>
         <name>b</name>
         <revision>2015-01-01</revision>	
         <namespace>urn:example:b</namespace>
         <conformance-type>implement</conformance-type> 
       </module>

       <module>
         <name>c</name>
         <revision>2015-02-02</revision>	
         <namespace>urn:example:c</namespace>
         <conformance-type>implement</conformance-type> 
       </module>

       <module>
         <name>c</name>
         <revision>2015-03-03</revision>	
         <namespace>urn:example:c</namespace>
         <conformance-type>implement</conformance-type> 
       </module>

       <module>
         <name>example-server-farm</name>
         <revision></revision>	
         <namespace>urn:example:server-farm</namespace>
         <conformance-type>implement</conformance-type> 
       </module>


    </modules-state>    
  </data>
</rpc-reply>

"""


rtext = """{
    "ietf-yang-library:modules-state": {
        "module-set-id": "e595da11ace92c0d881995fa7e56bbe86f1f48e9",
        "module": [
            {
                "@": {
                    "example-last-modified:last-modified": 123,
                    "example-last-modified:last-modified2": "2015-09-16T10:27:35+02:00"
                },                
                "name": "ietf-inet-types",
                "revision": "2013-07-15",
                "namespace": "urn:ietf:params:xml:ns:yang:ietf-inet-types",
                "conformance-type": ["eee", "import","hh"],                
                "@conformance-type": [
                     null,
                     { 
                     "example-last-modified:last-modified": "2015-06-18T17:01:14+02:00",
                       "ietf-netconf-with-defaults:default" :     true  
                     },
                     null
                ],                
                "a:schema": "https://raw.githubusercontent.com/YangModels/yang/master/standard/ietf/RFC/ietf-inet-types.yang",
                "a:mtu" : 1500,
                "@a:mtu" : {
                        "ietf-netconf-with-defaults:default" : true,
                        "example-last-modified:last-modified2": "2015-09-16T10:27:35+02:00"
                }                                   
            },
            {
                "name": "ietf-netconf-acm",
                "revision": "2012-02-22",
                "namespace": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm",
                "conformance-type": "implement",
                "schema": "https://raw.githubusercontent.com/YangModels/yang/master/standard/ietf/RFC/ietf-netconf-acm.yang"
            },
            {
                "name": "ietf-yang-library",
                "revision": "2016-06-21",
                "namespace": "urn:ietf:params:xml:ns:yang:ietf-yang-library",
                "conformance-type": "implement"
            },
            {
                "name": "ietf-yang-types",
                "revision": "2013-07-15",
                "namespace": "urn:ietf:params:xml:ns:yang:ietf-yang-types",
                "conformance-type": "import",
                "schema": "https://github.com/YangModels/yang/blob/master/standard/ietf/RFC/ietf-yang-types.yang"
            },
            {
                "name": "example-jukebox",
                "revision": "2016-08-15",
                "namespace": "urn:ietf:params:xml:ns:yang:example-jukebox",
                "conformance-type": "implement",
                "schema": "https://github.com/YangModels/yang/blob/master/standard/ietf/DRAFT/example-jukebox.yang"
            }
        ]
    }
}

"""

# Manually added for testing
"""
nsmap= {None : "urn:ietf:params:xml:ns:netconf:base:1.0",
        "ietf-yang-library" : "urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "a" : "http://seguesot",
        "example-last-modified" : "http://example-last-modified",
        "ietf-netconf-with-defaults" : "urn:ietf:params:xml:ns:netconf:default:1.0",
        "example-jukebox": "http://example.com/ns/example-jukebox"

       }
"""

nsmap= {"ietf-yang-library" : "urn:ietf:params:xml:ns:yang:ietf-yang-library",
        "a" : "http://seguesot",
        "example-last-modified" : "http://example-last-modified",
        "ietf-netconf-with-defaults" : "urn:ietf:params:xml:ns:netconf:default:1.0",
        "example-jukebox": "http://example.com/ns/example-jukebox"

       }

# reverse key and value 
inv_nsmap = {v: k for k, v in iter(nsmap.items())}
        
for k, v in list(nsmap.items()):        
    print("inv_nsmap  k: ", k , " v: ", v) 
            
parse_module.moduleToNamespaceImplementedDict.update(nsmap)
parse_module.namespaceToModuleImplementedDict.update(inv_nsmap)
for k, v in parse_module.moduleToNamespaceImplementedDict.items():
    print("k ", k, " v ", v)
rtData = json.loads(rtext)

#rootElem = Element('{urn:ietf:params:xml:ns:netconf:base:1.0}data',  nsmap= {None : "urn:ietf:params:xml:ns:netconf:base:1.0"})
# in moduleToNamespaceImplementedDict "ietf-netconf: "urn:ietf:params:xml:ns:netconf:base:1.0" 

rootElem = Element("data")

rtxml = tostring(rcy.etree( rtData, 
                            root=rootElem, 
                            nsmap=parse_module.moduleToNamespaceImplementedDict), 
                            pretty_print=True)

                            
# rtxml is bytes b string                            
print("xml ", rtxml.decode("utf-8"))                

#rtxml= """<data xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
#<jukebox:gap xmlns:jukebox="http://example.com/ns/example-jukebox">a</jukebox:gap>
#</data>"""

#rtxml= """<jbox:gap xmlns:jbox="http://example.com/ns/example-jukebox">a</jbox:gap>"""
 
# convert XML to data    
elem = fromstring(rtxml)
print("genearted...", tostring(elem, pretty_print=True).decode("utf-8"))

jt=rcy.data(elem, nsmap=parse_module.namespaceToModuleImplementedDict)

print("!!!jt ", jt)

jtstr=json.dumps(jt["data"], indent=4)
print("jstr ", jtstr)

