#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################
   
import os, sys
import logging

# Extend system path to import 'ssmanager' package under the 
# installation directory.

sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) , 
                                "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="example.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# Send a <copy-config> RPC to copy running config to candidate config
# The result is a tuple of five values:
# Operation succeeded (True or False), reply in xml format, reply in 
# lxml element format, request in xml format, request in lxml element format

r = s.copy_config("running", "candidate")


# Send a <copy-config> RPC to copy running config to a url"
s.copy_config("running", "file:///checkpoint.cfg")

# close sessions
s.close_session()


              
