#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################
import os, sys

# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                                        "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="example.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# Delete startup config
# When deleting <startup> config store, the server will reset the
# device to its factory defaults.
# The result is a tuple of five values:
#       Operation succeeded (True or False), 
#       reply in xml format, 
#       reply in lxml element format, 
#       request in xml format, 
#       request in lxml element format
s.delete_config("startup")

# delete file config
r = s.delete_config("file:///a.cfg")

errorDict = s.extract_rpc_error_from_rpc_reply(r[1])
for k, v in list(errorDict.items()):
    print(k, " = ", v)
