#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################
import os, sys
# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) ,
                             "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

r = s.edit_config('/nacm:nacm/nacm:rules-list', {'operation': 'create'}, 
        '/nacm:nacm/nacm:rules-list/nacm:name', 'guest-acl', 
        '/nacm:nacm/nacm:rules-list/nacm:group', 'guest', 
        '/nacm:nacm/nacm:rules-list/nacm:rule', {'operation': 'create'}, 
        '/nacm:nacm/nacm:rules-list/nacm:rule/nacm:name', 'deny-ncm', 
        '/nacm:nacm/nacm:rules-list/nacm:rule/nacm:module-name', 
            'ietf-netconf-monitoring', 
        '/nacm:nacm/nacm:rules-list/nacm:rule/nacm:access-operations', '*', 
        '/nacm:nacm/nacm:rules-list/nacm:rule/nacm:action', 'deny', 
        '/nacm:nacm/nacm:rules-list/nacm:rule/nacm:comment', 
            'Do not allow guests any access to the NETCONF monitoring information',
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error",                  
        namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
        )
 

r = s.edit_config(('/nacm:nacm/nacm:groups/nacm:group/nacm:name',
                        {'value': 'almighty'}),  
                  ('/nacm:nacm/nacm:groups/nacm:group/nacm:user-name',
                        {'insert_operation': 'first', 'value': 'netconf1'}),
                  target="candidate",
                  namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})

 
# This example demonstrates how to create, merge, replace, delete and remove
# leaf and leaf-list nodes.
          
# Leaf examples:            
# To edit leaf nodes that are not contained in a YANG list, we need to 
# pass in respective nodeID and value, in the order as it should 
# appear in the message.

# In its simplest form, you can omit "operation" attribute completely and 
# simply use the default 'merge' operation.

# The result is a tuple of five values:
# Operation succeeded (True or False), 
# reply in xml format, reply in lxml element format, 
# request in xml format, request in lxml element format

# Editing leaf example
r = s.edit_config("/nacm:nacm/nacm:enable-nacm", "false", 
                target="candidate",
                namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})


# edit two nodes in two different module
r = s.edit_config("/nacm:nacm/nacm:enable-nacm", "true",                
           "/ex:system/ex:services/ex:ssh/ex:allow-user", "eric",
           target="candidate",
           namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm",
                       "ex": "http://example.com/schema/config"})

# set value to 'true' and add "operation" attribute on 'enable-nacm' node
# when using 'create', the server will generate an error if the target node
# already exists.
#
# Note we do not need to explicitly request to create the intermediate node
# in "/nacm:nacm since they will be created using the default 'merge' operation.

# For all nodes that are not explicitly assigned an 'operation' attribute, 
# they will default to use the "default-operation" element in the RPC. 
#
# If there is no "default-operation" element in the RPC, the effective 
# default operation will be "merge".
  
r = s.edit_config("/nacm:nacm/nacm:enable-nacm", {"value":"true", "operation":"create"},
                     target="candidate", 
                     namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}                     
                     )

# Use explicit "merge" operation
r = s.edit_config("/nacm:nacm/nacm:enable-nacm", {"value":"true", "operation":"merge"}, 
                     target="candidate",
                     namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                     )

# Use "replace" operation
r = s.edit_config("/nacm:nacm/nacm:enable-nacm", {"value":"true", "operation":"replace"}, 
                     target="candidate",
                     namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                     )
                     
# Delete a leaf node 
# When deleting a node, the value specified (if any) is ignored.
r = s.edit_config("/nacm:nacm/nacm:enable-nacm", {"value":"true", "operation":"delete"}, 
                     target="candidate",
                     namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                     )
                     
# Remove a leaf node 
# When removing a node, the value specified (if any) is ignored.
# When using 'remove', the server will not generate an error if
# the target node does not exist

r = s.edit_config("/nacm:nacm/nacm:enable-nacm", {"value":"true", "operation":"remove"}, 
                     target="candidate",
                     namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                     )     

# Editing Leaf-list examples:
# The following examples build RPC as shown in RFC6020 7.7.8. Usage Example 
#     leaf-list allow-user  {
#         type string;
#         description "A list of user name patterns to allow";
#     }
# To create a new element in this list, using the default <edit-config>
# operation "merge":

# register namespace  and send edit_config
r = s.edit_config("/ex:system/ex:services/ex:ssh/ex:allow-user", "eric", 
                target="running",
                namespaces={"ex": "http://example.com/schema/config"})     


# Given the following ordered-by user leaf-list:
#     leaf-list cipher  {
#         type string;
#         ordered-by user;
#         description "A list of ciphers";
#     }
# The following would be used to insert a new cipher 
# "blowfish-cbc" after "3des-cbc":
r = s.edit_config("/ex:system/ex:services/ex:ssh/ex:cipher",  
                 {"value":"blowfish-cbc", "operation":"create", 
                        "insert_operation":"after", "target_value":"3des-cbc" },
                target="running",
                namespaces={"ex": "http://example.com/schema/config"}
                ) 
                
# The following would be used to move the just created 
# cipher "blowfish-cbc"  before "3des-cbc":
r = s.edit_config("/ex:system/ex:services/ex:ssh/ex:cipher",  
                    {"value":"blowfish-cbc", "operation":"merge", 
                            "insert_operation":"before", "target_value":"3des-cbc" },
                    target="running",
                    namespaces={"ex": "http://example.com/schema/config"}
                    )

# The following would be used to move the just created 
# cipher "blowfish-cbc"  to the end:
r = s.edit_config("/ex:system/ex:services/ex:ssh/ex:cipher",  
                    {"value":"blowfish-cbc", "operation":"merge", "insert_operation":"last"},
                    target="running",
                    namespaces={"ex": "http://example.com/schema/config"}
                    )   

# The following would be used to move the just created 
# cipher "blowfish-cbc"  to the first:
r = s.edit_config("/ex:system/ex:services/ex:ssh/ex:cipher",  
                    {"value":"blowfish-cbc", "operation":"merge", 
                            "insert_operation":"first"},
                    target="running",
                    namespaces={"ex": "http://example.com/schema/config"}
                    ) 

# Editing list example
# To edit a list entry, we need to pass in the nodeID of list entry and all leafs that 
# require a value, in the order it is defined in the YANG module. In other words,
# first list entry nodeID, then key leafs nodeID, followed by nodeIDs of other leafs.

# Note you must pass in all key nodeIDs when editing a list entry!

# This example creates list entry in NACM rule-list as shown in 
# RFC6536 A.2. Module Rule Example

# For clarity first we assign absolute node IDs for all leafs that need to be 
# assigned a value to the following variables. 

rulelist=                        "/nacm:nacm/nacm:rules-list"
rulelist_name=                   "/nacm:nacm/nacm:rules-list/nacm:name"
rulelist_group =                 "/nacm:nacm/nacm:rules-list/nacm:group"

rulelist_rule=                   "/nacm:nacm/nacm:rules-list/nacm:rule"
rulelist_rule_name=              "/nacm:nacm/nacm:rules-list/nacm:rule/nacm:name"
rulelist_rule_modulename=        "/nacm:nacm/nacm:rules-list/nacm:rule/nacm:module-name"
rulelist_rule_accessoperations=  "/nacm:nacm/nacm:rules-list/nacm:rule/nacm:access-operations"
rulelist_rule_action=            "/nacm:nacm/nacm:rules-list/nacm:rule/nacm:action"
rulelist_rule_comment=           "/nacm:nacm/nacm:rules-list/nacm:rule/nacm:comment"


# In this example we use 'create' operation by assigning 'create' attribute 
# to the list entry node
# Change it to "merge" or "replace" to see how Netconf handles different operations.

# When using 'create' operation, if the entry has already existed, then 
# the server will reject the request and return an error. 

# When using 'merge' operation, if the entry has already existed, then
# the server will merge the data in the RPC request into its configuration.

# when using 'replace' operation , if a list entry already exists, it
# will be replaced.
# If it does not exist, it will be will be created.

#OPERATION="create"
OPERATION="merge"
#OPERATION="replace"

# If we just want to create or modify a single list entry, we can use normal
# edit_config to achieve it.
# For edit-config, we must specify list key values before other non-key 
# node values.
#
# For example: 

r = s.edit_config( 
             # Add "operation" attribute to list entry node 'rule-list'. 
             # All nodes underneath
             # will effectively be using the same operation unless otherwise specified.
             rulelist,                       {"operation":OPERATION},  # the list node can be be left out
             rulelist_name,                  "guest-acl", # list key
             rulelist_group,                 "guest",     # list non-key node                       
             rulelist_rule_name,             "deny-ncm",  # nested list key
             rulelist_rule_modulename,       "ietf-netconf-monitoring",  # nested list key
             rulelist_rule_accessoperations, "*",                        # nested list non-key node
             rulelist_rule_action,           "deny",                     # nested list non-key node
             rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.", # nested list non-key node
             target="candidate", test_option="test-then-set", error_option="rollback-on-error",             
             namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
)


# If we want to create or modify two or more list entries in a single RPC, 
# edit_config multiple list entries example

# It is used in the list node (in this case it isn't really necessary) or 
# the first key node's valueDict (in this case it must be done).
r = s.edit_config(  #Add "operation" attribute to list entry node 'rule-list'. All nodes underneath
             #will effectively be using the same operation unless otherwise specified.
             rulelist,                       {"operation":"create"},  # the list node can be be left out                            
             rulelist_name,                  "guest-acl", # list key
             rulelist_group,                 "guest",     # list non-key node                       
             
             rulelist_rule,                  "",          # new list entry start
             rulelist_rule_name,             "deny-ncm",  # nested list key
             rulelist_rule_modulename,       "ietf-netconf-monitoring",  # nested list key
             rulelist_rule_accessoperations, "*",                        # nested list non-key node
             rulelist_rule_action,           "deny",                     # nested list non-key node
             rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.", # nested list non-key node

             #  nested entry in the first list entry
             rulelist_rule,                  "",          # new list entry start
             rulelist_rule_name,             "allow-ncm",  # nested list key
             rulelist_rule_modulename,       "ietf-netconf-monitoring",  # nested list key
             rulelist_rule_accessoperations, "*",                        # nested list non-key node
             rulelist_rule_action,           "deny",                     # nested list non-key node
             rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.", # nested list non-key node
             
             # second list entry             
             rulelist,                       {"operation":"merge"},  # the list node can be be left out
             rulelist_name,                  "family-acl", # list key
             rulelist_group,                 "parents",     # list non-key node 
             
             rulelist_rule,                  "",          # new list entry start                      
             rulelist_rule_name,             "deny-ncm",  # nested list key
             rulelist_rule_modulename,       "ietf-netconf-monitoring",  # nested list key
             rulelist_rule_accessoperations, "*",                        # nested list non-key node
             rulelist_rule_action,           "deny",                     # nested list non-key node
             rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.", # nested list non-key node

             # second nested entry in second list entry
             rulelist_rule,                  "",          # new list entry start
             rulelist_rule_name,             "allow-ncm",  # nested list key
             rulelist_rule_modulename,       "ietf-netconf-monitoring",  # nested list key
             rulelist_rule_accessoperations, "*",                        # nested list non-key node
             rulelist_rule_action,           "deny",                     # nested list non-key node
             rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.", # nested list non-key node
             
             # additional list entry
             
             # finally, specify other options
             
             target="candidate", test_option="test-then-set", error_option="rollback-on-error",             
             namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
)


# For ordered-by-user list we can use YANG:insert attribute on the list node 
# to reorder list entries:
#
# We can create a new entry and have it inserted before or after a specif
# existing entry.
# Note by default creating a new list entry will insert at the end
#
# If the entry is already existed, we can 'merge' or 'replace' its content 
# and move it to a different position in the list.
#
# insert before
r = s.edit_config(#Add "operation" attribute and YANG "insert..." attribute to the list entry node 'rule-list'.                      
                rulelist,  {"operation":OPERATION, "insert_operation":"before", "target_key": [("name", "limited-acl")]},
                #rulelist,  {"operation":OPERATION, "insert_operation":"before", "target_key":"[nacm:name='limited-acl']"},                  
                rulelist_name,                 "guest-acl",
                rulelist_group,                 "guest",     
                rulelist_rule,                  "",          # new list entry start                                 
                rulelist_rule_name,             "deny-ncm",
                rulelist_rule_modulename,       "ietf-netconf-monitoring",
                rulelist_rule_accessoperations, "*",
                rulelist_rule_action,           "deny",
                rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.",
                target="candidate", test_option="test-then-set", error_option="rollback-on-error",
                namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                )

# insert after
r = s.edit_config(#Add "operation" attribute and YANG "insert..." attribute to the list entry node 'rule-list'.          
                rulelist, {"operation":OPERATION, "insert_operation":"after", "target_key": [("name", "limited-acl")]},            
                #rulelist, {"operation":OPERATION, "insert_operation":"after", "target_key":"[nacm:name='limited-acl']"},
                rulelist_name,                  "guest-acl",
                rulelist_group,                 "guest",       
                rulelist_rule,                  "",          # new list entry start                                                          
                rulelist_rule_name,             "deny-ncm",
                rulelist_rule_modulename,       "ietf-netconf-monitoring",
                rulelist_rule_accessoperations, "*",
                rulelist_rule_action,           "deny",
                rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.",
                target="candidate", test_option="test-then-set", error_option="rollback-on-error",
                namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                )


# insert last
r = s.edit_config(#Add "operation" attribute and YANG "insert..." attribute to the list entry node 'rule-list'.                      
                rulelist, {"operation":OPERATION, "insert_operation":"last"},
                rulelist_name,                  "guest-acl",
                rulelist_group,                 "guest",   
                rulelist_rule,                  "",          # new list entry start                                                              
                rulelist_rule_name,             "deny-ncm",
                rulelist_rule_modulename,       "ietf-netconf-monitoring",
                rulelist_rule_accessoperations, "*",
                rulelist_rule_action,           "deny",
                rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.",
                target="candidate", test_option="test-then-set", error_option="rollback-on-error",
                namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                )

# insert first
r = s.edit_config(#Add "operation" attribute and YANG "insert..." attribute to the list entry node 'rule-list'.                      
                rulelist, {"operation":OPERATION, "insert_operation":"first"},
                rulelist_name,                  "guest-acl",
                rulelist_group,                 "guest",      
                rulelist_rule,                  "",          # new list entry start                                                           
                rulelist_rule_name,             "deny-ncm",
                rulelist_rule_modulename,       "ietf-netconf-monitoring",
                rulelist_rule_accessoperations, "*",
                rulelist_rule_action,           "deny",
                rulelist_rule_comment,          "Do not allow guests any access to the NETCONF monitoring information.",
                target="candidate", test_option="test-then-set", error_option="rollback-on-error",
                namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"}
                )
                                        
                    
# The following examples generate 'delete' example RPC in RFC6241  (page 41)
#
# You can use either "delete" or "remove" operation.
# The difference with 'delete' is that if the configuration data does not
# exist, the "remove" operation is silently ignored by the server.

# Delete the configuration for an interface named "Ethernet0/0" from
# the running configuration
OPERATION="delete"
#OPERATION="remove"


# For clarity first we assign absolute node IDs for all leafs that need to be 
# assigned a value to the following variables. 

interface = "/ex:top/ex:interface"
name = "/ex:top/ex:interface/ex:name"

area_name = "/ex:top/ex:protocols/ex:ospf/ex:area/ex:name"
area_interface = "/ex:top/ex:protocols/ex:ospf/ex:area/ex:interfaces/ex:interface"
area_interface_name = "/ex:top/ex:protocols/ex:ospf/ex:area/ex:interfaces/ex:interface/ex:name"

#When deleting a list entry, we must place 'delete' attribute on the list entry node.
r = s.edit_config(interface, {"operation":OPERATION},
                 name,   "Ethernet0/0",
                 target="candidate",
                 namespaces={"ex": "http://example.com/schema/1.2/config"})

# Delete interface 192.0.2.4 from an OSPF area (other interfaces
# configured in the same area are unaffected):                                

r = s.edit_config(  area_name, "0.0.0.0",
             area_interface, {"operation":OPERATION},
             area_interface_name, "192.0.2.4",
             target="candidate",
             namespaces={"ex": "http://example.com/schema/1.2/config"})

