#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################
import os, sys
# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) ,
                             "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

xmlmsg="""
     <rpc xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
       <get-config>
         <source>
           <runningerr/>
         </source>
       </get-config>
     </rpc>
"""

# The result of send_rpc_raw_xml is a tuple of five values:
# Operation succeeded (True or False), 
# reply in xml format, reply in lxml element format, 
# request in xml format, request in lxml element format  

r = s.send_rpc_raw_xml(xmlmsg)

# server should send back an error for the rpc above
errorDict = s.extract_rpc_error_from_rpc_reply(r[1])
for k, v in list(errorDict.items()):
    print("error property: ", k, " = ", v)
                        
# Another way is to use extract_value_from_rpc_reply to 
# extract interested error property value
# This is useful if you extend rpc-error structure 
# and added new element

res = s.extract_value_from_rpc_reply(r[1], 
            "/nc:rpc-error/nc:error-info/nc:bad-element",
            namespaces={"nc":"urn:ietf:params:xml:ns:netconf:base:1.0"})
print("extract value using extract_value_from_rpc_reply: ", res)
        
    