#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #
# Redistribution of this software, in whole or in part, is prohibited #
# without the express written permission of Seguesoft.                #
#######################################################################   
import os, sys

# Extend system path to import 'ssmanager' package under 
# the installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                        "..", "..", "ssclient"))
import ssmanager

print("Calling home....")

# Using callhome to create a connection:

# ssh 4334, tls 4335
client_sock, errException  = ssmanager.listen_callhome(4334)

print("Got client_sock ", client_sock)

s = ssmanager.create_session(client_sock=client_sock, 
                user="testconf", password="testconf2")
s.print_rpc_stdout()

print(("Session ID assigned by server: ", s.session_id))
print(("Modules advertised by Server: ", 
         { modulenameAndRev.split('@')[0]: modulenameAndRev.split('@')[1] \
        for modulenameAndRev in  list(s.server_capabilities_dict_tuple[0].keys())}))
print(("Capabilities advertised by Server: ", s.server_capabilities_dict_tuple[1]))

# Send GET requests using subtree filter
print("\n#Send a <get> RPC using nodeID with namespace.")

r = s.get("/sys:system/sys:hostname", 
          "/sys:system-state/sys:platform/sys:os-release",
          namespaces={"sys": "urn:ietf:params:xml:ns:yang:ietf-system"})

