#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################
   
import os, sys

# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) ,
                                 "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# Get available notification streams
# See RFC5277 3.2. Event Streams
streamNamesList = s.get_notification_stream_names()

print("Stream_names returned: ", streamNamesList)

# A callback is responsible for handing received notifications
# If no callback function specified then the default behavior is to 
# print the received notifications in stdout
def notification_callback(fromIP, notificationXML):
    print("Received: ", notificationXML)
    try:
        (evtTime, name, namespace)= ssmanager.extract_notification_name_timestamp(notificationXML)
    except Exception as e:
        print ("Error ", e)
    else:
        print("Event Time: ", evtTime, " Notification: ", name)


# Example to create a subscription with a subtree filter expression
# This is just for illustration purpose. In real world, the filter
# should be applied to the actual data model
subtree_filter = s.build_subtree_filter("/netconf-state/datastores/datastore")
r = s.create_subscription(stream="NETCONF", 
                             subtree_filter=subtree_filter, 
                             start_time="2013-01-01 12:00:00",
							 callback=notification_callback)

# The result is a tuple of five values:
# Operation succeeded (True or False),
# reply in xml format, reply in lxml element format,
# request in xml format, request in lxml element format
s.close_session()
           
# Example to create a subscription with a XPath filter expression           
s1=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")
r = s1.create_subscription(stream="NETCONF", 
            xpath_filter="/ncm:netconf-state/ncm:datastores/ncm:datastore", 
            namespaces={"ncm": "urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring"},
            start_time="2013-01-01 12:00:00",
            callback=notification_callback)
s1.close_session()            

# Create subscription to default notification stream
print("\nSubscribe to the default stream and wait for notifications:\n")   
# Create a netconf session to demo simple receiving

# Create netconf session
s2=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s2.print_rpc_stdout(True)
#s2.print_rpc_stdout(False)

s2.create_subscription(stream="NETCONF",
                        callback=notification_callback)

# The result is a tuple of five values:
# Operation succeeded (True or False), 
# reply in xml format, reply in lxml element format, 
# request in xml format, request in lxml element format

#wait for notification
print("Waiting for notification:")
ssmanager.wait_notification()

