#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #                                       
# Redistribution of this software, in whole or in part, is prohibited #        
# without the express written permission of Seguesoft.                #  
#######################################################################

import os, sys
from urllib.parse import urlparse

# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)) ,
                     "..", "..", "ssclient"))
import ssmanager
import requests
# Create a netconf session object
s = ssmanager.create_session_restconf(host="seguesoft.com", 
            port=8443,
            client_cert = "C:/Users/Xiang Li/jetconf-utils/cert_gen/xiangli@seguesoft.com.pem",
            client_key = "C:/Users/Xiang Li/jetconf-utils/cert_gen/xiangli@seguesoft.com.key",
            cacert = "C:/Users/Xiang Li/jetconf-utils/cert_gen/ca.pem",
            verify=False,
            http_version= 2
            )

# Set paths to YANG models and load them
# The YANG path directories MUST be writable by the application
# since the application will need to generate XML based 
# definition files.
#
#s.load_yang_modules_in_paths("C:/MY-YANG-modules",  "C:/MY-YANG-modules2", recursive=True)
# Set YANG model path to the default path, which is the same as in the GUI NETCONFc
s.load_yang_modules_in_paths()

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)
print("rootResource discovered ", s.rootResource)

# Get Top API Resource
# rget (RESTGet ) returns a Python Requests Response object
# https://docs.python-requests.org/en/latest/user/quickstart/#response-content
#
res = s.rget(s.rootResource)
print("Request: ", res.url, "\nResponse text: ", res.text)

# Get on Datastore resource (retrieve all data)
res = s.rget(f"{s.rootResource}/data")
print("Request: ", res.url, "\nResponse text: ", res.text)

# Get on Operations resource
res = s.rget(f"{s.rootResource}/operations")
print("Request: ", res.url, "\nResponse text: ", res.text)

# HEAD on Datastore resource 
res = s.head(f"{s.rootResource}/data")
print("Head datastore resource, response header: ", res.headers)

# OPTIONS on root resource
res = s.options(f"{s.rootResource}")
print("OPTIONS root resource, response header: ", res.headers)

# GET using nodeID with namespace mapping
res = s.get("example-jukebox:jukebox")
print("Request: ", res.url, " ok? ", res.ok, "\nResponse text: ", res.text)

res = s.get("example-jukebox:jukebox/library?fields=artist-count;album-count;song-count")
print("Request: ", res.url, " ok? ", res.ok, "\nResponse text: ", res.text)


# delete 
res = s.delete(
    requests.utils.quote("/example-jukebox:jukebox/library/artist=Foo Fighters/album=Wasting Light"),     
    )

print(" delete res ok?", res.ok,
    " res request", res.request,
    "resp message", res.text
    )

# Examples on POSTING data
# post_data
# post_actions
# post_operations

# To create a new top level "jukebox" resource
res = s.post_data("", 
"""{
    "example-jukebox:jukebox": {}
}"""
)
print("res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# Create New child data resources
res = s.post_data(
    "example-jukebox:jukebox/library", 
    """{
        "example-jukebox:artist" : [
        {
            "name" : "Foo Fighters"
        }
        ]
    }"""
)
print("res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# To create a new "album" resource for this artist within the "jukebox"
#   resource, the client might send the following request:
res = s.post_data(
    #"example-jukebox:jukebox/library/artist=Foo%20Fighters",
    requests.utils.quote("example-jukebox:jukebox/library/artist=Foo Fighters"), 
    """{
        "example-jukebox:album" : [
        {
            "name" : "Wasting Light"
            "year" : "2011"

        }
        ]
    }"""
)
print("res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# Detect Datastore Resource Entity-Tag Change
# Create New child data resources with additional headers
res = s.post_data(
    requests.utils.quote("/example-jukebox:jukebox/library/artist=Foo Fighters/album=Wasting Light/genre"), 
    """{
       "example-jukebox:genre" : "example-jukebox:alternative" 
    }""",
    headers =  {"If-Unmodified-Since" : "Tue, 02 Nov 2021 15:46:13 GMT"}
)
print("res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# "insert" Parameter
res = s.post_data(
    requests.utils.quote("/example-jukebox:jukebox/playlist=Foo-One"), 
    """
    {
        "example-jukebox:song" : [
           {
             "index" : 1,
             "id" : "/example-jukebox:jukebox/library/artist[name='Foo Fighters']/album[name='Wasting Light']/song[name='Rope']"
           }
         ]
    }        
    """,
    insert = "first"
)
print("res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# "insert" before and after and "point Parameter
res = s.post_data(
    requests.utils.quote("/example-jukebox:jukebox/playlist=Foo-One"), 
    """
    {
        "example-jukebox:song" : [
           {
             "index" : 2,
             "id" : "/example-jukebox:jukebox/library\
                /artist[name='Foo Fighters']\
                /album[name='Wasting Light']\
                /song[name='Bridge Burning']"
           }
         ]
    }       
    """,
    insert = "after",
    point  = "/example-jukebox%3Ajukebox/playlist=Foo-One%2Fsong%3D1"
    #point =   requests.utils.quote("/example-jukebox/jukebox/playlist=Foo-One/song=1")
)
print("res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

#  post_operations
res = s.post_operations(
    requests.utils.quote("example-jukebox:play"),         
    """
    {
        "example-jukebox:input": {
            "playlist": "test",
            "song-number": 1
        }
    }
    """,
    headers =  {"If-Match" : "b8389233a4c"}
)
print("post operations res ok?", res.text,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# post_actions

res = s.post_actions(
    requests.utils.quote("example-actions:interfaces/interface=eth1213/reset"),         
    """
    {
        "example-actions:input": {
            "delay": 11
        }
    }
    """,
    headers =  {"If-Match" : "b8389233a4c"}
)
print("post operations res ok?", res.text,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# plain patch (merge data)
res = s.patch(
    requests.utils.quote("/example-jukebox:jukebox/library/artist=Foo Fighters/album=Wasting Light"), 
    """{
        "example-jukebox:album" : [
        {
            "year" : "2011"
        }
        ]
    }""",
    headers =  {"If-Match" : "b8389233a4c"}
)
print("patch res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)

# put:   create or replace the target data resource
# post_data: create the target data resource
# "insert" before and after and "point Parameter
res = s.put(
    requests.utils.quote("/example-jukebox:jukebox/playlist=Foo-One"),     
    {
        "example-jukebox:song" : [
           {
             "index" : 2,
             "id" : "/example-jukebox:jukebox/library/artist[name='Foo Fighters']/album[name='Wasting Light']/song[name='Bridge Burning']"
           }
         ]
    },
    insert = "after",
    point  = "/example-jukebox%3Ajukebox/playlist=Foo-One%2Fsong%3D1"
    #point =   requests.utils.quote("/example-jukebox/jukebox/playlist=Foo-One/song=1")
)

print("put res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)


# To create/replace a new top level"jukebox" resource
res = s.put("",  
"""{
    "example-jukebox:jukebox": {}
}"""
)
print("res ok?", res.ok,
    "resp message", res.text, 
    "request url ", res.request.url,
    "request data ", res.request.body)



