#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #
# Redistribution of this software, in whole or in part, is prohibited #
# without the express written permission of Seguesoft.                #
#######################################################################   
import os, sys

# Extend system path to import 'ssmanager' package under 
# the installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                                        "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# Note ncm:format is an identityref
# According RFC6020, an identityref is encoded as the referred 
# identity's qualified name. If the prefix is not present, the 
# namespace of the identityref is the default namespace in effect 
# on the element that contains the identityref value.

# In the following example, the element 'ncm:format' contains the identityref
# value "yang". Because it is not using the default namespace, so we must
# pass in qualified name 'ncm:yang' as the value of the identityref.

# This is different when you call built-in get-schema method
# where format can be non-qualified name: "yang" | "yin" | "xsd" | "rng" | "rnc"

r=s.send_any_rpc("ncm:get-schema",
                    "ncm:identifier", "ietf-inet-types",
                    "ncm:version", "2010-09-24",
                    "ncm:format", "ncm:yang",
                    namespaces={"ncm":"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring"})

print("Sending succeeded? ", 
        r[0], " \n=====Result=====:\n", 
        r[1], " \n=====Request=====:\n", r[3])
        
if r[0]:
   resList, nsmap = s.extract_prefixed_node_id_and_value_from_rpc_reply(r[2])    
   for res in resList:
       print("nodeID ", res[0], "=>", res[1])
else:
    errDict = s.extract_rpc_error_from_rpc_reply(r[2])
    print("errDict ", errDict)
    
