'''
# Copyright (C) 2014  Seguesoft  Inc.                                                           
# Redistribution of this software, in whole or in part, is prohibited
# without the express written permission of Seguesoft.
'''

from pickle import TRUE
import platform
# We use pyinstaller to wrap python code and it uses sys._MEIPASS to indicate
# running in a wrapped environment
import os, sys, shutil

if sys.version_info[0] == 2:
    import ConfigParser as configparser
else:
    import configparser

license_remaining_days = 0

YANG_FILE_NOT_FOUND_MSG = "Module file not found in the current YANG module path. \n\nYou may right click to download it from the server or update your YANG Module Path to include it"
_dataNodes =            ["action", "choice", "case",  "module", "anyxml", "anydata", "container", "input", "leaf", "leaf-list", "list", "rpc"]

_dataNodesNoValue = ["action", "input", "output", "rpc", "choice", "container", "case", "list", "module", "submodule"]
_dataNodesNoValueExceptContainer = ["action", "input", "output", "rpc", "choice", "case", "list", "module", "submodule"]

YIN10NS = "urn:ietf:params:xml:ns:yang:yin:1"

# per module comiling flag
validate_normal_rules = False
validate_xpath_yang = False
validate_rfc6087_rules = False

# global compiling flag
global_validate_normal_rules = False
#global_validate_xpath_yang = False
global_validate_rfc6087_rules = False

global_comipling_choiceLst  = ["Validate no xpath no ietf rules"]

APP_INSTALLATION_ROOT = os.path.normpath(os.path.join(os.path.dirname(os.path.abspath(__file__)), ".."))
print("App root directory: ", APP_INSTALLATION_ROOT)

SSDEBUG = False
def DEBUGPRINT(*args, **kwargs):
    if SSDEBUG:
        print(*args, **kwargs)

SSDEBUG_SYN = True
def DEBUGPRINT_SYN(*args, **kwargs):
    if SSDEBUG_SYN:
        print(*args, **kwargs)
        
INSTALLED_Module_Path = "%s/YANG-modules"%APP_INSTALLATION_ROOT
print("INSTALLED_Module_Path ", INSTALLED_Module_Path)
Default_Module_Path = INSTALLED_Module_Path

"""
Default_Module_Path = os.path.join(os.path.expanduser("~"), "seguesoftNC", "YANG-modules")
firstCreated= False
if not os.path.exists(Default_Module_Path):
    try:
        os.makedirs(Default_Module_Path, exist_ok = True)
        firstCreated= True
        print("Default Module Directory '%s' created successfully" % Default_Module_Path)
    except OSError as error:
        print("Default Module Directory '%s' can not be created: %s" % (Default_Module_Path, error))            

# copy modules to user module path
# check if there is a new installation
t1 = os.path.getmtime(INSTALLED_Module_Path)    
t2 = os.path.getmtime(Default_Module_Path)        
if firstCreated or t2 < t1:
    try:
        shutil.copytree(INSTALLED_Module_Path, Default_Module_Path, dirs_exist_ok=True)     
        print("Copy modules to '%s' finished successfully" % Default_Module_Path)
    except OSError as error:
        print("Copy modules to '%s' can not be done: %s" % (Default_Module_Path, error))            
"""

INSTALLED_TESTSUITES = "%s/testsuites"%APP_INSTALLATION_ROOT
InstalledAUTOModuleTestsuites=os.path.join(INSTALLED_TESTSUITES, "All-Modules-Combined")
TESTSUITES = INSTALLED_TESTSUITES

"""
InstalledAUTOModuleTestsuites=os.path.join(INSTALLED_TESTSUITES, "All-Modules-Combined")
TESTSUITES = os.path.join(os.path.expanduser("~"), "seguesoftNC", "testsuites")
AUTOModuleTestsuites=os.path.join(TESTSUITES, "AutoTests-Modules")
AUTOModuleTestsuitesRunning=os.path.join(AUTOModuleTestsuites, "RFC6241-datastore")

AUTOModuleTestsuitesNMDARunning=os.path.join(AUTOModuleTestsuites, "NMDA-datastore")
#AUTOModuleTestsuitesNMDAIntended=os.path.join(AUTOModuleTestsuites, "NMDA-Intended")
#AUTOModuleTestsuitesNMDAOperational=os.path.join(AUTOModuleTestsuites, "NMDA-Operational")
"""


dataStoreRadio1 = "RFC6241 Datastore"
dataStoreRadio2 = "NMDA Datastore (RFC8342)" 
#dataStoreRadio3 ="NMDA <running>, <intended> and <operational> in RFC8342"


#try:
#    os.makedirs(AUTOModuleTestsuites, exist_ok = True)
#    os.makedirs(AUTOModuleTestsuitesRunning, exist_ok = True)
#    os.makedirs(AUTOModuleTestsuitesNMDARunning, exist_ok = True)
##    #os.makedirs(AUTOModuleTestsuitesNMDAIntended, exist_ok = True)
##    #os.makedirs(AUTOModuleTestsuitesNMDAOperational, exist_ok = True)
##
##    print("Default TESTSUITES Directory '%s' created successfully" % TESTSUITES)
##    firstCreated = True
#except OSError as error:
#    print("Default TESTSUITES Directory '%s' can not be created" % TESTSUITES)            

# copy standard tests to user testsuite path
# check if there is a new installation
#t1 = os.path.getmtime(INSTALLED_TESTSUITES)    
#t2 = os.path.getmtime(TESTSUITES)        
#if firstCreated or t2 < t1:
#    try:
#        shutil.rmtree(TESTSUITES, ignore_errors=True)
#        shutil.copytree(INSTALLED_TESTSUITES, TESTSUITES, dirs_exist_ok=True)   
#        shutil.rmtree("%s/All-Modules-Combined"%TESTSUITES, ignore_errors=True)
#        print("Copy tests to '%s' finished successfully" % TESTSUITES)
#    except OSError as error:
#        print("Copy tests to '%s' can not be done: %s" % (TESTSUITES, error))            

if platform.system() == "Windows":
    FLMID_APP = "%s/fortlm/windows/flmid.exe"%APP_INSTALLATION_ROOT
    #TESTSUITES = "%s/testsuites"%APP_INSTALLATION_ROOT

    if os.path.isfile(f"{APP_INSTALLATION_ROOT}/Python/Scripts/pyang.exe"):
        PYTHON_APP = "%s/Python/pythonw.exe"%APP_INSTALLATION_ROOT
        PyangScript = f"{APP_INSTALLATION_ROOT}/Python/Scripts/pyang.exe"
        YANGLint = f"{APP_INSTALLATION_ROOT}/Python/Scripts/yanglint.exe"
        RIDEScript = f"{APP_INSTALLATION_ROOT}/Python/Scripts/ride.py"
    else:
        # in workspace dev mode
        PYTHON_APP = sys.executable        
        pythondir = os.path.abspath(os.path.dirname(PYTHON_APP))
        PyangScript = f"{pythondir}/Scripts/pyang.exe"
        YANGLint = f"{pythondir}/Scripts/yanglint.exe"        
        RIDEScript = f"{pythondir}/Scripts/ride.py"                 

elif platform.system() == "Linux":    
    FLMID_APP = "%s/fortlm/linux/flmid"%APP_INSTALLATION_ROOT 
    #TESTSUITES = "%s/testsuites"%APP_INSTALLATION_ROOT
    if os.path.isfile(f"{APP_INSTALLATION_ROOT}/Python/Scripts/pyang"):    
        PYTHON_APP = "%s/Python/bin/python"%APP_INSTALLATION_ROOT
        PyangScript = "%s/Python/bin/pyang"%APP_INSTALLATION_ROOT        
        YANGLint = "%s/Python/bin/yanglint"%APP_INSTALLATION_ROOT        
        RIDEScript  = "%s/Python/bin/ride.py"%APP_INSTALLATION_ROOT
    else:
        # in workspace dev mode
        PYTHON_APP = sys.executable        
        pythondir = os.path.normpath(os.path.join(os.path.realpath(PYTHON_APP), ".."))
        PyangScript = f"{pythondir}/pyang"
        RIDEScript = f"{pythondir}/ride.py"        
        YANGLint = f"{pythondir}/yanglint"        

elif platform.system() == "Darwin":
    FLMID_APP = "%s/fortlm/macos/flmid"%APP_INSTALLATION_ROOT  
    #TESTSUITES = "%s/testsuites"%APP_INSTALLATION_ROOT

    if os.path.isfile(f"{APP_INSTALLATION_ROOT}/Python/Scripts/pyang"):    
        PYTHON_APP = "%s/Python/bin/python"%APP_INSTALLATION_ROOT  
        PyangScript = f"{APP_INSTALLATION_ROOT}/Python/bin/pyang"
        YANGLint = f"{APP_INSTALLATION_ROOT}/Python/bin/yanglint"
        RIDEScript = f"{APP_INSTALLATION_ROOT}/Python/bin/ride.py"
    else:
        # in workspace dev mode
        PYTHON_APP = sys.executable        
        pythondir = os.path.normpath(os.path.join(os.path.realpath(PYTHON_APP), ".."))
        PyangScript = f"{pythondir}/pyang"            
        RIDEScript = f"{pythondir}/ride.py"     
        YANGLint = f"{pythondir}/yanglint"        
        if not os.path.isfile(PyangScript):
            PyangScript = os.path.normpath(shutil.which("pyang"))
        if not os.path.isfile(YANGLint):
            YANGLint = os.path.normpath(shutil.which("yanglint"))
        if not os.path.isfile(RIDEScript):
            RIDEScript = os.path.normpath(shutil.which("ride.py"))

        print("PyangScript ", PyangScript)
        print("YANGLint ", YANGLint)
        print("RIDEScript ", RIDEScript)    
        
MODE="CLI"
DEMOORFULLGUI=""
SEGUE_DEBUG = 0        
    
APP_PREFERENCE_DATA_PATH = os.path.expanduser("~/.seguesoft/GUITools")
if platform.system() == "Windows":
    APP_PREFERENCE_DATA_PATH = os.path.join(os.environ['APPDATA'], 'Seguesoft', 'GUITools')

if not os.path.exists(APP_PREFERENCE_DATA_PATH):
    os.makedirs(APP_PREFERENCE_DATA_PATH)


NETCONFc_WINDOWN_TITLE = "REST+NETCONFc"
MasterYANG_WINDOWN_TITLE = "MasterYANG"

try:
    with open(f"{APP_INSTALLATION_ROOT}/build_date.txt",'r') as f:
        buildate = f.read()
except:
        buildate = 0000-00-00
        
NETCONFc_VERSION_STRING = "%s"%buildate.strip('"') 

NEED_A_VALUE_FOR_KEY = "NEED-A-VALUE-FOR-KEY-NODE!"
# Used to define custom event IDs
ID_CUSTOM_START = 1


identifierNames =["anyxml", "anydata", "bit", "belongs-to", "case", "choice", 
                  "container", "deviation", "deviate", "enum",  "extension", "feature",
                  "grouping", "import", "include", "identity",
                   "leaf", "leaf-list", 
                   "list", "module", "notification", "prefix", "rpc", "submodule",
                    "typedef", "name"]

builtin_int_types = ["int8", "int16", "int32", "int64"
        "uint8", "uint16", "uint32", "uint64"]

builtin_identity=[]

builtin_types = ["binary",
        "bits", "boolean",
        "decimal64", "empty",
        "enumeration", "identityref",
        "instance-identifier",
        "int8", "int16", "int32", "int64",
        "leafref", "string",
        "uint8", "uint16", "uint32", "uint64",
        "union"]

numerical_builtin_types = ["decimal64",
        "int8", "int16", "int32", "int64",
        "uint8", "uint16", "uint32", "uint64"]

numerical_builtin_types_extended = ["decimal64",
        "int8", "int16", "int32", "int64",
        "uint8", "uint16", "uint32", "uint64",
        "decimal64.1", "decimal64.2", "decimal64.3",
        "decimal64.4", "decimal64.5", "decimal64.6",
        "decimal64.7", "decimal64.8", "decimal64.9",
        "decimal64.10", "decimal64.11", "decimal64.12",
        "decimal64.13", "decimal64.14","decimal64.15",
        "decimal64.16", "decimal64.17","decimal64.18"]

numericTypeMin = {"int8"  : "-128",
                "int16" : "-32768",
                "int32" : "-2147483648",
                "int64" : "-9223372036854775808",
                "uint8" : "0",
                "uint16" : "0",
                "uint32" : "0",
                "uint64" : "0",           
                "decimal64.1" : "-922337203685477580.8",
                "decimal64.2" : "-92233720368547758.08",
                "decimal64.3" : "-9223372036854775.808",
                "decimal64.4" : "-922337203685477.5808",
                "decimal64.5" : "-92233720368547.75808",
                "decimal64.6" : "-9223372036854.775808",
                "decimal64.7" : "-922337203685.4775808",
                "decimal64.8" : "-92233720368.54775808",
                "decimal64.9" : "-9223372036.854775808",
                "decimal64.10" : "-922337203.6854775808",
                "decimal64.11" : "-92233720.36854775808",
                "decimal64.12" : "-9223372.036854775808",
                "decimal64.13" : "-922337.2036854775808",
                "decimal64.14" : "-92233.72036854775808",
                "decimal64.15" : "-9223.372036854775808",
                "decimal64.16" : "-922.3372036854775808",
                "decimal64.17" : "-92.23372036854775808",
                "decimal64.18" : "-9.223372036854775808",
                                 
             }

numericTypeMax = {"int8" : "127",
                "int16" : "32767",
                "int32" : "2147483647",
                "int64" : "9223372036854775807",
                "uint8" :  "255",
                "uint16" : "65535",
                "uint32" : "4294967295",
                "uint64" : "18446744073709551615",         
                "decimal64.1" : "922337203685477580.7",
                "decimal64.2" : "92233720368547758.07",
                "decimal64.3" : "9223372036854775.807",
                "decimal64.4" : "922337203685477.5807",
                "decimal64.5" : "92233720368547.75807",
                "decimal64.6" : "9223372036854.775807",
                "decimal64.7" : "922337203685.4775807",
                "decimal64.8" : "92233720368.54775807",
                "decimal64.9" : "9223372036.854775807",
                "decimal64.10" : "922337203.6854775807",
                "decimal64.11" : "92233720.36854775807",
                "decimal64.12" : "9223372.036854775807",
                "decimal64.13" : "922337.2036854775807",
                "decimal64.14" : "92233.72036854775807",
                "decimal64.15" : "9223.372036854775807",
                "decimal64.16" : "922.3372036854775807",
                "decimal64.17" : "92.23372036854775807",
                "decimal64.18" : "9.223372036854775807",                                 
              }

decimal64Min = { "decimal64.1" : "-922337203685477580.8",
                "decimal64.2" : "-92233720368547758.08",
                "decimal64.3" : "-9223372036854775.808",
                "decimal64.4" : "-922337203685477.5808",
                "decimal64.5" : "-92233720368547.75808",
                "decimal64.6" : "-9223372036854.775808",
                "decimal64.7" : "-922337203685.4775808",
                "decimal64.8" : "-92233720368.54775808",
                "decimal64.9" : "-9223372036.854775808",
                "decimal64.10" : "-922337203.6854775808",
                "decimal64.11" : "-92233720.36854775808",
                "decimal64.12" : "-9223372.036854775808",
                "decimal64.13" : "-922337.2036854775808",
                "decimal64.14" : "-92233.72036854775808",
                "decimal64.15" : "-9223.372036854775808",
                "decimal64.16" : "-922.3372036854775808",
                "decimal64.17" : "-92.23372036854775808",
                "decimal64.18" : "-9.223372036854775808",
                }

decimal64Max = {"decimal64.1" : "922337203685477580.7",
                "decimal64.2" : "92233720368547758.07",
                "decimal64.3" : "9223372036854775.807",
                "decimal64.4" : "922337203685477.5807",
                "decimal64.5" : "92233720368547.75807",
                "decimal64.6" : "9223372036854.775807",
                "decimal64.7" : "922337203685.4775807",
                "decimal64.8" : "92233720368.54775807",
                "decimal64.9" : "9223372036.854775807",
                "decimal64.10" : "922337203.6854775807",
                "decimal64.11" : "92233720.36854775807",
                "decimal64.12" : "9223372.036854775807",
                "decimal64.13" : "922337.2036854775807",
                "decimal64.14" : "92233.72036854775807",
                "decimal64.15" : "9223.372036854775807",
                "decimal64.16" : "922.3372036854775807",
                "decimal64.17" : "92.23372036854775807",
                "decimal64.18" : "9.223372036854775807",
                } 

data_statements=["extension",
                "feature",
                "identity",
                "typedef",
                "grouping",
                "container", "leaf", "leaf-list",
                 "list", "choice", "anyxml", "anydata",
                "uses",
                "augment",
                "rpc",
                "notification",
                "deviation"]         


node_cannot_empty = ["augment", "base", "config", "deviate", "if-feataure",
                     "mandatory", "min-elements", "max-elements",  "module", "must", "ordered-by",  
                     "position", "prefix", 
                     "presence", "refine",  "revision-date",  "submodule", "status", "typedef", "type",
                     "units", "value", "when", "yin-element", "yang-version"]    


SSCLIENT_PATH = os.path.normpath(os.path.join(os.path.dirname(os.path.abspath(__file__)) , "..", "ssclient"))

#SEGUE_master_yang_preferences_file = os.path.join(APP_PREFERENCE_DATA_PATH, "segue_master_yang_preferences.ini")
SEGUE_netconfc_preferences_file = os.path.join(APP_PREFERENCE_DATA_PATH, "segue_netconfc_preferences.ini")
print("SEGUE_netconfc_preferences_file ", SEGUE_netconfc_preferences_file)
                                              
MasterYANGdefaultPreferenceDict = { # 'moduleColum_width' : '220',
                                    #'revColum_width' : '100',
                                    #'fileColum_width' : '480',                          
                                    #'YANG_TREE_FRAME_WIDTH' : '800',
                                    #'YANG_TREE_FRAME_HEIGHT' : '600',
                                    #'YANG_TREE_FRAME_PROPORTION' : '0.66',
                                    "YANG_PATH_FILES_PROPORTION"  : '0.12',
                                    "YANG_PATH_FILES_SELECTED_ITEMIDX" :'0',
                                    #'statementColum_width' : '150', 
                                    #'argumentColum_width' : '380', 
                                    #'DATA_TREE_FRAME_WIDTH' : '800',
                                    #'DATA_TREE_FRAME_HEIGHT' : '600',      
                                    #'moduleAdvertisedColumn_width' : '330', 
                                    #'valueColumn_width' : '180',                                                                    
                                    #'YANG_TAB_WIDTH': '2', 
                                    #'YANG_MODPATH' : Default_Module_Path,
                                    #'YANG_VIEW_SCALE': '100',
                                    #'license_proxy': '', 
                                    #'license_proxy_port' : '',
                                    #'license_proxy_user' : '',
                                    #'license_proxy_password' : '',
                                    #"YANG_MODULE_RECURSIVE":"True",
                                    "global_validate_rfc6087_rules" : "False",
                                    "validate_xpath_yang" : "False",
                                    "validate_rfc6087_rules": "False",
                                    "validate_normal_rules": "False",
                                    #"last_modules_list": "",
                                    #"all_YANG_Paths" : ""
                                    }

NETCONFcdefaultPreferenceDict =  {  'moduleColum_width' : '420',
                                    'revColum_width' : '100',
                                    'fileColum_width' : '380',  
                                    'YANG_TREE_FRAME_WIDTH' : '800',
                                    'YANG_TREE_FRAME_HEIGHT' : '600',
                                    'YANG_TREE_FRAME_PROPORTION' : '0.5',
                                    'statementColum_width' : '150', 
                                    'argumentColum_width' : '280',                                    
                                    'DATA_TREE_FRAME_WIDTH' : '800',
                                    'DATA_TREE_FRAME_HEIGHT' : '600',
                                    'DATA_TREE_FRAME_PROPORTION' : '0.5',
                                    'moduleAdvertisedColumn_width' : '330', 
                                    'valueColumn_width' : '180',   
                                    'instNodeColumn_width' : '200',
                                    'instValueColumn_width' : '180',                                                                     
                                    'YANG_TAB_WIDTH': '2', 
                                    'YANG_MODPATH' : Default_Module_Path,
                                    'YANG_VIEW_SCALE': '100',
                                    'license_proxy': '', 
                                    'license_proxy_port' : '',
                                    'license_proxy_user' : '',
                                    'license_proxy_password' : '',
                                    'ssh_user_name':'',
                                    'ssh_user_password':'',
                                    'http_user_name':'',
                                    'http_user_password':'', 
                                    'http_auth':'Basic',               
                                    'http_cert_verify' : 'Yes',                                
                                    'ssh_host':'',
                                    'ssh_port':'830',
                                    'callhome_ssh_port': '4334',
                                    'callhome_tls_port': '4335',
                                    'callhome_rest_port': '4336',                                    
                                    'tls_port':'6513',
                                    'http_port':'8443',
                                    'client_cert':'',
                                    'client_key':'',
                                    'trusted_certs':'', 
                                    'tls_version': '',
                                    'tls_ciphers':'',
                                    'ssh_ciphers':'',                                   
                                    'ssh_privkey_file':'',
                                    'http_client_cert':'',
                                    'http_client_key':'',
                                    'http_trusted_certs':'',   
                                    'http_version':'1.1',                                    
                                    'ssh_timeout': '15',
                                    'ssh_keep_alive' : '300',
                                    'data_encoding' : 'JSON',
                                    'use_scheme' : 'HTTPS',
                                    'selectedModules': "",
                                    'add_custom_caps' : "",  
                                    'CONFIG_URLS': '',  
                                    'MAX_FAILURE': '', 
                                    "socks_server": '',
                                    "socks_port": "1080",
                                    "socks_type": "SOCKS5", 
                                    "socks_user": "",
                                    "socks_password": "", 
                                    "ignore_hello_namespace":"False",
                                    "use_netconf_1_dot_1" : "True",
                                    "use_netconf_1_dot_0" : "False",
                                    #"global_validate_xpath_yang" : "False",
                                    "YANG_MODULE_RECURSIVE":"True",
                                    "last_modules_list": "",
                                    #"all_YANG_Paths" : "",
                                    "rest_headers": "",                                    
                                    "rest_headers_for_get" : "", 
                                    "rest_headers_for_head": "", 
                                    "rest_headers_for_options": "", 
                                    "rest_headers_for_post_data": "", 
                                    "rest_headers_for_post_operations": "", 
                                    "rest_headers_for_put": "",
                                    "rest_headers_for_patch": "",
                                    "rest_headers_for_delete": "",                                    
                                    "hostname_ip_history" : "",
                                    "custom_title": "",
                                    "title_history": "",
                                    "enter_value":"",
                                    "enter_history": "",
                                    "find_value": "", 
                                    "find_history": "",  
                                    "skip_get_hostinfo": "True",
                                    "edit_config_test_option": "unspecified",
                                    "edit_config_error_option": "unspecified",
                                    "edit_config_default_operation": "unspecified",
                                    "rest_retrieval_with_defaults" : "unspecified",
                                    "rest_retrieval_depth" : "0",
                                    "rest_retrieval_content" : "unspecified",
                                    "rest_edit_datastore_target" : "unspecified",
                                    "rest_retrieval_datastore_target" : "unspecified",
                                    "defaultRootResource" :"/restconf",
                                    "useDefaultRootResource" :"No",
                                    "use_cached_etag_timestamp" : "true",
                                    #"dataStoreType" : dataStoreRadio1,
                                    "configFilterBool": 2,
                                    "withOriginBool" : False,
                                    "orginFiltesNegateBool" : 2,
                                    "intendedOirignFilter": False,
                                    "dynamicOirignFilter":False,
                                    "systemOirignFilter": False,
                                    "learnedOirignFilter": False,
                                    "defaultOirignFilter": False,
                                    "unknownOirignFilter": False,
                                    "maxDepthSCValue": 1,
                                    "maxDepthCbxValue": False,
                                    "maxDepthCbx2Value": True,
                                    "withDefaults": "unspecified"
                                    }

# shallow copying is ok since dict values are all simple types 
MasterYANGdefaultPreferenceDict.update(NETCONFcdefaultPreferenceDict)

def getCurrentLicenseInfo(license_env_name):
    licenseFileName = ""
    licenseInfo = ""          
    if license_env_name in os.environ:
        licenseFileName = os.environ[license_env_name]
    else:                   
        licenseFileName = os.path.join(APP_INSTALLATION_ROOT, "fortlm_license.lic")    
    #print("licenseFile name ",   licenseFileName)  
    if os.path.isfile(licenseFileName):
        with open(licenseFileName, "r") as fp:
            licenseInfo =  fp.read()
    #print("licenseInfo retrieved ", licenseInfo)                               
    return (licenseFileName, licenseInfo)


def obtainPreferencesObj(file, defaultDict):
    # read in config file
    #preferences = configparser.SafeConfigParser(defaultDict)
    #preferences = configparser.ConfigParser(defaultDict)
    # SafeConfigParser was deprecated starting in Python 3.2 and completely removed in Python 3.12.
    # Use ConfigParser. It already includes the behavior of the old SafeConfigParser.
    try:
        preferences = configparser.SafeConfigParser(defaultDict)
    except AttributeError:
        preferences = configparser.ConfigParser(defaultDict)
       
    fileSuccessfullyReadList =  preferences.read(file)
    if not len(fileSuccessfullyReadList):
        preferences.add_section('Main')
        preferences.add_section('Activation')           

    for section in ["Main", "Activation"]:
        if not preferences.has_section(section):
            preferences.add_section(section)
        
    return preferences

def updatePreferenceValue(preferencesObj, section, name, value):    
    if not preferencesObj.has_section(section):
        preferencesObj.add_section(section)
    
    # escape %
    strvalue = str(value)     
    if strvalue.find("%") != -1:        
        idxLst = [n for n in range(len(strvalue)) if strvalue.find("%", n) == n]
        nstrvalue = ""
        preidx = 0
        for idx in idxLst:
            nstrvalue = nstrvalue + strvalue[preidx:idx] + "%"
            preidx = idx 
        if preidx != 0:
            nstrvalue = nstrvalue + strvalue[preidx:]
        strvalue = nstrvalue 
             
    preferencesObj.set(section, name, strvalue)

def writePreferenceFile(preferencesObj, file):
    with open(file, 'w') as outfile:
        preferencesObj.write(outfile)
    

def is_junction(path: str) -> bool:
    try:
        return bool(os.readlink(path))
    except OSError:
        return False
