#---------------------------------------------------------------------
# Copyright (C) 2013  Seguesoft  Inc.
#                                                                             
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
# Modified based on ncclient
# ----------------------------------------------------------------------
# Copyright 2011 ChampNMS

from .rpc import RPC
from ..xml_ import *

from . import util
    
from ..transport import SessionListener

NOTIFICATION_NS = 'urn:ietf:params:xml:ns:netconf:notification:1.0'

class CreateSubscription(RPC):
    def request(self, stream="default",
                startTime=None, stopTime=None,
                filter=None, 
                xPathNamespacePrefixMap=None,
                callback=None, msgid=None):
                
                
        node = new_ele("create-subscription",  xmlns=NOTIFICATION_NS)
        
        if stream != "default":
            sub_ele(node, "stream").text = stream

        if filter is not None:
            node.append(util.build_filter(filter, xPathNamespacePrefixMap=xPathNamespacePrefixMap))
        if startTime is not None:
            sub_ele(node, "startTime").text = startTime
            
        if stopTime is not None:
            sub_ele(node, "stopTime").text = stopTime            
        return self._request(node, callback=callback, msgid=msgid)                


