#---------------------------------------------------------------------
# Copyright (C) 2013  Seguesoft  Inc.
#                                                                             
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
# Modified based on ncclient
# ----------------------------------------------------------------------
# Copyright 2009 Shikhar Bhushan
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

'Boilerplate ugliness'

from ..xml_ import *
from .errors import OperationError, MissingCapabilityError
import re

def one_of(*args):
    "Verifies that only one of the arguments is not None"
    for i, arg in enumerate(args):
        if arg is not None:
            for argh in args[i+1:]:
                if argh is not None:
                    raise OperationError("Too many parameters")
            else:
                return
    raise OperationError("Insufficient parameters")

def datastore_or_url(wha, loc, capcheck=None, forceUrl=False):
    node = new_ele(wha)
    if forceUrl == True:
        if capcheck is not None:
            #capcheck(":url") # url schema check at some point!
            sub_ele(node, "url").text = loc
    
    elif "://" in loc: # e.g. http://, file://, ftp://
        if capcheck is not None:
            #capcheck(":url") # url schema check at some point!
            sub_ele(node, "url").text = loc
    else:
        #if loc == 'candidate':
        #    capcheck(':candidate')
        #elif loc == 'startup':
        #    capcheck(':startup')
        #elif loc == 'running' and wha == 'target':
        #    capcheck(':writable-running')
        sub_ele(node, loc)
    return node

# this can only handle a single top level filter string
# for multiple one, either pass each top level filter in
# or pass in a pre-made filter string     
def build_filter(spec, xPathNamespacePrefixMap=None):
    filtertype = None    
    if isinstance(spec, tuple):        
        filtertype, criteria = spec
        # We only need the namespace declarations that are actually used        
        # in lxml tree  we use nsmap =
        if filtertype == "xpath":
            nsMapToUse={}
            allPrefixes = re.findall(r"/.+?:", criteria)
            for pfx in allPrefixes:
                #remove leading "/" and trailing ":"
                pfx = pfx[1:-1]
                if pfx in xPathNamespacePrefixMap:                    
                    nsMapToUse[pfx] =  xPathNamespacePrefixMap[pfx]
        
            rep = new_ele("filter", type=filtertype, nsmap=nsMapToUse)
        else:
            # If we are building subtree filter then since we always use full
            # namespace qualified name, lxml will take care of adding 
            # namespace attributes in the "right" place
            rep = new_ele("filter", type=filtertype)
            
        if criteria.strip() == "" and filtertype == "xpath":
            #empty select is invalid xpath but we still allow this for tesing purpose
            rep.attrib["select"] = criteria      
        
        if criteria.strip() != "":
            if filtertype == "xpath":
                rep.attrib["select"] = criteria                
            elif filtertype == "subtree":                    
                rep.append(to_ele(criteria))

            else:
                raise OperationError("Invalid filter type")
    else:
        # The filter string has already been built separately so we just need to validate it
        rep = validated_element(spec, ("filter", qualify("filter")),
                                        attrs=("type",))
        # TODO set type var here, check if select attr present in case of xpath..
   
    #if type == "xpath" and capcheck is not None:
    #    capcheck(":xpath")
    return rep

def build_get_data_filter(spec, xpath=False, xPathNamespacePrefixMap=None):
    filtertype = None
    print("specccc ", spec, " xPathNamespacePrefixMap ", xPathNamespacePrefixMap)
    if isinstance(spec, tuple):        
        filtertype, criteria = spec
        # We only need the namespace declarations that are actually used        
        # in lxml tree  we use nsmap =
        if filtertype == "xpath-filter":
            nsMapToUse={}
            allPrefixes = re.findall(r"/.+?:", criteria)
            for pfx in allPrefixes:
                #remove leading "/" and trailing ":"
                pfx = pfx[1:-1]
                if pfx in xPathNamespacePrefixMap:                    
                    nsMapToUse[pfx] =  xPathNamespacePrefixMap[pfx]
            rep = new_ele("xpath-filter", nsmap=nsMapToUse)
            rep.text = criteria
        else:
            # If we are building subtree filter then since we always use full
            # namespace qualified name, lxml will take care of adding 
            # namespace attributes in the "right" place
            rep = new_ele("subtree-filter")                   
            if criteria.strip() != "":
                rep.append(to_ele(criteria))
    else:
        # The filter string has already been built separately so we just need to validate it
        rep = validated_element(spec, ("subtree-filter", qualify("subtree-filter")))
   
    #if type == "xpath" and capcheck is not None:
    #    capcheck(":xpath")
    return rep

def build_withDefaults(spec, capcheck=None):
    # allow spec to be anything so we can test if the DUT return an error when unknown spec is used
    rep = new_ele("with-defaults", xmlns="urn:ietf:params:xml:ns:yang:ietf-netconf-with-defaults")
    rep.text=spec
    
    return rep    
  
def getTimeStamp():
 return strftime("%Y-%m-%d %H:%M:%S", gmtime())

#def getRPCType(msgxml):
#    name= "Not Found"
#    tname=""
#    try:
#        elem= ElementTree.fromstring(msgxml)  
#        tname=elem.tag
#        idx=tname.find("}")+1
#        tname=tname[idx:]
        
        
 #       #rpc name
 #       #The first child is the rpc name
 #       #nameNode =elem.find("./{urn:ietf:params:xml:ns:netconf:base:1.0}rpc")
 #       nameNode =elem[0]
 #       if nameNode is not None:
 #           name= nameNode.tag
 #           idx=name.find("}")+1
 #           name=name[idx:]           
#
#    except:
#        pass
#        
#    return (tname,name)   
    
# seguesoft added    
from time import gmtime, strftime

indent_flag = True
    

# http://effbot.org/zone/element-lib.htm#prettyprint

# in-place prettyprint formatter

def indent(elem, level=0):
    i = "\n" + level*"  "
    if len(elem):
        if not elem.text or not elem.text.strip():
            elem.text = i + "  "
        if not elem.tail or not elem.tail.strip():
            elem.tail = i
        for elem in elem:
            indent(elem, level+1)
        if not elem.tail or not elem.tail.strip():
            elem.tail = i
    else:
        if level and (not elem.tail or not elem.tail.strip()):
            elem.tail = i
"""            
# Adds whitespace to the tree, so that saving it as usual results in a prettyprinted tree.    
# With fixed about wrong indent on closing brackets
def indent(elem, level=0):
    i = "\n" + level*"  "
    if len(elem):
        if not elem.text or not repr(elem.text).strip():  
            elem.text = i + "  "            
    
        if not elem.tail or not repr(elem.tail).strip():
            elem.tail = i

        for child in elem:
            indent(child, level+1)    
            
        if not child.tail or not child.tail.strip():
            child.tail = i
        if not elem.tail or not elem.tail.strip():
            elem.tail = i        
         
            
    else:
        if level and (not elem.tail or not repr(elem.tail.strip())):
            elem.tail = i        
"""
def unindent(elem):    
    if len(elem):
        if elem.text:
            elem.text= elem.text.strip()
        if elem.tail:
            elem.tail = ""

        for child in elem:
            unindent(child)    
          
        if child.tail:
            child.tail = ""
        if elem.tail:
            elem.tail = ""
    else:     
        if elem.text:
            elem.text= elem.text.strip()
        if elem.tail:
            elem.tail = ""
    