#!/bin/bash

# Pieces borrowed from: https://github.com/owntracks/tools

# Set up a default search path.
PATH="/bin:/usr/bin:/usr/local/bin"
export PATH

CACERT_BASE=ca
SERVER_BASE=server

CA_C="US"
CA_ST="Illinois"
CA_L="Champaign"
CA_O="Seguesoft"
CA_OU="Seguesoft CERT generator"

CA_CN="server.example.tld"
CA_EMAIL="nobody@example.tld"
 
# Set the following optional environment variables before invocation
# to add the specified IP addresses and/or hostnames to the subjAltName list
# These contain white-space-separated values
#
#	IPLIST="172.13.14.15 192.168.1.1"
#	HOSTLIST="a.example.com b.example.com"

# A space-separated list of alternate hostnames (subjAltName)
# may be empty ""
ALTHOSTNAMES=${HOSTLIST}
ALTADDRESSES=${IPLIST}

# Chage this to the server CN that is to be certified
CA_CN="fortlm.mooo.com"
CA_EMAIL="xiangli@seguesoft.com"

CA_CN=`hostname -f`
SUBJ="/C=${CA_C}/ST=${CA_ST}/L=${CA_L}/O=${CA_O}/OU=${CA_OU}/CN=${CA_CN}/emailAddress=${CA_EMAIL}"

#CA_CPW=""
#SUBJ="${SUBJ}/challengePassword=${CA_CPW}"

DIGEST_ALG="-sha512"

# Returns OK (0) if $1 contains $2.
# Otherwise returns Not OK (1).
strstr() {
  [ "${1#*$2*}" = "$1" ] && return 1
  return 0
}

function getipaddresses() {
	/sbin/ifconfig |
		grep -v tunnel |
		sed -En '/inet6? /p' |
		sed -Ee 's/inet6? (addr:)?//' |
		awk '{print $1;}' |
		sed -e 's/[%/].*//' |
		egrep -v '(::1|127\.0\.0\.1)'	# omit loopback to add it later
}

function addresslist() {
	ALIST=""
	for a in $(getipaddresses); do
		ALIST="${ALIST}IP:$a,"
	done
	ALIST="${ALIST}IP:127.0.0.1,IP:::1,"

	for ip in $(echo ${ALTADDRESSES}); do
		ALIST="${ALIST}IP:${ip},"
	done
	for h in $(echo ${ALTHOSTNAMES}); do
		ALIST="${ALIST}DNS:$h,"
	done
	ALIST="${ALIST}DNS:localhost"
	echo ${ALIST}
}

if [ ! -f ${CACERT_BASE}.key ] || [ ! -f ${CACERT_BASE}.key ] ; then
  echo "Certificate authority (CA) files could not be located.  Please create them."
  echo "Not proceeding.  Nothing has been done."
  exit 1
fi

if [ -f ${SERVER_BASE}.csr ] || [ -f ${SERVER_BASE}.crt ] || [ -f ${SERVER_BASE}.key ] ; then
  echo -n 'Prior SERVER files exist.  Do you wish to replace them? (Y)es/(N)o? [N] '
  read answer
  if ( strstr "nN" "${answer}" ) || [ -z "${answer}" ] ; then
  	 echo "Not proceeding.  Nothing has been done.  You may run this script again."
  	 exit 1
  fi
fi

rm -f ${SERVER_BASE}.csr ${SERVER_BASE}.crt ${SERVER_BASE}.key

# There's no way to pass subjAltName on the CLI so
# create a cnf file and use that.

CNF=`mktemp /tmp/cacnf.XXXXXXXX` || { echo "$0: can't create temp file" >&2; exit 1; }
sed -e 's/^.*%%% //' > ${CNF} <<\!ENDconfig
		%%% [ IWLextensions ]
		%%% basicConstraints        = critical,CA:false
		%%% nsCertType              = server
		%%% keyUsage                = nonRepudiation, digitalSignature, keyEncipherment
		%%% nsComment               = "Broker Certificate"
		%%% subjectKeyIdentifier    = hash
		%%% authorityKeyIdentifier  = keyid,issuer:always
		%%% subjectAltName          = $ENV::SUBJALTNAME
		%%% # issuerAltName           = issuer:copy
		%%% ## nsCaRevocationUrl       = http://mqttitude.org/carev/
		%%% ## nsRevocationUrl         = http://mqttitude.org/carev/
		%%% certificatePolicies     = ia5org,@polsection
		%%% 
		%%% [polsection]
		%%% policyIdentifier	    = 1.3.5.8
		%%% CPS.1		    = "http://localhost"
		%%% userNotice.1	    = @notice
		%%% 
		%%% [notice]
		%%% explicitText            = "This CA is for a local MQTT broker installation only"
		%%% organization            = "IWL"
		%%% noticeNumbers           = 1

!ENDconfig

SUBJALTNAME="$(addresslist)"
export SUBJALTNAME		# Use environment. Because I can. ;-)

openssl genrsa -out ${SERVER_BASE}.key 2048
openssl req -new ${DIGEST_ALG} -subj "${SUBJ}" -out ${SERVER_BASE}.csr -key ${SERVER_BASE}.key
openssl x509 -req ${DIGEST_ALG} -in ${SERVER_BASE}.csr -CA ${CACERT_BASE}.crt -CAkey ${CACERT_BASE}.key -CAcreateserial -out ${SERVER_BASE}.crt -days 367789 -extfile ${CNF} -extensions IWLextensions

rm -f ${CNF}

echo "======================================================================"
openssl req -text -noout -subject -in ${SERVER_BASE}.csr
echo "======================================================================"
openssl rsa  -check -noout -in ${SERVER_BASE}.key
echo "======================================================================"
openssl x509 -text -noout -subject -in ${SERVER_BASE}.crt
echo "======================================================================"
