
'''
# Created 2017
# Copyright (C) Seguesoft                                               
#                                                                             
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
'''
import traceback
import requests
from common_global_variables import DEBUGPRINT

import json, sys, six
#import urllib.request, urllib.parse, urllib.error

import urllib

import abc
from lxml.etree import fromstring, tostring
from .hyper.contrib import HTTP20Adapter

from requests.auth import HTTPBasicAuth
from requests.auth import HTTPDigestAuth
import logging
logger = logging.getLogger(__name__)


    
class RESTRequestErrorException(Exception):
    def __init__(self, message, preparedreqobj):
        self.text = message
        #self.preparedreqobj = preparedreqobj
        self.request = preparedreqobj
        self.ok = False

#class RestCalls(object, metaclass=abc.ABCMeta):

class RestCalls(six.with_metaclass(abc.ABCMeta)):
    """ Creates RESTconf session.
        authType: "basic" or "digest"

    """
    
    Accept = [
        'application/yang.data+{fmt}',
        'application/yang.errors+{fmt}',
    ]
    ContentType = 'application/yang.data+{fmt}'

    def __init__(self, ip_address,
                       port=80, 
                       client_sock=None,
                       scheme="http",
                       username=None, 
                       password=None, 
                       authType="basic",
                       client_cert=None, client_key=None, cacert=None, verify=True, 
                       http_version="2.0", 
                       timeout=30,
                       defaultRootResource= '/restconf',
                       socks_proxy={},
                       ):
                               
        # The Session object allows you to persist certain parameters
        # across requests. It also persists cookies across all requests 
        # made from the Session instance, and will use urllib3's 
        # connection pooling. So if you're making several requests to 
        # the same host, the underlying TCP connection will be reused, 
        # which can result in a significant performance increase 
        # (see HTTP persistent connection).    
        self.root_resource = defaultRootResource.strip("/")
        session = requests.Session()
        #DEBUGPRINT("session timeout " + str(timeout))        
        self.timeout =timeout
        
        # Sessions can also be used to provide default data to the request 
        # methods. This is done by providing data to the properties 
        # on a Session object:
        
        if username is not None and password is not None:
            if authType.lower() == "basic":
                #DEBUGPRINT(" basic auth")
                session.auth = HTTPBasicAuth(username, password)
            elif authType.lower() == "digest":
                session.auth = HTTPDigestAuth(username, password)
            
        # client cert    
        if scheme.lower() == "https":
            if client_cert is not None:
                if client_key is not None:
                    session.cert = (client_cert, client_key)
                else:
                    # cert already contains client private key
                    session.cert = client_cert
          
        #print "session.cert  ", session.cert 
        # server cert 
                
        if verify:
            # pass verify the path to a CA_BUNDLE file 
            # you can pass verify False to disable validate server cert
            session.verify = cacert
            # force using https
            scheme = "https"
            
        else:
            session.verify = False 
                
        # default session headers to use    
        
        # RFC  8040 7.2
        # A client can determine if the RESTCONF server supports an encoding
        # format by sending a request using a specific format in the
        # "Content-Type" and/or "Accept" header field.  If the server does not
        # support the requested input encoding for a request, then it MUST
        # return an error response with a "415 Unsupported Media Type"
        # status-line.  If the server does not support any of the requested
        # output encodings for a request, then it MUST return an error response
        # with a "406 Not Acceptable" status-line.

        # in this case self.Format is assinged by subclasses    
        session.headers.update({
            'Accept': ','.join([
                accept.format(fmt=self.Format) for accept in self.Accept
            ]),
            'Content-Type': self.ContentType.format(fmt=self.Format),
        })
        
        
        
        self._host = '{scheme}://{ip}:{port}'.format(
            scheme=scheme.lower(),
            ip=ip_address,
            port=port
        )
        
        if http_version == "2" or http_version == "2.0":
            # requests doesn't support HTTP/2 though. 
            # To rectify that oversight, hyper provides a transport adapter that
            # can be plugged directly into Requests, giving it instant HTTP/2 support.         
            session.mount(self._host, HTTP20Adapter())
            
            
        self._session = session
        
        # Retrieve the Top-Level API Resource
        # Do this when the first request is sent  
        
        # Retrieve Server Module Information
        # do this when calling parse_restconf_server_capabilities  in unit_module_store

    def post(self,  url, data="", **kwargs):
        return self._post('POST', url, data, **kwargs)

    def post_data(self, target, data="", **kwargs):
        """POST data, rpc, action
            data String xml or json.
        """
        if target.startswith(self.root_resource):
            url = self._host + target            
        else:
            if target.startswith("http"):
                url = target
            else:
            
                # an target is passed in. For instance 
                # ietf-yang-library:modules-state/module=ietf-netconf-acm,2012-02-22
                url = self._host + self.root_resource.rstrip("/") + "/data" + "/" +  target.lstrip("/")                    
                        
        return self._post('POST', url, data, **kwargs)
                        

        
    def post_operations(self, target, data="", **kwargs):
        """POST data, rpc, action
            data String xml or json.
        """   
        if target.startswith(self.root_resource):
            url = self._host + target            
        else:
            if target.startswith("http"):
                url = target
            else:            
                # an target is passed in. For instance 
                # ietf-yang-library:modules-state/module=ietf-netconf-acm,2012-02-22
                url = self._host + self.root_resource.rstrip("/") + "/operations" + "/" + target.lstrip("/")
                    
        return self._post('POST', url, data, **kwargs)
                        
    
    def put(self, target, data="", **kwargs):
        """PUT 
            return response object or RESTRequestErrorException instance
        """
        if target.startswith(self.root_resource):
            url = self._host + target            
        else:
            if target.startswith("http"):
                url = target
            else:
            
                # an target is passed in. For instance 
                # ietf-yang-library:modules-state/module=ietf-netconf-acm,2012-02-22
                url = self._host + self.root_resource.rstrip("/") + "/data" + "/" + target.lstrip("/")
        return self._post('PUT', url, data, **kwargs)
        
    def patch(self, target, data="", **kwargs):
        """PATCH 
            return response object or RESTRequestErrorException instance
        """
        if target.startswith(self.root_resource):
            url = self._host + target            
        else:
            if target.startswith("http"):
                url = target
            else:
                # an target is passed in. For instance 
                # ietf-yang-library:modules-state/module=ietf-netconf-acm,2012-02-22            
                url = self._host + self.root_resource.rstrip("/") + "/data" + "/" + target.lstrip("/")

        return self._post('PATCH', url, data, **kwargs)
            
        
    def _post(self, rtype, url, data, **kwargs):   
             
        # kwargs:
        #  headers = {}
        #  params = {}
        # 
        DEBUGPRINT("in kwargs ", kwargs)
        msgid = ""
        if "msgid" in kwargs:
            msgid = kwargs["msgid"]
            del kwargs["msgid"]
        
        DEBUGPRINT("in kwargs after ", kwargs)    
        headers = {}
        if "headers" in kwargs:
            headers = kwargs["headers"]
            del kwargs["headers"]
            
        # to prevent python requests from percent encoding params
        # escape 'point' encoding
        if "insPointDsi" in kwargs: 
            insPointDsi = kwargs["insPointDsi"]
            DEBUGPRINT("in _post insPointDsi ", insPointDsi)
            del kwargs["insPointDsi"]                   
            if "point" in kwargs:
                DEBUGPRINT("inrt point ", kwargs["point"])
                for _, keyvalue in  kwargs["point"]:
                    insPointDsi = insPointDsi + "=" + str(keyvalue) + ","
                # reassign the final value back    
                kwargs["point"] =  insPointDsi.rstrip(",")
                    
        # do not quote again already percent encoded char   
        # point=value must be percent escaped except "%"              
        # The argument to urllib.parse.quote must a string, 
        # but the v may be int
        payload_str = "&".join("%s=%s" % (k, urllib.parse.quote(str(v), "%")) 
                    for k,v in list(kwargs.items()))

        DEBUGPRINT("_post url ", url, " payload_Str ", payload_str , "data ", data)
        # use prepare_request so that we get a chance to modify sent data if needed
        # and we can also dispaly sent packet even if the request timeout       
        req = requests.Request(rtype,  url, data=data, headers=headers, params=payload_str )
        #req = requests.Request(rtype,  url, data=data, headers=headers, params=kwargs )
        
        # this, In particular, makes sure that Session-level state such as cookies
        # will also get applied to your request.
        prepped = self._session.prepare_request(req)
        DEBUGPRINT("prepared ", prepped)
        # e.g: we can now do something with prepped.headers before sending the request out
        
        #prepped.headers['Keep-Dead'] = 'parrot'      
        dumR= RESTRequestErrorException("POST error: " , prepped)          
        DEBUGPRINT("returned here before", dumR)
        if msgid.startswith("DRYRUN_REQUEST_ID_"): 
            DEBUGPRINT("returned here!", dumR.text)
            return dumR
        
        logger.info(" %s "%rtype + prepped.url)       
        logger.info("request headers:\n" + str(prepped.headers))         
        try:
            resp = self._session.send(prepped,
                                      timeout=self.timeout,
                                      )
            
        except Exception as e:
            # print "get error " + str(e) 
            # This ???             
            logger.info(prepped.url)   
            return RESTRequestErrorException("POST error: " + repr(e), prepped)
        
        logger.info("response headers:\n" + str(resp.headers))        
        logger.info("\nresponse data:\n" + resp.text)        
        resp.request = prepped
        
        dictNoCase = dict( [(k.lower(), v) for k, v in list(resp.headers.items())])
        #DEBUGPRINT("dictNoCase ", dictNoCase)
        if "Last-Modified".lower() in dictNoCase:
            self.last_modified = dictNoCase["last-modified"]
            #DEBUGPRINT("self.last_modified ", self.last_modified)
        if "ETag".lower() in  dictNoCase:
            self.etag = dictNoCase["etag"]
            #DEBUGPRINT("self.etag ", self.etag)
        
        DEBUGPRINT((resp.status_code))
        return resp
        
    def options(self, target, **kwargs):
        # The OPTIONS method is sent by the client to discover which methods
        # are supported by the server for a specific resource (e.g., GET, POST,
        # DELETE).  The server MUST implement this method.

        # The "Accept-Patch" header field MUST be supported and returned in the
        # response to the OPTIONS request, as defined in [RFC5789].    
        return self._retriveal('OPTIONS', target, **kwargs)
        
    def head(self, target, **kwargs):
        # The RESTCONF server MUST support the HEAD method.  The HEAD method is
        # sent by the client to retrieve just the header fields (which contain
        # the metadata for a resource) that would be returned for the
        # comparable GET method, without the response message-body.  It is
        # supported for all resources that support the GET method.    
        return self._retriveal('HEAD', target, **kwargs)
        
    def get(self, target, **kwargs):    
        return self._retriveal('GET', target, **kwargs)
    
    def _retriveal(self, rtype, target, **kwargs):
        """GET RESTconf call            
            target = '', resource id or url            
                              
            kwargs:
            content:
                unspecified --
                all -- Return all descendant data nodes. 
                       unbounded or omitted. This is default                      
                config -- Return only configuration descendant data nodes
                nonconfig -- Return only non-configuration descendant data nodes
                
            depth:
                unspecified --
                unbounded -- retrieve all of the child resources
                              unbounded or omi'.  This is the default
                unbounded -- 1, 2, 3 ...
                              
            with-defaults:
                unspecified --
                report-all-tagged
                report-all
                trim
                explicit
            fields:
                unspecified/""/None/fieldsexpr
                
            headers = {} -- additional headers to include in request
                            must be given as a dict{header1: value, header2: value,}
            
        """
        #url = self._host + target
        #print "? target ", target,  " kwargs", kwargs
        if target.startswith("/.well-known/host-meta"):
            url = self._host + target
        elif target.startswith("http"):
            url = target
        elif target.startswith(self.root_resource):
            url = self._host + target                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
        else:
            # an target is passed in. For instance 
            # ietf-yang-library:modules-state/module=ietf-netconf-acm,2012-02-22
            url = self._host + self.root_resource.rstrip("/") + "/data" + "/"+ target.lstrip("/")
                        
        if "content" in kwargs:
            if kwargs["content"] != "unspecified":
                kwargs.update({'content': '%s'%kwargs["content"]})    
            else:
                del kwargs["content"]
        
        if "depth" in kwargs:
            if kwargs["depth"] != "unspecified" and int(kwargs["depth"]) != 0:
                kwargs.update({'depth': '%s'%kwargs["depth"]})  
            else:
                del kwargs["depth"]
        
        if "with-defaults" in kwargs:
            if kwargs["with-defaults"] != "unspecified":
                kwargs.update({'with-defaults': '%s'%kwargs["with-defaults"]}) 
            else:
                del kwargs["with-defaults"]
                
                
        if "fields" in kwargs:
            if kwargs["fields"] != "unspecified" and kwargs["fields"] != "" and kwargs["fields"] is not None:
                kwargs.update({'fields': '%s'%kwargs["fields"]})  
            else:
                del kwargs["fields"]
                
        #DEBUGPRINT("constructed url ", url, "kwargs: ", kwargs)     
        
        headers = {}
        if "headers" in kwargs:
            headers = kwargs["headers"]
            del kwargs["headers"]
                 
        # to prevent python requests from percent encoding params
        payload_str = "&".join("%s=%s" % (k,v) for k,v in list(kwargs.items()))

        # use prepare_request so that we get a chance to modify sent data if needed
        # and we can also dispaly sent packet even if the request timeout       
        req = requests.Request(rtype,  url,  headers=headers, params=payload_str )
        #req = requests.Request(rtype,  url, headers=headers, params=kwargs )
        
        # this, In particular, makes sure that Session-level state such as cookies
        # will also get applied to your request.
        prepped = self._session.prepare_request(req)
        
        # e.g: we can now do something with prepped.headers before sending the request out
        #prepped.headers['Keep-Dead'] = 'parrot'        
        
        logger.info(" %s "%rtype + prepped.url)       
        logger.info("request headers:\n" + str(prepped.headers))         
        try:
            resp = self._session.send(prepped,
                                      timeout=self.timeout,
                                      )
            
        except Exception as e:
            print("get error! " + str(e), "\n", traceback.format_exc())
            # This ???             
            logger.info(prepped.url)   
            return RESTRequestErrorException("GET error: " + repr(e), prepped)
        
        logger.info("response headers:\n" + str(resp.headers))        
        logger.info("\nresponse data:\n" + resp.text)      

        # update session's notion of timestamp and eTag
        #'last-modified': 'Mon, 20 Nov 2017 19:59:04 GMT', 'etag': '-5012614979785167186',
        
        # For configuration data resources, the server MAY maintain a
        # last-modified timestamp for the resource and return the
        # "Last-Modified" header field when it is retrieved with the GET or
        # HEAD methods.
   
        # For configuration data resources, the server SHOULD maintain a
        # resource entity-tag for each resource and return the "ETag" header
        # field when it is retrieved as the target resource with the GET or
        # HEAD methods. 
        
        dictNoCase = dict( [(k.lower(), v) for k, v in list(resp.headers.items())])
        #DEBUGPRINT("dictNoCase ", dictNoCase)
        if "Last-Modified".lower() in dictNoCase:
            self.last_modified = dictNoCase["last-modified"]
            #DEBUGPRINT("self.last_modified ", self.last_modified)
        if "ETag".lower() in  dictNoCase:
            self.etag = dictNoCase["etag"]
            #DEBUGPRINT("self.etag ", self.etag)
            
        #DEBUGPRINT((resp.status_code))
        return resp
     

            
    def delete(self, target):
        """GET RESTconf call
            :param target: String selection of YANG model and container
            :type target: str
            :return: Return the response object
            :rtype: Response object
        """

        if target.startswith(self.root_resource):
            url = self._host + target            
        else:
            if target.startswith("http"):
                url = target
            else:
            
                # an target is passed in. For instance 
                # ietf-yang-library:modules-state/module=ietf-netconf-acm,2012-02-22
                url = self._host + self.root_resource.rstrip("/") + "/data" + "/" +  target.lstrip("/") 
        res = self._session.delete(url)
        return res
