#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #
# Redistribution of this software, in whole or in part, is prohibited #
# without the express written permission of Seguesoft.                #
#######################################################################   
import os, sys

# Extend system path to import 'ssmanager' package under the 
# installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                                    "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

# This is one of the higher level convenient commmands.
# These higher level commands include hget, hget_config,
# create, merge, delete, replace and remove.

# The result of these commands is a tuple of 
# (True/ False, reply_xml, reply_element, request_xml, request_element

# set up YANG module path.  If no path is given, use the default path which is 
# the same as in NETCONFc GUI
  
# Set paths to YANG models and load them
# The YANG path directories MUST be writable by the application
# since the application will need to generate XML based 
# definition files.
#
#s.load_yang_modules_in_paths("C:/MY-YANG-modules",  "C:/MY-YANG-modules2", recursive=True)
# Set YANG model path to the default path, which is the same as in the GUI NETCONFc
s.load_yang_modules_in_paths()

r = s.create("/sys:system/sys:contact", "Joe", 
            namespaces={"sys": "urn:ietf:params:xml:ns:yang:ietf-system"})

# use simplified prefix form 
r = s.create("/sys:system/contact", "Joe", 
        namespaces={"sys": "urn:ietf:params:xml:ns:yang:ietf-system"})

# multiple branches              
r = s.create("/sys:system/contact", "Joe",  
            "/sys:system/hostname", "JoeHost", 
            namespaces={"sys": "urn:ietf:params:xml:ns:yang:ietf-system"})

# The following is an example of using module name as prefix. 
# In this case no namespace mapping is required 
# The module referred must be loaded first
#
r = s.create("/ietf-system:system/contact", "Joe")
r = s.create("/ietf-system:system/contact", "Joe", 
             "/ietf-system:system/hostname", "JoeHost" )

# When using this high level API to create list, you don't need to 
# specify list key values as separate arguments, rather they are 
# implicitly specified in the list key node 'predicates'

# We can just pass in instance-ID-1, value, instance-ID-2, value, etc.
# The key node does not need to be given explicitly 

r = s.create("/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/group", "guest",                          
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/module-name", "ietf-netconf-monitoring",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/access-operations", "*",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/action", "deny",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/comment", "Do not allow guests any access to the NETCONF monitoring information",
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error"
        )

# If you want more control on how to create this list such as inserting 
# to a specific place, then the first argument should be the list entry 
# instance-id such as
# /nacm:nacm/rules-list[name='guest-acl']
# The second argument is the dictionary that how you want this entry to 
# be created, For example:
# {"insert_operation": "after", "target_key": target-predicate}

r= s.create("/nacm:nacm/rules-list[name='guest-acl']", {"insert_operation": "before", "target_key" : "[nacm:name='family-acl']"},         
        "/nacm:nacm/rules-list[name='guest-acl']/group", "guest",                          
        "/nacm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']", {"insert_operation": "after", "target_key" : "[nacm:name='allow-ncm']"},                  
        "/nacm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/module-name", "ietf-netconf-monitoring",
        "/nacm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/access-operations", "*",
        "/nacm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/action", "deny",
        "/nacm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/comment", "Do not allow guests any access to the NETCONF monitoring information",
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error",
        namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"},
        )

# If you need to turn on 'with_default' attribute, add the item "with_default" 
# into the value dictionary
# {"value" : "*", "with_default":True}

r = s.create("/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/group", "guest",                          
             "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/module-name", "ietf-netconf-monitoring",
             "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/access-operations", {"value" : "*", "with_default":True},
             "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/action", "deny",
             "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/comment", "Do not allow guests any access to the NETCONF monitoring information",
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error",
        )

# Create or modify two or more list entries in a single RPC, 
r= s.create( # first top list entry
         "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/group", "guest",    
        
        # nested list entry 1                 
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/module-name", "ietf-netconf-monitoring",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/access-operations", "*",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/action", "deny",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/comment", "Do not allow guests any access to the NETCONF monitoring information",
        
        # nested list entry 2
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='allow-ncm']/module-name", "ietf-system",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='allow-ncm']/access-operations", "*",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='allow-ncm']/action", "deny",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='allow-ncm']/comment", "Allow guests any access to the NETCONF ietf-system",
        
         # second top list entry
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/group", "guest",
                            
        # nested list entry 1                                        
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='deny-ncm']/module-name", "ietf-netconf-monitoring",
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='deny-ncm']/access-operations", "*",
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='deny-ncm']/action", "deny",
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='deny-ncm']/comment", "Do not allow guests any access to the NETCONF monitoring information",
        
        # nested list entry 2
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='allow-ncm']/module-name", "ietf-system",
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='allow-ncm']/access-operations", "*",
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='allow-ncm']/action", "deny",
        "/ietf-netconf-acm:nacm/rules-list[name='family-acl']/rule[name='allow-ncm']/comment", "Allow guests any access to the NETCONF ietf-system",
                            
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error",             
        )


# create and insert
# using module name as prefix
r= s.create("/ietf-netconf-acm:nacm/rules-list[name='guest-acl']", {"insert_operation" : "before", "target_key" : "[ietf-netconf-acm:name='family-acl']"},          
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/group", "guest",                          
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']", {"insert_operation" : "after", "target_key" : "[ietf-netconf-acm:name='allow-ncm']"},                  
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/module-name", "ietf-netconf-monitoring",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/access-operations", "*",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/action", "deny",
        "/ietf-netconf-acm:nacm/rules-list[name='guest-acl']/rule[name='deny-ncm']/comment", "Do not allow guests any access to the NETCONF monitoring information",
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error",
        )
              
# This is one of the higher level convenient commands using IID
r = s.delete("/sys:system/sys:contact", "Joe",
         "/sys:system/sys:hostname", "JoeHost",
         namespaces={"sys": "urn:ietf:params:xml:ns:yang:ietf-system"}
         )

# Example to use module name as prefix. No namespace mapping is required 
# in this case but the module must be loaded first!
#s.load_module_by_name_revision("ietf-system", "2014-08-06")

# The usage of delete/ remove is exactly the same

r = s.delete("/ietf-system:system/contact", "Joe", 
             "/ietf-system:system/hostname", "JoeHost" )

# delete a list entry
s.remove("/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']", "", 
            namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"})
         
         
# When using this high level API to create list, you don't need to specify 
# list key values as separate arguments, instead they are implicitly specified 
# in the list key node 'predicates'

r = s.delete("/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:group", "guest",                          
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:module-name", "ietf-netconf-monitoring",
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:access-operations", "*",
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:action", "deny",
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:comment", "Do not allow guests any access to the NETCONF monitoring information",
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error",             
        namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"},
        )

# remove example
r = s.remove("/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:group", "guest",                          
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:module-name", "ietf-netconf-monitoring",
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:access-operations", "*",
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:action", "deny",
        "/nacm:nacm/nacm:rules-list[nacm:name='guest-acl']/nacm:rule[nacm:name='deny-ncm']/nacm:comment", "Do not allow guests any access to the NETCONF monitoring information",
        target="candidate", 
        test_option="test-then-set",
        error_option="rollback-on-error",             
        namespaces={"nacm": "urn:ietf:params:xml:ns:yang:ietf-netconf-acm"},
        )


