#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #
# Redistribution of this software, in whole or in part, is prohibited #
# without the express written permission of Seguesoft.                #
#######################################################################   

import os, sys
# Extend system path to import 'ssmanager' package under 
# the installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)),
                         "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")

s.print_rpc_stdout(True)
#s.print_rpc_stdout(False)

#lock unlock datastore
r = s.lock("candidate")

r = s.unlock("running")

#partial lock and unlock

#RFC 5717
#A NETCONF operation that locks parts of the running datastore.
#XPath expression that specifies the scope of the lock. An Instance
#Identifier expression MUST be used unless the :xpath capability
#is supported, in which case any XPath 1.0 expression is
#allowed.


r = s.partial_lock("/nacm:nacm", "/nacm:nacm2", 
        namespaces={"nacm": "http://netconfcentral.org/ns/yuma-nacm"})

# The result is a tuple of five values:
# Operation succeeded (True or False), 
# reply in xml format, reply in lxml element format, 
# request in xml format, request in lxml element format

# convert xml to a tuple of (nodeid, value) list
resList, nsmap = s.extract_prefixed_node_id_and_value_from_rpc_reply(r[2])    
for res in resList:
    print("nodeID ", res[0], "=>", res[1])
    
# To unlock, we need to get the lock-id returned in the previous partial-lock 
# operation and use it for partial-unlock

if r[0] == True:
    lockid = s.extract_value_from_rpc_reply(r[1], "/pl:lock-id",
                        namespaces={"pl": "urn:ietf:params:xml:ns:netconf:partial-lock:1.0"})
    print("lock id ", lockid)
    if lockid !="":
        r = s.partial_unlock(lock_id=lockid)
        print("Sending partial unlock succeeded? ", 
                r[0], " \n=====Result=====:\n", 
                r[1], " \n=====Request=====:\n", r[3])
    else:
        raise Exception("no lockid was extracted from partial-lock reply!")
else:
    print("partical locking failed")        
