#!/usr/bin/env python
#######################################################################
# Copyright (C) 2014 -2021  Seguesoft  Inc.                           #
# Redistribution of this software, in whole or in part, is prohibited #
# without the express written permission of Seguesoft.                #
#######################################################################   
import os, sys

# Extend system path to import 'ssmanager' package under 
# the installation directory.
sys.path.append(os.path.join(os.path.dirname(os.path.abspath(__file__)), 
                                        "..", "..", "ssclient"))
import ssmanager

# Create netconf session
s=ssmanager.create_session(host="seguesoft.com", port=830, 
                user="testconf", password="testconf2")
# s.set_indent_flag(True)
s.print_rpc_stdout()

# validate config store
r = s.validate("startup")
r = s.validate("candidate")
r = s.validate("running")

# validate url
r = s.validate("file:///a.cfg")

#inline config data
configdata="""
<config  xmlns:arp="http://netconfcentral.org/ns/yuma-arp" xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0" xmlns:ns2="http://netconfcentral.org/ns/yuma-interfaces">
 <arp:arp>
    </arp:arp>
    <ns2:interfaces>
      <ns2:interface>
        <ns2:name>1</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>11</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>111</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>1113</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>1212</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>1ss</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>adasda</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>afd</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>asdfas</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>dadsad</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>ddd</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>ddddddd112</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>eth0</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>lo</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>lo1</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>myinterface</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>ooo</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>qcvdf</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>rtet</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>samuel</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>sit0</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>trtrtr</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>tyryryr</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>yyyy</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>??</ns2:name>
      </ns2:interface>
      <ns2:interface>
        <ns2:name>??a??</ns2:name>
      </ns2:interface>
    </ns2:interfaces>
</config>
"""

# validate an inline config content that represents the entire config
r = s.validate(configdata)
print("Sending succeeded? ", 
            r[0], " \n=====Result=====:\n",
            r[1], " \n=====Request=====:\n", r[3])
