#**********************************************************************
# Copyright (c) 2021 Seguesoft, All Rights Reserved                   *
#                                                                     *
#              RESTRICTED RIGHTS LEGEND                               *
#**********************************************************************

import os, ctypes, sys, struct
import ctypes.util
        
LICENSE_CHECKED_OK=False
def checkLicense(feature=None):
    global LICENSE_CHECKED_OK 
    curdir = os.path.dirname(os.path.abspath(__file__))
    is64bit = True
    if struct.calcsize("P") * 8 == 32:
        is64bit = False
        #print("This is a 32-bit Python. SegueConf need 64-bit Python to run!")
        #exit(1)        

    if sys.platform == "linux" or sys.platform == "linux2":
        # linux
        if is64bit:
            soname = os.path.normpath(os.path.join(curdir, "..", "fortlm", "linux",
                                  "libchamplicense.so"))
        else:
            soname = os.path.normpath(os.path.join(curdir, "..", "fortlm", "linux",
                                  "libchamplicense.so"))

    elif sys.platform == "darwin":
        # OS X
        if is64bit:
            soname = os.path.normpath(os.path.join(curdir, "..", "fortlm", "macos",
                                  "libchamplicense.so"))
        else:
            print("32-bit platform '%s' not is supported!"%sys.platform)
            exit(1)                                      
    elif sys.platform == "win32" or sys.platform == "windows":
        # Windows...
        if is64bit:
            soname = os.path.normpath(os.path.join(curdir, "..", "fortlm", "windows",
                                  "libchamplicense.dll"))
        else:
            soname = os.path.normpath(os.path.join(curdir, "..", "fortlm", "windows32",
                                  "libchamplicense.dll"))            
    else:
        print("Platform '%s' not is supported!"%sys.platform)
        exit(1)

    # ctypes provides two LibraryLoader(s): CDLL and WinDLL.
    # CDLL supports __cdecl and WinDLL supports __stdcall (Windows only).
    # Depending on the calling convention you use in your
    # C library you have to use the right LibraryLoader in Python.
    #print("soname ", soname)
    flm = ctypes.CDLL(soname)
            
    lfname = os.path.normpath(os.path.join(curdir, "..",  "fortlm_license.lic"))
    
    os.environ["SEGUE_CONF_LICENSE"] =  lfname

    if feature is not None:
        featureBuf = ctypes.create_string_buffer(128)
        featureBuf.value = feature.encode("utf-8")
    else:
        featureBuf = None

    versionBuf = ctypes.create_string_buffer(128)
    versionBuf.value = b'1'

    envNameBuf = ctypes.create_string_buffer(128)
    envNameBuf.value = b'SEGUE_CONF_LICENSE'

    pubkeyBuf = ctypes.create_string_buffer(2048)
    pubkeyBuf.value = \
        b"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDtdvg549q+nmb4bHTOFn7k1t2l" + \
        b"abFUwXRfu1Vn1OCen83UawcocnsIno0vKWxBYw61Q/Bg+X+57xRoGvJybC2O6Yvb" + \
        b"t1x73bWLE8Sx4JwY+0AnlNNjVPT2QKi2Vioz0e96K2hGEVfSmRbLMeyIl5fnO8Wa" + \
        b"Z3R5l3e+FruiYoiz6QIDAQAB"

    # Trial key license verification need an extra private key digest
    # openssl  dgst -sha256 champnms_netconfc_priv_key.pem
    # SHA256(champnms_netconfc_priv_key.pem.pem)= 9d43f2426460cc1a59cd7eecbf4b5c21183c765a3d2fe82d4b1e1f6955f586bc
    # dos2unix may need to be performed on champnms_netconfc_priv_key.pem
    # NetconfcPrivkeyDgst = "40c86f9a16e7706fce484124fcca0825f092110fe556ad2f29f2b3f437e9e6d9"
    pkDigestBuf = ctypes.create_string_buffer(256)
    pkDigestBuf.value = b"40c86f9a16e7706fce484124fcca0825f092110fe556ad2f29f2b3f437e9e6d9"   
    # 
    # Enable clock reset checking
    flm.enable_clock_check()      

    flm.fortlm_verify_license_ex.restype = ctypes.c_int
    flm.license_err2str.restype = ctypes.c_char_p

    result = flm.fortlm_verify_license_ex(envNameBuf, pubkeyBuf, None, 
            featureBuf, versionBuf, pkDigestBuf)

    if result == 0:
        print("License file verified ok ... ")
        err = ""
        LICENSE_CHECKED_OK=True
        return 0
    else:       
        err = flm.license_err2str(result)
        # ctypes automatically convert c_char_p to bytes objects
        print(err.decode(), file=sys.stderr)
        exit(1)

