#---------------------------------------------------------------------
# Copyright (C) 2013  Seguesoft  Inc.
#                                                                             
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
# Modified based on ncclient
# ----------------------------------------------------------------------
# Copyright 2009 Shikhar Bhushan
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from .. import NCClientError

class TimeoutError(NCClientError):
    def __init__(self, request_xml="", request_ele=None):
        self.request_xml = request_xml
        self.request_ele = request_ele
        
    def __str__(self):
        return "Timeout request. No reply was received."
    def __repr__(self):
        return "Timeout request. No reply was received."
    
    
class ReplyParsingError(NCClientError):
    def __init__(self, err_msg="Reply parsing error", reply_xml="", request_xml=None, request_ele=None):
        self.err_msg = err_msg
        self.request_xml = request_xml
        self.request_ele = request_ele
        self.reply_xml = reply_xml
        
        
    def __str__(self):
        return self.err_msg
    def __repr__(self):
        return self.err_msg

class RPCRequestError(NCClientError):
    def __init__(self, request_xml="", request_ele=None, err_msg=""):
        self.request_xml = request_xml
        self.request_ele = request_ele
        self.err_msg =err_msg
        
    def __str__(self):
        return "Request got error!\n%s\n%s"%(self.request_xml, self.err_msg)
    def __repr__(self):
        return "Request got error!\n%s\n%s"%(self.request_xml, self.err_msg)

class OperationError(NCClientError):
    pass
class TimeoutExpiredError(NCClientError):
    pass

class MissingCapabilityError(NCClientError):
    pass
