#---------------------------------------------------------------------
# Copyright (C) 2013 - 2014  Seguesoft  Inc.
#                                                                             
# Redistribution of this software, in whole or in part, is prohibited         
# without the express written permission of Seguesoft. 
# Modified based on ncclient
# ----------------------------------------------------------------------
# Copyright 2009 Shikhar Bhushan
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import time
import queue
from threading import Thread, Lock, Event, currentThread
import _thread
from random import randint

from ..xml_ import *
from .. import xml_
from ..capabilities import Capabilities
from ..operations import util
from .errors import TransportError
from ..operations.errors import ReplyParsingError

import logging, traceback
import six

#logging.basicConfig(level=logging.DEBUG)
#logger = logging.getLogger('ncclient.transport.session')
logger = logging.getLogger(__name__)

def _notification_event_set(event):
   while 1 :
        print("start checking traps")
        #we wait for the flag to be set.
        #while not event.isSet():
        #    event.wait(0.01)
        event.wait()
        print(currentThread(), "...Woken Up")
        event.clear()




class Session(Thread):

    "Base class for use by transport protocol implementations."

    def __init__(self, capabilities, timeout=60):
        Thread.__init__(self)
        self.setDaemon(True)
        self._listeners = set()
        self._lock = Lock()
        self.setName('session')
        self._q = queue.Queue()
        self._client_capabilities = capabilities
        self._server_capabilities = None # yet
        self._id = None # session-id
        self._timeout=timeout # default timeout
        self._connected = False # to be set/cleared by subclass implementation
        self._host=None #to be set by SSHSession
        self._hostsrc=None #to be set by SSHSession
        self._delim_ver=1
        self.chunk_msg_test_buffer_len=0
        #logger.debug('%r created: client_capabilities=%r' %
        #             (self, self._client_capabilities))

    def _dispatch_message(self, raw):
        # Debugging reply
        logger.info('\nReceived message from %s:\n%s '% (self._host, raw))
        # test1 
        #if raw.find("xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"") != -1:
        #    raw = raw.replace(" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"", "")
            
        # test2    
        #if raw.find("message-id=\"0001333\"") != -1:
        #    raw = """<?xml version='1.0' encoding='UTF-8'?>
        #    <rpc-reply message-id="00013332" xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
        #     <data/>                  
        #    </rpc-reply>"""

        # test3
        #if raw.find("message-id=") == -1 and raw.find("<hello") == -1 :
        #    raw = """<?xml version='1.0' encoding='UTF-8'?>
        #<rpc-reply xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
        #  <rpc-error>
        #    <error-type>application</error-type>
        #    <error-tag>access-denied</error-tag>
        #    <error-severity>error</error-severity>
        #    <error-message>creating "nacm" data node is not permitted.</error-message>
        #  </rpc-error>
        # </rpc-reply>"""
        #
        # test 4
        
        #if raw.find("message-id=\"seguetest_action\"") != -1:
        #    raw = """<rpc-reply message-id="seguetest_action"
        #        xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
        #           <reset-finished-at xmlns="urn:example:server-farm">
        #               2014-07-29T13:42:12Z
        #           </reset-finished-at>
        #         </rpc-reply>"""

        #
        #if raw.find("message-id=\"seguetest_annotation\"") != -1:
        #    raw = """<rpc-reply xmlns="urn:ietf:params:xml:ns:netconf:base:1.0" message-id="seguetest_annotation">
        #          <data>
        #            <nacm xmlns="urn:ietf:params:xml:ns:yang:ietf-netconf-acm" xmlns:elm="http://example.org/example-last-modified" elm:last-modified="2015-09-16T10:27:35+02:00">
        #                <denied-operations>0</denied-operations>
        #            </nacm>
        #          </data>
        #        </rpc-reply>"""
        #
        
        #if raw.find("hello") == -1:
        #    raw="""<?xml version='1.0' encoding='UTF-8'?>
        #    <rpc-reply xmlns:ncx="http://netconfcentral.org/ns/yuma-ncx" xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
        #    <rpc-error>
        #      <error-type>transport</error-type>
        #      <error-tag>malformed-message</error-tag>
        #      <error-severity>error</error-severity>
        #      <error-app-tag>data-invalid</error-app-tag>
        #      <error-message xml:lang="en">invalid protocol framing characters received</error-message>
        #    </rpc-error>
        #    </rpc-reply>"""
        #
                
       
        try:            
            #if raw[0] != '<':
            #    raw = raw[raw.find("<"):]
                
            root = parse_root(raw)
        except Exception as e:
            logger.info('error parsing dispatch message: %s\n%s', e, raw)
            # can't raise here.
            # request listener expect a string to display error in a dialog
            raise ReplyParsingError("Invalid RPC reply! Parsing error: %s\n%s"%(e, raw))      
            #return 
        
        # Ignore "ignore server hello containing no namespace error'         
        tag, attrs = root
        #print(" hello tag: ", tag)
        #print("Root root ", root, " tag ", tag)
        if tag.startswith("{"):
            xml_.NO_BASE_NS_1_0 = False
        
        with self._lock:
            listeners = list(self._listeners)
        for l in listeners:
            #logger.debug('dispatching message to %s: %s' %(l, raw))
            logger.info('dispatching to: %s' %l)
            logger.info('dispatching message: %s' % raw)
            l.callback(root, raw) # no try-except; fail loudly if you must!
    
    def _dispatch_error(self, err):
        with self._lock:
            listeners = list(self._listeners)   
        for l in listeners:
            logger.info('dispatching error: \n%s' % err)
            try: # here we can be more considerate with catching exceptions
                l.errback(err) 
            except Exception as e:
                logger.info('error dispatching to %r: %r' % (l, e))

    def stop_listen_notification(self):
        while True:
            instance = self.get_listener_instance(NotificationListener)
            if instance is not None:
                #print "REMOVING NOTIFICATION LISTENER"
                self.remove_listener(instance)
            else:
                break
                
    def listen_notification(self, callback=None):     
        #event = Event()    
        def ok_cb(raw):
            if callback is not None:
                #print "self._host", self._host, "callback ", callback
                callback(self._host, raw)
            #event.set()
                            
        listener = NotificationListener(ok_cb)
        self.add_listener(listener)
        logger.info('starting main loop to receive notifications...')
        # we expect server's hello message
        #print "listen_notification"
        
        #thread.start_new_thread(_notification_event_set,(event,))
        
        #while 1:
        #    event.set()
        #    print event," Has been set"
        #    time.sleep(2)
           

    def _post_connect(self):
        "Greeting stuff"
        init_event = Event()
        error = [None] # so that err_cb can bind error[0]. just how it is.
        # callbacks
        def ok_cb(id, capabilities, raw):
            #print(" okback called "+ raw)
            self._id = id
            self._server_capabilities = capabilities
            self._server_capabilities_raw = raw
            init_event.set()
        def err_cb(err):
            #print(" errback called "+ err)
            error[0] = err
            init_event.set()
            
        listener = HelloHandler(ok_cb, err_cb)
        self.add_listener(listener)
        
        hello=HelloHandler.build(self._client_capabilities)
        #logger.info("Sending client hello %s"% six.ensure_str(hello))
        
        if "file://no_client_hello_first_test" not in self._client_capabilities:
            self.send(hello)
                                  
            if "file://send_extra_hello" in self._client_capabilities:
                self.send(hello)
                                           
        #logger.debug('starting the main loop')

        # Logging in threads under robotframwork issue:
        #
        # If a library uses threads, it should generally communicate with the framework only 
        # from the main thread. If a worker thread has, for example, a failure to report or 
        # something to log, it should pass the information first to the main thread, which 
        # can then use exceptions or other mechanisms explained in this section for c
        # ommunication with the framework.

        # This is especially important when threads are run on background while other keywords 
        # are running. Results of communicating with the framework in that case are undefined 
        # and can in the worst case cause a crash or a corrupted output file. If a keyword 
        # starts something on background, there should be another keyword that checks the 
        # status of the worker thread and reports gathered information accordingly.

        # Messages logged by non-main threads using the normal logging methods from programmatic 
        # logging APIs are silently ignored.

        # There is also a BackgroundLogger in separate robotbackgroundlogger project, with a 
        # similar API as the standard robot.api.logger. Normal logging methods will ignore 
        # messages from other than main thread, but the BackgroundLogger will save the 
        # background messages so that they can be later logged to Robot's log.

        self.start()
        # we expect server's hello message
        # WAIT 30 SECONDS
        init_event.wait(30)
                    
        # received hello message or an error happened
        self.remove_listener(listener)
                
        if error[0]:
            print("error0 ", error[0])
            logger.info("Receiving server hello error %s"% error[0])
            raise Exception(error[0])

        #when timeout happens, init_Event is not set! 
        if  init_event.isSet() == False:
            errmsg ="Did not receive hello message from the server ( possibly in wrong namespace?) or received incorrect hello message!"
            logger.info("Receiving server hello error %s"% errmsg)
            raise Exception(errmsg)


        logger.info("Received server hello %s"% self._server_capabilities_raw)

        if "file://no_client_hello_first_test" in self._client_capabilities:                
            self.send(hello)   
            # wait 3 seconds to ket the server finish processing client hello
            time.sleep(3)     

        if "urn:ietf:params:netconf:base:1.1" in self._server_capabilities \
            and "urn:ietf:params:netconf:base:1.1" in self._client_capabilities:
            self._delim_ver = 2

    def add_listener(self, listener):
        """Register a listener that will be notified of incoming messages and
        errors.

        :type listener: :class:`SessionListener`
        """
        #we don't want this to be logged into the debug output when running tests
        #logger.debug('installing listener %r' % listener)
        if not isinstance(listener, SessionListener):
            raise TransportError("Listener must be a SessionListener type")
        with self._lock:
            self._listeners.add(listener)

    def remove_listener(self, listener):
        """Unregister some listener; ignore if the listener was never
        registered.

        :type listener: :class:`SessionListener`
        """
        #logger.debug('discarding listener %r' % listener)
        with self._lock:
            self._listeners.discard(listener)

    def get_listener_instance(self, cls):
        """If a listener of the specified type is registered, returns the
        instance.

        :type cls: :class:`SessionListener`
        """
        with self._lock:
            for listener in self._listeners:
                if isinstance(listener, cls):
                    return listener

    def connect(self, *args, **kwds): # subclass implements
        raise NotImplementedError

    def run(self): # subclass implements
        raise NotImplementedError

    def send(self, message):    
        """Send the supplied *message* (xml string) to NETCONF server."""
        if not self.connected:
            raise TransportError('Not connected or connection was reset!')
        logger.info('Sending message to %s: \n%s' % (self._host, 
                message.decode()))
        self._q.put(message)

    ### Properties


    @property
    def connected(self):
        "Connection status of the session."
        return self._connected

    @property
    def client_capabilities(self):
        "Client's :class:`Capabilities`"
        return self._client_capabilities

    @property
    def server_capabilities(self):
        "Server's :class:`Capabilities`"
        return self._server_capabilities

    @property
    def id(self):
        """A string representing the `session-id`. If the session has not been initialized it will be `None`"""
        return self._id


class SessionListener(object):

    """Base class for :class:`Session` listeners, which are notified when a new
    NETCONF message is received or an error occurs.

    .. note::
        Avoid time-intensive tasks in a callback's context.
    """

    def callback(self, root, raw):
        """Called when a new XML document is received. The *root* argument allows the callback to determine whether it wants to further process the document.

        Here, *root* is a tuple of *(tag, attributes)* where *tag* is the qualified name of the root element and *attributes* is a dictionary of its attributes (also qualified names).

        *raw* will contain the XML document as a string.
        """
        raise NotImplementedError

    def errback(self, ex):
        """Called when an error occurs.

        :type ex: :exc:`Exception`
        """
        raise NotImplementedError


class HelloHandler(SessionListener):

    def __init__(self, init_cb, error_cb):
        self._init_cb = init_cb
        self._error_cb = error_cb

    def callback(self, root, raw):    
        # e.g: root = ('hello', {'xmlns:': 'urn:ietf:params:xml:ns:netconf:base:1.0'})  
        tag, attrs = root
        if tag == qualify("hello"):
            # when NO_BASE_NS_1_0 is false and Ignore hello namespace is set
            # this code will also get executed 
            try:
                # print("received qualified hello ", qualify("hello"))
                if xml_.NO_BASE_NS_1_0:
                    if raw.find("xmlns:=") !=1:
                        # ignore no namespace that is caused by the incorrect 
                        # <hello xmlns:="urn:ietf:params:xml:ns:netconf:base:1.0"
                        # note the 'xmlns:='
                        raw = raw.replace("xmlns:=", "xmlns=")                    
                        xml_.NO_BASE_NS_1_0 = False
                        
                id, capabilities = HelloHandler.parse(raw)
            except Exception as e:
                self._error_cb(e)
            else:
                self._init_cb(id, capabilities, raw)

    def errback(self, err):
        self._error_cb(err)

    @staticmethod
    def build(capabilities):
        "Given a list of capability URI's returns <hello> message XML string"
        hello = new_ele("hello", xmlns=BASE_NS_1_0)
        caps = sub_ele(hello, "capabilities")
        
        session_id_test=False
        if "file://add_session_id_test" in capabilities:
            session_id_test=True
            #capabilities.remove("add_session_id_test")
                            
        def fun(uri): sub_ele(caps, "capability").text = uri
        list(map(fun, capabilities))
        
        if session_id_test==True:
            sub_ele(hello, "session-id").text = "%d"%randint(2,90)  
  

   
        if "file://no-xml-declaration" in capabilities:
            xmldeclaration=False
        else:
            xmldeclaration=True
        #print("xmldeclaration ", xmldeclaration)    
        return to_xml(hello, xmldeclaration=xmldeclaration, pretty_print=util.indent_flag)

    @staticmethod
    def parse(raw):
        "Returns tuple of (session-id (str), capabilities (Capabilities)"
        
        # Debugging hello
        """<hello xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"
        xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
        <capabilities>
          <capability>urn:ietf:params:netconf:base:1.0</capability>
          <capability>urn:ietf:params:netconf:base:1.1</capability>
          <capability>urn:ietf:params:netconf:capability:writable-running:1.0</capability>
          <capability>urn:ietf:params:netconf:capability:rollback-on-error:1.0</capability>
         <capability>urn:ietf:params:netconf:capability:startup:1.0</capability>
          <capability>urn:ietf:params:netconf:capability:with-defaults:1.0?basic-mode=trim</capability>
          <capability>http://rad.com/ns/yang/rad-admin?module=rad-admin&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-admin-scheduler?module=rad-admin-scheduler&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-admin-software?module=rad-admin-software&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-cli-types?module=rad-cli-types&amp;revision=2017-02-05</capability>
          <capability>http://rad.com/ns/yang/rad-configure?module=rad-configure&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-access-control?module=rad-configure-access-control&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-flows?module=rad-configure-flows&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-management?module=rad-configure-management&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-management-access?module=rad-configure-management-access&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-management-netconf?module=rad-configure-management-netconf&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-management-radius?module=rad-configure-management-radius&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-management-snmp?module=rad-configure-management-snmp&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-management-tacacsplus?module=rad-configure-management-tacacsplus&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-oam?module=rad-configure-oam&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-oam-efm?module=rad-configure-oam-efm&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-port?module=rad-configure-port&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-port-cellular?module=rad-configure-port-cellular&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-port-ethernet?module=rad-configure-port-ethernet&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-port-ppp?module=rad-configure-port-ppp&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-port-svi?module=rad-configure-port-svi&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-qos?module=rad-configure-qos&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-qos-bw-profiles?module=rad-configure-qos-bw-profiles&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-qos-map-and-mark-profiles?module=rad-configure-qos-map-and-mark-profiles&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-qos-queue-profiles?module=rad-configure-qos-queue-profiles&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-reporting?module=rad-configure-reporting&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router?module=rad-configure-router&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-bgp?module=rad-configure-router-bgp&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-bgp-policy?module=rad-configure-router-bgp-policy&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-bgp-show?module=rad-configure-router-bgp-show&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-interface?module=rad-configure-router-interface&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-interface-ospf?module=rad-configure-router-interface-ospf&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-interface-show?module=rad-configure-router-interface-show&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-nat?module=rad-configure-router-nat&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-ospf?module=rad-configure-router-ospf&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-show?module=rad-configure-router-show&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-router-tunnel-interface?module=rad-configure-router-tunnel-interface&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-system?module=rad-configure-system&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-system-date-and-time?module=rad-configure-system-date-and-time&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-system-dhcp-server?module=rad-configure-system-dhcp-server&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-configure-system-syslog?module=rad-configure-system-syslog&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-features?module=rad-features&amp;revision=2017-01-31&amp;features=timing-hardware,csm,external-clock,ptp,gnss,oam-cfm,one-way-delay-variation,lag,load-balancing,tdm-pw,hardware-router,l3-acl,nat,l2-gre-tunnel,l3-gre-tunnel,y.1564,sat-jumbo-frames,sat-multiple-source-mac,ethernet-port,mtu-discard-counter,port-classifier,port-mirroring,fat-pipes,flow,multi-cos-flow,ethertype-list,alarm-input-relay,physical-port-types,cellular-interface,ethernet-10g,e1-t1-physical,e3-t3-physical,sdh-sonet,shdsl,vdsl2,logical-port-types,gfp,hdlc,logical-mac,pcs,ppp,vcg</capability>
          <capability>http://rad.com/ns/yang/rad-file?module=rad-file&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-root?module=rad-root&amp;revision=2016-06-07</capability>
          <capability>http://rad.com/ns/yang/rad-snmp-traps?module=rad-snmp-traps&amp;revision=2016-12-04</capability>
        </capabilities>
        <session-id>101</session-id>
        </hello>
        """
        """<?xml version="1.0" encoding="UTF-8"?>
        <hello xmlns="urn:ietf:params:xml:ns:netconf:base:1.0">
        <capabilities>
        <capability>urn:ietf:params:netconf:base:1.0</capability>
        <capability>urn:ietf:params:netconf:base:1.1</capability>
        <capability>urn:ietf:params:netconf:capability:writable-running:1.0</capability>
        <capability>urn:ietf:params:netconf:capability:xpath:1.0</capability>
        <capability>urn:ietf:params:netconf:capability:validate:1.0</capability>
        <capability>urn:ietf:params:netconf:capability:validate:1.1</capability>
        <capability>urn:ietf:params:netconf:capability:rollback-on-error:1.0</capability>
        <capability>http://tail-f.com/ns/netconf/actions/1.0</capability>
        <capability>http://tail-f.com/ns/netconf/extensions</capability>
        <capability>urn:ietf:params:netconf:capability:with-defaults:1.0?basic-mode=explicit&amp;also-supported=report-all-tagged</capability>
        <capability>urn:ietf:params:xml:ns:yang:ietf-netconf-with-defaults?revision=2011-06-01&amp;module=ietf-netconf-with-defaults</capability>
        <capability>http://tail-f.com/ns/aaa/1.1?module=tailf-aaa&amp;revision=2015-06-16</capability>
        <capability>http://tail-f.com/ns/example/dhcpd?module=dhcpd</capability>
        <capability>http://tail-f.com/ns/webui?module=tailf-webui&amp;revision=2013-03-07</capability>
        <capability>http://tail-f.com/yang/acm?module=tailf-acm&amp;revision=2013-03-07</capability>
        <capability>http://tail-f.com/yang/common-monitoring?module=tailf-common-monitoring&amp;revision=2013-06-14</capability>
        <capability>http://tail-f.com/yang/confd-monitoring?module=tailf-confd-monitoring&amp;revision=2013-06-14</capability>
        <capability>http://tail-f.com/yang/netconf-monitoring?module=tailf-netconf-monitoring&amp;revision=2014-11-13</capability>
        <capability>urn:ietf:params:xml:ns:yang:iana-crypt-hash?module=iana-crypt-hash&amp;revision=2014-04-04&amp;features=crypt-hash-sha-512,crypt-hash-sha-256,crypt-hash-md5</capability>
        <capability>urn:ietf:params:xml:ns:yang:ietf-inet-types?module=ietf-inet-types&amp;revision=2013-07-15</capability>
        <capability>urn:ietf:params:xml:ns:yang:ietf-netconf-acm?module=ietf-netconf-acm&amp;revision=2012-02-22</capability>
        <capability>urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring?module=ietf-netconf-monitoring&amp;revision=2010-10-04</capability>
        <capability>urn:ietf:params:xml:ns:yang:ietf-netconf-notifications?module=ietf-netconf-notifications&amp;revision=2012-02-06</capability>
        <capability>urn:ietf:params:xml:ns:yang:ietf-yang-types?module=ietf-yang-types&amp;revision=2013-07-15</capability>
        </capabilities>
        <session-id>11</session-id></hello>
        """

        sid, capabilities = 0, []
        
        root = to_ele(raw)
        
        logger.info("Received hello %s"%six.ensure_str(to_xml(root)))
                
        for child in root.getchildren():
            if child.tag == qualify("session-id"):
                sid = child.text
            elif child.tag == qualify("capabilities"):
                for cap in child.getchildren():
                    if cap.tag == qualify("capability"):
                        capabilities.append(cap.text)
                                       
        return sid, Capabilities(capabilities)

        
class NotificationListener(SessionListener): 
    def __init__(self, init_cb):
        self._init_cb = init_cb
        
    def callback(self, root, raw):
        #print("Received raw notification %s"%raw)
        
        # Debugging notification
        #raw ="""<notification
        #xmlns="urn:ietf:params:xml:ns:netconf:notification:1.0">
        #<eventTime>2008-07-08T00:01:00Z</eventTime>
        #<interfaces xmlns="urn:example:interface-module">
        # <interface>
        #   <name>eth1</name>
        #   <interface-enabled>
        #     <by-user>fred</by-user>
        #   </interface-enabled>
        # </interface>
        # </interfaces>
        # </notification>"""
        #
        #
        tag, attrs = root
        if tag == qualify("notification", ns='urn:ietf:params:xml:ns:netconf:notification:1.0'):
            try:
                self._init_cb(raw)
                #pass
            except:
                pass

    def errback(self, err):
        #rpc error should not be delivered to  notification listeners
        pass


    
        