#!/bin/bash

# Set up a default search path.
PATH="/bin:/usr/bin:/usr/local/bin"
export PATH

if [ $# -ne 1 ] ; then
  echo "Incorrect number of arguments.  Not proceeding.  Nothing has been done."
  echo "Usage: $0 <client_domain_name>"
  exit 1
fi

CACERT_BASE=ca
CLIENT_BASE="$1"

CA_C="US"
CA_ST="Illinois"
CA_L="Champaign"
CA_O="Seguesoft"
CA_OU="Seguesoft CERT generator"

CA_CN="client.example.tld"
CA_EMAIL="nobody@example.tld"
 
CA_EMAIL="xiangli@seguesoft.com"

CA_CN="$1"
SUBJ="/C=${CA_C}/ST=${CA_ST}/L=${CA_L}/O=${CA_O}/OU=${CA_OU}/CN=${CA_CN}/emailAddress=${CA_EMAIL}"

#CA_CPW=""
#SUBJ="${SUBJ}/challengePassword=${CA_CPW}"

DIGEST_ALG="-sha512"

# Returns OK (0) if $1 contains $2.
# Otherwise returns Not OK (1).
strstr() {
  [ "${1#*$2*}" = "$1" ] && return 1
  return 0
}

if [ ! -f ${CACERT_BASE}.key ] || [ ! -f ${CACERT_BASE}.key ] ; then
  echo "Certificate authority (CA) files could not be located.  Please create them."
  echo "Not proceeding.  Nothing has been done."
  exit 1
fi

if [ -f ${CLIENT_BASE}.csr ] || [ -f ${CLIENT_BASE}.crt ] || [ -f ${CLIENT_BASE}.key ] ; then
  echo -n 'Prior CLIENT files exist.  Do you wish to replace them? (Y)es/(N)o? [N] '
  read answer
  if ( strstr "nN" "${answer}" ) || [ -z "${answer}" ] ; then
  	 echo "Not proceeding.  Nothing has been done.  You may run this script again."
  	 exit 1
  fi
fi

rm -f ${CLIENT_BASE}.csr ${CLIENT_BASE}.crt ${CLIENT_BASE}.key

openssl genrsa -out ${CLIENT_BASE}.key 2048
openssl req -new ${DIGEST_ALG} -subj "${SUBJ}" -out ${CLIENT_BASE}.csr -key ${CLIENT_BASE}.key
openssl x509 -req ${DIGEST_ALG} -in ${CLIENT_BASE}.csr -CA ${CACERT_BASE}.crt -CAkey ${CACERT_BASE}.key -CAcreateserial -out ${CLIENT_BASE}.crt -days 367789

echo "======================================================================"
openssl req -text -noout -subject -in ${CLIENT_BASE}.csr
echo "======================================================================"
openssl rsa  -check -noout -in ${CLIENT_BASE}.key
echo "======================================================================"
openssl x509 -text -noout -subject -in ${CLIENT_BASE}.crt
echo "======================================================================"
