# Copyright (C) Seguesoft                                               
#                                                                             
# Redistribution of this software, in whole or in part, is
# prohibited without the express written permission of 
# Seguesoft. 

import os, re, sys
from lxml import etree
import parse_module
from copy import deepcopy

from common_global_variables import _dataNodes
from common_global_variables import YIN10NS
from common_global_variables import NEED_A_VALUE_FOR_KEY

from common_global_variables import builtin_types
from common_global_variables import numericTypeMin
from common_global_variables import numericTypeMax
from common_global_variables import numerical_builtin_types_extended

import sys
class SSYangTree(object):
    # Instantiating a SSYANGTree object using a lxml treeRoot
    # will cause the imported modules to be loaded and any local augments ,
    # groupings etc. to be resolved first
    # but the external augments will be done by separately 
    def __init__(self, modrevkey, treeRoot):      
        if treeRoot is None:           
            raise Exception("Instantiating SSYANGTree, treeRoot can't be None!")        
        self.root = treeRoot
        

        # resolve uses, remove choice , case etc.
        #self._retouchTree(self.root)
        #print("Applying uses and grouping for module '%s' ..."%treeRoot.get("name"))
        #parse_module.SS_YANG_Dict[modrevkey]["usesGroupsApplied"] = True
    '''
    def _retouchTree(self, node):    
        # resolve uses, remove choice , case etc.
        # first we add nodes from include, uses and local augment
        belongstoNode = \
            self.root.find("./{urn:ietf:params:xml:ns:yang:yin:1}belongs-to")        
        for nodechild in node:
            statement = parse_module.getStatementValue(nodechild)            
            if statement == "include" and belongstoNode is None:
                # do this only if this is not a submodule. We don't insert 
                # submodule statements into another submodule!
                if  self._retouchIncludedSubmodule(nodechild) == False:
                    return
            elif statement == "import":
                # process imported module and make its /uses' statement
                # get substituted
                if self._retouchImportedModule(nodechild) == False:
                    return    
                    
        # now process all other interesting nodes        
        useNodes = node.xpath("//yin:uses", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        for useNode in useNodes:
            # we always replace 'uses' with the actual 'grouping' when first loading a module
            # augmented nodes should find grouping in the augmenting module
            self._retouchUsesNode(useNode)    

        useNodes = node.xpath("//yin:augment", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        for useNode in useNodes:
            # process augment in 'uses' statement
            # If this augments other external modules, nothing to do here since that is handled differently  
            # see applyAugmentingModule                   
            self._retouchLocalUsesAugmentNodeIfApplicable(useNode) 

        useNodes = node.xpath("//yin:refine", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        for useNode in useNodes:
            # refine can only be a sub-element uses
            self._retouchLocalUsesRefineNodeIfApplicable(useNode)
    
    def _retouchImportedModule(self, importNode):   
        importedModuleName = importNode.get("module")                
        # check if a specific rev is asked
        importedModuleRev = importNode.find("./{urn:ietf:params:xml:ns:yang:yin:1}revision-date")
        
        useKey = importedModuleName
        if importedModuleRev is not None:
            revDate = importedModuleRev.get("date")   
            useKey += "@"+ revDate
                               
        if useKey in parse_module.SS_YANG_Dict:                        
            treeObj = parse_module.SS_YANG_Dict[useKey]["lxmlTreeRoot"]
            yangFile = parse_module.SS_YANG_Dict[useKey]["file"]
            if treeObj is None:
                # load it 
                (treeObj, _, _) = parse_module.load_yang_module(yangFile)
            
            if treeObj is not None:
                # Doing this will cause the imported modules to be loaded 
                # and any local augments ,
                # groupings etc. to be resolved first
                # but the external augments will be done by 
                # resolveUsesApplyAugments
                SSYangTree(useKey, treeObj.getroot())
            return True
        else:
            raise Exception("Error! imported module %s by %s not found in module " \
                            "path!"%(useKey, self.getModuleName()))
        
             
    def _retouchIncludedSubmodule(self, includeNode):        
        includedModuleName = includeNode.get("module")        

        # check if a specific rev is asked
        includedModuleRev = includeNode.find("./{urn:ietf:params:xml:ns:yang:yin:1}revision-date")
        
        useKey = includedModuleName
        if includedModuleRev is not None:
            revDate = includedModuleRev.get("date")   
            useKey += "@"+ revDate
                 
        #useDictionary = parse_module.SS_YANG_Dict
        if useKey in parse_module.SS_YANG_Dict:                        
            treeObj = parse_module.SS_YANG_Dict[useKey]["lxmlTreeRoot"]
            yangFile = parse_module.SS_YANG_Dict[useKey]["file"]
            if treeObj is None:
                # load it 
                print("Please wait while Loading included submodule: %s"%os.path.split(yangFile)[1])
                
                (treeObj, _, _) = parse_module.load_yang_module(yangFile)
            
            # insert nodes defined in submodules    
            if treeObj is not None:
                # Insert data nodes in submodule that are not defined in augment node
                # find inserting index
                indexToInsertWhenReplacing = self.root.index(includeNode)                
                # remove include node itself before replacing with real nodes in submodules
                # Leave the include node there so we know where to  search typedefs defined in submodules 
                #self.root.remove(includeNode)
                
                # https://bugs.launchpad.net/lxml/+bug/555602
                # Add nsmap in submodule to the main module root
                # lxml nsmap is readonly!
                #if self.ssession is not None:
                #    self.ssession.nsmapMerged.update(treeObj.getroot().nsmap)
                #    # Add the submodule into the selectedModels so that aguments defined in
                #    # submodule can be appled in resolveUsesApplyAugments
                #    self.ssession.add_to_server_supported_modules(useKey)

                #insert data nodes 
                for childNode in treeObj.getroot():   
                    if etree.QName(childNode).localname in _dataNodes:
                        # we MUST  get a deepcopy of childNode to insert otherwise 
                        # the node in the original sub module is gone
                        # then it will fail if we open another session window and build 
                        # another datatree
                        # lxml moving tree nodes actually moves the node!
                        self.root.insert(indexToInsertWhenReplacing, deepcopy(childNode))
                        indexToInsertWhenReplacing  += 1
            
                # the included submodule must be augmenting the main module!
                # Note augmenting in submodules is done in data_treeList_model:
                #  resolveUsesApplyAugments    
                return True
        else:
            raise Exception("Error! included submodule %s not found in module path!"%includedModuleName)
            #return False
                        
    def _retouchLocalUsesRefineNodeIfApplicable(self, refinenode):   
        # augment nodes under 'uses' are re-attached in _retouchUsesNode 
        refineTarget = parse_module.getArgumentValue(refinenode)        
        if refineTarget.startswith("/"):
            print("this is a local refine: " +  refineTarget)
            refinedNode = self.get_elemNode_from_IDPath(refineTarget, augmentFlag=True)                
        else:
            # must be a  local augment under 'uses' statement
            #print "this is a refine under uses: " ,  refineTarget, " parent ", parse_module.getArgumentValue(refinenode.getparent())
            print("this is a refine under uses: " +  refineTarget)
            refinedNode = self.get_elemNode_from_IDPath(refineTarget, startNode=refinenode.getparent(), augmentFlag=True)            
            #print " refinedNode found : ", refinedNode      
            #print "refinedNode ", parse_module.getStatementValue(refinedNode), " value: ", parse_module.getArgumentValue(refinedNode)
                       
        if refinedNode is not None:
            for refingNode in refinenode: 
                #print "local  refine under uses. retouching local refine node " + parse_module.getStatementValue(refingNode) + " value: " + parse_module.getArgumentValue(refingNode)
                print("local  refine under uses. retouching local refine node " + parse_module.getStatementValue(refingNode) + " value: " + parse_module.getArgumentValue(refingNode))
                
                deepCopiedNode = deepcopy(refingNode)
                # check if the refinedNode already has the property of the refiningNode
                # if yes, replace it otherwise add it                           
                foundDefines = refinedNode.xpath("t:%s"%parse_module.getStatementValue(refingNode), namespaces={'t' : "urn:ietf:params:xml:ns:yang:yin:1"})
                if len(foundDefines) > 0:
                    print("foundDefines " + parse_module.getStatementValue(foundDefines[0]) +  " value: "+ parse_module.getArgumentValue(foundDefines[0]))
                    idx = refinedNode.index(foundDefines[0])                    
                    refinedNode.insert(idx, deepCopiedNode )
                    # remove the old one            
                    refinedNode.remove(foundDefines[0])
                else:                
                    refinedNode.append(deepCopiedNode)
                                                      
                # remove this local refine node   
                if refinenode.getparent() is not None: 
                    refinenode.getparent().remove(refinenode)          
                            
    def _retouchLocalUsesAugmentNodeIfApplicable(self, augmentnode): 
        # augment nodes under 'uses' are re-attached in _retouchUsesNode                                    
        augmentTarget = parse_module.getArgumentValue(augmentnode)        
        if augmentTarget.startswith("/"):
            # this is an augment statement that augments external module that does not need to
            # be processed now
            return               
        else:
            # must be a  local augment under 'uses' statement
            # This is an augment under 'uses' statement: 
            augmentedNode = self.get_elemNode_from_IDPath(augmentTarget, startNode=augmentnode.getparent(), augmentFlag=True)            
                       
        if augmentedNode is not None:
            for augmentingNode in augmentnode: 
                deepCopiedNode = deepcopy(augmentingNode)
                augmentedNode.append(deepCopiedNode)                                  
            # remove this local augment node    
            augmentnode.getparent().remove(augmentnode)          
        print("Done with local augmenting  %s"%augmentTarget)                        
              
    def _retouchUsesNode(self, usesnode):
        #print "Find Groups, " , parse_module.getArgumentValue(usesnode)
        usesGroupName = parse_module.getArgumentValue(usesnode)
        originatedYangTree = self 
        # check if usesGroupName contains a prefix that is the module itself
        idx = usesGroupName.find(":")
        if idx  != -1:
            localPfx = usesGroupName[:idx]             
            if self.getModulePrefix() == localPfx:
                usesGroupName = usesGroupName[idx+1:]

        foundGroupingNodesDict = originatedYangTree.getImportedAndLocalGroupings(usesnode)
                        
        if usesGroupName in foundGroupingNodesDict:
            groupingNode = foundGroupingNodesDict[usesGroupName]
            # process grouping node, create nodes to be added to the tree
            # remove the 'uses' node and then replace insert related group children
            usesNodeParentNode = usesnode.getparent()
            indexToInsertWhenReplacing = usesNodeParentNode.index(usesnode)
            usesNodeParentNode.remove(usesnode)
            
            for nodechild in groupingNode:                
                statement = parse_module.getStatementValue(nodechild)
                # deep copy the node onto augmented tree
                deepCopiedNode = deepcopy(nodechild)                                        
                
                usesNodeParentNode.insert(indexToInsertWhenReplacing, deepCopiedNode)
                indexToInsertWhenReplacing = indexToInsertWhenReplacing + 1
                    
            # add any augment or refine statement of uses. See https://tools.ietf.org/html/draft-ietf-netconf-server-model-01
            # uses network-managers-config {
            #   augment network-managers/network-manager/transport {  ...
            for useChildNode in usesnode:  
                usesNodeParentNode.append(useChildNode)                                        
        else:
            if 'wx' in sys.modules:
                import wx # not needed                        
                wx.MessageBox("The grouping %s referenced not found! \nFound only:\n%s"%(usesGroupName, str(list(foundGroupingNodesDict.keys()))), "Error", wx.OK | wx.ICON_ERROR)
            else:
                print("Error! The grouping '%s' referenced not found!"%usesGroupName)
                           
    @classmethod    
    def getFirstPrefixInNodeIDSequence(cls, augmentTarget, sequenceNo=0):
        # /pfx:id1/pfx:id2 ...
        if augmentTarget.startswith("/"):
            IDNameAtSequencePosition = augmentTarget.split("/")[sequenceNo+1]
        else:
            IDNameAtSequencePosition = augmentTarget.split("/")[sequenceNo]
        
        IDNameAtSequencePositionPrefix = None       
        IDNameAtSequencePositionColonIdx = IDNameAtSequencePosition.find(':')
        if IDNameAtSequencePositionColonIdx != -1:
            IDNameAtSequencePositionPrefix = IDNameAtSequencePosition[0:IDNameAtSequencePositionColonIdx] 
                           
        return IDNameAtSequencePositionPrefix
        
    def getNamespaceAndPrefixInBelongstoMainModule(self, mainModuleName):
        # SS_YANG_Dict is keyed with modulename  (useKeyNoRevNoFile)
        # here we assume multiple revisions of modulename uses the same namespace
        if mainModuleName in parse_module.SS_YANG_Dict:
            ns = parse_module.SS_YANG_Dict[mainModuleName]["namespace"]
            pfx = parse_module.SS_YANG_Dict[mainModuleName]["prefix"]
            return (ns, pfx)
        else:
            if 'wx' in sys.modules:
                import wx # not needed                        
                wx.MessageBox("could not find the namespace and prefix of the main module when applying augments defined for other module"%mainModuleName, "Error", wx.OK | wx.ICON_ERROR)
            else:
                print("Error ! could not find the namespace and prefix of the main module when applying augments defined for other module%mainModuleName")
            
    def getPrefixOfBelongsToNodeInSubModule(self, ssYangTree, belongsToModuleName):
        augmentingTreeRoot = ssYangTree.root 
        #print "find prefix in belongsToModuleName module %s"%augmentingTreeRoot.get("name"), " belongsToModuleName  to find ", belongsToModuleName
          
        foundCorrespondentBelongsToPrefixNode = augmentingTreeRoot.xpath("yin:belongs-to[@module='%s']/yin:prefix"%belongsToModuleName,  namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        
        #print "found prefix node ", len(foundCorrespondentBelongsToPrefixNode), " ", foundCorrespondentBelongsToPrefixNode
            
        if  len(foundCorrespondentBelongsToPrefixNode) == 1:            
            foundCorrespondentBelongsToPrefix = foundCorrespondentBelongsToPrefixNode[0].get("value")
            #print " foundCorrespondentPrefixNode ", foundCorrespondentPrefixUsed
            return foundCorrespondentBelongsToPrefix
    
    def getPrefixOfBaseIdentityModuleUsedInDerivingIdentityModule(self, ssYangTree):
        basedModuleName = self.getModuleName()
        basedModuleRev = self.getModuleRevision()
        #print "basedModuleName " , basedModuleName, " basedModuleRev ", basedModuleRev
        extendingTreeRoot = ssYangTree.root 
        #print "find prefix in extending module %s"%extendingTreeRoot.get("name"), " imported modulename to find ", importedModuleName
          
        foundCorrespondentPrefixUsedNodeS = extendingTreeRoot.xpath("yin:import[@module='%s']"%basedModuleName,  namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        foundCorrespondentPrefixUsed = None
                    
        if len (foundCorrespondentPrefixUsedNodeS) > 0:
            #print "found import prefix node ", len(foundCorrespondentPrefixUsedNodeS), " ", foundCorrespondentPrefixUsedNodeS
            # in yang 1.1 there could be multiple revision of a module being imported    
            for fcn in foundCorrespondentPrefixUsedNodeS:                                    
                prefixNode = fcn.xpath("yin:prefix", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
                if len(prefixNode):
                    foundCorrespondentPrefixUsed = prefixNode[0].get("value")                
                else:
                    # no prefix node found. This is actually impossible because it got to have a prefix node for import
                    continue
                    
                prefixRevisionNode = fcn.xpath("yin:revision-date", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})            
                if len(prefixRevisionNode):
                    prefixRev = prefixRevisionNode[0].get("date")
                    #print " prefixRev ", prefixRev, " basedModuleRev ", basedModuleRev, " foundCorrespondentPrefixUsed ", foundCorrespondentPrefixUsed
                    if prefixRev == basedModuleRev:
                        return (foundCorrespondentPrefixUsed, "extendOtherModuleFlag")
                    else:
                        continue
                else:
                    return (foundCorrespondentPrefixUsed, "extendOtherModuleFlag")
                
        else:                           
            #
            # in case this is a submodule that is extending its main module
            foundCorrespondentPrefixUsed =  self.getPrefixOfBelongsToNodeInSubModule(ssYangTree, basedModuleName )            
            return (foundCorrespondentPrefixUsed, "extendMainModuleFlag")
            
        
                
    def getPrefixOfAugmentedModuleUsedInAugmentingModule(self, ssYangTree):
        augmentedModuleName = self.getModuleName()
        augmentedModuleRev = self.getModuleRevision()
        #print "augmentedModuleName " , augmentedModuleName, " augmentedModuleRev ", augmentedModuleRev
        augmentingTreeRoot = ssYangTree.root 
        #print "find prefix in augmenting module %s"%augmentingTreeRoot.get("name"), " imported modulename to find ", augmentedModuleName
          
        foundCorrespondentPrefixImportedNodeS = augmentingTreeRoot.xpath("yin:import[@module='%s']"%augmentedModuleName,  namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        foundCorrespondentPrefixUsed = None
                    
        if len (foundCorrespondentPrefixImportedNodeS) > 0:
            # if a module imports another module to augment it 
            # then it can't be that module's submodule
            
            #print "found import prefix node ", len(foundCorrespondentPrefixImportedNodeS), " ", foundCorrespondentPrefixImportedNodeS
            # in yang 1.1 there could be multiple revision of a module being imported    
            for fcn in foundCorrespondentPrefixImportedNodeS:                                    
                prefixNode = fcn.xpath("yin:prefix", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
                if len(prefixNode):
                    foundCorrespondentPrefixUsed = prefixNode[0].get("value")                
                else:
                    # no prefix node found. This is actually impossible because it got to have a prefix node for import
                    continue
                    
                prefixRevisionNode = fcn.xpath("yin:revision-date", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})            
                if len(prefixRevisionNode):
                    prefixRev = prefixRevisionNode[0].get("date")
                    if prefixRev == augmentedModuleRev:
                        #print " prefixRev ", prefixRev, " augmentedModuleRev ", augmentedModuleRev, " foundCorrespondentPrefixUsed ", foundCorrespondentPrefixUsed                    
                        return (foundCorrespondentPrefixUsed, "augmentOtherModuleFlag")
                    else:
                        continue
                else:
                    # no revision then should apply to all 
                    return (foundCorrespondentPrefixUsed, "augmentOtherModuleFlag")
                    
            # no matching revision for augmented and augmenting module found.
            return (None, "augmentOtherModuleFlag")
                
        else:                
            #
            # in case this is a subodule that is augmenting its main module
            foundCorrespondentPrefixUsed = \
                 self.getPrefixOfBelongsToNodeInSubModule(ssYangTree, augmentedModuleName )            
            return (foundCorrespondentPrefixUsed, "augmentMainModuleFlag")
        #print "no return none "    
                   
    def augmentTargetsDefined(self, augmentingSSYangTree):       
        AugmentingRoot = augmentingSSYangTree.root
        #augmentingNamespace = augmentingSSYangTree.getModuleNamespace()
        # here we make sure the augmentation is only done on matching revision
        # if augmented  revision does not match augmenting,    
        # foundCorrespondentPrefixUsed will be None
        foundCorrespondentPrefixUsed, augmentMainOrOtherModuleFlag = \
            self.getPrefixOfAugmentedModuleUsedInAugmentingModule(augmentingSSYangTree )
          
        augmentTargetsDefined = []        
        augmentNodes = AugmentingRoot.xpath("yin:augment", 
             namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})
        #print "augmentNodesaugmentNodes ", augmentNodes,  " in ", AugmentingRoot.get("name")
        for augmentNode in augmentNodes:                
            augmentTarget =  augmentNode.get("target-node")
            firstPrx = self.getFirstPrefixInNodeIDSequence(augmentTarget)  
            
            # target could be: ['/bbf-fast:fast/bbf-fast:vectors', '/bbf-fast:fast/bbf-fast:thresholds', '/if:interfaces/if:interface/bbf-fastdsl:line/bbf-fast:line']
            # when applying augments for 'if', we must exclude 'bbf-fast' since that will cause  incorrect order of applying augments
             
            if firstPrx == foundCorrespondentPrefixUsed:
                augmentTargetsDefined.append((augmentNode, augmentTarget, augmentMainOrOtherModuleFlag ))
        return augmentTargetsDefined
    
                                           
    def applyAugmentingModule(self, augmentingSSYangTree, augmentNode,
             targetOfThisAugmentNode, augmentMainOrOtherModuleFlag, nsmap={}):        
        # this is used to indicate the scenario where a submodule 
        # contains augments statement that
        # augment modules other than its main module
        #augmentingMainModulePrefix = None
                    
        AugmentingRoot = augmentingSSYangTree.root
        AugmentingModuleName = AugmentingRoot.get("name") 
        augmentingNamespace = None
        augmentingPrefix = ""
        
        if augmentMainOrOtherModuleFlag == "augmentOtherModuleFlag":
            # this is the case this module or submdule augments 
            # another module  (other than submodule's main module)
            belongstoNode = AugmentingRoot.xpath("yin:belongs-to", 
                namespaces={"yin" : "urn:ietf:params:xml:ns:yang:yin:1"})     

            if len(belongstoNode):
                # first find which module include this submodule revision
                belongsToMainModuleName = belongstoNode[0].get("module")
                # then find the namespace and prefx of the main module 
                # since the main module name
                # is the one that is really augmenting the target module
                augmentingNamespace, augmentingPrefix = \
                    self.getNamespaceAndPrefixInBelongstoMainModule(belongsToMainModuleName)
                
            else:            
                augmentingNamespace = augmentingSSYangTree.getModuleNamespace()
                augmentingPrefix =    augmentingSSYangTree.getModulePrefix()

        else:
            # this must be a submodule augments its main module so we don't need to 
            # qualify node to be "module-prefix:augmentingNode"
            pass
            
        augmentedNode = self.get_elemNode_from_IDPath(targetOfThisAugmentNode, 
                augmentFlag=True,  nsmap=nsmap,
                augmentingSSYangTree=augmentingSSYangTree)                            
        if augmentedNode is not None:
            for augmentingNode in augmentNode:  
                # process each child of augmentNode
                deepCopiedNode = deepcopy(augmentingNode)
                
                # this is a hack                                         
                # add back the lost namespace mapping.during deepcopy,
                # deedpcopy discards any unused namespace mapping in nsmap.
                # However we need the augmenting namespace and prefix mapping!
                # lxml so far does not allow change nsmap after fact
                # so here we add a mapping for augmentingPrefix to 
                # cause / force this mapping to be added  
                if augmentMainOrOtherModuleFlag == "augmentOtherModuleFlag":
                    nsmapItems = list(augmentingNode.nsmap.items())
                    nsmapItems.append((augmentingPrefix, augmentingNamespace ))
                    for prefix, ns in nsmapItems:
                        if prefix is None or  ns is None:
                            continue
                        # must register it globally. Does this mean the prefix 
                        # used must be unique
                        etree.register_namespace(prefix, ns)
                        nsQualifier="{%s}" % ns
                        deepCopiedNode.set(nsQualifier + "%s"%prefix, prefix)
                        
                if augmentMainOrOtherModuleFlag != "augmentMainModuleFlag":         
                    for cpElement in deepCopiedNode.iter():  
                        # process all descendants of this child
                                                
                        # change the name to qualified name such as ip:port 
                        # to differentiate with non-qualified name 
                        #print " deepCopiedNodeStatement ", 
                        # parse_module.getStatementValue(cpElement)  
                        #if parse_module.getStatementValue(cpElement) not in ["enum", "bit"]:
                        #if parse_module.getStatementValue(cpElement) in _dataNodes:                              
                        #cpElement.set(parse_module.YIN_YANG_Mapping_Dict[deepCopiedNodeStatement], 
                        # "%s:%s"%(augmentingPrefix, parse_module.getArgumentValue(cpElement)))
                        cpElemStatement = parse_module.getStatementValue(cpElement)
                        #print " cpElemStatement ", cpElemStatement
                        if cpElemStatement in parse_module.YIN_YANG_Mapping_Dict:
                            cpElement.set(parse_module.YIN_YANG_Mapping_Dict[cpElemStatement], 
                                "%s:%s"%(augmentingPrefix, parse_module.getArgumentValue(cpElement)))
                            #print "augmentingPrefix ", augmentingPrefix, " after set:  ", 
                            #       parse_module.getStatementValue(cpElement)  ,
                            #       " val ", parse_module.getArgumentValue(cpElement)                              
                else:
                    # in this case: submodule    
                    # we do not use prefix qualified name since a submodule
                    #  simply adds node into the main module
                    #deepCopiedNode.set(parse_module.YIN_YANG_Mapping_Dict[deepCopiedNodeStatement],
                    #  "%s"%deepCopiedNodeArgument)
                    pass
                    
                augmentedNode.append(deepCopiedNode)                
                print("Augmenting: %s ..."%augmentedNode.get(AugmentingModuleName))
                 
        else:
            msg =   "In augmenting module  '%s', target '%s' not found. "\
                    "Possibly because there is another dependent augmenting "\
                    "module not advertised or otherwise not " \
                    "found"%(AugmentingModuleName, targetOfThisAugmentNode)
            raise Exception(msg)
                        
        
    @classmethod
    def _getNodeIDPathHelper(cls, node, relative, topNode, excludeChoiceCase=True):      
        # excludeChoiceCase flag used by masterYANG editor                  
        nodeID = ""
        nsmap = {}
        while True:
            statement = parse_module.getStatementValue(node)
            # choice and case does not appear in XML encode
            #print "get nodeID statement ", statement
            excludeChoiceCaseLst=[]
            if excludeChoiceCase:
                excludeChoiceCaseLst.extend(["choice", "case"])
            #excludeChoiceCaseLst.extend(["choice", "case"])    
            #print " excludeChoiceCaseLst ", excludeChoiceCaseLst    
            if statement not in excludeChoiceCaseLst:
                
                (myID, mymap) = cls.get_prefix_qualified_name_and_nsmap_helper(node)
                if nodeID != "":                
                    nodeID =  myID + "/"+ nodeID
                else:
                    nodeID =  myID


                nsmap.update(mymap)                
            node = node.getparent()
            if node is None or node is topNode:
                break
        # finally    
        if not relative and not nodeID.startswith("/"):                        
            nodeID =  "/" + nodeID 

        #if None in nsmap:
        #    del nsmap[None]
         
        return (nodeID, nsmap)
                         
     
                             
    def getNodeIDPath(self, node, topNode=None, relative=False, includeKey=False, excludeChoiceCase=True):
        return self._getNodeIDPathAndValueHelper(node, topNode=topNode, relative=relative, includeKey=includeKey, getValue=False, excludeChoiceCase=excludeChoiceCase)        
        
    def getNodeIDPathAndValue(self, node, topNode=None, relative=False, includeKey=False):               
        return self._getNodeIDPathAndValueHelper(node, topNode=topNode, relative=relative, includeKey=includeKey, getValue=True)        
        
    def getNodeIDPathValueForEditConfig(self, node, topNode=None, relative=False, includeKey=True, alreadyStagedNodeIDAndValues=[], onlyDecendantOfSelected=False):
        return self._getNodeIDPathAndValueHelper(node, topNode=topNode, relative=relative, 
                                                includeKey=includeKey, 
                                                buildEditConfigValDict=True,
                                                alreadyStagedNodeIDAndValues=alreadyStagedNodeIDAndValues)
        
        # this method returns 
        # (ID1, valueDict1), nsmap
        #print "obtained nodeID ", nodeID, " mymap ", mymap
        
    def _buildEditConfigValueDict(self, node, isKeyNode=False):   
        editValue = node.get("content_match_or_set_value")
        if editValue is None:
            # IF buildEditConfigValDict is true
            # we are building xml for edit-config so we report an error if no value for keys are specified            
            if isKeyNode:
                editValue = NEED_A_VALUE_FOR_KEY
            else:
                editValue = ""    
        value =  {"value": editValue}     
        
        operationVal = node.get("operation")       
        if operationVal is not None and operationVal != "unspecified":
            value["operation"] = operationVal


        operationVal = node.get("ordered-by-user")       
        if operationVal is not None and operationVal != "unspecified":
            value["insert_operation"] = operationVal
            
            
        yangInsertBeforeAfterTargetVal = node.get("ordered-by-user-insert-list-value")
        if yangInsertBeforeAfterTargetVal is not None:  
            # yangInsertBeforeAfterTargetVal returned is key1=val1;key2=val2...
            keyNameValList=[]
            keyNameValStrList = yangInsertBeforeAfterTargetVal.split(";")
            for keyNameValStr in keyNameValStrList:
                keyName, keyVal = keyNameValStr.split("=")
                keyNameValList.append((keyName, keyVal))
            value["target_key"] = keyNameValList
    
        yangInsertBeforeAfterTargetVal = node.get("ordered-by-user-insert-leaf-list-value")
        if yangInsertBeforeAfterTargetVal is not None:
            # yangInsertBeforeAfterTargetVal returned is a value  
            value["target_value"] = yangInsertBeforeAfterTargetVal                

                                    
        withDefaultVal = node.get("default-attribute")     
        if withDefaultVal is not None and withDefaultVal != "unspecified":  
            value["with_default"] = withDefaultVal == "true"
        
        
        
        
        
        XMLDataVal = node.get("raw_XML_data")
        if XMLDataVal is not None and XMLDataVal == "true":
            value["raw_XML_data"] = True
        else:    
            value["raw_XML_data"] = False
        
        return value
        
    @classmethod
    def  _checkIfSameInstanceSpecified(cls, keyNodeValueList, alreadyStagedNodeIDAndValues):
        if len(alreadyStagedNodeIDAndValues) == 0:
            return False
         
        for i in range (len(alreadyStagedNodeIDAndValues) - len(keyNodeValueList) + 1):
            if alreadyStagedNodeIDAndValues[i:i + len(keyNodeValueList)] == keyNodeValueList:
                return True
        
        return False        
        
        
    def _getNodeIDPathAndValueHelper(self, node, topNode=None, relative=False, includeKey=False,
            getValue=False, buildEditConfigValDict=False,
            alreadyStagedNodeIDAndValues=[], excludeChoiceCase=True):             
        if topNode is None:
            topNode =  self.root
        (nodeID, nsmap) = self._getNodeIDPathHelper(node, relative, topNode, excludeChoiceCase=excludeChoiceCase)        

        # if there is content match value specified, make nodeID a tuple
        if not buildEditConfigValDict:
            if node.get("content_match_or_set_value") is not None and getValue:            
                nodeID = (nodeID, node.get("content_match_or_set_value"))
        else:
            nodeID = (nodeID, self._buildEditConfigValueDict(node))
            
        #if includeKey and not onlyDecendantOfSelected:
        if includeKey:
            #selectedNodeIDProcessed = False
            # return a list of nodeID with parent keys added
            ancestorsFromTop=[]   
            for ancestor in node.iterancestors():
                if ancestor.tag == " {urn:ietf:params:xml:ns:netconf:base:1.0}module":
                    break
                ancestorsFromTop.append(ancestor)
            
            ancestorsFromTop.reverse()
            
            nodeIDsIncludeKeys = []
            theSameListEntryFlag =True    
            listEntryNotChecked = True
            
            if len(ancestorsFromTop):
                for ancestor in ancestorsFromTop:                                                                 
                    if self.isListNode(ancestor):
                        listEntryNotChecked = False
                        # get the key node as defined in 'key' statement so we are sure about its encoding order
                        # add "new_list_entry" to key node's valDict for creating correct xml for multiple lists
                        (ancestorNodeID, mymap) = self._getNodeIDPathHelper(ancestor, relative, 
                                topNode, excludeChoiceCase=excludeChoiceCase)

                        if buildEditConfigValDict:
                            ancestorNodeID = (ancestorNodeID, self._buildEditConfigValueDict(ancestor))
                            nodeIDsIncludeKeys.append(ancestorNodeID)    
                            nsmap.update(mymap)
                        
                        # now to to include actually key nodes
                        keyLst = self.getListKey(ancestor).split()
                        keyValueDict={}
                        keyValueOrderedLst = []                        
                        
                        for child in ancestor.iterchildren():
                            if parse_module.getStatementValue(child) != "leaf":
                                continue
                            
                            (childNodeID, childNodeNSmap) = self._getNodeIDPathHelper(child, relative, topNode, excludeChoiceCase=excludeChoiceCase)
                            #print "found childNodeID key processing", childNodeID 
                            if self.isListKeyNode(child): 
                                keyName =  parse_module.getArgumentValue(child)
                                    
                                if not buildEditConfigValDict:
                                    if child.get("content_match_or_set_value") is not None and getValue:            
                                        childNodeID = (childNodeID, child.get("content_match_or_set_value"))
                                else:
                                    childNodeID = (childNodeID, self._buildEditConfigValueDict(child, isKeyNode=True))
                                    
                                keyValueDict[keyName] = childNodeID
                                
                                # add an entry using keyName without prefix. For example, a list defined in a augmenting module
                                # the key defined in augmenting module will have no prefix, but when applied in the augmented 
                                # module, the actual key node name will have prefix qualified. For example:
                                #keyValueDict  {'Context:contextNameId': ('/ComTop:ManagedElement/Context:Context/Context:contextNameId', {'value': 'NEED-A-VALUE-FOR-KEY-NODE!'})}
                                #keyKst  ['contextNameId']
                                if keyName.find(":") != -1: 
                                    keyValueDict[keyName.split(":")[1]] = childNodeID
                                
                                nsmap.update(childNodeNSmap)
                        
                        #print "keyValueDict ", keyValueDict
                        #print "keyKst ", keyLst     
                                           
                        for key in keyLst:
                            if key in  keyValueDict:
                                if keyValueDict[key] not in nodeIDsIncludeKeys:
                                    keyValueOrderedLst.append(keyValueDict[key])
                                    
                                    
                        #print "keyValueOrderedLst ", keyValueOrderedLst       
                        # We also need to make sure this list does not have the same key values that have already been 
                        # processed. This avoids creating duplicated list entries when using
                        # "Add staged values to next edit-config"
                       
                        
                        # check if all key nodes value sequence have already existed in the data assembled previously
                        # by default we assume the same list entry
                        # but once we detect the parent is not the same entry the its children are 
                        if theSameListEntryFlag:                            
                            theSameListEntryFlag = self._checkIfSameInstanceSpecified(keyValueOrderedLst, alreadyStagedNodeIDAndValues )
                        
                        if not theSameListEntryFlag:                             
                            nodeIDsIncludeKeys.extend(keyValueOrderedLst)
                        else:
                            # get rid of the list entry itself
                            if ancestorNodeID in nodeIDsIncludeKeys:
                                nodeIDsIncludeKeys.remove(ancestorNodeID)                            
                        #print "nodeIDsIncludeKeys ", nodeIDsIncludeKeys  
                        
                # Finally add the leaf node ID in question           
                # this way we can make sure the key node is always encoded first ,
                # before other leaf nodes     
                # if the keyNode is selected and it is already added along with searching for parent keys
                # do not add it again. 
                #print "alreadyStagedNodeIDAndValues: ", alreadyStagedNodeIDAndValues
                #print "current examing nodeID ", nodeID
                nodetypeNodeCat = parse_module.getStatementValue(self.get_elemNode_from_IDPath(nodeID[0]))
                #print " nodetypeNodeCat ", nodetypeNodeCat
                nodetypeNodeCatNew = True
                nodetypeNodeIDNew = True
                # exclude the same leaf-list value
                for alreadyStagedIDValue in alreadyStagedNodeIDAndValues:
                    if alreadyStagedIDValue[0] == nodeID[0]:
                        nodetypeNodeIDNew = False
                        if "value" in alreadyStagedIDValue[1] and "value" in nodeID[1]:
                            if alreadyStagedIDValue[1]["value"] == nodeID[1]["value"]:
                                nodetypeNodeCatNew = False
                                    
                if nodeID  not in nodeIDsIncludeKeys and (not theSameListEntryFlag or 
                        (listEntryNotChecked and (nodetypeNodeIDNew or (nodetypeNodeCat =="leaf-list" and nodetypeNodeCatNew))) or 
                        (nodetypeNodeCat=="leaf-list" and nodetypeNodeCatNew)):
                    nodeIDsIncludeKeys.append(nodeID)     
                
                return  (nodeIDsIncludeKeys, nsmap)               
                   
            else:
                # include key flag is not set, just return nodeID and nsmap    
                return (nodeID, nsmap)
        else:
            #print "in helper got nodeID, ", nodeID       
            return (nodeID, nsmap)
    
    
    def get_prefix_qualified_name_and_nsmap(self, node):
        return self.get_prefix_qualified_name_and_nsmap_helper(node)
    
    @classmethod                            
    def get_prefix_qualified_name_and_nsmap_helper(cls, node):
        pfx =  cls.getModulePrefixHelper(rootNode = node.getroottree().getroot())

        argument = parse_module.getArgumentValue(node)
        statement = parse_module.getStatementValue(node)
        if argument == "" and (statement == "input" or statement == "output"):
            argument = statement
        if argument.find(":") != -1:
            return (argument, node.nsmap)            
        else:
            pfx =  cls.getModulePrefixHelper(rootNode = node.getroottree().getroot())
            return ("%s:%s"%(pfx, argument), node.nsmap)
        
                        
    def getelemNodeNamespace(self, elemNode):
        """ return None if no namespace found"""
        argument = parse_module.getArgumentValue(elemNode)
        argumentLst = argument.split(":")
        if len(argumentLst) > 1:
            prefix = argumentLst[0]
            #value = argumentLst[1]
        else:
            prefix = ""
            #value = argumentLst[0] 
       
        if prefix == "":
            return self.getModuleNamespace()            

        for pfx, ns in list(elemNode.nsmap.items()):
            if pfx == prefix:
                return ns

    def getModuleRevision(self):
        node = self.root.xpath("yin:revision", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        if node is not None and len(node) > 0:
            return node[0].get("date")                  
        return ""
    
    def getModuleName(self):
        return self.root.get("name")
    
    def getModuleNamespace(self):
        namespaceNode = self.root.xpath("yin:namespace", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        if namespaceNode is not None and len(namespaceNode) > 0:
            return namespaceNode[0].get("uri")                  
    
    @classmethod
    def getModulePrefixHelper(cls, rootNode):
        prefixNode = rootNode.xpath("yin:prefix", namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
        if prefixNode is not None and len(prefixNode) > 0:
            return prefixNode[0].get("value")                  
    
    def getModulePrefix(self):
        return self.getModulePrefixHelper(self.root)
                            
    def get_elemNode_from_IDPath(self, IDPath, startNode=None, nsmap={}, augmentFlag=False, augmentingSSYangTree=None):
        # augmentFlag is used by "refine" statement too
        # IDPath : /id1/id2/prx:id3...
        # namespaces: a prefix:namespace dictionary for prefixes used in the ID
        # augmentedModulePrefixUsed: prefix used in the ID, only needed if it is not using the default one defined in the module 
        # lxml xpath needs to use relative path to search from the context node
        # so must remove the leading "/"   
        
        # using xpath can't solve all cases  
        # convert mon:netconf-state/mon:datastores/mon:datastore
        # to *[[@attribute1="abc"
        
        # use xapth to match attribute value will not work
        # for choice/augment/input etc.
        # e.g. this won't match *[@name='get-config']/*[@name='input']
        
            

        choiceNodes = []
        #print("in get_elemNode_from_IDPath Process ID path %s"%IDPath)
        IDPath = IDPath.strip("/")       
        IDPathLst = IDPath.split('/') 
            
        # prefix
        prefix = self.getModulePrefix ()    
        if startNode is None:
            startNode = self.root
            
        firstPrefix = "" 
        # sometimes nodes in the same level can have the same name but different category
        # for example /ietf-system:system/clock/timezone-name 
        if augmentFlag:
            nodesToChoose = ["action","input", "output", "case", "choice", "notification", "list", "container"]
        else:
            nodesToChoose = ["action", "notification", "leaf", "leaf-list", "list", "container"]                            
        for i, id in enumerate(IDPathLst):
            foundNode = None
                        
            # Remove predicates if there is any
            # ncm:netconf-state/ncm:sessions/ncm:session[ncm:session-id='307']/ncm:transport becomes
            # ncm:netconf-state/ncm:sessions/ncm:session/ncm:transport
            idBracket = id.find("[", 1)            
            if idBracket != -1:
                id = id[0:idBracket]
            if id.startswith("{"):
                # This is a namespace qualified id, special case in netconfc.
                # Replace | with /, assuming |  will not appear in a namespace string
                # see instance_tree_list_model.py
                idToUse = re.sub(r'\|\|\|',r'/', id)
            else:
                            
                idcolon = id.find(":", 1)            
                if idcolon!= -1:     
                    #idToUse = id           
                    idprefix = id[:idcolon]
                    if i == 0:
                        # get the prefix used in the first ID 
                        firstPrefix = idprefix
                        
                    if firstPrefix != idprefix:
                        # in case the prefix of a particular ID is different than the first ID's prefix
                        # it must be an imported ID referencing other module
                        # so we use the full prx:id form 
                        idToUse = id    
                    else:                        
                        idToUse = id[idcolon+1:]   
                else:
                    if augmentingSSYangTree is not None:
                        # bbf-sub-interface-tagging  
                        # augment '/if:interfaces/if:interface/bbf-subif:frame-processing/'
                        #+ 'bbf-subif:ingress-rule/bbf-subif:rule/bbf-subif:'
                        #+ 'flexible-match/match-criteria/vlan-tag-match-type/vlan-'
                        #+ 'tagged/tag'                         
                        idToUse = augmentingSSYangTree.getModulePrefix()+ ":"+ id
                    else:
                        idToUse = id             
            # if the idToUse include a prefix then this must be a node that is augmented and 
            # it must be defined in another module. 
            # Convert to {namespace}id to search...
            if idToUse.find(":") != -1:
                if idToUse.find('}') != -1:
                    # {namespace}id
                    # prefix:id This is used by searching in instance tree
                    #idToUseNamespaceWithStartingCurly, ifToUseName = idToUse.split("}")
                    #idToUseNamespace = idToUseNamespaceWithStartingCurly[1:]
                    
                    pass # nothing to do since it is already in the correct form
                else:
                    # prefix:id This is used by searching in schema tree???
                    idToUsePrefix, ifToUseName = idToUse.split(":")
                    if idToUsePrefix in nsmap:
                        # prefix:id
                        idToUseNS = nsmap[idToUsePrefix]
                        idToUse = "{%s}%s"%(idToUseNS,ifToUseName)                     
                    else:
                        # SS_YANG_Dict keeps the original prefix to namespace definition
                        raise Exception("Namespace for %s not found! Load the module first!"%idToUsePrefix)    
                          
            if idToUse.startswith("{"):
                # e.g. /system/authentication/{urn:ietf:params:xml:ns:yang:ietf-system-tls-auth}tls/{urn:ietf:params:xml:ns:yang:ietf-system-tls-auth}cert-maps/{urn:ietf:params:xml:ns:yang:ietf-system-tls-auth}cert-to-name
                # augmenting nodes
                #"./*[@name='%s']"%idToUse
                #tree.xpath("//*[re:test(@id, '9467')]", namespaces={'re':'http://exslt.org/regular-expressions'})
                augmentingNamespace = etree.QName(idToUse).namespace
                augmentingName = etree.QName(idToUse).localname
                    
                foundNodes = startNode.xpath("*[re:test(@name, '.+:%s')]"%augmentingName, namespaces={"re": "http://exslt.org/regular-expressions"})
                if len(foundNodes) > 0:
                    for foundNodeCandidate in foundNodes:
                        if parse_module.getStatementValue(foundNodeCandidate) not in nodesToChoose:
                            # skip non data node such as keys etc.
                            # The target node MUST be either a container, list, choice, case, input,
                            # output, or notification node.                            
                            continue 
                           
                        prefixedName = foundNodeCandidate.get("name")
                        prefix = prefixedName.split(":")[0]
                        if prefix in foundNodeCandidate.nsmap:
                            if foundNodeCandidate.nsmap[prefix] ==     augmentingNamespace:
                                foundNode = foundNodeCandidate
                                break
                                         
            else:   
                # The target node MUST be either a container, list, choice, case, input,
                # output, or notification node.   
                # When using this procedure to find node it can be any data node though
                
                if augmentFlag:
                    xpathExprStr = ("yin:action[@name='%s'] | "
                                    "yin:rpc[@name='%s'] | "
                                    "yin:output | "      
                                    "yin:input | "       
                                    "yin:case[@name='%s'] | "        
                                    "yin:choice[@name='%s'] | "      
                                    "yin:container[@name='%s'] | "
                                    "yin:leaf[@name='%s'] | "      
                                    "yin:leaf-list[@name='%s'] | "                                      
                                    "yin:notification[@name='%s'] | "
                                    "yin:list[@name='%s'] "%(idToUse, idToUse, idToUse, idToUse, idToUse, idToUse, idToUse, idToUse, idToUse))
                                            
                else:
                    xpathExprStr = ("md:annotation[@name='%s'] | "
                                    "yin:action[@name='%s'] | "
                                    "yin:rpc[@name='%s'] | "
                                    "yin:input | "
                                   "yin:container[@name='%s'] | "    
                                   "yin:notification[@name='%s'] | " 
                                   "yin:leaf[@name='%s'] | "         
                                   "yin:leaf-list[@name='%s'] | "    
                                   "yin:list[@name='%s'] "%(idToUse, idToUse, idToUse, idToUse, idToUse, idToUse, idToUse, idToUse))
                foundNodes = startNode.xpath(xpathExprStr,  namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1",
                                                                        "md": "urn:ietf:params:xml:ns:yang:ietf-yang-metadata"})   
                if len(foundNodes) > 0:
                        foundNode = foundNodes[0]
                              
            # not found or in rare cases case node has the same name as a child leaf?
            if foundNode is None:
                break
            else:
                startNode = foundNode
            
        # any choice or case node under startNode?
        # Note the augment nodes have been attached to the tree so nothing needs to be done for them
        #
        if foundNode is None:
            IDPathRemains = "/".join(IDPathLst[i:])                             
            choiceNodes = startNode.xpath("yin:choice | yin:case",  namespaces={"yin":"urn:ietf:params:xml:ns:yang:yin:1"})
            
            # process choice or case branches
            for choiceNode in choiceNodes:  
                #print("choiceNode ", choiceNode.get("name"))                      
                foundNode = self.get_elemNode_from_IDPath(IDPathRemains, startNode=choiceNode, nsmap=nsmap, augmentFlag=augmentFlag)
                if foundNode is not None:
                    break
                
        # this might be a toplevel non-data node
        # e.g.: lookup category  for "example-last-modified:last-modified"
        #if foundNode is None:
        #        ??
        return foundNode            
                            
    '''