#!/bin/bash
# Install netconfc on Linux
install_dir=~/NETCONFc

ask_answer() 
{
  retval=-1
  while true; do
    #read -p "I have read and accept the license agreeement (Yes or No)?" yn
    read -p "$1" yn
    case $yn in
        [Yy]* ) retval=1;break;;
        [Nn]* ) retval=0;break;;
        * ) echo "Please answer yes or no.";;
    esac
  done
  if [ "$retval" -eq "0" ] || [ "$retval" -eq "1" ] ; then
    return $retval
  fi

}


select_dir()
{

  retval=-1
  while true; do
    read -e -p "Install into $install_dir (Enter to accept default): " install_dir_new
    if [ -n "$install_dir_new" ] && [ "$install_dir_new" != "\n" ];  then 
      if [[ "$install_dir_new" == "/"* ]]; then
        install_dir=$install_dir_new
        break
      else
        echo "Must enter an absolute full path"
      fi
    else
        break
    fi
  done
  echo "The installation directory selected: $install_dir"
}


is_upgrading()
{
  # upgrading check
  if [ -e "$install_dir/start_NETCONFc.sh" ]; then
      echo "The target directory appears already containing an existing installation"
      retval=$?
      ask_answer "Do you want to replace the existing installation? (Yes/No)?:"
      if [ "$retval" -ne "1" ]; then
          select_dir
          is_upgrading
      fi
  fi
}

do_install()
{
  mkdir -p $install_dir

  # check if writable
  if [[ ! -w $install_dir ]]; then
        # Not writable. Pop the error and exit.
        echo "Directory $install_dir is not writable"
        exit 1
  fi

  if [ -e "$install_dir/uninstall_files" ]; then
    echo "Uninstalling..." 
    rm -rf  $install_dir/Python
    rm -rf  $install_dir/netconfc
    rm -rf  $install_dir/ssclient
    rm -rf  $install_dir/ssclient-sample-scripts
    rm -rf  $install_dir/fortlm 
    rm -rf  $install_dir/*.pyc
    while read line; do
        #echo -e "$line" 
        if [ -f "$install_dir/$line" ]; then
           rm -f "$install_dir/$line"
        fi
    done < $install_dir/uninstall_files
    rm -f "$install_dir/uninstall_files"
  fi    

  if [ -e "./netconfc_pro.tar" ]; then
    echo "Installing ..."
    tar xf ./netconfc_pro.tar -C $install_dir --strip-components=1
    tar tf ./netconfc_pro.tar -C $install_dir --strip-components=1  > $install_dir/uninstall_files
  elif [ -e "./netconfc_demo.tar" ]; then
    echo "Installing ..."
    tar xf ./netconfc_demo.tar -C $install_dir --strip-components=1
    tar tf ./netconfc_demo.tar -C $install_dir --strip-components=1 > $install_dir/uninstall_files
  else
    echo "No appropriate archive file to extract! error!"
    exit 1
  fi

  echo "Installation completed successfully!"
  chmod 755 $install_dir/YANG-modules
  echo "To run NETCONFc, cd $install_dir, and run ./start_NETCONFc.sh"

  ask_answer "Run NETCONFc now (Yes or No)?:"
  retval=$?
  if [ "$retval" -eq "0" ]; then
      echo "To run NETCONFC, cd $install_dir and run ./start_NETCONFc.sh"
    exit 0
  else
      cd $install_dir;./start_NETCONFc.sh
  fi
}

retval=0
echo "You must agree to the license agreement before proceeding. Press space key to continue ..."
read -n 1 -r -p "Press space key to continue"
more -d LICENSE-AGREEMENT.txt
echo ""

ask_answer "I have read and accept the license agreeement (Yes or No)?:"
retval=$?
if [ "$retval" -eq "0" ]; then
    echo "You must accept license agreement before proceeding!"
    exit 0
fi

select_dir
is_upgrading
do_install
